// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"strconv"

	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
)

// StorageTypeCapacity Storage type capacity
// swagger:model StorageTypeCapacity
type StorageTypeCapacity struct {

	// maximum storage allocation
	MaximumStorageAllocation *MaximumStorageAllocation `json:"maximumStorageAllocation,omitempty"`

	// List of storage pool capacity for storage type
	StoragePoolsCapacity []*StoragePoolCapacity `json:"storagePoolsCapacity"`

	// Storage type
	StorageType string `json:"storageType,omitempty"`
}

// Validate validates this storage type capacity
func (m *StorageTypeCapacity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMaximumStorageAllocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStoragePoolsCapacity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *StorageTypeCapacity) validateMaximumStorageAllocation(formats strfmt.Registry) error {

	if swag.IsZero(m.MaximumStorageAllocation) { // not required
		return nil
	}

	if m.MaximumStorageAllocation != nil {
		if err := m.MaximumStorageAllocation.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("maximumStorageAllocation")
			}
			return err
		}
	}

	return nil
}

func (m *StorageTypeCapacity) validateStoragePoolsCapacity(formats strfmt.Registry) error {

	if swag.IsZero(m.StoragePoolsCapacity) { // not required
		return nil
	}

	for i := 0; i < len(m.StoragePoolsCapacity); i++ {
		if swag.IsZero(m.StoragePoolsCapacity[i]) { // not required
			continue
		}

		if m.StoragePoolsCapacity[i] != nil {
			if err := m.StoragePoolsCapacity[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("storagePoolsCapacity" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *StorageTypeCapacity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *StorageTypeCapacity) UnmarshalBinary(b []byte) error {
	var res StorageTypeCapacity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
