package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPermissionList invokes the bssopenapi.QueryPermissionList API synchronously
func (client *Client) QueryPermissionList(request *QueryPermissionListRequest) (response *QueryPermissionListResponse, err error) {
	response = CreateQueryPermissionListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPermissionListWithChan invokes the bssopenapi.QueryPermissionList API asynchronously
func (client *Client) QueryPermissionListWithChan(request *QueryPermissionListRequest) (<-chan *QueryPermissionListResponse, <-chan error) {
	responseChan := make(chan *QueryPermissionListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPermissionList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPermissionListWithCallback invokes the bssopenapi.QueryPermissionList API asynchronously
func (client *Client) QueryPermissionListWithCallback(request *QueryPermissionListRequest, callback func(response *QueryPermissionListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPermissionListResponse
		var err error
		defer close(result)
		response, err = client.QueryPermissionList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPermissionListRequest is the request struct for api QueryPermissionList
type QueryPermissionListRequest struct {
	*requests.RpcRequest
	RelationId requests.Integer `position:"Query" name:"RelationId"`
}

// QueryPermissionListResponse is the response struct for api QueryPermissionList
type QueryPermissionListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryPermissionListRequest creates a request to invoke QueryPermissionList API
func CreateQueryPermissionListRequest() (request *QueryPermissionListRequest) {
	request = &QueryPermissionListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "QueryPermissionList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryPermissionListResponse creates a response to parse from QueryPermissionList response
func CreateQueryPermissionListResponse() (response *QueryPermissionListResponse) {
	response = &QueryPermissionListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
