package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEventRuleList invokes the cms.DescribeEventRuleList API synchronously
func (client *Client) DescribeEventRuleList(request *DescribeEventRuleListRequest) (response *DescribeEventRuleListResponse, err error) {
	response = CreateDescribeEventRuleListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEventRuleListWithChan invokes the cms.DescribeEventRuleList API asynchronously
func (client *Client) DescribeEventRuleListWithChan(request *DescribeEventRuleListRequest) (<-chan *DescribeEventRuleListResponse, <-chan error) {
	responseChan := make(chan *DescribeEventRuleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEventRuleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEventRuleListWithCallback invokes the cms.DescribeEventRuleList API asynchronously
func (client *Client) DescribeEventRuleListWithCallback(request *DescribeEventRuleListRequest, callback func(response *DescribeEventRuleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEventRuleListResponse
		var err error
		defer close(result)
		response, err = client.DescribeEventRuleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEventRuleListRequest is the request struct for api DescribeEventRuleList
type DescribeEventRuleListRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	PageNumber string `position:"Query" name:"PageNumber"`
	PageSize   string `position:"Query" name:"PageSize"`
	NamePrefix string `position:"Query" name:"NamePrefix"`
}

// DescribeEventRuleListResponse is the response struct for api DescribeEventRuleList
type DescribeEventRuleListResponse struct {
	*responses.BaseResponse
	Success    bool       `json:"Success" xml:"Success"`
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Total      int        `json:"Total" xml:"Total"`
	EventRules EventRules `json:"EventRules" xml:"EventRules"`
}

// CreateDescribeEventRuleListRequest creates a request to invoke DescribeEventRuleList API
func CreateDescribeEventRuleListRequest() (request *DescribeEventRuleListRequest) {
	request = &DescribeEventRuleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeEventRuleList", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEventRuleListResponse creates a response to parse from DescribeEventRuleList response
func CreateDescribeEventRuleListResponse() (response *DescribeEventRuleListResponse) {
	response = &DescribeEventRuleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
