package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutCustomMetricRule invokes the cms.PutCustomMetricRule API synchronously
func (client *Client) PutCustomMetricRule(request *PutCustomMetricRuleRequest) (response *PutCustomMetricRuleResponse, err error) {
	response = CreatePutCustomMetricRuleResponse()
	err = client.DoAction(request, response)
	return
}

// PutCustomMetricRuleWithChan invokes the cms.PutCustomMetricRule API asynchronously
func (client *Client) PutCustomMetricRuleWithChan(request *PutCustomMetricRuleRequest) (<-chan *PutCustomMetricRuleResponse, <-chan error) {
	responseChan := make(chan *PutCustomMetricRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutCustomMetricRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutCustomMetricRuleWithCallback invokes the cms.PutCustomMetricRule API asynchronously
func (client *Client) PutCustomMetricRuleWithCallback(request *PutCustomMetricRuleRequest, callback func(response *PutCustomMetricRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutCustomMetricRuleResponse
		var err error
		defer close(result)
		response, err = client.PutCustomMetricRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutCustomMetricRuleRequest is the request struct for api PutCustomMetricRule
type PutCustomMetricRuleRequest struct {
	*requests.RpcRequest
	Webhook            string           `position:"Query" name:"Webhook"`
	RuleName           string           `position:"Query" name:"RuleName"`
	Threshold          string           `position:"Query" name:"Threshold"`
	EffectiveInterval  string           `position:"Query" name:"EffectiveInterval"`
	EmailSubject       string           `position:"Query" name:"EmailSubject"`
	EvaluationCount    requests.Integer `position:"Query" name:"EvaluationCount"`
	SilenceTime        requests.Integer `position:"Query" name:"SilenceTime"`
	MetricName         string           `position:"Query" name:"MetricName"`
	Period             string           `position:"Query" name:"Period"`
	ContactGroups      string           `position:"Query" name:"ContactGroups"`
	Level              string           `position:"Query" name:"Level"`
	GroupId            string           `position:"Query" name:"GroupId"`
	Resources          string           `position:"Query" name:"Resources"`
	RuleId             string           `position:"Query" name:"RuleId"`
	ComparisonOperator string           `position:"Query" name:"ComparisonOperator"`
	Statistics         string           `position:"Query" name:"Statistics"`
}

// PutCustomMetricRuleResponse is the response struct for api PutCustomMetricRule
type PutCustomMetricRuleResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePutCustomMetricRuleRequest creates a request to invoke PutCustomMetricRule API
func CreatePutCustomMetricRuleRequest() (request *PutCustomMetricRuleRequest) {
	request = &PutCustomMetricRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "PutCustomMetricRule", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutCustomMetricRuleResponse creates a response to parse from PutCustomMetricRule response
func CreatePutCustomMetricRuleResponse() (response *PutCustomMetricRuleResponse) {
	response = &PutCustomMetricRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
