package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListChartNamespace invokes the cr.ListChartNamespace API synchronously
// api document: https://help.aliyun.com/api/cr/listchartnamespace.html
func (client *Client) ListChartNamespace(request *ListChartNamespaceRequest) (response *ListChartNamespaceResponse, err error) {
	response = CreateListChartNamespaceResponse()
	err = client.DoAction(request, response)
	return
}

// ListChartNamespaceWithChan invokes the cr.ListChartNamespace API asynchronously
// api document: https://help.aliyun.com/api/cr/listchartnamespace.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListChartNamespaceWithChan(request *ListChartNamespaceRequest) (<-chan *ListChartNamespaceResponse, <-chan error) {
	responseChan := make(chan *ListChartNamespaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListChartNamespace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListChartNamespaceWithCallback invokes the cr.ListChartNamespace API asynchronously
// api document: https://help.aliyun.com/api/cr/listchartnamespace.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListChartNamespaceWithCallback(request *ListChartNamespaceRequest, callback func(response *ListChartNamespaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListChartNamespaceResponse
		var err error
		defer close(result)
		response, err = client.ListChartNamespace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListChartNamespaceRequest is the request struct for api ListChartNamespace
type ListChartNamespaceRequest struct {
	*requests.RpcRequest
	NamespaceName   string           `position:"Query" name:"NamespaceName"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	PageNo          requests.Integer `position:"Query" name:"PageNo"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	NamespaceStatus string           `position:"Query" name:"NamespaceStatus"`
}

// ListChartNamespaceResponse is the response struct for api ListChartNamespace
type ListChartNamespaceResponse struct {
	*responses.BaseResponse
	ListChartNamespaceIsSuccess bool             `json:"IsSuccess" xml:"IsSuccess"`
	Code                        string           `json:"Code" xml:"Code"`
	RequestId                   string           `json:"RequestId" xml:"RequestId"`
	PageNo                      int              `json:"PageNo" xml:"PageNo"`
	PageSize                    int              `json:"PageSize" xml:"PageSize"`
	TotalCount                  string           `json:"TotalCount" xml:"TotalCount"`
	Namespaces                  []NamespacesItem `json:"Namespaces" xml:"Namespaces"`
}

// CreateListChartNamespaceRequest creates a request to invoke ListChartNamespace API
func CreateListChartNamespaceRequest() (request *ListChartNamespaceRequest) {
	request = &ListChartNamespaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "ListChartNamespace", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListChartNamespaceResponse creates a response to parse from ListChartNamespace response
func CreateListChartNamespaceResponse() (response *ListChartNamespaceResponse) {
	response = &ListChartNamespaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
