package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterAttachScripts invokes the cs.DescribeClusterAttachScripts API synchronously
func (client *Client) DescribeClusterAttachScripts(request *DescribeClusterAttachScriptsRequest) (response *DescribeClusterAttachScriptsResponse, err error) {
	response = CreateDescribeClusterAttachScriptsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterAttachScriptsWithChan invokes the cs.DescribeClusterAttachScripts API asynchronously
func (client *Client) DescribeClusterAttachScriptsWithChan(request *DescribeClusterAttachScriptsRequest) (<-chan *DescribeClusterAttachScriptsResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterAttachScriptsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterAttachScripts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterAttachScriptsWithCallback invokes the cs.DescribeClusterAttachScripts API asynchronously
func (client *Client) DescribeClusterAttachScriptsWithCallback(request *DescribeClusterAttachScriptsRequest, callback func(response *DescribeClusterAttachScriptsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterAttachScriptsResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterAttachScripts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterAttachScriptsRequest is the request struct for api DescribeClusterAttachScripts
type DescribeClusterAttachScriptsRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// DescribeClusterAttachScriptsResponse is the response struct for api DescribeClusterAttachScripts
type DescribeClusterAttachScriptsResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClusterAttachScriptsRequest creates a request to invoke DescribeClusterAttachScripts API
func CreateDescribeClusterAttachScriptsRequest() (request *DescribeClusterAttachScriptsRequest) {
	request = &DescribeClusterAttachScriptsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterAttachScripts", "/clusters/[ClusterId]/attachscript", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterAttachScriptsResponse creates a response to parse from DescribeClusterAttachScripts response
func CreateDescribeClusterAttachScriptsResponse() (response *DescribeClusterAttachScriptsResponse) {
	response = &DescribeClusterAttachScriptsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
