package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnUserBillHistory invokes the dcdn.DescribeDcdnUserBillHistory API synchronously
func (client *Client) DescribeDcdnUserBillHistory(request *DescribeDcdnUserBillHistoryRequest) (response *DescribeDcdnUserBillHistoryResponse, err error) {
	response = CreateDescribeDcdnUserBillHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnUserBillHistoryWithChan invokes the dcdn.DescribeDcdnUserBillHistory API asynchronously
func (client *Client) DescribeDcdnUserBillHistoryWithChan(request *DescribeDcdnUserBillHistoryRequest) (<-chan *DescribeDcdnUserBillHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnUserBillHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnUserBillHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnUserBillHistoryWithCallback invokes the dcdn.DescribeDcdnUserBillHistory API asynchronously
func (client *Client) DescribeDcdnUserBillHistoryWithCallback(request *DescribeDcdnUserBillHistoryRequest, callback func(response *DescribeDcdnUserBillHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnUserBillHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnUserBillHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnUserBillHistoryRequest is the request struct for api DescribeDcdnUserBillHistory
type DescribeDcdnUserBillHistoryRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnUserBillHistoryResponse is the response struct for api DescribeDcdnUserBillHistory
type DescribeDcdnUserBillHistoryResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	BillHistoryData BillHistoryData `json:"BillHistoryData" xml:"BillHistoryData"`
}

// CreateDescribeDcdnUserBillHistoryRequest creates a request to invoke DescribeDcdnUserBillHistory API
func CreateDescribeDcdnUserBillHistoryRequest() (request *DescribeDcdnUserBillHistoryRequest) {
	request = &DescribeDcdnUserBillHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnUserBillHistory", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnUserBillHistoryResponse creates a response to parse from DescribeDcdnUserBillHistory response
func CreateDescribeDcdnUserBillHistoryResponse() (response *DescribeDcdnUserBillHistoryResponse) {
	response = &DescribeDcdnUserBillHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
