package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartDcdnIpaDomain invokes the dcdn.StartDcdnIpaDomain API synchronously
func (client *Client) StartDcdnIpaDomain(request *StartDcdnIpaDomainRequest) (response *StartDcdnIpaDomainResponse, err error) {
	response = CreateStartDcdnIpaDomainResponse()
	err = client.DoAction(request, response)
	return
}

// StartDcdnIpaDomainWithChan invokes the dcdn.StartDcdnIpaDomain API asynchronously
func (client *Client) StartDcdnIpaDomainWithChan(request *StartDcdnIpaDomainRequest) (<-chan *StartDcdnIpaDomainResponse, <-chan error) {
	responseChan := make(chan *StartDcdnIpaDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartDcdnIpaDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartDcdnIpaDomainWithCallback invokes the dcdn.StartDcdnIpaDomain API asynchronously
func (client *Client) StartDcdnIpaDomainWithCallback(request *StartDcdnIpaDomainRequest, callback func(response *StartDcdnIpaDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartDcdnIpaDomainResponse
		var err error
		defer close(result)
		response, err = client.StartDcdnIpaDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartDcdnIpaDomainRequest is the request struct for api StartDcdnIpaDomain
type StartDcdnIpaDomainRequest struct {
	*requests.RpcRequest
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// StartDcdnIpaDomainResponse is the response struct for api StartDcdnIpaDomain
type StartDcdnIpaDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartDcdnIpaDomainRequest creates a request to invoke StartDcdnIpaDomain API
func CreateStartDcdnIpaDomainRequest() (request *StartDcdnIpaDomainRequest) {
	request = &StartDcdnIpaDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "StartDcdnIpaDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateStartDcdnIpaDomainResponse creates a response to parse from StartDcdnIpaDomain response
func CreateStartDcdnIpaDomainResponse() (response *StartDcdnIpaDomainResponse) {
	response = &StartDcdnIpaDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
