package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebPreciseAccessRule invokes the ddoscoo.DescribeWebPreciseAccessRule API synchronously
func (client *Client) DescribeWebPreciseAccessRule(request *DescribeWebPreciseAccessRuleRequest) (response *DescribeWebPreciseAccessRuleResponse, err error) {
	response = CreateDescribeWebPreciseAccessRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebPreciseAccessRuleWithChan invokes the ddoscoo.DescribeWebPreciseAccessRule API asynchronously
func (client *Client) DescribeWebPreciseAccessRuleWithChan(request *DescribeWebPreciseAccessRuleRequest) (<-chan *DescribeWebPreciseAccessRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeWebPreciseAccessRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebPreciseAccessRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebPreciseAccessRuleWithCallback invokes the ddoscoo.DescribeWebPreciseAccessRule API asynchronously
func (client *Client) DescribeWebPreciseAccessRuleWithCallback(request *DescribeWebPreciseAccessRuleRequest, callback func(response *DescribeWebPreciseAccessRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebPreciseAccessRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebPreciseAccessRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebPreciseAccessRuleRequest is the request struct for api DescribeWebPreciseAccessRule
type DescribeWebPreciseAccessRuleRequest struct {
	*requests.RpcRequest
	Domains         *[]string `position:"Query" name:"Domains"  type:"Repeated"`
	ResourceGroupId string    `position:"Query" name:"ResourceGroupId"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
}

// DescribeWebPreciseAccessRuleResponse is the response struct for api DescribeWebPreciseAccessRule
type DescribeWebPreciseAccessRuleResponse struct {
	*responses.BaseResponse
	RequestId               string                `json:"RequestId" xml:"RequestId"`
	PreciseAccessConfigList []PreciseAccessConfig `json:"PreciseAccessConfigList" xml:"PreciseAccessConfigList"`
}

// CreateDescribeWebPreciseAccessRuleRequest creates a request to invoke DescribeWebPreciseAccessRule API
func CreateDescribeWebPreciseAccessRuleRequest() (request *DescribeWebPreciseAccessRuleRequest) {
	request = &DescribeWebPreciseAccessRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeWebPreciseAccessRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeWebPreciseAccessRuleResponse creates a response to parse from DescribeWebPreciseAccessRule response
func CreateDescribeWebPreciseAccessRuleResponse() (response *DescribeWebPreciseAccessRuleResponse) {
	response = &DescribeWebPreciseAccessRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
