package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InsertSwimmingLaneGroup invokes the edas.InsertSwimmingLaneGroup API synchronously
func (client *Client) InsertSwimmingLaneGroup(request *InsertSwimmingLaneGroupRequest) (response *InsertSwimmingLaneGroupResponse, err error) {
	response = CreateInsertSwimmingLaneGroupResponse()
	err = client.DoAction(request, response)
	return
}

// InsertSwimmingLaneGroupWithChan invokes the edas.InsertSwimmingLaneGroup API asynchronously
func (client *Client) InsertSwimmingLaneGroupWithChan(request *InsertSwimmingLaneGroupRequest) (<-chan *InsertSwimmingLaneGroupResponse, <-chan error) {
	responseChan := make(chan *InsertSwimmingLaneGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InsertSwimmingLaneGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InsertSwimmingLaneGroupWithCallback invokes the edas.InsertSwimmingLaneGroup API asynchronously
func (client *Client) InsertSwimmingLaneGroupWithCallback(request *InsertSwimmingLaneGroupRequest, callback func(response *InsertSwimmingLaneGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InsertSwimmingLaneGroupResponse
		var err error
		defer close(result)
		response, err = client.InsertSwimmingLaneGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InsertSwimmingLaneGroupRequest is the request struct for api InsertSwimmingLaneGroup
type InsertSwimmingLaneGroupRequest struct {
	*requests.RoaRequest
	AppIds          string `position:"Query" name:"AppIds"`
	LogicalRegionId string `position:"Query" name:"LogicalRegionId"`
	Name            string `position:"Query" name:"Name"`
	EntryApp        string `position:"Query" name:"EntryApp"`
}

// InsertSwimmingLaneGroupResponse is the response struct for api InsertSwimmingLaneGroup
type InsertSwimmingLaneGroupResponse struct {
	*responses.BaseResponse
	Code      int                           `json:"Code" xml:"Code"`
	Message   string                        `json:"Message" xml:"Message"`
	RequestId string                        `json:"RequestId" xml:"RequestId"`
	Data      DataInInsertSwimmingLaneGroup `json:"Data" xml:"Data"`
}

// CreateInsertSwimmingLaneGroupRequest creates a request to invoke InsertSwimmingLaneGroup API
func CreateInsertSwimmingLaneGroupRequest() (request *InsertSwimmingLaneGroupRequest) {
	request = &InsertSwimmingLaneGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "InsertSwimmingLaneGroup", "/pop/v5/trafficmgnt/swimming_lane_groups", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInsertSwimmingLaneGroupResponse creates a response to parse from InsertSwimmingLaneGroup response
func CreateInsertSwimmingLaneGroupResponse() (response *InsertSwimmingLaneGroupResponse) {
	response = &InsertSwimmingLaneGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
