package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterMetaCollect invokes the emr.DescribeClusterMetaCollect API synchronously
func (client *Client) DescribeClusterMetaCollect(request *DescribeClusterMetaCollectRequest) (response *DescribeClusterMetaCollectResponse, err error) {
	response = CreateDescribeClusterMetaCollectResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterMetaCollectWithChan invokes the emr.DescribeClusterMetaCollect API asynchronously
func (client *Client) DescribeClusterMetaCollectWithChan(request *DescribeClusterMetaCollectRequest) (<-chan *DescribeClusterMetaCollectResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterMetaCollectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterMetaCollect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterMetaCollectWithCallback invokes the emr.DescribeClusterMetaCollect API asynchronously
func (client *Client) DescribeClusterMetaCollectWithCallback(request *DescribeClusterMetaCollectRequest, callback func(response *DescribeClusterMetaCollectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterMetaCollectResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterMetaCollect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterMetaCollectRequest is the request struct for api DescribeClusterMetaCollect
type DescribeClusterMetaCollectRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// DescribeClusterMetaCollectResponse is the response struct for api DescribeClusterMetaCollect
type DescribeClusterMetaCollectResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ClusterId     string `json:"ClusterId" xml:"ClusterId"`
	MetaStoreType string `json:"MetaStoreType" xml:"MetaStoreType"`
	Status        string `json:"Status" xml:"Status"`
}

// CreateDescribeClusterMetaCollectRequest creates a request to invoke DescribeClusterMetaCollect API
func CreateDescribeClusterMetaCollectRequest() (request *DescribeClusterMetaCollectRequest) {
	request = &DescribeClusterMetaCollectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeClusterMetaCollect", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClusterMetaCollectResponse creates a response to parse from DescribeClusterMetaCollect response
func CreateDescribeClusterMetaCollectResponse() (response *DescribeClusterMetaCollectResponse) {
	response = &DescribeClusterMetaCollectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
