package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeJob invokes the emr.DescribeJob API synchronously
func (client *Client) DescribeJob(request *DescribeJobRequest) (response *DescribeJobResponse, err error) {
	response = CreateDescribeJobResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeJobWithChan invokes the emr.DescribeJob API asynchronously
func (client *Client) DescribeJobWithChan(request *DescribeJobRequest) (<-chan *DescribeJobResponse, <-chan error) {
	responseChan := make(chan *DescribeJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeJobWithCallback invokes the emr.DescribeJob API asynchronously
func (client *Client) DescribeJobWithCallback(request *DescribeJobRequest, callback func(response *DescribeJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeJobResponse
		var err error
		defer close(result)
		response, err = client.DescribeJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeJobRequest is the request struct for api DescribeJob
type DescribeJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	Id              string           `position:"Query" name:"Id"`
}

// DescribeJobResponse is the response struct for api DescribeJob
type DescribeJobResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	Id            string `json:"Id" xml:"Id"`
	Name          string `json:"Name" xml:"Name"`
	FailAct       string `json:"FailAct" xml:"FailAct"`
	Type          string `json:"Type" xml:"Type"`
	MaxRetry      int    `json:"MaxRetry" xml:"MaxRetry"`
	RetryInterval int    `json:"RetryInterval" xml:"RetryInterval"`
	RunParameter  string `json:"RunParameter" xml:"RunParameter"`
}

// CreateDescribeJobRequest creates a request to invoke DescribeJob API
func CreateDescribeJobRequest() (request *DescribeJobRequest) {
	request = &DescribeJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeJob", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeJobResponse creates a response to parse from DescribeJob response
func CreateDescribeJobResponse() (response *DescribeJobResponse) {
	response = &DescribeJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
