package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLibraryInstallTaskDetail invokes the emr.DescribeLibraryInstallTaskDetail API synchronously
func (client *Client) DescribeLibraryInstallTaskDetail(request *DescribeLibraryInstallTaskDetailRequest) (response *DescribeLibraryInstallTaskDetailResponse, err error) {
	response = CreateDescribeLibraryInstallTaskDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLibraryInstallTaskDetailWithChan invokes the emr.DescribeLibraryInstallTaskDetail API asynchronously
func (client *Client) DescribeLibraryInstallTaskDetailWithChan(request *DescribeLibraryInstallTaskDetailRequest) (<-chan *DescribeLibraryInstallTaskDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeLibraryInstallTaskDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLibraryInstallTaskDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLibraryInstallTaskDetailWithCallback invokes the emr.DescribeLibraryInstallTaskDetail API asynchronously
func (client *Client) DescribeLibraryInstallTaskDetailWithCallback(request *DescribeLibraryInstallTaskDetailRequest, callback func(response *DescribeLibraryInstallTaskDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLibraryInstallTaskDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeLibraryInstallTaskDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLibraryInstallTaskDetailRequest is the request struct for api DescribeLibraryInstallTaskDetail
type DescribeLibraryInstallTaskDetailRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskBizId       string           `position:"Query" name:"TaskBizId"`
}

// DescribeLibraryInstallTaskDetailResponse is the response struct for api DescribeLibraryInstallTaskDetail
type DescribeLibraryInstallTaskDetailResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	LibraryBizId string `json:"LibraryBizId" xml:"LibraryBizId"`
	TaskGroupId  string `json:"TaskGroupId" xml:"TaskGroupId"`
	TaskId       string `json:"TaskId" xml:"TaskId"`
	TaskStatus   string `json:"TaskStatus" xml:"TaskStatus"`
	StartTime    int64  `json:"StartTime" xml:"StartTime"`
	EndTime      int64  `json:"EndTime" xml:"EndTime"`
	ExecuteTime  int64  `json:"ExecuteTime" xml:"ExecuteTime"`
	TaskProcess  int    `json:"TaskProcess" xml:"TaskProcess"`
	TaskType     string `json:"TaskType" xml:"TaskType"`
	Detail       string `json:"Detail" xml:"Detail"`
	ClusterBizId string `json:"ClusterBizId" xml:"ClusterBizId"`
	Hostname     string `json:"Hostname" xml:"Hostname"`
}

// CreateDescribeLibraryInstallTaskDetailRequest creates a request to invoke DescribeLibraryInstallTaskDetail API
func CreateDescribeLibraryInstallTaskDetailRequest() (request *DescribeLibraryInstallTaskDetailRequest) {
	request = &DescribeLibraryInstallTaskDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeLibraryInstallTaskDetail", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLibraryInstallTaskDetailResponse creates a response to parse from DescribeLibraryInstallTaskDetail response
func CreateDescribeLibraryInstallTaskDetailResponse() (response *DescribeLibraryInstallTaskDetailResponse) {
	response = &DescribeLibraryInstallTaskDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
