package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVswitch invokes the emr.ListVswitch API synchronously
func (client *Client) ListVswitch(request *ListVswitchRequest) (response *ListVswitchResponse, err error) {
	response = CreateListVswitchResponse()
	err = client.DoAction(request, response)
	return
}

// ListVswitchWithChan invokes the emr.ListVswitch API asynchronously
func (client *Client) ListVswitchWithChan(request *ListVswitchRequest) (<-chan *ListVswitchResponse, <-chan error) {
	responseChan := make(chan *ListVswitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVswitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVswitchWithCallback invokes the emr.ListVswitch API asynchronously
func (client *Client) ListVswitchWithCallback(request *ListVswitchRequest, callback func(response *ListVswitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVswitchResponse
		var err error
		defer close(result)
		response, err = client.ListVswitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVswitchRequest is the request struct for api ListVswitch
type ListVswitchRequest struct {
	*requests.RpcRequest
	DepositType string `position:"Query" name:"DepositType"`
	ProductType string `position:"Query" name:"ProductType"`
	VpcId       string `position:"Query" name:"VpcId"`
	ZoneId      string `position:"Query" name:"ZoneId"`
}

// ListVswitchResponse is the response struct for api ListVswitch
type ListVswitchResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	VswitchList VswitchList `json:"VswitchList" xml:"VswitchList"`
}

// CreateListVswitchRequest creates a request to invoke ListVswitch API
func CreateListVswitchRequest() (request *ListVswitchRequest) {
	request = &ListVswitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListVswitch", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVswitchResponse creates a response to parse from ListVswitch response
func CreateListVswitchResponse() (response *ListVswitchResponse) {
	response = &ListVswitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
