package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLibraryInstallTaskStatus invokes the emr.UpdateLibraryInstallTaskStatus API synchronously
func (client *Client) UpdateLibraryInstallTaskStatus(request *UpdateLibraryInstallTaskStatusRequest) (response *UpdateLibraryInstallTaskStatusResponse, err error) {
	response = CreateUpdateLibraryInstallTaskStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLibraryInstallTaskStatusWithChan invokes the emr.UpdateLibraryInstallTaskStatus API asynchronously
func (client *Client) UpdateLibraryInstallTaskStatusWithChan(request *UpdateLibraryInstallTaskStatusRequest) (<-chan *UpdateLibraryInstallTaskStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateLibraryInstallTaskStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLibraryInstallTaskStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLibraryInstallTaskStatusWithCallback invokes the emr.UpdateLibraryInstallTaskStatus API asynchronously
func (client *Client) UpdateLibraryInstallTaskStatusWithCallback(request *UpdateLibraryInstallTaskStatusRequest, callback func(response *UpdateLibraryInstallTaskStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLibraryInstallTaskStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateLibraryInstallTaskStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLibraryInstallTaskStatusRequest is the request struct for api UpdateLibraryInstallTaskStatus
type UpdateLibraryInstallTaskStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskBizId       string           `position:"Query" name:"TaskBizId"`
	Status          string           `position:"Query" name:"Status"`
}

// UpdateLibraryInstallTaskStatusResponse is the response struct for api UpdateLibraryInstallTaskStatus
type UpdateLibraryInstallTaskStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateUpdateLibraryInstallTaskStatusRequest creates a request to invoke UpdateLibraryInstallTaskStatus API
func CreateUpdateLibraryInstallTaskStatusRequest() (request *UpdateLibraryInstallTaskStatusRequest) {
	request = &UpdateLibraryInstallTaskStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "UpdateLibraryInstallTaskStatus", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLibraryInstallTaskStatusResponse creates a response to parse from UpdateLibraryInstallTaskStatus response
func CreateUpdateLibraryInstallTaskStatusResponse() (response *UpdateLibraryInstallTaskStatusResponse) {
	response = &UpdateLibraryInstallTaskStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
