package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLifecycleHook invokes the ess.CreateLifecycleHook API synchronously
func (client *Client) CreateLifecycleHook(request *CreateLifecycleHookRequest) (response *CreateLifecycleHookResponse, err error) {
	response = CreateCreateLifecycleHookResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLifecycleHookWithChan invokes the ess.CreateLifecycleHook API asynchronously
func (client *Client) CreateLifecycleHookWithChan(request *CreateLifecycleHookRequest) (<-chan *CreateLifecycleHookResponse, <-chan error) {
	responseChan := make(chan *CreateLifecycleHookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLifecycleHook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLifecycleHookWithCallback invokes the ess.CreateLifecycleHook API asynchronously
func (client *Client) CreateLifecycleHookWithCallback(request *CreateLifecycleHookRequest, callback func(response *CreateLifecycleHookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLifecycleHookResponse
		var err error
		defer close(result)
		response, err = client.CreateLifecycleHook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLifecycleHookRequest is the request struct for api CreateLifecycleHook
type CreateLifecycleHookRequest struct {
	*requests.RpcRequest
	DefaultResult        string           `position:"Query" name:"DefaultResult"`
	HeartbeatTimeout     requests.Integer `position:"Query" name:"HeartbeatTimeout"`
	ScalingGroupId       string           `position:"Query" name:"ScalingGroupId"`
	LifecycleTransition  string           `position:"Query" name:"LifecycleTransition"`
	LifecycleHookName    string           `position:"Query" name:"LifecycleHookName"`
	NotificationArn      string           `position:"Query" name:"NotificationArn"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	NotificationMetadata string           `position:"Query" name:"NotificationMetadata"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateLifecycleHookResponse is the response struct for api CreateLifecycleHook
type CreateLifecycleHookResponse struct {
	*responses.BaseResponse
	LifecycleHookId string `json:"LifecycleHookId" xml:"LifecycleHookId"`
	RequestId       string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateLifecycleHookRequest creates a request to invoke CreateLifecycleHook API
func CreateCreateLifecycleHookRequest() (request *CreateLifecycleHookRequest) {
	request = &CreateLifecycleHookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "CreateLifecycleHook", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLifecycleHookResponse creates a response to parse from CreateLifecycleHook response
func CreateCreateLifecycleHookResponse() (response *CreateLifecycleHookResponse) {
	response = &CreateLifecycleHookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
