package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLifecycleHooks invokes the ess.DescribeLifecycleHooks API synchronously
func (client *Client) DescribeLifecycleHooks(request *DescribeLifecycleHooksRequest) (response *DescribeLifecycleHooksResponse, err error) {
	response = CreateDescribeLifecycleHooksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLifecycleHooksWithChan invokes the ess.DescribeLifecycleHooks API asynchronously
func (client *Client) DescribeLifecycleHooksWithChan(request *DescribeLifecycleHooksRequest) (<-chan *DescribeLifecycleHooksResponse, <-chan error) {
	responseChan := make(chan *DescribeLifecycleHooksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLifecycleHooks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLifecycleHooksWithCallback invokes the ess.DescribeLifecycleHooks API asynchronously
func (client *Client) DescribeLifecycleHooksWithCallback(request *DescribeLifecycleHooksRequest, callback func(response *DescribeLifecycleHooksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLifecycleHooksResponse
		var err error
		defer close(result)
		response, err = client.DescribeLifecycleHooks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLifecycleHooksRequest is the request struct for api DescribeLifecycleHooks
type DescribeLifecycleHooksRequest struct {
	*requests.RpcRequest
	ScalingGroupId       string           `position:"Query" name:"ScalingGroupId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	LifecycleHookName    string           `position:"Query" name:"LifecycleHookName"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	LifecycleHookId      *[]string        `position:"Query" name:"LifecycleHookId"  type:"Repeated"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLifecycleHooksResponse is the response struct for api DescribeLifecycleHooks
type DescribeLifecycleHooksResponse struct {
	*responses.BaseResponse
	TotalCount     int            `json:"TotalCount" xml:"TotalCount"`
	PageNumber     int            `json:"PageNumber" xml:"PageNumber"`
	PageSize       int            `json:"PageSize" xml:"PageSize"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	LifecycleHooks LifecycleHooks `json:"LifecycleHooks" xml:"LifecycleHooks"`
}

// CreateDescribeLifecycleHooksRequest creates a request to invoke DescribeLifecycleHooks API
func CreateDescribeLifecycleHooksRequest() (request *DescribeLifecycleHooksRequest) {
	request = &DescribeLifecycleHooksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "DescribeLifecycleHooks", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLifecycleHooksResponse creates a response to parse from DescribeLifecycleHooks response
func CreateDescribeLifecycleHooksResponse() (response *DescribeLifecycleHooksResponse) {
	response = &DescribeLifecycleHooksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
