package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGlobalDatabaseNetwork invokes the polardb.CreateGlobalDatabaseNetwork API synchronously
func (client *Client) CreateGlobalDatabaseNetwork(request *CreateGlobalDatabaseNetworkRequest) (response *CreateGlobalDatabaseNetworkResponse, err error) {
	response = CreateCreateGlobalDatabaseNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGlobalDatabaseNetworkWithChan invokes the polardb.CreateGlobalDatabaseNetwork API asynchronously
func (client *Client) CreateGlobalDatabaseNetworkWithChan(request *CreateGlobalDatabaseNetworkRequest) (<-chan *CreateGlobalDatabaseNetworkResponse, <-chan error) {
	responseChan := make(chan *CreateGlobalDatabaseNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGlobalDatabaseNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGlobalDatabaseNetworkWithCallback invokes the polardb.CreateGlobalDatabaseNetwork API asynchronously
func (client *Client) CreateGlobalDatabaseNetworkWithCallback(request *CreateGlobalDatabaseNetworkRequest, callback func(response *CreateGlobalDatabaseNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGlobalDatabaseNetworkResponse
		var err error
		defer close(result)
		response, err = client.CreateGlobalDatabaseNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGlobalDatabaseNetworkRequest is the request struct for api CreateGlobalDatabaseNetwork
type CreateGlobalDatabaseNetworkRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	GDNDescription       string           `position:"Query" name:"GDNDescription"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateGlobalDatabaseNetworkResponse is the response struct for api CreateGlobalDatabaseNetwork
type CreateGlobalDatabaseNetworkResponse struct {
	*responses.BaseResponse
	GDNId     string `json:"GDNId" xml:"GDNId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateGlobalDatabaseNetworkRequest creates a request to invoke CreateGlobalDatabaseNetwork API
func CreateCreateGlobalDatabaseNetworkRequest() (request *CreateGlobalDatabaseNetworkRequest) {
	request = &CreateGlobalDatabaseNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CreateGlobalDatabaseNetwork", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGlobalDatabaseNetworkResponse creates a response to parse from CreateGlobalDatabaseNetwork response
func CreateCreateGlobalDatabaseNetworkResponse() (response *CreateGlobalDatabaseNetworkResponse) {
	response = &CreateGlobalDatabaseNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
