package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogBackupPolicy invokes the polardb.DescribeLogBackupPolicy API synchronously
func (client *Client) DescribeLogBackupPolicy(request *DescribeLogBackupPolicyRequest) (response *DescribeLogBackupPolicyResponse, err error) {
	response = CreateDescribeLogBackupPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogBackupPolicyWithChan invokes the polardb.DescribeLogBackupPolicy API asynchronously
func (client *Client) DescribeLogBackupPolicyWithChan(request *DescribeLogBackupPolicyRequest) (<-chan *DescribeLogBackupPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeLogBackupPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogBackupPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogBackupPolicyWithCallback invokes the polardb.DescribeLogBackupPolicy API asynchronously
func (client *Client) DescribeLogBackupPolicyWithCallback(request *DescribeLogBackupPolicyRequest, callback func(response *DescribeLogBackupPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogBackupPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogBackupPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogBackupPolicyRequest is the request struct for api DescribeLogBackupPolicy
type DescribeLogBackupPolicyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLogBackupPolicyResponse is the response struct for api DescribeLogBackupPolicy
type DescribeLogBackupPolicyResponse struct {
	*responses.BaseResponse
	RequestId                string `json:"RequestId" xml:"RequestId"`
	EnableBackupLog          int    `json:"EnableBackupLog" xml:"EnableBackupLog"`
	LogBackupRetentionPeriod int    `json:"LogBackupRetentionPeriod" xml:"LogBackupRetentionPeriod"`
}

// CreateDescribeLogBackupPolicyRequest creates a request to invoke DescribeLogBackupPolicy API
func CreateDescribeLogBackupPolicyRequest() (request *DescribeLogBackupPolicyRequest) {
	request = &DescribeLogBackupPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeLogBackupPolicy", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLogBackupPolicyResponse creates a response to parse from DescribeLogBackupPolicy response
func CreateDescribeLogBackupPolicyResponse() (response *DescribeLogBackupPolicyResponse) {
	response = &DescribeLogBackupPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
