package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGlobalDistributeCache invokes the r_kvstore.DescribeGlobalDistributeCache API synchronously
func (client *Client) DescribeGlobalDistributeCache(request *DescribeGlobalDistributeCacheRequest) (response *DescribeGlobalDistributeCacheResponse, err error) {
	response = CreateDescribeGlobalDistributeCacheResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGlobalDistributeCacheWithChan invokes the r_kvstore.DescribeGlobalDistributeCache API asynchronously
func (client *Client) DescribeGlobalDistributeCacheWithChan(request *DescribeGlobalDistributeCacheRequest) (<-chan *DescribeGlobalDistributeCacheResponse, <-chan error) {
	responseChan := make(chan *DescribeGlobalDistributeCacheResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGlobalDistributeCache(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGlobalDistributeCacheWithCallback invokes the r_kvstore.DescribeGlobalDistributeCache API asynchronously
func (client *Client) DescribeGlobalDistributeCacheWithCallback(request *DescribeGlobalDistributeCacheRequest, callback func(response *DescribeGlobalDistributeCacheResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGlobalDistributeCacheResponse
		var err error
		defer close(result)
		response, err = client.DescribeGlobalDistributeCache(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGlobalDistributeCacheRequest is the request struct for api DescribeGlobalDistributeCache
type DescribeGlobalDistributeCacheRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           string           `position:"Query" name:"PageNumber"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	PageSize             string           `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SubInstanceId        string           `position:"Query" name:"SubInstanceId"`
	GlobalInstanceId     string           `position:"Query" name:"GlobalInstanceId"`
}

// DescribeGlobalDistributeCacheResponse is the response struct for api DescribeGlobalDistributeCache
type DescribeGlobalDistributeCacheResponse struct {
	*responses.BaseResponse
	RequestId              string                  `json:"RequestId" xml:"RequestId"`
	TotalRecordCount       int                     `json:"TotalRecordCount" xml:"TotalRecordCount"`
	PageNumber             int                     `json:"PageNumber" xml:"PageNumber"`
	PageSize               int                     `json:"PageSize" xml:"PageSize"`
	GlobalDistributeCaches []GlobalDistributeCache `json:"GlobalDistributeCaches" xml:"GlobalDistributeCaches"`
}

// CreateDescribeGlobalDistributeCacheRequest creates a request to invoke DescribeGlobalDistributeCache API
func CreateDescribeGlobalDistributeCacheRequest() (request *DescribeGlobalDistributeCacheRequest) {
	request = &DescribeGlobalDistributeCacheRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeGlobalDistributeCache", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGlobalDistributeCacheResponse creates a response to parse from DescribeGlobalDistributeCache response
func CreateDescribeGlobalDistributeCacheResponse() (response *DescribeGlobalDistributeCacheResponse) {
	response = &DescribeGlobalDistributeCacheResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
