package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateIngestionJob invokes the sls.CreateIngestionJob API synchronously
func (client *Client) CreateIngestionJob(request *CreateIngestionJobRequest) (response *CreateIngestionJobResponse, err error) {
	response = CreateCreateIngestionJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreateIngestionJobWithChan invokes the sls.CreateIngestionJob API asynchronously
func (client *Client) CreateIngestionJobWithChan(request *CreateIngestionJobRequest) (<-chan *CreateIngestionJobResponse, <-chan error) {
	responseChan := make(chan *CreateIngestionJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateIngestionJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateIngestionJobWithCallback invokes the sls.CreateIngestionJob API asynchronously
func (client *Client) CreateIngestionJobWithCallback(request *CreateIngestionJobRequest, callback func(response *CreateIngestionJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateIngestionJobResponse
		var err error
		defer close(result)
		response, err = client.CreateIngestionJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateIngestionJobRequest is the request struct for api CreateIngestionJob
type CreateIngestionJobRequest struct {
	*requests.RpcRequest
	Args            string           `position:"Body" name:"Args"`
	Image           string           `position:"Body" name:"Image"`
	EnvFromSecret   string           `position:"Body" name:"EnvFromSecret"`
	RestartPolicy   string           `position:"Body" name:"RestartPolicy"`
	Parallelism     requests.Integer `position:"Body" name:"Parallelism"`
	Namespace       string           `position:"Body" name:"Namespace"`
	Completions     requests.Integer `position:"Body" name:"Completions"`
	EnvVars         string           `position:"Body" name:"EnvVars"`
	ImagePullSecret string           `position:"Body" name:"ImagePullSecret"`
	CallerId        string           `position:"Body" name:"CallerId"`
	Region          string           `position:"Body" name:"Region"`
	JobName         string           `position:"Body" name:"JobName"`
}

// CreateIngestionJobResponse is the response struct for api CreateIngestionJob
type CreateIngestionJobResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateIngestionJobRequest creates a request to invoke CreateIngestionJob API
func CreateCreateIngestionJobRequest() (request *CreateIngestionJobRequest) {
	request = &CreateIngestionJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "CreateIngestionJob", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateIngestionJobResponse creates a response to parse from CreateIngestionJob response
func CreateCreateIngestionJobResponse() (response *CreateIngestionJobResponse) {
	response = &CreateIngestionJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
