package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagGlobalRouteProtocol invokes the smartag.ModifySagGlobalRouteProtocol API synchronously
func (client *Client) ModifySagGlobalRouteProtocol(request *ModifySagGlobalRouteProtocolRequest) (response *ModifySagGlobalRouteProtocolResponse, err error) {
	response = CreateModifySagGlobalRouteProtocolResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagGlobalRouteProtocolWithChan invokes the smartag.ModifySagGlobalRouteProtocol API asynchronously
func (client *Client) ModifySagGlobalRouteProtocolWithChan(request *ModifySagGlobalRouteProtocolRequest) (<-chan *ModifySagGlobalRouteProtocolResponse, <-chan error) {
	responseChan := make(chan *ModifySagGlobalRouteProtocolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagGlobalRouteProtocol(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagGlobalRouteProtocolWithCallback invokes the smartag.ModifySagGlobalRouteProtocol API asynchronously
func (client *Client) ModifySagGlobalRouteProtocolWithCallback(request *ModifySagGlobalRouteProtocolRequest, callback func(response *ModifySagGlobalRouteProtocolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagGlobalRouteProtocolResponse
		var err error
		defer close(result)
		response, err = client.ModifySagGlobalRouteProtocol(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagGlobalRouteProtocolRequest is the request struct for api ModifySagGlobalRouteProtocol
type ModifySagGlobalRouteProtocolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RouteProtocol        string           `position:"Query" name:"RouteProtocol"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// ModifySagGlobalRouteProtocolResponse is the response struct for api ModifySagGlobalRouteProtocol
type ModifySagGlobalRouteProtocolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagGlobalRouteProtocolRequest creates a request to invoke ModifySagGlobalRouteProtocol API
func CreateModifySagGlobalRouteProtocolRequest() (request *ModifySagGlobalRouteProtocolRequest) {
	request = &ModifySagGlobalRouteProtocolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagGlobalRouteProtocol", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySagGlobalRouteProtocolResponse creates a response to parse from ModifySagGlobalRouteProtocol response
func CreateModifySagGlobalRouteProtocolResponse() (response *ModifySagGlobalRouteProtocolResponse) {
	response = &ModifySagGlobalRouteProtocolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
