package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrafficMirrorFilterRules invokes the vpc.CreateTrafficMirrorFilterRules API synchronously
func (client *Client) CreateTrafficMirrorFilterRules(request *CreateTrafficMirrorFilterRulesRequest) (response *CreateTrafficMirrorFilterRulesResponse, err error) {
	response = CreateCreateTrafficMirrorFilterRulesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTrafficMirrorFilterRulesWithChan invokes the vpc.CreateTrafficMirrorFilterRules API asynchronously
func (client *Client) CreateTrafficMirrorFilterRulesWithChan(request *CreateTrafficMirrorFilterRulesRequest) (<-chan *CreateTrafficMirrorFilterRulesResponse, <-chan error) {
	responseChan := make(chan *CreateTrafficMirrorFilterRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrafficMirrorFilterRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrafficMirrorFilterRulesWithCallback invokes the vpc.CreateTrafficMirrorFilterRules API asynchronously
func (client *Client) CreateTrafficMirrorFilterRulesWithCallback(request *CreateTrafficMirrorFilterRulesRequest, callback func(response *CreateTrafficMirrorFilterRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrafficMirrorFilterRulesResponse
		var err error
		defer close(result)
		response, err = client.CreateTrafficMirrorFilterRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrafficMirrorFilterRulesRequest is the request struct for api CreateTrafficMirrorFilterRules
type CreateTrafficMirrorFilterRulesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer                              `position:"Query" name:"ResourceOwnerId"`
	ClientToken           string                                        `position:"Query" name:"ClientToken"`
	IngressRules          *[]CreateTrafficMirrorFilterRulesIngressRules `position:"Query" name:"IngressRules"  type:"Repeated"`
	EgressRules           *[]CreateTrafficMirrorFilterRulesEgressRules  `position:"Query" name:"EgressRules"  type:"Repeated"`
	DryRun                requests.Boolean                              `position:"Query" name:"DryRun"`
	ResourceOwnerAccount  string                                        `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string                                        `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer                              `position:"Query" name:"OwnerId"`
	TrafficMirrorFilterId string                                        `position:"Query" name:"TrafficMirrorFilterId"`
}

// CreateTrafficMirrorFilterRulesIngressRules is a repeated param struct in CreateTrafficMirrorFilterRulesRequest
type CreateTrafficMirrorFilterRulesIngressRules struct {
	Priority             string `name:"Priority"`
	Action               string `name:"Action"`
	Protocol             string `name:"Protocol"`
	DestinationCidrBlock string `name:"DestinationCidrBlock"`
	SourceCidrBlock      string `name:"SourceCidrBlock"`
	DestinationPortRange string `name:"DestinationPortRange"`
	SourcePortRange      string `name:"SourcePortRange"`
}

// CreateTrafficMirrorFilterRulesEgressRules is a repeated param struct in CreateTrafficMirrorFilterRulesRequest
type CreateTrafficMirrorFilterRulesEgressRules struct {
	Priority             string `name:"Priority"`
	Action               string `name:"Action"`
	Protocol             string `name:"Protocol"`
	DestinationCidrBlock string `name:"DestinationCidrBlock"`
	SourceCidrBlock      string `name:"SourceCidrBlock"`
	DestinationPortRange string `name:"DestinationPortRange"`
	SourcePortRange      string `name:"SourcePortRange"`
}

// CreateTrafficMirrorFilterRulesResponse is the response struct for api CreateTrafficMirrorFilterRules
type CreateTrafficMirrorFilterRulesResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	IngressRules []IngressRule `json:"IngressRules" xml:"IngressRules"`
	EgressRules  []EgressRule  `json:"EgressRules" xml:"EgressRules"`
}

// CreateCreateTrafficMirrorFilterRulesRequest creates a request to invoke CreateTrafficMirrorFilterRules API
func CreateCreateTrafficMirrorFilterRulesRequest() (request *CreateTrafficMirrorFilterRulesRequest) {
	request = &CreateTrafficMirrorFilterRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateTrafficMirrorFilterRules", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTrafficMirrorFilterRulesResponse creates a response to parse from CreateTrafficMirrorFilterRules response
func CreateCreateTrafficMirrorFilterRulesResponse() (response *CreateTrafficMirrorFilterRulesResponse) {
	response = &CreateTrafficMirrorFilterRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
