package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNatGatewayAttribute invokes the vpc.GetNatGatewayAttribute API synchronously
func (client *Client) GetNatGatewayAttribute(request *GetNatGatewayAttributeRequest) (response *GetNatGatewayAttributeResponse, err error) {
	response = CreateGetNatGatewayAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// GetNatGatewayAttributeWithChan invokes the vpc.GetNatGatewayAttribute API asynchronously
func (client *Client) GetNatGatewayAttributeWithChan(request *GetNatGatewayAttributeRequest) (<-chan *GetNatGatewayAttributeResponse, <-chan error) {
	responseChan := make(chan *GetNatGatewayAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNatGatewayAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNatGatewayAttributeWithCallback invokes the vpc.GetNatGatewayAttribute API asynchronously
func (client *Client) GetNatGatewayAttributeWithCallback(request *GetNatGatewayAttributeRequest, callback func(response *GetNatGatewayAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNatGatewayAttributeResponse
		var err error
		defer close(result)
		response, err = client.GetNatGatewayAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNatGatewayAttributeRequest is the request struct for api GetNatGatewayAttribute
type GetNatGatewayAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NatGatewayId         string           `position:"Query" name:"NatGatewayId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetNatGatewayAttributeResponse is the response struct for api GetNatGatewayAttribute
type GetNatGatewayAttributeResponse struct {
	*responses.BaseResponse
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	Description            string                 `json:"Description" xml:"Description"`
	NatType                string                 `json:"NatType" xml:"NatType"`
	EcsMetricEnabled       bool                   `json:"EcsMetricEnabled" xml:"EcsMetricEnabled"`
	VpcId                  string                 `json:"VpcId" xml:"VpcId"`
	NatGatewayId           string                 `json:"NatGatewayId" xml:"NatGatewayId"`
	CreationTime           string                 `json:"CreationTime" xml:"CreationTime"`
	ExpiredTime            string                 `json:"ExpiredTime" xml:"ExpiredTime"`
	Name                   string                 `json:"Name" xml:"Name"`
	Status                 string                 `json:"Status" xml:"Status"`
	BusinessStatus         string                 `json:"BusinessStatus" xml:"BusinessStatus"`
	RegionId               string                 `json:"RegionId" xml:"RegionId"`
	ResourceGroupId        string                 `json:"ResourceGroupId" xml:"ResourceGroupId"`
	ForwardTable           ForwardTable           `json:"ForwardTable" xml:"ForwardTable"`
	SnatTable              SnatTable              `json:"SnatTable" xml:"SnatTable"`
	BillingConfig          BillingConfig          `json:"BillingConfig" xml:"BillingConfig"`
	PrivateInfo            PrivateInfo            `json:"PrivateInfo" xml:"PrivateInfo"`
	DeletionProtectionInfo DeletionProtectionInfo `json:"DeletionProtectionInfo" xml:"DeletionProtectionInfo"`
	IpList                 []IpListItem           `json:"IpList" xml:"IpList"`
}

// CreateGetNatGatewayAttributeRequest creates a request to invoke GetNatGatewayAttribute API
func CreateGetNatGatewayAttributeRequest() (request *GetNatGatewayAttributeRequest) {
	request = &GetNatGatewayAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetNatGatewayAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNatGatewayAttributeResponse creates a response to parse from GetNatGatewayAttribute response
func CreateGetNatGatewayAttributeResponse() (response *GetNatGatewayAttributeResponse) {
	response = &GetNatGatewayAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
