package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRegion invokes the cr.GetRegion API synchronously
func (client *Client) GetRegion(request *GetRegionRequest) (response *GetRegionResponse, err error) {
	response = CreateGetRegionResponse()
	err = client.DoAction(request, response)
	return
}

// GetRegionWithChan invokes the cr.GetRegion API asynchronously
func (client *Client) GetRegionWithChan(request *GetRegionRequest) (<-chan *GetRegionResponse, <-chan error) {
	responseChan := make(chan *GetRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRegionWithCallback invokes the cr.GetRegion API asynchronously
func (client *Client) GetRegionWithCallback(request *GetRegionRequest, callback func(response *GetRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRegionResponse
		var err error
		defer close(result)
		response, err = client.GetRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRegionRequest is the request struct for api GetRegion
type GetRegionRequest struct {
	*requests.RoaRequest
	Domain string `position:"Query" name:"Domain"`
}

// GetRegionResponse is the response struct for api GetRegion
type GetRegionResponse struct {
	*responses.BaseResponse
}

// CreateGetRegionRequest creates a request to invoke GetRegion API
func CreateGetRegionRequest() (request *GetRegionRequest) {
	request = &GetRegionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetRegion", "/regions", "acr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRegionResponse creates a response to parse from GetRegion response
func CreateGetRegionResponse() (response *GetRegionResponse) {
	response = &GetRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
