package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWebhook invokes the arms.CreateWebhook API synchronously
func (client *Client) CreateWebhook(request *CreateWebhookRequest) (response *CreateWebhookResponse, err error) {
	response = CreateCreateWebhookResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWebhookWithChan invokes the arms.CreateWebhook API asynchronously
func (client *Client) CreateWebhookWithChan(request *CreateWebhookRequest) (<-chan *CreateWebhookResponse, <-chan error) {
	responseChan := make(chan *CreateWebhookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWebhook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWebhookWithCallback invokes the arms.CreateWebhook API asynchronously
func (client *Client) CreateWebhookWithCallback(request *CreateWebhookRequest, callback func(response *CreateWebhookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWebhookResponse
		var err error
		defer close(result)
		response, err = client.CreateWebhook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWebhookRequest is the request struct for api CreateWebhook
type CreateWebhookRequest struct {
	*requests.RpcRequest
	HttpHeaders string `position:"Query" name:"HttpHeaders"`
	Method      string `position:"Query" name:"Method"`
	HttpParams  string `position:"Query" name:"HttpParams"`
	ProxyUserId string `position:"Query" name:"ProxyUserId"`
	Body        string `position:"Query" name:"Body"`
	Url         string `position:"Query" name:"Url"`
	ContactName string `position:"Query" name:"ContactName"`
}

// CreateWebhookResponse is the response struct for api CreateWebhook
type CreateWebhookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ContactId string `json:"ContactId" xml:"ContactId"`
}

// CreateCreateWebhookRequest creates a request to invoke CreateWebhook API
func CreateCreateWebhookRequest() (request *CreateWebhookRequest) {
	request = &CreateWebhookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "CreateWebhook", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateWebhookResponse creates a response to parse from CreateWebhook response
func CreateCreateWebhookResponse() (response *CreateWebhookResponse) {
	response = &CreateWebhookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
