package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWhitelist invokes the cloudauth.DeleteWhitelist API synchronously
func (client *Client) DeleteWhitelist(request *DeleteWhitelistRequest) (response *DeleteWhitelistResponse, err error) {
	response = CreateDeleteWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWhitelistWithChan invokes the cloudauth.DeleteWhitelist API asynchronously
func (client *Client) DeleteWhitelistWithChan(request *DeleteWhitelistRequest) (<-chan *DeleteWhitelistResponse, <-chan error) {
	responseChan := make(chan *DeleteWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWhitelistWithCallback invokes the cloudauth.DeleteWhitelist API asynchronously
func (client *Client) DeleteWhitelistWithCallback(request *DeleteWhitelistRequest, callback func(response *DeleteWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWhitelistResponse
		var err error
		defer close(result)
		response, err = client.DeleteWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWhitelistRequest is the request struct for api DeleteWhitelist
type DeleteWhitelistRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Ids      string `position:"Query" name:"Ids"`
	Lang     string `position:"Query" name:"Lang"`
}

// DeleteWhitelistResponse is the response struct for api DeleteWhitelist
type DeleteWhitelistResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteWhitelistRequest creates a request to invoke DeleteWhitelist API
func CreateDeleteWhitelistRequest() (request *DeleteWhitelistRequest) {
	request = &DeleteWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DeleteWhitelist", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteWhitelistResponse creates a response to parse from DeleteWhitelist response
func CreateDeleteWhitelistResponse() (response *DeleteWhitelistResponse) {
	response = &DeleteWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
