package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCategories invokes the cloudcallcenter.ListCategories API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcategories.html
func (client *Client) ListCategories(request *ListCategoriesRequest) (response *ListCategoriesResponse, err error) {
	response = CreateListCategoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCategoriesWithChan invokes the cloudcallcenter.ListCategories API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcategories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListCategoriesWithChan(request *ListCategoriesRequest) (<-chan *ListCategoriesResponse, <-chan error) {
	responseChan := make(chan *ListCategoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCategories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCategoriesWithCallback invokes the cloudcallcenter.ListCategories API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listcategories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListCategoriesWithCallback(request *ListCategoriesRequest, callback func(response *ListCategoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCategoriesResponse
		var err error
		defer close(result)
		response, err = client.ListCategories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCategoriesRequest is the request struct for api ListCategories
type ListCategoriesRequest struct {
	*requests.RpcRequest
	Type       requests.Integer `position:"Query" name:"Type"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	ScenarioId string           `position:"Query" name:"ScenarioId"`
}

// ListCategoriesResponse is the response struct for api ListCategories
type ListCategoriesResponse struct {
	*responses.BaseResponse
	RequestId      string              `json:"RequestId" xml:"RequestId"`
	Success        bool                `json:"Success" xml:"Success"`
	Code           string              `json:"Code" xml:"Code"`
	Message        string              `json:"Message" xml:"Message"`
	HttpStatusCode int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Categories     []ScenarioParameter `json:"Categories" xml:"Categories"`
}

// CreateListCategoriesRequest creates a request to invoke ListCategories API
func CreateListCategoriesRequest() (request *ListCategoriesRequest) {
	request = &ListCategoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListCategories", "", "")
	request.Method = requests.POST
	return
}

// CreateListCategoriesResponse creates a response to parse from ListCategories response
func CreateListCategoriesResponse() (response *ListCategoriesResponse) {
	response = &ListCategoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
