package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApplicationLogs invokes the companyreg.ListApplicationLogs API synchronously
func (client *Client) ListApplicationLogs(request *ListApplicationLogsRequest) (response *ListApplicationLogsResponse, err error) {
	response = CreateListApplicationLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListApplicationLogsWithChan invokes the companyreg.ListApplicationLogs API asynchronously
func (client *Client) ListApplicationLogsWithChan(request *ListApplicationLogsRequest) (<-chan *ListApplicationLogsResponse, <-chan error) {
	responseChan := make(chan *ListApplicationLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApplicationLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApplicationLogsWithCallback invokes the companyreg.ListApplicationLogs API asynchronously
func (client *Client) ListApplicationLogsWithCallback(request *ListApplicationLogsRequest, callback func(response *ListApplicationLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApplicationLogsResponse
		var err error
		defer close(result)
		response, err = client.ListApplicationLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApplicationLogsRequest is the request struct for api ListApplicationLogs
type ListApplicationLogsRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// ListApplicationLogsResponse is the response struct for api ListApplicationLogs
type ListApplicationLogsResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListApplicationLogsRequest creates a request to invoke ListApplicationLogs API
func CreateListApplicationLogsRequest() (request *ListApplicationLogsRequest) {
	request = &ListApplicationLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2019-05-08", "ListApplicationLogs", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListApplicationLogsResponse creates a response to parse from ListApplicationLogs response
func CreateListApplicationLogsResponse() (response *ListApplicationLogsResponse) {
	response = &ListApplicationLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
