package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSLS invokes the eas.CreateSLS API synchronously
// api document: https://help.aliyun.com/api/eas/createsls.html
func (client *Client) CreateSLS(request *CreateSLSRequest) (response *CreateSLSResponse, err error) {
	response = CreateCreateSLSResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSLSWithChan invokes the eas.CreateSLS API asynchronously
// api document: https://help.aliyun.com/api/eas/createsls.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSLSWithChan(request *CreateSLSRequest) (<-chan *CreateSLSResponse, <-chan error) {
	responseChan := make(chan *CreateSLSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSLS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSLSWithCallback invokes the eas.CreateSLS API asynchronously
// api document: https://help.aliyun.com/api/eas/createsls.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateSLSWithCallback(request *CreateSLSRequest, callback func(response *CreateSLSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSLSResponse
		var err error
		defer close(result)
		response, err = client.CreateSLS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSLSRequest is the request struct for api CreateSLS
type CreateSLSRequest struct {
	*requests.RoaRequest
	ClusterId    string `position:"Path" name:"cluster_id"`
	ResourceName string `position:"Path" name:"resource_name"`
}

// CreateSLSResponse is the response struct for api CreateSLS
type CreateSLSResponse struct {
	*responses.BaseResponse
}

// CreateCreateSLSRequest creates a request to invoke CreateSLS API
func CreateCreateSLSRequest() (request *CreateSLSRequest) {
	request = &CreateSLSRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "CreateSLS", "/api/resources/[cluster_id]/[resource_name]/log", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSLSResponse creates a response to parse from CreateSLS response
func CreateCreateSLSResponse() (response *CreateSLSResponse) {
	response = &CreateSLSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
