package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SyncService invokes the eas.SyncService API synchronously
// api document: https://help.aliyun.com/api/eas/syncservice.html
func (client *Client) SyncService(request *SyncServiceRequest) (response *SyncServiceResponse, err error) {
	response = CreateSyncServiceResponse()
	err = client.DoAction(request, response)
	return
}

// SyncServiceWithChan invokes the eas.SyncService API asynchronously
// api document: https://help.aliyun.com/api/eas/syncservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SyncServiceWithChan(request *SyncServiceRequest) (<-chan *SyncServiceResponse, <-chan error) {
	responseChan := make(chan *SyncServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SyncService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SyncServiceWithCallback invokes the eas.SyncService API asynchronously
// api document: https://help.aliyun.com/api/eas/syncservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SyncServiceWithCallback(request *SyncServiceRequest, callback func(response *SyncServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SyncServiceResponse
		var err error
		defer close(result)
		response, err = client.SyncService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SyncServiceRequest is the request struct for api SyncService
type SyncServiceRequest struct {
	*requests.RoaRequest
	ServiceName string `position:"Path" name:"service_name"`
	Region      string `position:"Path" name:"region"`
}

// SyncServiceResponse is the response struct for api SyncService
type SyncServiceResponse struct {
	*responses.BaseResponse
}

// CreateSyncServiceRequest creates a request to invoke SyncService API
func CreateSyncServiceRequest() (request *SyncServiceRequest) {
	request = &SyncServiceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2018-05-22", "SyncService", "/api/services/[region]/[service_name]/sync", "", "")
	request.Method = requests.GET
	return
}

// CreateSyncServiceResponse creates a response to parse from SyncService response
func CreateSyncServiceResponse() (response *SyncServiceResponse) {
	response = &SyncServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
