package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportKeywords invokes the green.ExportKeywords API synchronously
func (client *Client) ExportKeywords(request *ExportKeywordsRequest) (response *ExportKeywordsResponse, err error) {
	response = CreateExportKeywordsResponse()
	err = client.DoAction(request, response)
	return
}

// ExportKeywordsWithChan invokes the green.ExportKeywords API asynchronously
func (client *Client) ExportKeywordsWithChan(request *ExportKeywordsRequest) (<-chan *ExportKeywordsResponse, <-chan error) {
	responseChan := make(chan *ExportKeywordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportKeywords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportKeywordsWithCallback invokes the green.ExportKeywords API asynchronously
func (client *Client) ExportKeywordsWithCallback(request *ExportKeywordsRequest, callback func(response *ExportKeywordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportKeywordsResponse
		var err error
		defer close(result)
		response, err = client.ExportKeywords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportKeywordsRequest is the request struct for api ExportKeywords
type ExportKeywordsRequest struct {
	*requests.RpcRequest
	KeywordLibId requests.Integer `position:"Query" name:"KeywordLibId"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
}

// ExportKeywordsResponse is the response struct for api ExportKeywords
type ExportKeywordsResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	DownloadUrl string `json:"DownloadUrl" xml:"DownloadUrl"`
}

// CreateExportKeywordsRequest creates a request to invoke ExportKeywords API
func CreateExportKeywordsRequest() (request *ExportKeywordsRequest) {
	request = &ExportKeywordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Green", "2017-08-23", "ExportKeywords", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExportKeywordsResponse creates a response to parse from ExportKeywords response
func CreateExportKeywordsResponse() (response *ExportKeywordsResponse) {
	response = &ExportKeywordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
