package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VodAsyncScanResults invokes the green.VodAsyncScanResults API synchronously
func (client *Client) VodAsyncScanResults(request *VodAsyncScanResultsRequest) (response *VodAsyncScanResultsResponse, err error) {
	response = CreateVodAsyncScanResultsResponse()
	err = client.DoAction(request, response)
	return
}

// VodAsyncScanResultsWithChan invokes the green.VodAsyncScanResults API asynchronously
func (client *Client) VodAsyncScanResultsWithChan(request *VodAsyncScanResultsRequest) (<-chan *VodAsyncScanResultsResponse, <-chan error) {
	responseChan := make(chan *VodAsyncScanResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VodAsyncScanResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VodAsyncScanResultsWithCallback invokes the green.VodAsyncScanResults API asynchronously
func (client *Client) VodAsyncScanResultsWithCallback(request *VodAsyncScanResultsRequest, callback func(response *VodAsyncScanResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VodAsyncScanResultsResponse
		var err error
		defer close(result)
		response, err = client.VodAsyncScanResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VodAsyncScanResultsRequest is the request struct for api VodAsyncScanResults
type VodAsyncScanResultsRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// VodAsyncScanResultsResponse is the response struct for api VodAsyncScanResults
type VodAsyncScanResultsResponse struct {
	*responses.BaseResponse
}

// CreateVodAsyncScanResultsRequest creates a request to invoke VodAsyncScanResults API
func CreateVodAsyncScanResultsRequest() (request *VodAsyncScanResultsRequest) {
	request = &VodAsyncScanResultsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "VodAsyncScanResults", "/green/vod/results", "green", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVodAsyncScanResultsResponse creates a response to parse from VodAsyncScanResults response
func CreateVodAsyncScanResultsResponse() (response *VodAsyncScanResultsResponse) {
	response = &VodAsyncScanResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
