package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRecordTask invokes the rtc.UpdateRecordTask API synchronously
func (client *Client) UpdateRecordTask(request *UpdateRecordTaskRequest) (response *UpdateRecordTaskResponse, err error) {
	response = CreateUpdateRecordTaskResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRecordTaskWithChan invokes the rtc.UpdateRecordTask API asynchronously
func (client *Client) UpdateRecordTaskWithChan(request *UpdateRecordTaskRequest) (<-chan *UpdateRecordTaskResponse, <-chan error) {
	responseChan := make(chan *UpdateRecordTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRecordTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRecordTaskWithCallback invokes the rtc.UpdateRecordTask API asynchronously
func (client *Client) UpdateRecordTaskWithCallback(request *UpdateRecordTaskRequest, callback func(response *UpdateRecordTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRecordTaskResponse
		var err error
		defer close(result)
		response, err = client.UpdateRecordTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRecordTaskRequest is the request struct for api UpdateRecordTask
type UpdateRecordTaskRequest struct {
	*requests.RpcRequest
	UserPanes    *[]UpdateRecordTaskUserPanes `position:"Query" name:"UserPanes"  type:"Repeated"`
	TaskId       string                       `position:"Query" name:"TaskId"`
	ShowLog      string                       `position:"Query" name:"ShowLog"`
	OwnerId      requests.Integer             `position:"Query" name:"OwnerId"`
	TemplateId   string                       `position:"Query" name:"TemplateId"`
	SubSpecUsers *[]string                    `position:"Query" name:"SubSpecUsers"  type:"Repeated"`
	AppId        string                       `position:"Query" name:"AppId"`
	ChannelId    string                       `position:"Query" name:"ChannelId"`
}

// UpdateRecordTaskUserPanes is a repeated param struct in UpdateRecordTaskRequest
type UpdateRecordTaskUserPanes struct {
	PaneId     string                    `name:"PaneId"`
	UserId     string                    `name:"UserId"`
	SourceType string                    `name:"SourceType"`
	Images     *[]UpdateRecordTaskImages `name:"Images" type:"Repeated"`
	Texts      *[]UpdateRecordTaskTexts  `name:"Texts" type:"Repeated"`
}

// UpdateRecordTaskImages is a repeated param struct in UpdateRecordTaskRequest
type UpdateRecordTaskImages struct {
	Url     string `name:"Url"`
	Display string `name:"Display"`
	X       string `name:"X"`
	Y       string `name:"Y"`
	Width   string `name:"Width"`
	Height  string `name:"Height"`
	ZOrder  string `name:"ZOrder"`
}

// UpdateRecordTaskTexts is a repeated param struct in UpdateRecordTaskRequest
type UpdateRecordTaskTexts struct {
	Text      string `name:"Text"`
	X         string `name:"X"`
	Y         string `name:"Y"`
	FontType  string `name:"FontType"`
	FontSize  string `name:"FontSize"`
	FontColor string `name:"FontColor"`
	ZOrder    string `name:"ZOrder"`
}

// UpdateRecordTaskResponse is the response struct for api UpdateRecordTask
type UpdateRecordTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateRecordTaskRequest creates a request to invoke UpdateRecordTask API
func CreateUpdateRecordTaskRequest() (request *UpdateRecordTaskRequest) {
	request = &UpdateRecordTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "UpdateRecordTask", "rtc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateRecordTaskResponse creates a response to parse from UpdateRecordTask response
func CreateUpdateRecordTaskResponse() (response *UpdateRecordTaskResponse) {
	response = &UpdateRecordTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
