package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchResumeVsStream invokes the vs.BatchResumeVsStream API synchronously
func (client *Client) BatchResumeVsStream(request *BatchResumeVsStreamRequest) (response *BatchResumeVsStreamResponse, err error) {
	response = CreateBatchResumeVsStreamResponse()
	err = client.DoAction(request, response)
	return
}

// BatchResumeVsStreamWithChan invokes the vs.BatchResumeVsStream API asynchronously
func (client *Client) BatchResumeVsStreamWithChan(request *BatchResumeVsStreamRequest) (<-chan *BatchResumeVsStreamResponse, <-chan error) {
	responseChan := make(chan *BatchResumeVsStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchResumeVsStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchResumeVsStreamWithCallback invokes the vs.BatchResumeVsStream API asynchronously
func (client *Client) BatchResumeVsStreamWithCallback(request *BatchResumeVsStreamRequest, callback func(response *BatchResumeVsStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchResumeVsStreamResponse
		var err error
		defer close(result)
		response, err = client.BatchResumeVsStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchResumeVsStreamRequest is the request struct for api BatchResumeVsStream
type BatchResumeVsStreamRequest struct {
	*requests.RpcRequest
	Channel             string           `position:"Query" name:"Channel"`
	ShowLog             string           `position:"Query" name:"ShowLog"`
	ControlStreamAction string           `position:"Query" name:"ControlStreamAction"`
	LiveStreamType      string           `position:"Query" name:"LiveStreamType"`
	DomainName          string           `position:"Query" name:"DomainName"`
	OwnerId             requests.Integer `position:"Query" name:"OwnerId"`
}

// BatchResumeVsStreamResponse is the response struct for api BatchResumeVsStream
type BatchResumeVsStreamResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ResumeResult ResumeResult `json:"ResumeResult" xml:"ResumeResult"`
}

// CreateBatchResumeVsStreamRequest creates a request to invoke BatchResumeVsStream API
func CreateBatchResumeVsStreamRequest() (request *BatchResumeVsStreamRequest) {
	request = &BatchResumeVsStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchResumeVsStream", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchResumeVsStreamResponse creates a response to parse from BatchResumeVsStream response
func CreateBatchResumeVsStreamResponse() (response *BatchResumeVsStreamResponse) {
	response = &BatchResumeVsStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
