package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUnbindParentPlatformDevices invokes the vs.BatchUnbindParentPlatformDevices API synchronously
func (client *Client) BatchUnbindParentPlatformDevices(request *BatchUnbindParentPlatformDevicesRequest) (response *BatchUnbindParentPlatformDevicesResponse, err error) {
	response = CreateBatchUnbindParentPlatformDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUnbindParentPlatformDevicesWithChan invokes the vs.BatchUnbindParentPlatformDevices API asynchronously
func (client *Client) BatchUnbindParentPlatformDevicesWithChan(request *BatchUnbindParentPlatformDevicesRequest) (<-chan *BatchUnbindParentPlatformDevicesResponse, <-chan error) {
	responseChan := make(chan *BatchUnbindParentPlatformDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUnbindParentPlatformDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUnbindParentPlatformDevicesWithCallback invokes the vs.BatchUnbindParentPlatformDevices API asynchronously
func (client *Client) BatchUnbindParentPlatformDevicesWithCallback(request *BatchUnbindParentPlatformDevicesRequest, callback func(response *BatchUnbindParentPlatformDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUnbindParentPlatformDevicesResponse
		var err error
		defer close(result)
		response, err = client.BatchUnbindParentPlatformDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUnbindParentPlatformDevicesRequest is the request struct for api BatchUnbindParentPlatformDevices
type BatchUnbindParentPlatformDevicesRequest struct {
	*requests.RpcRequest
	ParentPlatformId string           `position:"Query" name:"ParentPlatformId"`
	ShowLog          string           `position:"Query" name:"ShowLog"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId         string           `position:"Query" name:"DeviceId"`
}

// BatchUnbindParentPlatformDevicesResponse is the response struct for api BatchUnbindParentPlatformDevices
type BatchUnbindParentPlatformDevicesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateBatchUnbindParentPlatformDevicesRequest creates a request to invoke BatchUnbindParentPlatformDevices API
func CreateBatchUnbindParentPlatformDevicesRequest() (request *BatchUnbindParentPlatformDevicesRequest) {
	request = &BatchUnbindParentPlatformDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BatchUnbindParentPlatformDevices", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchUnbindParentPlatformDevicesResponse creates a response to parse from BatchUnbindParentPlatformDevices response
func CreateBatchUnbindParentPlatformDevicesResponse() (response *BatchUnbindParentPlatformDevicesResponse) {
	response = &BatchUnbindParentPlatformDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
