package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindParentPlatformDevice invokes the vs.BindParentPlatformDevice API synchronously
func (client *Client) BindParentPlatformDevice(request *BindParentPlatformDeviceRequest) (response *BindParentPlatformDeviceResponse, err error) {
	response = CreateBindParentPlatformDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BindParentPlatformDeviceWithChan invokes the vs.BindParentPlatformDevice API asynchronously
func (client *Client) BindParentPlatformDeviceWithChan(request *BindParentPlatformDeviceRequest) (<-chan *BindParentPlatformDeviceResponse, <-chan error) {
	responseChan := make(chan *BindParentPlatformDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindParentPlatformDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindParentPlatformDeviceWithCallback invokes the vs.BindParentPlatformDevice API asynchronously
func (client *Client) BindParentPlatformDeviceWithCallback(request *BindParentPlatformDeviceRequest, callback func(response *BindParentPlatformDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindParentPlatformDeviceResponse
		var err error
		defer close(result)
		response, err = client.BindParentPlatformDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindParentPlatformDeviceRequest is the request struct for api BindParentPlatformDevice
type BindParentPlatformDeviceRequest struct {
	*requests.RpcRequest
	ParentPlatformId string           `position:"Query" name:"ParentPlatformId"`
	ShowLog          string           `position:"Query" name:"ShowLog"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId         string           `position:"Query" name:"DeviceId"`
}

// BindParentPlatformDeviceResponse is the response struct for api BindParentPlatformDevice
type BindParentPlatformDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindParentPlatformDeviceRequest creates a request to invoke BindParentPlatformDevice API
func CreateBindParentPlatformDeviceRequest() (request *BindParentPlatformDeviceRequest) {
	request = &BindParentPlatformDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "BindParentPlatformDevice", "vs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindParentPlatformDeviceResponse creates a response to parse from BindParentPlatformDevice response
func CreateBindParentPlatformDeviceResponse() (response *BindParentPlatformDeviceResponse) {
	response = &BindParentPlatformDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
