package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnSubList invokes the cdn.DescribeCdnSubList API synchronously
func (client *Client) DescribeCdnSubList(request *DescribeCdnSubListRequest) (response *DescribeCdnSubListResponse, err error) {
	response = CreateDescribeCdnSubListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnSubListWithChan invokes the cdn.DescribeCdnSubList API asynchronously
func (client *Client) DescribeCdnSubListWithChan(request *DescribeCdnSubListRequest) (<-chan *DescribeCdnSubListResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnSubListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnSubList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnSubListWithCallback invokes the cdn.DescribeCdnSubList API asynchronously
func (client *Client) DescribeCdnSubListWithCallback(request *DescribeCdnSubListRequest, callback func(response *DescribeCdnSubListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnSubListResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnSubList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnSubListRequest is the request struct for api DescribeCdnSubList
type DescribeCdnSubListRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	Status  string           `position:"Query" name:"Status"`
}

// DescribeCdnSubListResponse is the response struct for api DescribeCdnSubList
type DescribeCdnSubListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Content   string `json:"Content" xml:"Content"`
}

// CreateDescribeCdnSubListRequest creates a request to invoke DescribeCdnSubList API
func CreateDescribeCdnSubListRequest() (request *DescribeCdnSubListRequest) {
	request = &DescribeCdnSubListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnSubList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnSubListResponse creates a response to parse from DescribeCdnSubList response
func CreateDescribeCdnSubListResponse() (response *DescribeCdnSubListResponse) {
	response = &DescribeCdnSubListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
