package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnOfflineLogDeliveryField invokes the dcdn.DescribeDcdnOfflineLogDeliveryField API synchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryField(request *DescribeDcdnOfflineLogDeliveryFieldRequest) (response *DescribeDcdnOfflineLogDeliveryFieldResponse, err error) {
	response = CreateDescribeDcdnOfflineLogDeliveryFieldResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnOfflineLogDeliveryFieldWithChan invokes the dcdn.DescribeDcdnOfflineLogDeliveryField API asynchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryFieldWithChan(request *DescribeDcdnOfflineLogDeliveryFieldRequest) (<-chan *DescribeDcdnOfflineLogDeliveryFieldResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnOfflineLogDeliveryFieldResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnOfflineLogDeliveryField(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnOfflineLogDeliveryFieldWithCallback invokes the dcdn.DescribeDcdnOfflineLogDeliveryField API asynchronously
func (client *Client) DescribeDcdnOfflineLogDeliveryFieldWithCallback(request *DescribeDcdnOfflineLogDeliveryFieldRequest, callback func(response *DescribeDcdnOfflineLogDeliveryFieldResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnOfflineLogDeliveryFieldResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnOfflineLogDeliveryField(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnOfflineLogDeliveryFieldRequest is the request struct for api DescribeDcdnOfflineLogDeliveryField
type DescribeDcdnOfflineLogDeliveryFieldRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDcdnOfflineLogDeliveryFieldResponse is the response struct for api DescribeDcdnOfflineLogDeliveryField
type DescribeDcdnOfflineLogDeliveryFieldResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Fields    []Field `json:"Fields" xml:"Fields"`
}

// CreateDescribeDcdnOfflineLogDeliveryFieldRequest creates a request to invoke DescribeDcdnOfflineLogDeliveryField API
func CreateDescribeDcdnOfflineLogDeliveryFieldRequest() (request *DescribeDcdnOfflineLogDeliveryFieldRequest) {
	request = &DescribeDcdnOfflineLogDeliveryFieldRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnOfflineLogDeliveryField", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnOfflineLogDeliveryFieldResponse creates a response to parse from DescribeDcdnOfflineLogDeliveryField response
func CreateDescribeDcdnOfflineLogDeliveryFieldResponse() (response *DescribeDcdnOfflineLogDeliveryFieldResponse) {
	response = &DescribeDcdnOfflineLogDeliveryFieldResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
