package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImagePipelineExecutions invokes the ecs.DescribeImagePipelineExecutions API synchronously
func (client *Client) DescribeImagePipelineExecutions(request *DescribeImagePipelineExecutionsRequest) (response *DescribeImagePipelineExecutionsResponse, err error) {
	response = CreateDescribeImagePipelineExecutionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImagePipelineExecutionsWithChan invokes the ecs.DescribeImagePipelineExecutions API asynchronously
func (client *Client) DescribeImagePipelineExecutionsWithChan(request *DescribeImagePipelineExecutionsRequest) (<-chan *DescribeImagePipelineExecutionsResponse, <-chan error) {
	responseChan := make(chan *DescribeImagePipelineExecutionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImagePipelineExecutions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImagePipelineExecutionsWithCallback invokes the ecs.DescribeImagePipelineExecutions API asynchronously
func (client *Client) DescribeImagePipelineExecutionsWithCallback(request *DescribeImagePipelineExecutionsRequest, callback func(response *DescribeImagePipelineExecutionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImagePipelineExecutionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeImagePipelineExecutions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImagePipelineExecutionsRequest is the request struct for api DescribeImagePipelineExecutions
type DescribeImagePipelineExecutionsRequest struct {
	*requests.RpcRequest
	ImagePipelineId      string                                `position:"Query" name:"ImagePipelineId"`
	ResourceOwnerId      requests.Integer                      `position:"Query" name:"ResourceOwnerId"`
	ExecutionId          string                                `position:"Query" name:"ExecutionId"`
	NextToken            string                                `position:"Query" name:"NextToken"`
	Tag                  *[]DescribeImagePipelineExecutionsTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                                `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                      `position:"Query" name:"OwnerId"`
	MaxResults           requests.Integer                      `position:"Query" name:"MaxResults"`
	Status               string                                `position:"Query" name:"Status"`
}

// DescribeImagePipelineExecutionsTag is a repeated param struct in DescribeImagePipelineExecutionsRequest
type DescribeImagePipelineExecutionsTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// DescribeImagePipelineExecutionsResponse is the response struct for api DescribeImagePipelineExecutions
type DescribeImagePipelineExecutionsResponse struct {
	*responses.BaseResponse
	NextToken              string                 `json:"NextToken" xml:"NextToken"`
	RequestId              string                 `json:"RequestId" xml:"RequestId"`
	TotalCount             int                    `json:"TotalCount" xml:"TotalCount"`
	MaxResults             int                    `json:"MaxResults" xml:"MaxResults"`
	ImagePipelineExecution ImagePipelineExecution `json:"ImagePipelineExecution" xml:"ImagePipelineExecution"`
}

// CreateDescribeImagePipelineExecutionsRequest creates a request to invoke DescribeImagePipelineExecutions API
func CreateDescribeImagePipelineExecutionsRequest() (request *DescribeImagePipelineExecutionsRequest) {
	request = &DescribeImagePipelineExecutionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeImagePipelineExecutions", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImagePipelineExecutionsResponse creates a response to parse from DescribeImagePipelineExecutions response
func CreateDescribeImagePipelineExecutionsResponse() (response *DescribeImagePipelineExecutionsResponse) {
	response = &DescribeImagePipelineExecutionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
