// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package media

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/mediaservices/mgmt/2020-05-01/media"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AacAudioProfile = original.AacAudioProfile

const (
	AacLc   AacAudioProfile = original.AacLc
	HeAacV1 AacAudioProfile = original.HeAacV1
	HeAacV2 AacAudioProfile = original.HeAacV2
)

type AccountEncryptionKeyType = original.AccountEncryptionKeyType

const (
	CustomerKey AccountEncryptionKeyType = original.CustomerKey
	SystemKey   AccountEncryptionKeyType = original.SystemKey
)

type AnalysisResolution = original.AnalysisResolution

const (
	SourceResolution   AnalysisResolution = original.SourceResolution
	StandardDefinition AnalysisResolution = original.StandardDefinition
)

type AssetContainerPermission = original.AssetContainerPermission

const (
	Read            AssetContainerPermission = original.Read
	ReadWrite       AssetContainerPermission = original.ReadWrite
	ReadWriteDelete AssetContainerPermission = original.ReadWriteDelete
)

type AssetStorageEncryptionFormat = original.AssetStorageEncryptionFormat

const (
	MediaStorageClientEncryption AssetStorageEncryptionFormat = original.MediaStorageClientEncryption
	None                         AssetStorageEncryptionFormat = original.None
)

type AudioAnalysisMode = original.AudioAnalysisMode

const (
	Basic    AudioAnalysisMode = original.Basic
	Standard AudioAnalysisMode = original.Standard
)

type ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.ContentKeyPolicyFairPlayRentalAndLeaseKeyType

const (
	DualExpiry          ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.DualExpiry
	PersistentLimited   ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.PersistentLimited
	PersistentUnlimited ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.PersistentUnlimited
	Undefined           ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.Undefined
	Unknown             ContentKeyPolicyFairPlayRentalAndLeaseKeyType = original.Unknown
)

type ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentType

const (
	ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload  ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload
	ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming
	ContentKeyPolicyPlayReadyContentTypeUnknown              ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUnknown
	ContentKeyPolicyPlayReadyContentTypeUnspecified          ContentKeyPolicyPlayReadyContentType = original.ContentKeyPolicyPlayReadyContentTypeUnspecified
)

type ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseType

const (
	ContentKeyPolicyPlayReadyLicenseTypeNonPersistent ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypeNonPersistent
	ContentKeyPolicyPlayReadyLicenseTypePersistent    ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypePersistent
	ContentKeyPolicyPlayReadyLicenseTypeUnknown       ContentKeyPolicyPlayReadyLicenseType = original.ContentKeyPolicyPlayReadyLicenseTypeUnknown
)

type ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOption

const (
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed                      ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed                   ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed
	ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown                      ContentKeyPolicyPlayReadyUnknownOutputPassingOption = original.ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown
)

type ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenType

const (
	ContentKeyPolicyRestrictionTokenTypeJwt     ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeJwt
	ContentKeyPolicyRestrictionTokenTypeSwt     ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeSwt
	ContentKeyPolicyRestrictionTokenTypeUnknown ContentKeyPolicyRestrictionTokenType = original.ContentKeyPolicyRestrictionTokenTypeUnknown
)

type DeinterlaceMode = original.DeinterlaceMode

const (
	AutoPixelAdaptive DeinterlaceMode = original.AutoPixelAdaptive
	Off               DeinterlaceMode = original.Off
)

type DeinterlaceParity = original.DeinterlaceParity

const (
	Auto             DeinterlaceParity = original.Auto
	BottomFieldFirst DeinterlaceParity = original.BottomFieldFirst
	TopFieldFirst    DeinterlaceParity = original.TopFieldFirst
)

type EncoderNamedPreset = original.EncoderNamedPreset

const (
	AACGoodQualityAudio              EncoderNamedPreset = original.AACGoodQualityAudio
	AdaptiveStreaming                EncoderNamedPreset = original.AdaptiveStreaming
	ContentAwareEncoding             EncoderNamedPreset = original.ContentAwareEncoding
	ContentAwareEncodingExperimental EncoderNamedPreset = original.ContentAwareEncodingExperimental
	CopyAllBitrateNonInterleaved     EncoderNamedPreset = original.CopyAllBitrateNonInterleaved
	H264MultipleBitrate1080p         EncoderNamedPreset = original.H264MultipleBitrate1080p
	H264MultipleBitrate720p          EncoderNamedPreset = original.H264MultipleBitrate720p
	H264MultipleBitrateSD            EncoderNamedPreset = original.H264MultipleBitrateSD
	H264SingleBitrate1080p           EncoderNamedPreset = original.H264SingleBitrate1080p
	H264SingleBitrate720p            EncoderNamedPreset = original.H264SingleBitrate720p
	H264SingleBitrateSD              EncoderNamedPreset = original.H264SingleBitrateSD
)

type EncryptionScheme = original.EncryptionScheme

const (
	EncryptionSchemeCommonEncryptionCbcs EncryptionScheme = original.EncryptionSchemeCommonEncryptionCbcs
	EncryptionSchemeCommonEncryptionCenc EncryptionScheme = original.EncryptionSchemeCommonEncryptionCenc
	EncryptionSchemeEnvelopeEncryption   EncryptionScheme = original.EncryptionSchemeEnvelopeEncryption
	EncryptionSchemeNoEncryption         EncryptionScheme = original.EncryptionSchemeNoEncryption
)

type EntropyMode = original.EntropyMode

const (
	Cabac EntropyMode = original.Cabac
	Cavlc EntropyMode = original.Cavlc
)

type FilterTrackPropertyCompareOperation = original.FilterTrackPropertyCompareOperation

const (
	Equal    FilterTrackPropertyCompareOperation = original.Equal
	NotEqual FilterTrackPropertyCompareOperation = original.NotEqual
)

type FilterTrackPropertyType = original.FilterTrackPropertyType

const (
	FilterTrackPropertyTypeBitrate  FilterTrackPropertyType = original.FilterTrackPropertyTypeBitrate
	FilterTrackPropertyTypeFourCC   FilterTrackPropertyType = original.FilterTrackPropertyTypeFourCC
	FilterTrackPropertyTypeLanguage FilterTrackPropertyType = original.FilterTrackPropertyTypeLanguage
	FilterTrackPropertyTypeName     FilterTrackPropertyType = original.FilterTrackPropertyTypeName
	FilterTrackPropertyTypeType     FilterTrackPropertyType = original.FilterTrackPropertyTypeType
	FilterTrackPropertyTypeUnknown  FilterTrackPropertyType = original.FilterTrackPropertyTypeUnknown
)

type H264Complexity = original.H264Complexity

const (
	Balanced H264Complexity = original.Balanced
	Quality  H264Complexity = original.Quality
	Speed    H264Complexity = original.Speed
)

type H264VideoProfile = original.H264VideoProfile

const (
	H264VideoProfileAuto     H264VideoProfile = original.H264VideoProfileAuto
	H264VideoProfileBaseline H264VideoProfile = original.H264VideoProfileBaseline
	H264VideoProfileHigh     H264VideoProfile = original.H264VideoProfileHigh
	H264VideoProfileHigh422  H264VideoProfile = original.H264VideoProfileHigh422
	H264VideoProfileHigh444  H264VideoProfile = original.H264VideoProfileHigh444
	H264VideoProfileMain     H264VideoProfile = original.H264VideoProfileMain
)

type InsightsType = original.InsightsType

const (
	AllInsights       InsightsType = original.AllInsights
	AudioInsightsOnly InsightsType = original.AudioInsightsOnly
	VideoInsightsOnly InsightsType = original.VideoInsightsOnly
)

type JobErrorCategory = original.JobErrorCategory

const (
	JobErrorCategoryConfiguration JobErrorCategory = original.JobErrorCategoryConfiguration
	JobErrorCategoryContent       JobErrorCategory = original.JobErrorCategoryContent
	JobErrorCategoryDownload      JobErrorCategory = original.JobErrorCategoryDownload
	JobErrorCategoryService       JobErrorCategory = original.JobErrorCategoryService
	JobErrorCategoryUpload        JobErrorCategory = original.JobErrorCategoryUpload
)

type JobErrorCode = original.JobErrorCode

const (
	ConfigurationUnsupported JobErrorCode = original.ConfigurationUnsupported
	ContentMalformed         JobErrorCode = original.ContentMalformed
	ContentUnsupported       JobErrorCode = original.ContentUnsupported
	DownloadNotAccessible    JobErrorCode = original.DownloadNotAccessible
	DownloadTransientError   JobErrorCode = original.DownloadTransientError
	ServiceError             JobErrorCode = original.ServiceError
	ServiceTransientError    JobErrorCode = original.ServiceTransientError
	UploadNotAccessible      JobErrorCode = original.UploadNotAccessible
	UploadTransientError     JobErrorCode = original.UploadTransientError
)

type JobRetry = original.JobRetry

const (
	DoNotRetry JobRetry = original.DoNotRetry
	MayRetry   JobRetry = original.MayRetry
)

type JobState = original.JobState

const (
	Canceled   JobState = original.Canceled
	Canceling  JobState = original.Canceling
	Error      JobState = original.Error
	Finished   JobState = original.Finished
	Processing JobState = original.Processing
	Queued     JobState = original.Queued
	Scheduled  JobState = original.Scheduled
)

type LiveEventEncodingType = original.LiveEventEncodingType

const (
	LiveEventEncodingTypeNone         LiveEventEncodingType = original.LiveEventEncodingTypeNone
	LiveEventEncodingTypePremium1080p LiveEventEncodingType = original.LiveEventEncodingTypePremium1080p
	LiveEventEncodingTypeStandard     LiveEventEncodingType = original.LiveEventEncodingTypeStandard
)

type LiveEventInputProtocol = original.LiveEventInputProtocol

const (
	FragmentedMP4 LiveEventInputProtocol = original.FragmentedMP4
	RTMP          LiveEventInputProtocol = original.RTMP
)

type LiveEventResourceState = original.LiveEventResourceState

const (
	Allocating LiveEventResourceState = original.Allocating
	Deleting   LiveEventResourceState = original.Deleting
	Running    LiveEventResourceState = original.Running
	StandBy    LiveEventResourceState = original.StandBy
	Starting   LiveEventResourceState = original.Starting
	Stopped    LiveEventResourceState = original.Stopped
	Stopping   LiveEventResourceState = original.Stopping
)

type LiveOutputResourceState = original.LiveOutputResourceState

const (
	LiveOutputResourceStateCreating LiveOutputResourceState = original.LiveOutputResourceStateCreating
	LiveOutputResourceStateDeleting LiveOutputResourceState = original.LiveOutputResourceStateDeleting
	LiveOutputResourceStateRunning  LiveOutputResourceState = original.LiveOutputResourceStateRunning
)

type ManagedIdentityType = original.ManagedIdentityType

const (
	ManagedIdentityTypeNone           ManagedIdentityType = original.ManagedIdentityTypeNone
	ManagedIdentityTypeSystemAssigned ManagedIdentityType = original.ManagedIdentityTypeSystemAssigned
)

type MetricAggregationType = original.MetricAggregationType

const (
	Average MetricAggregationType = original.Average
	Count   MetricAggregationType = original.Count
	Total   MetricAggregationType = original.Total
)

type MetricUnit = original.MetricUnit

const (
	MetricUnitBytes        MetricUnit = original.MetricUnitBytes
	MetricUnitCount        MetricUnit = original.MetricUnitCount
	MetricUnitMilliseconds MetricUnit = original.MetricUnitMilliseconds
)

type OdataType = original.OdataType

const (
	OdataTypeContentKeyPolicyPlayReadyContentKeyLocation                                  OdataType = original.OdataTypeContentKeyPolicyPlayReadyContentKeyLocation
	OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader        OdataType = original.OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader
	OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier OdataType = original.OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier
)

type OdataTypeBasicClipTime = original.OdataTypeBasicClipTime

const (
	OdataTypeClipTime                       OdataTypeBasicClipTime = original.OdataTypeClipTime
	OdataTypeMicrosoftMediaAbsoluteClipTime OdataTypeBasicClipTime = original.OdataTypeMicrosoftMediaAbsoluteClipTime
	OdataTypeMicrosoftMediaUtcClipTime      OdataTypeBasicClipTime = original.OdataTypeMicrosoftMediaUtcClipTime
)

type OdataTypeBasicCodec = original.OdataTypeBasicCodec

const (
	OdataTypeCodec                   OdataTypeBasicCodec = original.OdataTypeCodec
	OdataTypeMicrosoftMediaAacAudio  OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaAacAudio
	OdataTypeMicrosoftMediaAudio     OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaAudio
	OdataTypeMicrosoftMediaCopyAudio OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaCopyAudio
	OdataTypeMicrosoftMediaCopyVideo OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaCopyVideo
	OdataTypeMicrosoftMediaH264Video OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaH264Video
	OdataTypeMicrosoftMediaImage     OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaImage
	OdataTypeMicrosoftMediaJpgImage  OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaJpgImage
	OdataTypeMicrosoftMediaPngImage  OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaPngImage
	OdataTypeMicrosoftMediaVideo     OdataTypeBasicCodec = original.OdataTypeMicrosoftMediaVideo
)

type OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeBasicContentKeyPolicyConfiguration

const (
	OdataTypeContentKeyPolicyConfiguration                        OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeContentKeyPolicyConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration   OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration
	OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration  OdataTypeBasicContentKeyPolicyConfiguration = original.OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration
)

type OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeBasicContentKeyPolicyRestriction

const (
	OdataTypeContentKeyPolicyRestriction                      OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeContentKeyPolicyRestriction
	OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction    OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction
	OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction   OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction
	OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction OdataTypeBasicContentKeyPolicyRestriction = original.OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction
)

type OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeBasicContentKeyPolicyRestrictionTokenKey

const (
	OdataTypeContentKeyPolicyRestrictionTokenKey                   OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeContentKeyPolicyRestrictionTokenKey
	OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey             OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey
	OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey       OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey
	OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey OdataTypeBasicContentKeyPolicyRestrictionTokenKey = original.OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey
)

type OdataTypeBasicFormat = original.OdataTypeBasicFormat

const (
	OdataTypeFormat                              OdataTypeBasicFormat = original.OdataTypeFormat
	OdataTypeMicrosoftMediaImageFormat           OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaImageFormat
	OdataTypeMicrosoftMediaJpgFormat             OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaJpgFormat
	OdataTypeMicrosoftMediaMp4Format             OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaMp4Format
	OdataTypeMicrosoftMediaMultiBitrateFormat    OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaMultiBitrateFormat
	OdataTypeMicrosoftMediaPngFormat             OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaPngFormat
	OdataTypeMicrosoftMediaTransportStreamFormat OdataTypeBasicFormat = original.OdataTypeMicrosoftMediaTransportStreamFormat
)

type OdataTypeBasicJobInput = original.OdataTypeBasicJobInput

const (
	OdataTypeJobInput                    OdataTypeBasicJobInput = original.OdataTypeJobInput
	OdataTypeMicrosoftMediaJobInputAsset OdataTypeBasicJobInput = original.OdataTypeMicrosoftMediaJobInputAsset
	OdataTypeMicrosoftMediaJobInputClip  OdataTypeBasicJobInput = original.OdataTypeMicrosoftMediaJobInputClip
	OdataTypeMicrosoftMediaJobInputHTTP  OdataTypeBasicJobInput = original.OdataTypeMicrosoftMediaJobInputHTTP
	OdataTypeMicrosoftMediaJobInputs     OdataTypeBasicJobInput = original.OdataTypeMicrosoftMediaJobInputs
)

type OdataTypeBasicJobOutput = original.OdataTypeBasicJobOutput

const (
	OdataTypeJobOutput                    OdataTypeBasicJobOutput = original.OdataTypeJobOutput
	OdataTypeMicrosoftMediaJobOutputAsset OdataTypeBasicJobOutput = original.OdataTypeMicrosoftMediaJobOutputAsset
)

type OdataTypeBasicLayer = original.OdataTypeBasicLayer

const (
	OdataTypeLayer                    OdataTypeBasicLayer = original.OdataTypeLayer
	OdataTypeMicrosoftMediaH264Layer  OdataTypeBasicLayer = original.OdataTypeMicrosoftMediaH264Layer
	OdataTypeMicrosoftMediaJpgLayer   OdataTypeBasicLayer = original.OdataTypeMicrosoftMediaJpgLayer
	OdataTypeMicrosoftMediaPngLayer   OdataTypeBasicLayer = original.OdataTypeMicrosoftMediaPngLayer
	OdataTypeMicrosoftMediaVideoLayer OdataTypeBasicLayer = original.OdataTypeMicrosoftMediaVideoLayer
)

type OdataTypeBasicOverlay = original.OdataTypeBasicOverlay

const (
	OdataTypeMicrosoftMediaAudioOverlay OdataTypeBasicOverlay = original.OdataTypeMicrosoftMediaAudioOverlay
	OdataTypeMicrosoftMediaVideoOverlay OdataTypeBasicOverlay = original.OdataTypeMicrosoftMediaVideoOverlay
	OdataTypeOverlay                    OdataTypeBasicOverlay = original.OdataTypeOverlay
)

type OdataTypeBasicPreset = original.OdataTypeBasicPreset

const (
	OdataTypeMicrosoftMediaAudioAnalyzerPreset          OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaAudioAnalyzerPreset
	OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset
	OdataTypeMicrosoftMediaFaceDetectorPreset           OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaFaceDetectorPreset
	OdataTypeMicrosoftMediaStandardEncoderPreset        OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaStandardEncoderPreset
	OdataTypeMicrosoftMediaVideoAnalyzerPreset          OdataTypeBasicPreset = original.OdataTypeMicrosoftMediaVideoAnalyzerPreset
	OdataTypePreset                                     OdataTypeBasicPreset = original.OdataTypePreset
)

type OnErrorType = original.OnErrorType

const (
	ContinueJob       OnErrorType = original.ContinueJob
	StopProcessingJob OnErrorType = original.StopProcessingJob
)

type Priority = original.Priority

const (
	High   Priority = original.High
	Low    Priority = original.Low
	Normal Priority = original.Normal
)

type PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningState

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateCreating
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateDeleting
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateFailed
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateSucceeded
)

type PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatus

const (
	Approved PrivateEndpointServiceConnectionStatus = original.Approved
	Pending  PrivateEndpointServiceConnectionStatus = original.Pending
	Rejected PrivateEndpointServiceConnectionStatus = original.Rejected
)

type Rotation = original.Rotation

const (
	RotationAuto      Rotation = original.RotationAuto
	RotationNone      Rotation = original.RotationNone
	RotationRotate0   Rotation = original.RotationRotate0
	RotationRotate180 Rotation = original.RotationRotate180
	RotationRotate270 Rotation = original.RotationRotate270
	RotationRotate90  Rotation = original.RotationRotate90
)

type StorageAccountType = original.StorageAccountType

const (
	Primary   StorageAccountType = original.Primary
	Secondary StorageAccountType = original.Secondary
)

type StorageAuthentication = original.StorageAuthentication

const (
	ManagedIdentity StorageAuthentication = original.ManagedIdentity
	System          StorageAuthentication = original.System
)

type StreamOptionsFlag = original.StreamOptionsFlag

const (
	Default    StreamOptionsFlag = original.Default
	LowLatency StreamOptionsFlag = original.LowLatency
)

type StreamingEndpointResourceState = original.StreamingEndpointResourceState

const (
	StreamingEndpointResourceStateDeleting StreamingEndpointResourceState = original.StreamingEndpointResourceStateDeleting
	StreamingEndpointResourceStateRunning  StreamingEndpointResourceState = original.StreamingEndpointResourceStateRunning
	StreamingEndpointResourceStateScaling  StreamingEndpointResourceState = original.StreamingEndpointResourceStateScaling
	StreamingEndpointResourceStateStarting StreamingEndpointResourceState = original.StreamingEndpointResourceStateStarting
	StreamingEndpointResourceStateStopped  StreamingEndpointResourceState = original.StreamingEndpointResourceStateStopped
	StreamingEndpointResourceStateStopping StreamingEndpointResourceState = original.StreamingEndpointResourceStateStopping
)

type StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyType

const (
	StreamingLocatorContentKeyTypeCommonEncryptionCbcs StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeCommonEncryptionCbcs
	StreamingLocatorContentKeyTypeCommonEncryptionCenc StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeCommonEncryptionCenc
	StreamingLocatorContentKeyTypeEnvelopeEncryption   StreamingLocatorContentKeyType = original.StreamingLocatorContentKeyTypeEnvelopeEncryption
)

type StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocol

const (
	StreamingPolicyStreamingProtocolDash            StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolDash
	StreamingPolicyStreamingProtocolDownload        StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolDownload
	StreamingPolicyStreamingProtocolHls             StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolHls
	StreamingPolicyStreamingProtocolSmoothStreaming StreamingPolicyStreamingProtocol = original.StreamingPolicyStreamingProtocolSmoothStreaming
)

type StretchMode = original.StretchMode

const (
	StretchModeAutoFit  StretchMode = original.StretchModeAutoFit
	StretchModeAutoSize StretchMode = original.StretchModeAutoSize
	StretchModeNone     StretchMode = original.StretchModeNone
)

type TrackPropertyCompareOperation = original.TrackPropertyCompareOperation

const (
	TrackPropertyCompareOperationEqual   TrackPropertyCompareOperation = original.TrackPropertyCompareOperationEqual
	TrackPropertyCompareOperationUnknown TrackPropertyCompareOperation = original.TrackPropertyCompareOperationUnknown
)

type TrackPropertyType = original.TrackPropertyType

const (
	TrackPropertyTypeFourCC  TrackPropertyType = original.TrackPropertyTypeFourCC
	TrackPropertyTypeUnknown TrackPropertyType = original.TrackPropertyTypeUnknown
)

type VideoSyncMode = original.VideoSyncMode

const (
	VideoSyncModeAuto        VideoSyncMode = original.VideoSyncModeAuto
	VideoSyncModeCfr         VideoSyncMode = original.VideoSyncModeCfr
	VideoSyncModePassthrough VideoSyncMode = original.VideoSyncModePassthrough
	VideoSyncModeVfr         VideoSyncMode = original.VideoSyncModeVfr
)

type APIError = original.APIError
type AacAudio = original.AacAudio
type AbsoluteClipTime = original.AbsoluteClipTime
type AccountEncryption = original.AccountEncryption
type AccountFilter = original.AccountFilter
type AccountFilterCollection = original.AccountFilterCollection
type AccountFilterCollectionIterator = original.AccountFilterCollectionIterator
type AccountFilterCollectionPage = original.AccountFilterCollectionPage
type AccountFiltersClient = original.AccountFiltersClient
type AkamaiAccessControl = original.AkamaiAccessControl
type AkamaiSignatureHeaderAuthenticationKey = original.AkamaiSignatureHeaderAuthenticationKey
type Asset = original.Asset
type AssetCollection = original.AssetCollection
type AssetCollectionIterator = original.AssetCollectionIterator
type AssetCollectionPage = original.AssetCollectionPage
type AssetContainerSas = original.AssetContainerSas
type AssetFileEncryptionMetadata = original.AssetFileEncryptionMetadata
type AssetFilter = original.AssetFilter
type AssetFilterCollection = original.AssetFilterCollection
type AssetFilterCollectionIterator = original.AssetFilterCollectionIterator
type AssetFilterCollectionPage = original.AssetFilterCollectionPage
type AssetFiltersClient = original.AssetFiltersClient
type AssetProperties = original.AssetProperties
type AssetStreamingLocator = original.AssetStreamingLocator
type AssetsClient = original.AssetsClient
type Audio = original.Audio
type AudioAnalyzerPreset = original.AudioAnalyzerPreset
type AudioOverlay = original.AudioOverlay
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type BasicAudio = original.BasicAudio
type BasicAudioAnalyzerPreset = original.BasicAudioAnalyzerPreset
type BasicClipTime = original.BasicClipTime
type BasicCodec = original.BasicCodec
type BasicContentKeyPolicyConfiguration = original.BasicContentKeyPolicyConfiguration
type BasicContentKeyPolicyPlayReadyContentKeyLocation = original.BasicContentKeyPolicyPlayReadyContentKeyLocation
type BasicContentKeyPolicyRestriction = original.BasicContentKeyPolicyRestriction
type BasicContentKeyPolicyRestrictionTokenKey = original.BasicContentKeyPolicyRestrictionTokenKey
type BasicFormat = original.BasicFormat
type BasicImage = original.BasicImage
type BasicImageFormat = original.BasicImageFormat
type BasicJobInput = original.BasicJobInput
type BasicJobInputClip = original.BasicJobInputClip
type BasicJobOutput = original.BasicJobOutput
type BasicLayer = original.BasicLayer
type BasicMultiBitrateFormat = original.BasicMultiBitrateFormat
type BasicOverlay = original.BasicOverlay
type BasicPreset = original.BasicPreset
type BasicVideo = original.BasicVideo
type BasicVideoLayer = original.BasicVideoLayer
type BuiltInStandardEncoderPreset = original.BuiltInStandardEncoderPreset
type CbcsDrmConfiguration = original.CbcsDrmConfiguration
type CencDrmConfiguration = original.CencDrmConfiguration
type CheckNameAvailabilityInput = original.CheckNameAvailabilityInput
type ClipTime = original.ClipTime
type Codec = original.Codec
type CommonEncryptionCbcs = original.CommonEncryptionCbcs
type CommonEncryptionCenc = original.CommonEncryptionCenc
type ContentKeyPoliciesClient = original.ContentKeyPoliciesClient
type ContentKeyPolicy = original.ContentKeyPolicy
type ContentKeyPolicyClearKeyConfiguration = original.ContentKeyPolicyClearKeyConfiguration
type ContentKeyPolicyCollection = original.ContentKeyPolicyCollection
type ContentKeyPolicyCollectionIterator = original.ContentKeyPolicyCollectionIterator
type ContentKeyPolicyCollectionPage = original.ContentKeyPolicyCollectionPage
type ContentKeyPolicyConfiguration = original.ContentKeyPolicyConfiguration
type ContentKeyPolicyFairPlayConfiguration = original.ContentKeyPolicyFairPlayConfiguration
type ContentKeyPolicyFairPlayOfflineRentalConfiguration = original.ContentKeyPolicyFairPlayOfflineRentalConfiguration
type ContentKeyPolicyOpenRestriction = original.ContentKeyPolicyOpenRestriction
type ContentKeyPolicyOption = original.ContentKeyPolicyOption
type ContentKeyPolicyPlayReadyConfiguration = original.ContentKeyPolicyPlayReadyConfiguration
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader = original.ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier = original.ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier
type ContentKeyPolicyPlayReadyContentKeyLocation = original.ContentKeyPolicyPlayReadyContentKeyLocation
type ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction = original.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction
type ContentKeyPolicyPlayReadyLicense = original.ContentKeyPolicyPlayReadyLicense
type ContentKeyPolicyPlayReadyPlayRight = original.ContentKeyPolicyPlayReadyPlayRight
type ContentKeyPolicyProperties = original.ContentKeyPolicyProperties
type ContentKeyPolicyRestriction = original.ContentKeyPolicyRestriction
type ContentKeyPolicyRestrictionTokenKey = original.ContentKeyPolicyRestrictionTokenKey
type ContentKeyPolicyRsaTokenKey = original.ContentKeyPolicyRsaTokenKey
type ContentKeyPolicySymmetricTokenKey = original.ContentKeyPolicySymmetricTokenKey
type ContentKeyPolicyTokenClaim = original.ContentKeyPolicyTokenClaim
type ContentKeyPolicyTokenRestriction = original.ContentKeyPolicyTokenRestriction
type ContentKeyPolicyUnknownConfiguration = original.ContentKeyPolicyUnknownConfiguration
type ContentKeyPolicyUnknownRestriction = original.ContentKeyPolicyUnknownRestriction
type ContentKeyPolicyWidevineConfiguration = original.ContentKeyPolicyWidevineConfiguration
type ContentKeyPolicyX509CertificateTokenKey = original.ContentKeyPolicyX509CertificateTokenKey
type CopyAudio = original.CopyAudio
type CopyVideo = original.CopyVideo
type CrossSiteAccessPolicies = original.CrossSiteAccessPolicies
type DefaultKey = original.DefaultKey
type Deinterlace = original.Deinterlace
type EdgePolicies = original.EdgePolicies
type EdgeUsageDataCollectionPolicy = original.EdgeUsageDataCollectionPolicy
type EdgeUsageDataEventHub = original.EdgeUsageDataEventHub
type EnabledProtocols = original.EnabledProtocols
type EntityNameAvailabilityCheckOutput = original.EntityNameAvailabilityCheckOutput
type EnvelopeEncryption = original.EnvelopeEncryption
type FaceDetectorPreset = original.FaceDetectorPreset
type FilterProperties = original.FilterProperties
type FilterTrackPropertyCondition = original.FilterTrackPropertyCondition
type FilterTrackSelection = original.FilterTrackSelection
type Filters = original.Filters
type FirstQuality = original.FirstQuality
type Format = original.Format
type H264Layer = original.H264Layer
type H264Video = original.H264Video
type Hls = original.Hls
type IPAccessControl = original.IPAccessControl
type IPRange = original.IPRange
type Image = original.Image
type ImageFormat = original.ImageFormat
type Job = original.Job
type JobCollection = original.JobCollection
type JobCollectionIterator = original.JobCollectionIterator
type JobCollectionPage = original.JobCollectionPage
type JobError = original.JobError
type JobErrorDetail = original.JobErrorDetail
type JobInput = original.JobInput
type JobInputAsset = original.JobInputAsset
type JobInputClip = original.JobInputClip
type JobInputHTTP = original.JobInputHTTP
type JobInputs = original.JobInputs
type JobOutput = original.JobOutput
type JobOutputAsset = original.JobOutputAsset
type JobProperties = original.JobProperties
type JobsClient = original.JobsClient
type JpgFormat = original.JpgFormat
type JpgImage = original.JpgImage
type JpgLayer = original.JpgLayer
type KeyVaultProperties = original.KeyVaultProperties
type Layer = original.Layer
type ListContainerSasInput = original.ListContainerSasInput
type ListContentKeysResponse = original.ListContentKeysResponse
type ListEdgePoliciesInput = original.ListEdgePoliciesInput
type ListPathsResponse = original.ListPathsResponse
type ListStreamingLocatorsResponse = original.ListStreamingLocatorsResponse
type LiveEvent = original.LiveEvent
type LiveEventActionInput = original.LiveEventActionInput
type LiveEventEncoding = original.LiveEventEncoding
type LiveEventEndpoint = original.LiveEventEndpoint
type LiveEventInput = original.LiveEventInput
type LiveEventInputAccessControl = original.LiveEventInputAccessControl
type LiveEventInputTrackSelection = original.LiveEventInputTrackSelection
type LiveEventListResult = original.LiveEventListResult
type LiveEventListResultIterator = original.LiveEventListResultIterator
type LiveEventListResultPage = original.LiveEventListResultPage
type LiveEventOutputTranscriptionTrack = original.LiveEventOutputTranscriptionTrack
type LiveEventPreview = original.LiveEventPreview
type LiveEventPreviewAccessControl = original.LiveEventPreviewAccessControl
type LiveEventProperties = original.LiveEventProperties
type LiveEventTranscription = original.LiveEventTranscription
type LiveEventsAllocateFuture = original.LiveEventsAllocateFuture
type LiveEventsClient = original.LiveEventsClient
type LiveEventsCreateFuture = original.LiveEventsCreateFuture
type LiveEventsDeleteFuture = original.LiveEventsDeleteFuture
type LiveEventsResetFuture = original.LiveEventsResetFuture
type LiveEventsStartFuture = original.LiveEventsStartFuture
type LiveEventsStopFuture = original.LiveEventsStopFuture
type LiveEventsUpdateFuture = original.LiveEventsUpdateFuture
type LiveOutput = original.LiveOutput
type LiveOutputListResult = original.LiveOutputListResult
type LiveOutputListResultIterator = original.LiveOutputListResultIterator
type LiveOutputListResultPage = original.LiveOutputListResultPage
type LiveOutputProperties = original.LiveOutputProperties
type LiveOutputsClient = original.LiveOutputsClient
type LiveOutputsCreateFuture = original.LiveOutputsCreateFuture
type LiveOutputsDeleteFuture = original.LiveOutputsDeleteFuture
type Location = original.Location
type LocationsClient = original.LocationsClient
type LogSpecification = original.LogSpecification
type MediaservicesClient = original.MediaservicesClient
type MetricDimension = original.MetricDimension
type MetricSpecification = original.MetricSpecification
type Mp4Format = original.Mp4Format
type MultiBitrateFormat = original.MultiBitrateFormat
type NoEncryption = original.NoEncryption
type ODataError = original.ODataError
type Operation = original.Operation
type OperationCollection = original.OperationCollection
type OperationCollectionIterator = original.OperationCollectionIterator
type OperationCollectionPage = original.OperationCollectionPage
type OperationDisplay = original.OperationDisplay
type OperationsClient = original.OperationsClient
type OutputFile = original.OutputFile
type Overlay = original.Overlay
type PngFormat = original.PngFormat
type PngImage = original.PngImage
type PngLayer = original.PngLayer
type PresentationTimeRange = original.PresentationTimeRange
type Preset = original.Preset
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type Properties = original.Properties
type Provider = original.Provider
type ProxyResource = original.ProxyResource
type Rectangle = original.Rectangle
type Resource = original.Resource
type Service = original.Service
type ServiceCollection = original.ServiceCollection
type ServiceCollectionIterator = original.ServiceCollectionIterator
type ServiceCollectionPage = original.ServiceCollectionPage
type ServiceIdentity = original.ServiceIdentity
type ServiceProperties = original.ServiceProperties
type ServiceSpecification = original.ServiceSpecification
type StandardEncoderPreset = original.StandardEncoderPreset
type StorageAccount = original.StorageAccount
type StorageEncryptedAssetDecryptionData = original.StorageEncryptedAssetDecryptionData
type StreamingEndpoint = original.StreamingEndpoint
type StreamingEndpointAccessControl = original.StreamingEndpointAccessControl
type StreamingEndpointListResult = original.StreamingEndpointListResult
type StreamingEndpointListResultIterator = original.StreamingEndpointListResultIterator
type StreamingEndpointListResultPage = original.StreamingEndpointListResultPage
type StreamingEndpointProperties = original.StreamingEndpointProperties
type StreamingEndpointsClient = original.StreamingEndpointsClient
type StreamingEndpointsCreateFuture = original.StreamingEndpointsCreateFuture
type StreamingEndpointsDeleteFuture = original.StreamingEndpointsDeleteFuture
type StreamingEndpointsScaleFuture = original.StreamingEndpointsScaleFuture
type StreamingEndpointsStartFuture = original.StreamingEndpointsStartFuture
type StreamingEndpointsStopFuture = original.StreamingEndpointsStopFuture
type StreamingEndpointsUpdateFuture = original.StreamingEndpointsUpdateFuture
type StreamingEntityScaleUnit = original.StreamingEntityScaleUnit
type StreamingLocator = original.StreamingLocator
type StreamingLocatorCollection = original.StreamingLocatorCollection
type StreamingLocatorCollectionIterator = original.StreamingLocatorCollectionIterator
type StreamingLocatorCollectionPage = original.StreamingLocatorCollectionPage
type StreamingLocatorContentKey = original.StreamingLocatorContentKey
type StreamingLocatorProperties = original.StreamingLocatorProperties
type StreamingLocatorsClient = original.StreamingLocatorsClient
type StreamingPath = original.StreamingPath
type StreamingPoliciesClient = original.StreamingPoliciesClient
type StreamingPolicy = original.StreamingPolicy
type StreamingPolicyCollection = original.StreamingPolicyCollection
type StreamingPolicyCollectionIterator = original.StreamingPolicyCollectionIterator
type StreamingPolicyCollectionPage = original.StreamingPolicyCollectionPage
type StreamingPolicyContentKey = original.StreamingPolicyContentKey
type StreamingPolicyContentKeys = original.StreamingPolicyContentKeys
type StreamingPolicyFairPlayConfiguration = original.StreamingPolicyFairPlayConfiguration
type StreamingPolicyPlayReadyConfiguration = original.StreamingPolicyPlayReadyConfiguration
type StreamingPolicyProperties = original.StreamingPolicyProperties
type StreamingPolicyWidevineConfiguration = original.StreamingPolicyWidevineConfiguration
type SyncStorageKeysInput = original.SyncStorageKeysInput
type TrackPropertyCondition = original.TrackPropertyCondition
type TrackSelection = original.TrackSelection
type TrackedResource = original.TrackedResource
type Transform = original.Transform
type TransformCollection = original.TransformCollection
type TransformCollectionIterator = original.TransformCollectionIterator
type TransformCollectionPage = original.TransformCollectionPage
type TransformOutput = original.TransformOutput
type TransformProperties = original.TransformProperties
type TransformsClient = original.TransformsClient
type TransportStreamFormat = original.TransportStreamFormat
type UtcClipTime = original.UtcClipTime
type Video = original.Video
type VideoAnalyzerPreset = original.VideoAnalyzerPreset
type VideoLayer = original.VideoLayer
type VideoOverlay = original.VideoOverlay

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAccountFilterCollectionIterator(page AccountFilterCollectionPage) AccountFilterCollectionIterator {
	return original.NewAccountFilterCollectionIterator(page)
}
func NewAccountFilterCollectionPage(cur AccountFilterCollection, getNextPage func(context.Context, AccountFilterCollection) (AccountFilterCollection, error)) AccountFilterCollectionPage {
	return original.NewAccountFilterCollectionPage(cur, getNextPage)
}
func NewAccountFiltersClient(subscriptionID string) AccountFiltersClient {
	return original.NewAccountFiltersClient(subscriptionID)
}
func NewAccountFiltersClientWithBaseURI(baseURI string, subscriptionID string) AccountFiltersClient {
	return original.NewAccountFiltersClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssetCollectionIterator(page AssetCollectionPage) AssetCollectionIterator {
	return original.NewAssetCollectionIterator(page)
}
func NewAssetCollectionPage(cur AssetCollection, getNextPage func(context.Context, AssetCollection) (AssetCollection, error)) AssetCollectionPage {
	return original.NewAssetCollectionPage(cur, getNextPage)
}
func NewAssetFilterCollectionIterator(page AssetFilterCollectionPage) AssetFilterCollectionIterator {
	return original.NewAssetFilterCollectionIterator(page)
}
func NewAssetFilterCollectionPage(cur AssetFilterCollection, getNextPage func(context.Context, AssetFilterCollection) (AssetFilterCollection, error)) AssetFilterCollectionPage {
	return original.NewAssetFilterCollectionPage(cur, getNextPage)
}
func NewAssetFiltersClient(subscriptionID string) AssetFiltersClient {
	return original.NewAssetFiltersClient(subscriptionID)
}
func NewAssetFiltersClientWithBaseURI(baseURI string, subscriptionID string) AssetFiltersClient {
	return original.NewAssetFiltersClientWithBaseURI(baseURI, subscriptionID)
}
func NewAssetsClient(subscriptionID string) AssetsClient {
	return original.NewAssetsClient(subscriptionID)
}
func NewAssetsClientWithBaseURI(baseURI string, subscriptionID string) AssetsClient {
	return original.NewAssetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewContentKeyPoliciesClient(subscriptionID string) ContentKeyPoliciesClient {
	return original.NewContentKeyPoliciesClient(subscriptionID)
}
func NewContentKeyPoliciesClientWithBaseURI(baseURI string, subscriptionID string) ContentKeyPoliciesClient {
	return original.NewContentKeyPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewContentKeyPolicyCollectionIterator(page ContentKeyPolicyCollectionPage) ContentKeyPolicyCollectionIterator {
	return original.NewContentKeyPolicyCollectionIterator(page)
}
func NewContentKeyPolicyCollectionPage(cur ContentKeyPolicyCollection, getNextPage func(context.Context, ContentKeyPolicyCollection) (ContentKeyPolicyCollection, error)) ContentKeyPolicyCollectionPage {
	return original.NewContentKeyPolicyCollectionPage(cur, getNextPage)
}
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return original.NewJobCollectionIterator(page)
}
func NewJobCollectionPage(cur JobCollection, getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return original.NewJobCollectionPage(cur, getNextPage)
}
func NewJobsClient(subscriptionID string) JobsClient {
	return original.NewJobsClient(subscriptionID)
}
func NewJobsClientWithBaseURI(baseURI string, subscriptionID string) JobsClient {
	return original.NewJobsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLiveEventListResultIterator(page LiveEventListResultPage) LiveEventListResultIterator {
	return original.NewLiveEventListResultIterator(page)
}
func NewLiveEventListResultPage(cur LiveEventListResult, getNextPage func(context.Context, LiveEventListResult) (LiveEventListResult, error)) LiveEventListResultPage {
	return original.NewLiveEventListResultPage(cur, getNextPage)
}
func NewLiveEventsClient(subscriptionID string) LiveEventsClient {
	return original.NewLiveEventsClient(subscriptionID)
}
func NewLiveEventsClientWithBaseURI(baseURI string, subscriptionID string) LiveEventsClient {
	return original.NewLiveEventsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLiveOutputListResultIterator(page LiveOutputListResultPage) LiveOutputListResultIterator {
	return original.NewLiveOutputListResultIterator(page)
}
func NewLiveOutputListResultPage(cur LiveOutputListResult, getNextPage func(context.Context, LiveOutputListResult) (LiveOutputListResult, error)) LiveOutputListResultPage {
	return original.NewLiveOutputListResultPage(cur, getNextPage)
}
func NewLiveOutputsClient(subscriptionID string) LiveOutputsClient {
	return original.NewLiveOutputsClient(subscriptionID)
}
func NewLiveOutputsClientWithBaseURI(baseURI string, subscriptionID string) LiveOutputsClient {
	return original.NewLiveOutputsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLocationsClient(subscriptionID string) LocationsClient {
	return original.NewLocationsClient(subscriptionID)
}
func NewLocationsClientWithBaseURI(baseURI string, subscriptionID string) LocationsClient {
	return original.NewLocationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewMediaservicesClient(subscriptionID string) MediaservicesClient {
	return original.NewMediaservicesClient(subscriptionID)
}
func NewMediaservicesClientWithBaseURI(baseURI string, subscriptionID string) MediaservicesClient {
	return original.NewMediaservicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationCollectionIterator(page OperationCollectionPage) OperationCollectionIterator {
	return original.NewOperationCollectionIterator(page)
}
func NewOperationCollectionPage(cur OperationCollection, getNextPage func(context.Context, OperationCollection) (OperationCollection, error)) OperationCollectionPage {
	return original.NewOperationCollectionPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceCollectionIterator(page ServiceCollectionPage) ServiceCollectionIterator {
	return original.NewServiceCollectionIterator(page)
}
func NewServiceCollectionPage(cur ServiceCollection, getNextPage func(context.Context, ServiceCollection) (ServiceCollection, error)) ServiceCollectionPage {
	return original.NewServiceCollectionPage(cur, getNextPage)
}
func NewStreamingEndpointListResultIterator(page StreamingEndpointListResultPage) StreamingEndpointListResultIterator {
	return original.NewStreamingEndpointListResultIterator(page)
}
func NewStreamingEndpointListResultPage(cur StreamingEndpointListResult, getNextPage func(context.Context, StreamingEndpointListResult) (StreamingEndpointListResult, error)) StreamingEndpointListResultPage {
	return original.NewStreamingEndpointListResultPage(cur, getNextPage)
}
func NewStreamingEndpointsClient(subscriptionID string) StreamingEndpointsClient {
	return original.NewStreamingEndpointsClient(subscriptionID)
}
func NewStreamingEndpointsClientWithBaseURI(baseURI string, subscriptionID string) StreamingEndpointsClient {
	return original.NewStreamingEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingLocatorCollectionIterator(page StreamingLocatorCollectionPage) StreamingLocatorCollectionIterator {
	return original.NewStreamingLocatorCollectionIterator(page)
}
func NewStreamingLocatorCollectionPage(cur StreamingLocatorCollection, getNextPage func(context.Context, StreamingLocatorCollection) (StreamingLocatorCollection, error)) StreamingLocatorCollectionPage {
	return original.NewStreamingLocatorCollectionPage(cur, getNextPage)
}
func NewStreamingLocatorsClient(subscriptionID string) StreamingLocatorsClient {
	return original.NewStreamingLocatorsClient(subscriptionID)
}
func NewStreamingLocatorsClientWithBaseURI(baseURI string, subscriptionID string) StreamingLocatorsClient {
	return original.NewStreamingLocatorsClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingPoliciesClient(subscriptionID string) StreamingPoliciesClient {
	return original.NewStreamingPoliciesClient(subscriptionID)
}
func NewStreamingPoliciesClientWithBaseURI(baseURI string, subscriptionID string) StreamingPoliciesClient {
	return original.NewStreamingPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewStreamingPolicyCollectionIterator(page StreamingPolicyCollectionPage) StreamingPolicyCollectionIterator {
	return original.NewStreamingPolicyCollectionIterator(page)
}
func NewStreamingPolicyCollectionPage(cur StreamingPolicyCollection, getNextPage func(context.Context, StreamingPolicyCollection) (StreamingPolicyCollection, error)) StreamingPolicyCollectionPage {
	return original.NewStreamingPolicyCollectionPage(cur, getNextPage)
}
func NewTransformCollectionIterator(page TransformCollectionPage) TransformCollectionIterator {
	return original.NewTransformCollectionIterator(page)
}
func NewTransformCollectionPage(cur TransformCollection, getNextPage func(context.Context, TransformCollection) (TransformCollection, error)) TransformCollectionPage {
	return original.NewTransformCollectionPage(cur, getNextPage)
}
func NewTransformsClient(subscriptionID string) TransformsClient {
	return original.NewTransformsClient(subscriptionID)
}
func NewTransformsClientWithBaseURI(baseURI string, subscriptionID string) TransformsClient {
	return original.NewTransformsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAacAudioProfileValues() []AacAudioProfile {
	return original.PossibleAacAudioProfileValues()
}
func PossibleAccountEncryptionKeyTypeValues() []AccountEncryptionKeyType {
	return original.PossibleAccountEncryptionKeyTypeValues()
}
func PossibleAnalysisResolutionValues() []AnalysisResolution {
	return original.PossibleAnalysisResolutionValues()
}
func PossibleAssetContainerPermissionValues() []AssetContainerPermission {
	return original.PossibleAssetContainerPermissionValues()
}
func PossibleAssetStorageEncryptionFormatValues() []AssetStorageEncryptionFormat {
	return original.PossibleAssetStorageEncryptionFormatValues()
}
func PossibleAudioAnalysisModeValues() []AudioAnalysisMode {
	return original.PossibleAudioAnalysisModeValues()
}
func PossibleContentKeyPolicyFairPlayRentalAndLeaseKeyTypeValues() []ContentKeyPolicyFairPlayRentalAndLeaseKeyType {
	return original.PossibleContentKeyPolicyFairPlayRentalAndLeaseKeyTypeValues()
}
func PossibleContentKeyPolicyPlayReadyContentTypeValues() []ContentKeyPolicyPlayReadyContentType {
	return original.PossibleContentKeyPolicyPlayReadyContentTypeValues()
}
func PossibleContentKeyPolicyPlayReadyLicenseTypeValues() []ContentKeyPolicyPlayReadyLicenseType {
	return original.PossibleContentKeyPolicyPlayReadyLicenseTypeValues()
}
func PossibleContentKeyPolicyPlayReadyUnknownOutputPassingOptionValues() []ContentKeyPolicyPlayReadyUnknownOutputPassingOption {
	return original.PossibleContentKeyPolicyPlayReadyUnknownOutputPassingOptionValues()
}
func PossibleContentKeyPolicyRestrictionTokenTypeValues() []ContentKeyPolicyRestrictionTokenType {
	return original.PossibleContentKeyPolicyRestrictionTokenTypeValues()
}
func PossibleDeinterlaceModeValues() []DeinterlaceMode {
	return original.PossibleDeinterlaceModeValues()
}
func PossibleDeinterlaceParityValues() []DeinterlaceParity {
	return original.PossibleDeinterlaceParityValues()
}
func PossibleEncoderNamedPresetValues() []EncoderNamedPreset {
	return original.PossibleEncoderNamedPresetValues()
}
func PossibleEncryptionSchemeValues() []EncryptionScheme {
	return original.PossibleEncryptionSchemeValues()
}
func PossibleEntropyModeValues() []EntropyMode {
	return original.PossibleEntropyModeValues()
}
func PossibleFilterTrackPropertyCompareOperationValues() []FilterTrackPropertyCompareOperation {
	return original.PossibleFilterTrackPropertyCompareOperationValues()
}
func PossibleFilterTrackPropertyTypeValues() []FilterTrackPropertyType {
	return original.PossibleFilterTrackPropertyTypeValues()
}
func PossibleH264ComplexityValues() []H264Complexity {
	return original.PossibleH264ComplexityValues()
}
func PossibleH264VideoProfileValues() []H264VideoProfile {
	return original.PossibleH264VideoProfileValues()
}
func PossibleInsightsTypeValues() []InsightsType {
	return original.PossibleInsightsTypeValues()
}
func PossibleJobErrorCategoryValues() []JobErrorCategory {
	return original.PossibleJobErrorCategoryValues()
}
func PossibleJobErrorCodeValues() []JobErrorCode {
	return original.PossibleJobErrorCodeValues()
}
func PossibleJobRetryValues() []JobRetry {
	return original.PossibleJobRetryValues()
}
func PossibleJobStateValues() []JobState {
	return original.PossibleJobStateValues()
}
func PossibleLiveEventEncodingTypeValues() []LiveEventEncodingType {
	return original.PossibleLiveEventEncodingTypeValues()
}
func PossibleLiveEventInputProtocolValues() []LiveEventInputProtocol {
	return original.PossibleLiveEventInputProtocolValues()
}
func PossibleLiveEventResourceStateValues() []LiveEventResourceState {
	return original.PossibleLiveEventResourceStateValues()
}
func PossibleLiveOutputResourceStateValues() []LiveOutputResourceState {
	return original.PossibleLiveOutputResourceStateValues()
}
func PossibleManagedIdentityTypeValues() []ManagedIdentityType {
	return original.PossibleManagedIdentityTypeValues()
}
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return original.PossibleMetricAggregationTypeValues()
}
func PossibleMetricUnitValues() []MetricUnit {
	return original.PossibleMetricUnitValues()
}
func PossibleOdataTypeBasicClipTimeValues() []OdataTypeBasicClipTime {
	return original.PossibleOdataTypeBasicClipTimeValues()
}
func PossibleOdataTypeBasicCodecValues() []OdataTypeBasicCodec {
	return original.PossibleOdataTypeBasicCodecValues()
}
func PossibleOdataTypeBasicContentKeyPolicyConfigurationValues() []OdataTypeBasicContentKeyPolicyConfiguration {
	return original.PossibleOdataTypeBasicContentKeyPolicyConfigurationValues()
}
func PossibleOdataTypeBasicContentKeyPolicyRestrictionTokenKeyValues() []OdataTypeBasicContentKeyPolicyRestrictionTokenKey {
	return original.PossibleOdataTypeBasicContentKeyPolicyRestrictionTokenKeyValues()
}
func PossibleOdataTypeBasicContentKeyPolicyRestrictionValues() []OdataTypeBasicContentKeyPolicyRestriction {
	return original.PossibleOdataTypeBasicContentKeyPolicyRestrictionValues()
}
func PossibleOdataTypeBasicFormatValues() []OdataTypeBasicFormat {
	return original.PossibleOdataTypeBasicFormatValues()
}
func PossibleOdataTypeBasicJobInputValues() []OdataTypeBasicJobInput {
	return original.PossibleOdataTypeBasicJobInputValues()
}
func PossibleOdataTypeBasicJobOutputValues() []OdataTypeBasicJobOutput {
	return original.PossibleOdataTypeBasicJobOutputValues()
}
func PossibleOdataTypeBasicLayerValues() []OdataTypeBasicLayer {
	return original.PossibleOdataTypeBasicLayerValues()
}
func PossibleOdataTypeBasicOverlayValues() []OdataTypeBasicOverlay {
	return original.PossibleOdataTypeBasicOverlayValues()
}
func PossibleOdataTypeBasicPresetValues() []OdataTypeBasicPreset {
	return original.PossibleOdataTypeBasicPresetValues()
}
func PossibleOdataTypeValues() []OdataType {
	return original.PossibleOdataTypeValues()
}
func PossibleOnErrorTypeValues() []OnErrorType {
	return original.PossibleOnErrorTypeValues()
}
func PossiblePriorityValues() []Priority {
	return original.PossiblePriorityValues()
}
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return original.PossiblePrivateEndpointConnectionProvisioningStateValues()
}
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return original.PossiblePrivateEndpointServiceConnectionStatusValues()
}
func PossibleRotationValues() []Rotation {
	return original.PossibleRotationValues()
}
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return original.PossibleStorageAccountTypeValues()
}
func PossibleStorageAuthenticationValues() []StorageAuthentication {
	return original.PossibleStorageAuthenticationValues()
}
func PossibleStreamOptionsFlagValues() []StreamOptionsFlag {
	return original.PossibleStreamOptionsFlagValues()
}
func PossibleStreamingEndpointResourceStateValues() []StreamingEndpointResourceState {
	return original.PossibleStreamingEndpointResourceStateValues()
}
func PossibleStreamingLocatorContentKeyTypeValues() []StreamingLocatorContentKeyType {
	return original.PossibleStreamingLocatorContentKeyTypeValues()
}
func PossibleStreamingPolicyStreamingProtocolValues() []StreamingPolicyStreamingProtocol {
	return original.PossibleStreamingPolicyStreamingProtocolValues()
}
func PossibleStretchModeValues() []StretchMode {
	return original.PossibleStretchModeValues()
}
func PossibleTrackPropertyCompareOperationValues() []TrackPropertyCompareOperation {
	return original.PossibleTrackPropertyCompareOperationValues()
}
func PossibleTrackPropertyTypeValues() []TrackPropertyType {
	return original.PossibleTrackPropertyTypeValues()
}
func PossibleVideoSyncModeValues() []VideoSyncMode {
	return original.PossibleVideoSyncModeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
