// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ServiceInstance service instance
// swagger:model ServiceInstance
type ServiceInstance struct {

	// Indicates (from the viewpoint of the provider) whether the service instance is (perceived) active or not and is meaningful if enabled is true. The default value is true if not specified.
	// Required: true
	Active *bool `json:"active"`

	// Indicates the current state of the service instance.
	// Required: true
	Enable *bool `json:"enable"`

	// Indicates when the service instance was last accessed or modified, and is meaningful if enabled is true AND active is false. Represented as milliseconds since the epoch, but does not need to be accurate to the second/hour.
	// Required: true
	LastActive *float64 `json:"last_active"`
}

// Validate validates this service instance
func (m *ServiceInstance) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActive(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEnable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastActive(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ServiceInstance) validateActive(formats strfmt.Registry) error {

	if err := validate.Required("active", "body", m.Active); err != nil {
		return err
	}

	return nil
}

func (m *ServiceInstance) validateEnable(formats strfmt.Registry) error {

	if err := validate.Required("enable", "body", m.Enable); err != nil {
		return err
	}

	return nil
}

func (m *ServiceInstance) validateLastActive(formats strfmt.Registry) error {

	if err := validate.Required("last_active", "body", m.LastActive); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ServiceInstance) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ServiceInstance) UnmarshalBinary(b []byte) error {
	var res ServiceInstance
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
