---
layout: "language"
page_title: "textdecodebase64 - Functions - Configuration Language"
sidebar_current: "docs-funcs-encoding-textdecodebase64"
description: |-
  The textdecodebase64 function decodes a string that was previously Base64-encoded,
  and then interprets the result as characters in a specified character encoding.
---

# `textdecodebase64` Function

-> **Note:** This function is supported only in Terraform v0.14 and later.

`textdecodebase64` function decodes a string that was previously Base64-encoded,
and then interprets the result as characters in a specified character encoding.

Terraform uses the "standard" Base64 alphabet as defined in
[RFC 4648 section 4](https://tools.ietf.org/html/rfc4648#section-4).

The `encoding_name` argument must contain one of the encoding names or aliases
recorded in
[the IANA character encoding registry](https://www.iana.org/assignments/character-sets/character-sets.xhtml).
Terraform supports only a subset of the registered encodings, and the encoding
support may vary between Terraform versions.

Terraform accepts the encoding name `UTF-8`, which will produce the same result
as [`base64decode`](./base64decode.html).

## Examples

```
> textdecodebase64("SABlAGwAbABvACAAVwBvAHIAbABkAA==", "UTF-16LE")
Hello World
```

## Related Functions

* [`textencodebase64`](./textencodebase64.html) performs the opposite operation,
  applying target encoding and then Base64 to a string.
* [`base64decode`](./base64decode.html) is effectively a shorthand for
  `textdecodebase64` where the character encoding is fixed as `UTF-8`.
