// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a list branches operation.
type ListBranchesInput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the repository that contains the branches.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListBranchesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBranchesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBranchesInput"}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a list branches operation.
type ListBranchesOutput struct {
	_ struct{} `type:"structure"`

	// The list of branch names.
	Branches []string `locationName:"branches" type:"list"`

	// An enumeration token that returns the batch of the results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBranchesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListBranches = "ListBranches"

// ListBranchesRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Gets information about one or more branches in a repository.
//
//    // Example sending a request using ListBranchesRequest.
//    req := client.ListBranchesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches
func (c *Client) ListBranchesRequest(input *ListBranchesInput) ListBranchesRequest {
	op := &aws.Operation{
		Name:       opListBranches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBranchesInput{}
	}

	req := c.newRequest(op, input, &ListBranchesOutput{})
	return ListBranchesRequest{Request: req, Input: input, Copy: c.ListBranchesRequest}
}

// ListBranchesRequest is the request type for the
// ListBranches API operation.
type ListBranchesRequest struct {
	*aws.Request
	Input *ListBranchesInput
	Copy  func(*ListBranchesInput) ListBranchesRequest
}

// Send marshals and sends the ListBranches API request.
func (r ListBranchesRequest) Send(ctx context.Context) (*ListBranchesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBranchesResponse{
		ListBranchesOutput: r.Request.Data.(*ListBranchesOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBranchesRequestPaginator returns a paginator for ListBranches.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBranchesRequest(input)
//   p := codecommit.NewListBranchesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBranchesPaginator(req ListBranchesRequest) ListBranchesPaginator {
	return ListBranchesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBranchesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBranchesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBranchesPaginator struct {
	aws.Pager
}

func (p *ListBranchesPaginator) CurrentPage() *ListBranchesOutput {
	return p.Pager.CurrentPage().(*ListBranchesOutput)
}

// ListBranchesResponse is the response type for the
// ListBranches API operation.
type ListBranchesResponse struct {
	*ListBranchesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBranches request.
func (r *ListBranchesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
