// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devopsguru

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddNotificationChannel = "AddNotificationChannel"

// AddNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the AddNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddNotificationChannel for more information on using the AddNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddNotificationChannelRequest method.
//    req, resp := client.AddNotificationChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel
func (c *DevOpsGuru) AddNotificationChannelRequest(input *AddNotificationChannelInput) (req *request.Request, output *AddNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opAddNotificationChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/channels",
	}

	if input == nil {
		input = &AddNotificationChannelInput{}
	}

	output = &AddNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddNotificationChannel API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation AddNotificationChannel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * InternalServerException
//
//   * ServiceQuotaExceededException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/AddNotificationChannel
func (c *DevOpsGuru) AddNotificationChannel(input *AddNotificationChannelInput) (*AddNotificationChannelOutput, error) {
	req, out := c.AddNotificationChannelRequest(input)
	return out, req.Send()
}

// AddNotificationChannelWithContext is the same as AddNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See AddNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) AddNotificationChannelWithContext(ctx aws.Context, input *AddNotificationChannelInput, opts ...request.Option) (*AddNotificationChannelOutput, error) {
	req, out := c.AddNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountHealth = "DescribeAccountHealth"

// DescribeAccountHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountHealth for more information on using the DescribeAccountHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountHealthRequest method.
//    req, resp := client.DescribeAccountHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth
func (c *DevOpsGuru) DescribeAccountHealthRequest(input *DescribeAccountHealthInput) (req *request.Request, output *DescribeAccountHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/health",
	}

	if input == nil {
		input = &DescribeAccountHealthInput{}
	}

	output = &DescribeAccountHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountHealth API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAccountHealth for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountHealth
func (c *DevOpsGuru) DescribeAccountHealth(input *DescribeAccountHealthInput) (*DescribeAccountHealthOutput, error) {
	req, out := c.DescribeAccountHealthRequest(input)
	return out, req.Send()
}

// DescribeAccountHealthWithContext is the same as DescribeAccountHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAccountHealthWithContext(ctx aws.Context, input *DescribeAccountHealthInput, opts ...request.Option) (*DescribeAccountHealthOutput, error) {
	req, out := c.DescribeAccountHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountOverview = "DescribeAccountOverview"

// DescribeAccountOverviewRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountOverview operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountOverview for more information on using the DescribeAccountOverview
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountOverviewRequest method.
//    req, resp := client.DescribeAccountOverviewRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview
func (c *DevOpsGuru) DescribeAccountOverviewRequest(input *DescribeAccountOverviewInput) (req *request.Request, output *DescribeAccountOverviewOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountOverview,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/overview",
	}

	if input == nil {
		input = &DescribeAccountOverviewInput{}
	}

	output = &DescribeAccountOverviewOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountOverview API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAccountOverview for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAccountOverview
func (c *DevOpsGuru) DescribeAccountOverview(input *DescribeAccountOverviewInput) (*DescribeAccountOverviewOutput, error) {
	req, out := c.DescribeAccountOverviewRequest(input)
	return out, req.Send()
}

// DescribeAccountOverviewWithContext is the same as DescribeAccountOverview with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountOverview for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAccountOverviewWithContext(ctx aws.Context, input *DescribeAccountOverviewInput, opts ...request.Option) (*DescribeAccountOverviewOutput, error) {
	req, out := c.DescribeAccountOverviewRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAnomaly = "DescribeAnomaly"

// DescribeAnomalyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAnomaly operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAnomaly for more information on using the DescribeAnomaly
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAnomalyRequest method.
//    req, resp := client.DescribeAnomalyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly
func (c *DevOpsGuru) DescribeAnomalyRequest(input *DescribeAnomalyInput) (req *request.Request, output *DescribeAnomalyOutput) {
	op := &request.Operation{
		Name:       opDescribeAnomaly,
		HTTPMethod: "GET",
		HTTPPath:   "/anomalies/{Id}",
	}

	if input == nil {
		input = &DescribeAnomalyInput{}
	}

	output = &DescribeAnomalyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAnomaly API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeAnomaly for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeAnomaly
func (c *DevOpsGuru) DescribeAnomaly(input *DescribeAnomalyInput) (*DescribeAnomalyOutput, error) {
	req, out := c.DescribeAnomalyRequest(input)
	return out, req.Send()
}

// DescribeAnomalyWithContext is the same as DescribeAnomaly with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAnomaly for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeAnomalyWithContext(ctx aws.Context, input *DescribeAnomalyInput, opts ...request.Option) (*DescribeAnomalyOutput, error) {
	req, out := c.DescribeAnomalyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInsight = "DescribeInsight"

// DescribeInsightRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInsight for more information on using the DescribeInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInsightRequest method.
//    req, resp := client.DescribeInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight
func (c *DevOpsGuru) DescribeInsightRequest(input *DescribeInsightInput) (req *request.Request, output *DescribeInsightOutput) {
	op := &request.Operation{
		Name:       opDescribeInsight,
		HTTPMethod: "GET",
		HTTPPath:   "/insights/{Id}",
	}

	if input == nil {
		input = &DescribeInsightInput{}
	}

	output = &DescribeInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInsight API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeInsight for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeInsight
func (c *DevOpsGuru) DescribeInsight(input *DescribeInsightInput) (*DescribeInsightOutput, error) {
	req, out := c.DescribeInsightRequest(input)
	return out, req.Send()
}

// DescribeInsightWithContext is the same as DescribeInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeInsightWithContext(ctx aws.Context, input *DescribeInsightInput, opts ...request.Option) (*DescribeInsightOutput, error) {
	req, out := c.DescribeInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeResourceCollectionHealth = "DescribeResourceCollectionHealth"

// DescribeResourceCollectionHealthRequest generates a "aws/request.Request" representing the
// client's request for the DescribeResourceCollectionHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeResourceCollectionHealth for more information on using the DescribeResourceCollectionHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeResourceCollectionHealthRequest method.
//    req, resp := client.DescribeResourceCollectionHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth
func (c *DevOpsGuru) DescribeResourceCollectionHealthRequest(input *DescribeResourceCollectionHealthInput) (req *request.Request, output *DescribeResourceCollectionHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeResourceCollectionHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/health/resource-collection/{ResourceCollectionType}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeResourceCollectionHealthInput{}
	}

	output = &DescribeResourceCollectionHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeResourceCollectionHealth API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeResourceCollectionHealth for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeResourceCollectionHealth
func (c *DevOpsGuru) DescribeResourceCollectionHealth(input *DescribeResourceCollectionHealthInput) (*DescribeResourceCollectionHealthOutput, error) {
	req, out := c.DescribeResourceCollectionHealthRequest(input)
	return out, req.Send()
}

// DescribeResourceCollectionHealthWithContext is the same as DescribeResourceCollectionHealth with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeResourceCollectionHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeResourceCollectionHealthWithContext(ctx aws.Context, input *DescribeResourceCollectionHealthInput, opts ...request.Option) (*DescribeResourceCollectionHealthOutput, error) {
	req, out := c.DescribeResourceCollectionHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeResourceCollectionHealthPages iterates over the pages of a DescribeResourceCollectionHealth operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeResourceCollectionHealth method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeResourceCollectionHealth operation.
//    pageNum := 0
//    err := client.DescribeResourceCollectionHealthPages(params,
//        func(page *devopsguru.DescribeResourceCollectionHealthOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) DescribeResourceCollectionHealthPages(input *DescribeResourceCollectionHealthInput, fn func(*DescribeResourceCollectionHealthOutput, bool) bool) error {
	return c.DescribeResourceCollectionHealthPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeResourceCollectionHealthPagesWithContext same as DescribeResourceCollectionHealthPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeResourceCollectionHealthPagesWithContext(ctx aws.Context, input *DescribeResourceCollectionHealthInput, fn func(*DescribeResourceCollectionHealthOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeResourceCollectionHealthInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeResourceCollectionHealthRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeResourceCollectionHealthOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeServiceIntegration = "DescribeServiceIntegration"

// DescribeServiceIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServiceIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServiceIntegration for more information on using the DescribeServiceIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServiceIntegrationRequest method.
//    req, resp := client.DescribeServiceIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration
func (c *DevOpsGuru) DescribeServiceIntegrationRequest(input *DescribeServiceIntegrationInput) (req *request.Request, output *DescribeServiceIntegrationOutput) {
	op := &request.Operation{
		Name:       opDescribeServiceIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/service-integrations",
	}

	if input == nil {
		input = &DescribeServiceIntegrationInput{}
	}

	output = &DescribeServiceIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServiceIntegration API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation DescribeServiceIntegration for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/DescribeServiceIntegration
func (c *DevOpsGuru) DescribeServiceIntegration(input *DescribeServiceIntegrationInput) (*DescribeServiceIntegrationOutput, error) {
	req, out := c.DescribeServiceIntegrationRequest(input)
	return out, req.Send()
}

// DescribeServiceIntegrationWithContext is the same as DescribeServiceIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServiceIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) DescribeServiceIntegrationWithContext(ctx aws.Context, input *DescribeServiceIntegrationInput, opts ...request.Option) (*DescribeServiceIntegrationOutput, error) {
	req, out := c.DescribeServiceIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceCollection = "GetResourceCollection"

// GetResourceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the GetResourceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourceCollection for more information on using the GetResourceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceCollectionRequest method.
//    req, resp := client.GetResourceCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection
func (c *DevOpsGuru) GetResourceCollectionRequest(input *GetResourceCollectionInput) (req *request.Request, output *GetResourceCollectionOutput) {
	op := &request.Operation{
		Name:       opGetResourceCollection,
		HTTPMethod: "GET",
		HTTPPath:   "/resource-collections/{ResourceCollectionType}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourceCollectionInput{}
	}

	output = &GetResourceCollectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourceCollection API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation GetResourceCollection for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/GetResourceCollection
func (c *DevOpsGuru) GetResourceCollection(input *GetResourceCollectionInput) (*GetResourceCollectionOutput, error) {
	req, out := c.GetResourceCollectionRequest(input)
	return out, req.Send()
}

// GetResourceCollectionWithContext is the same as GetResourceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) GetResourceCollectionWithContext(ctx aws.Context, input *GetResourceCollectionInput, opts ...request.Option) (*GetResourceCollectionOutput, error) {
	req, out := c.GetResourceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourceCollectionPages iterates over the pages of a GetResourceCollection operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResourceCollection method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResourceCollection operation.
//    pageNum := 0
//    err := client.GetResourceCollectionPages(params,
//        func(page *devopsguru.GetResourceCollectionOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) GetResourceCollectionPages(input *GetResourceCollectionInput, fn func(*GetResourceCollectionOutput, bool) bool) error {
	return c.GetResourceCollectionPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourceCollectionPagesWithContext same as GetResourceCollectionPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) GetResourceCollectionPagesWithContext(ctx aws.Context, input *GetResourceCollectionInput, fn func(*GetResourceCollectionOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourceCollectionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourceCollectionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourceCollectionOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAnomaliesForInsight = "ListAnomaliesForInsight"

// ListAnomaliesForInsightRequest generates a "aws/request.Request" representing the
// client's request for the ListAnomaliesForInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAnomaliesForInsight for more information on using the ListAnomaliesForInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAnomaliesForInsightRequest method.
//    req, resp := client.ListAnomaliesForInsightRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight
func (c *DevOpsGuru) ListAnomaliesForInsightRequest(input *ListAnomaliesForInsightInput) (req *request.Request, output *ListAnomaliesForInsightOutput) {
	op := &request.Operation{
		Name:       opListAnomaliesForInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/anomalies/insight/{InsightId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAnomaliesForInsightInput{}
	}

	output = &ListAnomaliesForInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAnomaliesForInsight API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListAnomaliesForInsight for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListAnomaliesForInsight
func (c *DevOpsGuru) ListAnomaliesForInsight(input *ListAnomaliesForInsightInput) (*ListAnomaliesForInsightOutput, error) {
	req, out := c.ListAnomaliesForInsightRequest(input)
	return out, req.Send()
}

// ListAnomaliesForInsightWithContext is the same as ListAnomaliesForInsight with the addition of
// the ability to pass a context and additional request options.
//
// See ListAnomaliesForInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListAnomaliesForInsightWithContext(ctx aws.Context, input *ListAnomaliesForInsightInput, opts ...request.Option) (*ListAnomaliesForInsightOutput, error) {
	req, out := c.ListAnomaliesForInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAnomaliesForInsightPages iterates over the pages of a ListAnomaliesForInsight operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAnomaliesForInsight method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAnomaliesForInsight operation.
//    pageNum := 0
//    err := client.ListAnomaliesForInsightPages(params,
//        func(page *devopsguru.ListAnomaliesForInsightOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListAnomaliesForInsightPages(input *ListAnomaliesForInsightInput, fn func(*ListAnomaliesForInsightOutput, bool) bool) error {
	return c.ListAnomaliesForInsightPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAnomaliesForInsightPagesWithContext same as ListAnomaliesForInsightPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListAnomaliesForInsightPagesWithContext(ctx aws.Context, input *ListAnomaliesForInsightInput, fn func(*ListAnomaliesForInsightOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAnomaliesForInsightInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAnomaliesForInsightRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAnomaliesForInsightOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEvents = "ListEvents"

// ListEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEvents for more information on using the ListEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventsRequest method.
//    req, resp := client.ListEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents
func (c *DevOpsGuru) ListEventsRequest(input *ListEventsInput) (req *request.Request, output *ListEventsOutput) {
	op := &request.Operation{
		Name:       opListEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/events",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventsInput{}
	}

	output = &ListEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEvents API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListEvents for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListEvents
func (c *DevOpsGuru) ListEvents(input *ListEventsInput) (*ListEventsOutput, error) {
	req, out := c.ListEventsRequest(input)
	return out, req.Send()
}

// ListEventsWithContext is the same as ListEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListEventsWithContext(ctx aws.Context, input *ListEventsInput, opts ...request.Option) (*ListEventsOutput, error) {
	req, out := c.ListEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEventsPages iterates over the pages of a ListEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEvents operation.
//    pageNum := 0
//    err := client.ListEventsPages(params,
//        func(page *devopsguru.ListEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListEventsPages(input *ListEventsInput, fn func(*ListEventsOutput, bool) bool) error {
	return c.ListEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEventsPagesWithContext same as ListEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListEventsPagesWithContext(ctx aws.Context, input *ListEventsInput, fn func(*ListEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInsights = "ListInsights"

// ListInsightsRequest generates a "aws/request.Request" representing the
// client's request for the ListInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInsights for more information on using the ListInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInsightsRequest method.
//    req, resp := client.ListInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights
func (c *DevOpsGuru) ListInsightsRequest(input *ListInsightsInput) (req *request.Request, output *ListInsightsOutput) {
	op := &request.Operation{
		Name:       opListInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInsightsInput{}
	}

	output = &ListInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInsights API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListInsights for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListInsights
func (c *DevOpsGuru) ListInsights(input *ListInsightsInput) (*ListInsightsOutput, error) {
	req, out := c.ListInsightsRequest(input)
	return out, req.Send()
}

// ListInsightsWithContext is the same as ListInsights with the addition of
// the ability to pass a context and additional request options.
//
// See ListInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListInsightsWithContext(ctx aws.Context, input *ListInsightsInput, opts ...request.Option) (*ListInsightsOutput, error) {
	req, out := c.ListInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInsightsPages iterates over the pages of a ListInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInsights operation.
//    pageNum := 0
//    err := client.ListInsightsPages(params,
//        func(page *devopsguru.ListInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListInsightsPages(input *ListInsightsInput, fn func(*ListInsightsOutput, bool) bool) error {
	return c.ListInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInsightsPagesWithContext same as ListInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListInsightsPagesWithContext(ctx aws.Context, input *ListInsightsInput, fn func(*ListInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNotificationChannels = "ListNotificationChannels"

// ListNotificationChannelsRequest generates a "aws/request.Request" representing the
// client's request for the ListNotificationChannels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNotificationChannels for more information on using the ListNotificationChannels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNotificationChannelsRequest method.
//    req, resp := client.ListNotificationChannelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels
func (c *DevOpsGuru) ListNotificationChannelsRequest(input *ListNotificationChannelsInput) (req *request.Request, output *ListNotificationChannelsOutput) {
	op := &request.Operation{
		Name:       opListNotificationChannels,
		HTTPMethod: "POST",
		HTTPPath:   "/channels",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNotificationChannelsInput{}
	}

	output = &ListNotificationChannelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNotificationChannels API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListNotificationChannels for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListNotificationChannels
func (c *DevOpsGuru) ListNotificationChannels(input *ListNotificationChannelsInput) (*ListNotificationChannelsOutput, error) {
	req, out := c.ListNotificationChannelsRequest(input)
	return out, req.Send()
}

// ListNotificationChannelsWithContext is the same as ListNotificationChannels with the addition of
// the ability to pass a context and additional request options.
//
// See ListNotificationChannels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListNotificationChannelsWithContext(ctx aws.Context, input *ListNotificationChannelsInput, opts ...request.Option) (*ListNotificationChannelsOutput, error) {
	req, out := c.ListNotificationChannelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNotificationChannelsPages iterates over the pages of a ListNotificationChannels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNotificationChannels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNotificationChannels operation.
//    pageNum := 0
//    err := client.ListNotificationChannelsPages(params,
//        func(page *devopsguru.ListNotificationChannelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListNotificationChannelsPages(input *ListNotificationChannelsInput, fn func(*ListNotificationChannelsOutput, bool) bool) error {
	return c.ListNotificationChannelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNotificationChannelsPagesWithContext same as ListNotificationChannelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListNotificationChannelsPagesWithContext(ctx aws.Context, input *ListNotificationChannelsInput, fn func(*ListNotificationChannelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNotificationChannelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNotificationChannelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNotificationChannelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecommendations = "ListRecommendations"

// ListRecommendationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecommendations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecommendations for more information on using the ListRecommendations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRecommendationsRequest method.
//    req, resp := client.ListRecommendationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations
func (c *DevOpsGuru) ListRecommendationsRequest(input *ListRecommendationsInput) (req *request.Request, output *ListRecommendationsOutput) {
	op := &request.Operation{
		Name:       opListRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/recommendations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecommendationsInput{}
	}

	output = &ListRecommendationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecommendations API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation ListRecommendations for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/ListRecommendations
func (c *DevOpsGuru) ListRecommendations(input *ListRecommendationsInput) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	return out, req.Send()
}

// ListRecommendationsWithContext is the same as ListRecommendations with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecommendations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListRecommendationsWithContext(ctx aws.Context, input *ListRecommendationsInput, opts ...request.Option) (*ListRecommendationsOutput, error) {
	req, out := c.ListRecommendationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecommendationsPages iterates over the pages of a ListRecommendations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecommendations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRecommendations operation.
//    pageNum := 0
//    err := client.ListRecommendationsPages(params,
//        func(page *devopsguru.ListRecommendationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) ListRecommendationsPages(input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool) error {
	return c.ListRecommendationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecommendationsPagesWithContext same as ListRecommendationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) ListRecommendationsPagesWithContext(ctx aws.Context, input *ListRecommendationsInput, fn func(*ListRecommendationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecommendationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecommendationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecommendationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutFeedback = "PutFeedback"

// PutFeedbackRequest generates a "aws/request.Request" representing the
// client's request for the PutFeedback operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFeedback for more information on using the PutFeedback
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutFeedbackRequest method.
//    req, resp := client.PutFeedbackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback
func (c *DevOpsGuru) PutFeedbackRequest(input *PutFeedbackInput) (req *request.Request, output *PutFeedbackOutput) {
	op := &request.Operation{
		Name:       opPutFeedback,
		HTTPMethod: "PUT",
		HTTPPath:   "/feedback",
	}

	if input == nil {
		input = &PutFeedbackInput{}
	}

	output = &PutFeedbackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutFeedback API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation PutFeedback for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/PutFeedback
func (c *DevOpsGuru) PutFeedback(input *PutFeedbackInput) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	return out, req.Send()
}

// PutFeedbackWithContext is the same as PutFeedback with the addition of
// the ability to pass a context and additional request options.
//
// See PutFeedback for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) PutFeedbackWithContext(ctx aws.Context, input *PutFeedbackInput, opts ...request.Option) (*PutFeedbackOutput, error) {
	req, out := c.PutFeedbackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveNotificationChannel = "RemoveNotificationChannel"

// RemoveNotificationChannelRequest generates a "aws/request.Request" representing the
// client's request for the RemoveNotificationChannel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveNotificationChannel for more information on using the RemoveNotificationChannel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveNotificationChannelRequest method.
//    req, resp := client.RemoveNotificationChannelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel
func (c *DevOpsGuru) RemoveNotificationChannelRequest(input *RemoveNotificationChannelInput) (req *request.Request, output *RemoveNotificationChannelOutput) {
	op := &request.Operation{
		Name:       opRemoveNotificationChannel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/channels/{Id}",
	}

	if input == nil {
		input = &RemoveNotificationChannelInput{}
	}

	output = &RemoveNotificationChannelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveNotificationChannel API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation RemoveNotificationChannel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
//   * ResourceNotFoundException
//
//   * ThrottlingException
//
//   * ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/RemoveNotificationChannel
func (c *DevOpsGuru) RemoveNotificationChannel(input *RemoveNotificationChannelInput) (*RemoveNotificationChannelOutput, error) {
	req, out := c.RemoveNotificationChannelRequest(input)
	return out, req.Send()
}

// RemoveNotificationChannelWithContext is the same as RemoveNotificationChannel with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveNotificationChannel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) RemoveNotificationChannelWithContext(ctx aws.Context, input *RemoveNotificationChannelInput, opts ...request.Option) (*RemoveNotificationChannelOutput, error) {
	req, out := c.RemoveNotificationChannelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchInsights = "SearchInsights"

// SearchInsightsRequest generates a "aws/request.Request" representing the
// client's request for the SearchInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchInsights for more information on using the SearchInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchInsightsRequest method.
//    req, resp := client.SearchInsightsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights
func (c *DevOpsGuru) SearchInsightsRequest(input *SearchInsightsInput) (req *request.Request, output *SearchInsightsOutput) {
	op := &request.Operation{
		Name:       opSearchInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/insights/search",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchInsightsInput{}
	}

	output = &SearchInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchInsights API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation SearchInsights for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/SearchInsights
func (c *DevOpsGuru) SearchInsights(input *SearchInsightsInput) (*SearchInsightsOutput, error) {
	req, out := c.SearchInsightsRequest(input)
	return out, req.Send()
}

// SearchInsightsWithContext is the same as SearchInsights with the addition of
// the ability to pass a context and additional request options.
//
// See SearchInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) SearchInsightsWithContext(ctx aws.Context, input *SearchInsightsInput, opts ...request.Option) (*SearchInsightsOutput, error) {
	req, out := c.SearchInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchInsightsPages iterates over the pages of a SearchInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SearchInsights operation.
//    pageNum := 0
//    err := client.SearchInsightsPages(params,
//        func(page *devopsguru.SearchInsightsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DevOpsGuru) SearchInsightsPages(input *SearchInsightsInput, fn func(*SearchInsightsOutput, bool) bool) error {
	return c.SearchInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchInsightsPagesWithContext same as SearchInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) SearchInsightsPagesWithContext(ctx aws.Context, input *SearchInsightsInput, fn func(*SearchInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateResourceCollection = "UpdateResourceCollection"

// UpdateResourceCollectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResourceCollection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResourceCollection for more information on using the UpdateResourceCollection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceCollectionRequest method.
//    req, resp := client.UpdateResourceCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection
func (c *DevOpsGuru) UpdateResourceCollectionRequest(input *UpdateResourceCollectionInput) (req *request.Request, output *UpdateResourceCollectionOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceCollection,
		HTTPMethod: "PUT",
		HTTPPath:   "/resource-collections",
	}

	if input == nil {
		input = &UpdateResourceCollectionInput{}
	}

	output = &UpdateResourceCollectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateResourceCollection API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation UpdateResourceCollection for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateResourceCollection
func (c *DevOpsGuru) UpdateResourceCollection(input *UpdateResourceCollectionInput) (*UpdateResourceCollectionOutput, error) {
	req, out := c.UpdateResourceCollectionRequest(input)
	return out, req.Send()
}

// UpdateResourceCollectionWithContext is the same as UpdateResourceCollection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceCollection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) UpdateResourceCollectionWithContext(ctx aws.Context, input *UpdateResourceCollectionInput, opts ...request.Option) (*UpdateResourceCollectionOutput, error) {
	req, out := c.UpdateResourceCollectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceIntegration = "UpdateServiceIntegration"

// UpdateServiceIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceIntegration for more information on using the UpdateServiceIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServiceIntegrationRequest method.
//    req, resp := client.UpdateServiceIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration
func (c *DevOpsGuru) UpdateServiceIntegrationRequest(input *UpdateServiceIntegrationInput) (req *request.Request, output *UpdateServiceIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceIntegration,
		HTTPMethod: "PUT",
		HTTPPath:   "/service-integrations",
	}

	if input == nil {
		input = &UpdateServiceIntegrationInput{}
	}

	output = &UpdateServiceIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServiceIntegration API operation for Amazon DevOps Guru.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DevOps Guru's
// API operation UpdateServiceIntegration for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//
//   * ValidationException
//
//   * InternalServerException
//
//   * ConflictException
//
//   * AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/devops-guru-2020-12-01/UpdateServiceIntegration
func (c *DevOpsGuru) UpdateServiceIntegration(input *UpdateServiceIntegrationInput) (*UpdateServiceIntegrationOutput, error) {
	req, out := c.UpdateServiceIntegrationRequest(input)
	return out, req.Send()
}

// UpdateServiceIntegrationWithContext is the same as UpdateServiceIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DevOpsGuru) UpdateServiceIntegrationWithContext(ctx aws.Context, input *UpdateServiceIntegrationInput, opts ...request.Option) (*UpdateServiceIntegrationOutput, error) {
	req, out := c.UpdateServiceIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddNotificationChannelInput struct {
	_ struct{} `type:"structure"`

	// Config is a required field
	Config *NotificationChannelConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddNotificationChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddNotificationChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddNotificationChannelInput"}
	if s.Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Config"))
	}
	if s.Config != nil {
		if err := s.Config.Validate(); err != nil {
			invalidParams.AddNested("Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfig sets the Config field's value.
func (s *AddNotificationChannelInput) SetConfig(v *NotificationChannelConfig) *AddNotificationChannelInput {
	s.Config = v
	return s
}

type AddNotificationChannelOutput struct {
	_ struct{} `type:"structure"`

	Id *string `min:"36" type:"string"`
}

// String returns the string representation
func (s AddNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddNotificationChannelOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *AddNotificationChannelOutput) SetId(v string) *AddNotificationChannelOutput {
	s.Id = &v
	return s
}

type AnomalySourceDetails struct {
	_ struct{} `type:"structure"`

	CloudWatchMetrics []*CloudWatchMetricsDetail `type:"list"`
}

// String returns the string representation
func (s AnomalySourceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnomalySourceDetails) GoString() string {
	return s.String()
}

// SetCloudWatchMetrics sets the CloudWatchMetrics field's value.
func (s *AnomalySourceDetails) SetCloudWatchMetrics(v []*CloudWatchMetricsDetail) *AnomalySourceDetails {
	s.CloudWatchMetrics = v
	return s
}

type AnomalyTimeRange struct {
	_ struct{} `type:"structure"`

	EndTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`
}

// String returns the string representation
func (s AnomalyTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnomalyTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *AnomalyTimeRange) SetEndTime(v time.Time) *AnomalyTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AnomalyTimeRange) SetStartTime(v time.Time) *AnomalyTimeRange {
	s.StartTime = &v
	return s
}

type CloudFormationCollection struct {
	_ struct{} `type:"structure"`

	StackNames []*string `type:"list"`
}

// String returns the string representation
func (s CloudFormationCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFormationCollection) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *CloudFormationCollection) SetStackNames(v []*string) *CloudFormationCollection {
	s.StackNames = v
	return s
}

type CloudFormationCollectionFilter struct {
	_ struct{} `type:"structure"`

	StackNames []*string `type:"list"`
}

// String returns the string representation
func (s CloudFormationCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFormationCollectionFilter) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *CloudFormationCollectionFilter) SetStackNames(v []*string) *CloudFormationCollectionFilter {
	s.StackNames = v
	return s
}

type CloudFormationHealth struct {
	_ struct{} `type:"structure"`

	Insight *InsightHealth `type:"structure"`

	StackName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CloudFormationHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudFormationHealth) GoString() string {
	return s.String()
}

// SetInsight sets the Insight field's value.
func (s *CloudFormationHealth) SetInsight(v *InsightHealth) *CloudFormationHealth {
	s.Insight = v
	return s
}

// SetStackName sets the StackName field's value.
func (s *CloudFormationHealth) SetStackName(v string) *CloudFormationHealth {
	s.StackName = &v
	return s
}

type CloudWatchMetricsDetail struct {
	_ struct{} `type:"structure"`

	Dimensions []*CloudWatchMetricsDimension `type:"list"`

	MetricName *string `type:"string"`

	Namespace *string `type:"string"`

	Period *int64 `type:"integer"`

	Stat *string `type:"string" enum:"CloudWatchMetricsStat"`

	Unit *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchMetricsDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchMetricsDetail) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *CloudWatchMetricsDetail) SetDimensions(v []*CloudWatchMetricsDimension) *CloudWatchMetricsDetail {
	s.Dimensions = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CloudWatchMetricsDetail) SetMetricName(v string) *CloudWatchMetricsDetail {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CloudWatchMetricsDetail) SetNamespace(v string) *CloudWatchMetricsDetail {
	s.Namespace = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CloudWatchMetricsDetail) SetPeriod(v int64) *CloudWatchMetricsDetail {
	s.Period = &v
	return s
}

// SetStat sets the Stat field's value.
func (s *CloudWatchMetricsDetail) SetStat(v string) *CloudWatchMetricsDetail {
	s.Stat = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *CloudWatchMetricsDetail) SetUnit(v string) *CloudWatchMetricsDetail {
	s.Unit = &v
	return s
}

type CloudWatchMetricsDimension struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s CloudWatchMetricsDimension) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchMetricsDimension) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CloudWatchMetricsDimension) SetName(v string) *CloudWatchMetricsDimension {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CloudWatchMetricsDimension) SetValue(v string) *CloudWatchMetricsDimension {
	s.Value = &v
	return s
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeAccountHealthInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountHealthInput) GoString() string {
	return s.String()
}

type DescribeAccountHealthOutput struct {
	_ struct{} `type:"structure"`

	MetricsAnalyzed *int64 `type:"integer"`

	OpenProactiveInsights *int64 `type:"integer"`

	OpenReactiveInsights *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeAccountHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountHealthOutput) GoString() string {
	return s.String()
}

// SetMetricsAnalyzed sets the MetricsAnalyzed field's value.
func (s *DescribeAccountHealthOutput) SetMetricsAnalyzed(v int64) *DescribeAccountHealthOutput {
	s.MetricsAnalyzed = &v
	return s
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *DescribeAccountHealthOutput) SetOpenProactiveInsights(v int64) *DescribeAccountHealthOutput {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *DescribeAccountHealthOutput) SetOpenReactiveInsights(v int64) *DescribeAccountHealthOutput {
	s.OpenReactiveInsights = &v
	return s
}

type DescribeAccountOverviewInput struct {
	_ struct{} `type:"structure"`

	// FromTime is a required field
	FromTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`

	ToTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`
}

// String returns the string representation
func (s DescribeAccountOverviewInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountOverviewInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountOverviewInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountOverviewInput"}
	if s.FromTime == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromTime sets the FromTime field's value.
func (s *DescribeAccountOverviewInput) SetFromTime(v time.Time) *DescribeAccountOverviewInput {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *DescribeAccountOverviewInput) SetToTime(v time.Time) *DescribeAccountOverviewInput {
	s.ToTime = &v
	return s
}

type DescribeAccountOverviewOutput struct {
	_ struct{} `type:"structure"`

	MeanTimeToRecoverInMilliseconds *int64 `type:"long"`

	ProactiveInsights *int64 `type:"integer"`

	ReactiveInsights *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeAccountOverviewOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountOverviewOutput) GoString() string {
	return s.String()
}

// SetMeanTimeToRecoverInMilliseconds sets the MeanTimeToRecoverInMilliseconds field's value.
func (s *DescribeAccountOverviewOutput) SetMeanTimeToRecoverInMilliseconds(v int64) *DescribeAccountOverviewOutput {
	s.MeanTimeToRecoverInMilliseconds = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *DescribeAccountOverviewOutput) SetProactiveInsights(v int64) *DescribeAccountOverviewOutput {
	s.ProactiveInsights = &v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *DescribeAccountOverviewOutput) SetReactiveInsights(v int64) *DescribeAccountOverviewOutput {
	s.ReactiveInsights = &v
	return s
}

type DescribeAnomalyInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAnomalyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAnomalyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAnomalyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAnomalyInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeAnomalyInput) SetId(v string) *DescribeAnomalyInput {
	s.Id = &v
	return s
}

type DescribeAnomalyOutput struct {
	_ struct{} `type:"structure"`

	ProactiveAnomaly *ProactiveAnomaly `type:"structure"`

	ReactiveAnomaly *ReactiveAnomaly `type:"structure"`
}

// String returns the string representation
func (s DescribeAnomalyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAnomalyOutput) GoString() string {
	return s.String()
}

// SetProactiveAnomaly sets the ProactiveAnomaly field's value.
func (s *DescribeAnomalyOutput) SetProactiveAnomaly(v *ProactiveAnomaly) *DescribeAnomalyOutput {
	s.ProactiveAnomaly = v
	return s
}

// SetReactiveAnomaly sets the ReactiveAnomaly field's value.
func (s *DescribeAnomalyOutput) SetReactiveAnomaly(v *ReactiveAnomaly) *DescribeAnomalyOutput {
	s.ReactiveAnomaly = v
	return s
}

type DescribeInsightInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInsightInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeInsightInput) SetId(v string) *DescribeInsightInput {
	s.Id = &v
	return s
}

type DescribeInsightOutput struct {
	_ struct{} `type:"structure"`

	ProactiveInsight *ProactiveInsight `type:"structure"`

	ReactiveInsight *ReactiveInsight `type:"structure"`
}

// String returns the string representation
func (s DescribeInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInsightOutput) GoString() string {
	return s.String()
}

// SetProactiveInsight sets the ProactiveInsight field's value.
func (s *DescribeInsightOutput) SetProactiveInsight(v *ProactiveInsight) *DescribeInsightOutput {
	s.ProactiveInsight = v
	return s
}

// SetReactiveInsight sets the ReactiveInsight field's value.
func (s *DescribeInsightOutput) SetReactiveInsight(v *ReactiveInsight) *DescribeInsightOutput {
	s.ReactiveInsight = v
	return s
}

type DescribeResourceCollectionHealthInput struct {
	_ struct{} `type:"structure"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// ResourceCollectionType is a required field
	ResourceCollectionType *string `location:"uri" locationName:"ResourceCollectionType" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeResourceCollectionHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceCollectionHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeResourceCollectionHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeResourceCollectionHealthInput"}
	if s.ResourceCollectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollectionType"))
	}
	if s.ResourceCollectionType != nil && len(*s.ResourceCollectionType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceCollectionType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeResourceCollectionHealthInput) SetNextToken(v string) *DescribeResourceCollectionHealthInput {
	s.NextToken = &v
	return s
}

// SetResourceCollectionType sets the ResourceCollectionType field's value.
func (s *DescribeResourceCollectionHealthInput) SetResourceCollectionType(v string) *DescribeResourceCollectionHealthInput {
	s.ResourceCollectionType = &v
	return s
}

type DescribeResourceCollectionHealthOutput struct {
	_ struct{} `type:"structure"`

	CloudFormation []*CloudFormationHealth `type:"list"`

	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s DescribeResourceCollectionHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceCollectionHealthOutput) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *DescribeResourceCollectionHealthOutput) SetCloudFormation(v []*CloudFormationHealth) *DescribeResourceCollectionHealthOutput {
	s.CloudFormation = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeResourceCollectionHealthOutput) SetNextToken(v string) *DescribeResourceCollectionHealthOutput {
	s.NextToken = &v
	return s
}

type DescribeServiceIntegrationInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceIntegrationInput) GoString() string {
	return s.String()
}

type DescribeServiceIntegrationOutput struct {
	_ struct{} `type:"structure"`

	ServiceIntegration *ServiceIntegrationConfig `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceIntegrationOutput) GoString() string {
	return s.String()
}

// SetServiceIntegration sets the ServiceIntegration field's value.
func (s *DescribeServiceIntegrationOutput) SetServiceIntegration(v *ServiceIntegrationConfig) *DescribeServiceIntegrationOutput {
	s.ServiceIntegration = v
	return s
}

type EndTimeRange struct {
	_ struct{} `type:"structure"`

	FromTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	ToTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`
}

// String returns the string representation
func (s EndTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndTimeRange) GoString() string {
	return s.String()
}

// SetFromTime sets the FromTime field's value.
func (s *EndTimeRange) SetFromTime(v time.Time) *EndTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *EndTimeRange) SetToTime(v time.Time) *EndTimeRange {
	s.ToTime = &v
	return s
}

type Event struct {
	_ struct{} `type:"structure"`

	DataSource *string `type:"string" enum:"EventDataSource"`

	EventClass *string `type:"string" enum:"EventClass"`

	EventSource *string `min:"10" type:"string"`

	Id *string `type:"string"`

	Name *string `type:"string"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Resources []*EventResource `type:"list"`

	Time *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *Event) SetDataSource(v string) *Event {
	s.DataSource = &v
	return s
}

// SetEventClass sets the EventClass field's value.
func (s *Event) SetEventClass(v string) *Event {
	s.EventClass = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *Event) SetEventSource(v string) *Event {
	s.EventSource = &v
	return s
}

// SetId sets the Id field's value.
func (s *Event) SetId(v string) *Event {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Event) SetName(v string) *Event {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *Event) SetResourceCollection(v *ResourceCollection) *Event {
	s.ResourceCollection = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Event) SetResources(v []*EventResource) *Event {
	s.Resources = v
	return s
}

// SetTime sets the Time field's value.
func (s *Event) SetTime(v time.Time) *Event {
	s.Time = &v
	return s
}

type EventResource struct {
	_ struct{} `type:"structure"`

	Arn *string `min:"36" type:"string"`

	Name *string `type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s EventResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventResource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EventResource) SetArn(v string) *EventResource {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventResource) SetName(v string) *EventResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *EventResource) SetType(v string) *EventResource {
	s.Type = &v
	return s
}

type EventTimeRange struct {
	_ struct{} `type:"structure"`

	// FromTime is a required field
	FromTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`

	// ToTime is a required field
	ToTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`
}

// String returns the string representation
func (s EventTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventTimeRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventTimeRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventTimeRange"}
	if s.FromTime == nil {
		invalidParams.Add(request.NewErrParamRequired("FromTime"))
	}
	if s.ToTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ToTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromTime sets the FromTime field's value.
func (s *EventTimeRange) SetFromTime(v time.Time) *EventTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *EventTimeRange) SetToTime(v time.Time) *EventTimeRange {
	s.ToTime = &v
	return s
}

type GetResourceCollectionInput struct {
	_ struct{} `type:"structure"`

	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// ResourceCollectionType is a required field
	ResourceCollectionType *string `location:"uri" locationName:"ResourceCollectionType" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResourceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceCollectionInput"}
	if s.ResourceCollectionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollectionType"))
	}
	if s.ResourceCollectionType != nil && len(*s.ResourceCollectionType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceCollectionType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceCollectionInput) SetNextToken(v string) *GetResourceCollectionInput {
	s.NextToken = &v
	return s
}

// SetResourceCollectionType sets the ResourceCollectionType field's value.
func (s *GetResourceCollectionInput) SetResourceCollectionType(v string) *GetResourceCollectionInput {
	s.ResourceCollectionType = &v
	return s
}

type GetResourceCollectionOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `min:"36" type:"string"`

	ResourceCollection *ResourceCollectionFilter `type:"structure"`
}

// String returns the string representation
func (s GetResourceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceCollectionOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetResourceCollectionOutput) SetNextToken(v string) *GetResourceCollectionOutput {
	s.NextToken = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *GetResourceCollectionOutput) SetResourceCollection(v *ResourceCollectionFilter) *GetResourceCollectionOutput {
	s.ResourceCollection = v
	return s
}

type InsightFeedback struct {
	_ struct{} `type:"structure"`

	Feedback *string `type:"string" enum:"InsightFeedbackOption"`

	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InsightFeedback) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightFeedback) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InsightFeedback) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InsightFeedback"}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFeedback sets the Feedback field's value.
func (s *InsightFeedback) SetFeedback(v string) *InsightFeedback {
	s.Feedback = &v
	return s
}

// SetId sets the Id field's value.
func (s *InsightFeedback) SetId(v string) *InsightFeedback {
	s.Id = &v
	return s
}

type InsightHealth struct {
	_ struct{} `type:"structure"`

	MeanTimeToRecoverInMilliseconds *int64 `type:"long"`

	OpenProactiveInsights *int64 `type:"integer"`

	OpenReactiveInsights *int64 `type:"integer"`
}

// String returns the string representation
func (s InsightHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightHealth) GoString() string {
	return s.String()
}

// SetMeanTimeToRecoverInMilliseconds sets the MeanTimeToRecoverInMilliseconds field's value.
func (s *InsightHealth) SetMeanTimeToRecoverInMilliseconds(v int64) *InsightHealth {
	s.MeanTimeToRecoverInMilliseconds = &v
	return s
}

// SetOpenProactiveInsights sets the OpenProactiveInsights field's value.
func (s *InsightHealth) SetOpenProactiveInsights(v int64) *InsightHealth {
	s.OpenProactiveInsights = &v
	return s
}

// SetOpenReactiveInsights sets the OpenReactiveInsights field's value.
func (s *InsightHealth) SetOpenReactiveInsights(v int64) *InsightHealth {
	s.OpenReactiveInsights = &v
	return s
}

type InsightTimeRange struct {
	_ struct{} `type:"structure"`

	EndTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`
}

// String returns the string representation
func (s InsightTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsightTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *InsightTimeRange) SetEndTime(v time.Time) *InsightTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *InsightTimeRange) SetStartTime(v time.Time) *InsightTimeRange {
	s.StartTime = &v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAnomaliesForInsightInput struct {
	_ struct{} `type:"structure"`

	// InsightId is a required field
	InsightId *string `location:"uri" locationName:"InsightId" type:"string" required:"true"`

	MaxResults *int64 `min:"1" type:"integer"`

	NextToken *string `min:"36" type:"string"`

	StartTimeRange *StartTimeRange `type:"structure"`
}

// String returns the string representation
func (s ListAnomaliesForInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAnomaliesForInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAnomaliesForInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAnomaliesForInsightInput"}
	if s.InsightId == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightId"))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightId sets the InsightId field's value.
func (s *ListAnomaliesForInsightInput) SetInsightId(v string) *ListAnomaliesForInsightInput {
	s.InsightId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAnomaliesForInsightInput) SetMaxResults(v int64) *ListAnomaliesForInsightInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomaliesForInsightInput) SetNextToken(v string) *ListAnomaliesForInsightInput {
	s.NextToken = &v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *ListAnomaliesForInsightInput) SetStartTimeRange(v *StartTimeRange) *ListAnomaliesForInsightInput {
	s.StartTimeRange = v
	return s
}

type ListAnomaliesForInsightOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `min:"36" type:"string"`

	ProactiveAnomalies []*ProactiveAnomalySummary `type:"list"`

	ReactiveAnomalies []*ReactiveAnomalySummary `type:"list"`
}

// String returns the string representation
func (s ListAnomaliesForInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAnomaliesForInsightOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAnomaliesForInsightOutput) SetNextToken(v string) *ListAnomaliesForInsightOutput {
	s.NextToken = &v
	return s
}

// SetProactiveAnomalies sets the ProactiveAnomalies field's value.
func (s *ListAnomaliesForInsightOutput) SetProactiveAnomalies(v []*ProactiveAnomalySummary) *ListAnomaliesForInsightOutput {
	s.ProactiveAnomalies = v
	return s
}

// SetReactiveAnomalies sets the ReactiveAnomalies field's value.
func (s *ListAnomaliesForInsightOutput) SetReactiveAnomalies(v []*ReactiveAnomalySummary) *ListAnomaliesForInsightOutput {
	s.ReactiveAnomalies = v
	return s
}

type ListEventsFilters struct {
	_ struct{} `type:"structure"`

	DataSource *string `type:"string" enum:"EventDataSource"`

	EventClass *string `type:"string" enum:"EventClass"`

	EventSource *string `min:"10" type:"string"`

	EventTimeRange *EventTimeRange `type:"structure"`

	InsightId *string `min:"1" type:"string"`

	ResourceCollection *ResourceCollection `type:"structure"`
}

// String returns the string representation
func (s ListEventsFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventsFilters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventsFilters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventsFilters"}
	if s.EventSource != nil && len(*s.EventSource) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("EventSource", 10))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.EventTimeRange != nil {
		if err := s.EventTimeRange.Validate(); err != nil {
			invalidParams.AddNested("EventTimeRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *ListEventsFilters) SetDataSource(v string) *ListEventsFilters {
	s.DataSource = &v
	return s
}

// SetEventClass sets the EventClass field's value.
func (s *ListEventsFilters) SetEventClass(v string) *ListEventsFilters {
	s.EventClass = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *ListEventsFilters) SetEventSource(v string) *ListEventsFilters {
	s.EventSource = &v
	return s
}

// SetEventTimeRange sets the EventTimeRange field's value.
func (s *ListEventsFilters) SetEventTimeRange(v *EventTimeRange) *ListEventsFilters {
	s.EventTimeRange = v
	return s
}

// SetInsightId sets the InsightId field's value.
func (s *ListEventsFilters) SetInsightId(v string) *ListEventsFilters {
	s.InsightId = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ListEventsFilters) SetResourceCollection(v *ResourceCollection) *ListEventsFilters {
	s.ResourceCollection = v
	return s
}

type ListEventsInput struct {
	_ struct{} `type:"structure"`

	// Filters is a required field
	Filters *ListEventsFilters `type:"structure" required:"true"`

	MaxResults *int64 `min:"1" type:"integer"`

	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventsInput"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListEventsInput) SetFilters(v *ListEventsFilters) *ListEventsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventsInput) SetMaxResults(v int64) *ListEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventsInput) SetNextToken(v string) *ListEventsInput {
	s.NextToken = &v
	return s
}

type ListEventsOutput struct {
	_ struct{} `type:"structure"`

	Events []*Event `type:"list"`

	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ListEventsOutput) SetEvents(v []*Event) *ListEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventsOutput) SetNextToken(v string) *ListEventsOutput {
	s.NextToken = &v
	return s
}

type ListInsightsAnyStatusFilter struct {
	_ struct{} `type:"structure"`

	// StartTimeRange is a required field
	StartTimeRange *StartTimeRange `type:"structure" required:"true"`

	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation
func (s ListInsightsAnyStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsAnyStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsAnyStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsAnyStatusFilter"}
	if s.StartTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *ListInsightsAnyStatusFilter) SetStartTimeRange(v *StartTimeRange) *ListInsightsAnyStatusFilter {
	s.StartTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *ListInsightsAnyStatusFilter) SetType(v string) *ListInsightsAnyStatusFilter {
	s.Type = &v
	return s
}

type ListInsightsClosedStatusFilter struct {
	_ struct{} `type:"structure"`

	// EndTimeRange is a required field
	EndTimeRange *EndTimeRange `type:"structure" required:"true"`

	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation
func (s ListInsightsClosedStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsClosedStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsClosedStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsClosedStatusFilter"}
	if s.EndTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTimeRange sets the EndTimeRange field's value.
func (s *ListInsightsClosedStatusFilter) SetEndTimeRange(v *EndTimeRange) *ListInsightsClosedStatusFilter {
	s.EndTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *ListInsightsClosedStatusFilter) SetType(v string) *ListInsightsClosedStatusFilter {
	s.Type = &v
	return s
}

type ListInsightsInput struct {
	_ struct{} `type:"structure"`

	MaxResults *int64 `min:"1" type:"integer"`

	NextToken *string `min:"36" type:"string"`

	// StatusFilter is a required field
	StatusFilter *ListInsightsStatusFilter `type:"structure" required:"true"`
}

// String returns the string representation
func (s ListInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.StatusFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusFilter"))
	}
	if s.StatusFilter != nil {
		if err := s.StatusFilter.Validate(); err != nil {
			invalidParams.AddNested("StatusFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInsightsInput) SetMaxResults(v int64) *ListInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInsightsInput) SetNextToken(v string) *ListInsightsInput {
	s.NextToken = &v
	return s
}

// SetStatusFilter sets the StatusFilter field's value.
func (s *ListInsightsInput) SetStatusFilter(v *ListInsightsStatusFilter) *ListInsightsInput {
	s.StatusFilter = v
	return s
}

type ListInsightsOngoingStatusFilter struct {
	_ struct{} `type:"structure"`

	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation
func (s ListInsightsOngoingStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsOngoingStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsOngoingStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsOngoingStatusFilter"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *ListInsightsOngoingStatusFilter) SetType(v string) *ListInsightsOngoingStatusFilter {
	s.Type = &v
	return s
}

type ListInsightsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `min:"36" type:"string"`

	ProactiveInsights []*ProactiveInsightSummary `type:"list"`

	ReactiveInsights []*ReactiveInsightSummary `type:"list"`
}

// String returns the string representation
func (s ListInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListInsightsOutput) SetNextToken(v string) *ListInsightsOutput {
	s.NextToken = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *ListInsightsOutput) SetProactiveInsights(v []*ProactiveInsightSummary) *ListInsightsOutput {
	s.ProactiveInsights = v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *ListInsightsOutput) SetReactiveInsights(v []*ReactiveInsightSummary) *ListInsightsOutput {
	s.ReactiveInsights = v
	return s
}

type ListInsightsStatusFilter struct {
	_ struct{} `type:"structure"`

	Any *ListInsightsAnyStatusFilter `type:"structure"`

	Closed *ListInsightsClosedStatusFilter `type:"structure"`

	Ongoing *ListInsightsOngoingStatusFilter `type:"structure"`
}

// String returns the string representation
func (s ListInsightsStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInsightsStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsStatusFilter"}
	if s.Any != nil {
		if err := s.Any.Validate(); err != nil {
			invalidParams.AddNested("Any", err.(request.ErrInvalidParams))
		}
	}
	if s.Closed != nil {
		if err := s.Closed.Validate(); err != nil {
			invalidParams.AddNested("Closed", err.(request.ErrInvalidParams))
		}
	}
	if s.Ongoing != nil {
		if err := s.Ongoing.Validate(); err != nil {
			invalidParams.AddNested("Ongoing", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAny sets the Any field's value.
func (s *ListInsightsStatusFilter) SetAny(v *ListInsightsAnyStatusFilter) *ListInsightsStatusFilter {
	s.Any = v
	return s
}

// SetClosed sets the Closed field's value.
func (s *ListInsightsStatusFilter) SetClosed(v *ListInsightsClosedStatusFilter) *ListInsightsStatusFilter {
	s.Closed = v
	return s
}

// SetOngoing sets the Ongoing field's value.
func (s *ListInsightsStatusFilter) SetOngoing(v *ListInsightsOngoingStatusFilter) *ListInsightsStatusFilter {
	s.Ongoing = v
	return s
}

type ListNotificationChannelsInput struct {
	_ struct{} `type:"structure"`

	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListNotificationChannelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotificationChannelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNotificationChannelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNotificationChannelsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationChannelsInput) SetNextToken(v string) *ListNotificationChannelsInput {
	s.NextToken = &v
	return s
}

type ListNotificationChannelsOutput struct {
	_ struct{} `type:"structure"`

	Channels []*NotificationChannel `type:"list"`

	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListNotificationChannelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNotificationChannelsOutput) GoString() string {
	return s.String()
}

// SetChannels sets the Channels field's value.
func (s *ListNotificationChannelsOutput) SetChannels(v []*NotificationChannel) *ListNotificationChannelsOutput {
	s.Channels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNotificationChannelsOutput) SetNextToken(v string) *ListNotificationChannelsOutput {
	s.NextToken = &v
	return s
}

type ListRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// InsightId is a required field
	InsightId *string `min:"1" type:"string" required:"true"`

	NextToken *string `min:"36" type:"string"`
}

// String returns the string representation
func (s ListRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommendationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecommendationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecommendationsInput"}
	if s.InsightId == nil {
		invalidParams.Add(request.NewErrParamRequired("InsightId"))
	}
	if s.InsightId != nil && len(*s.InsightId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InsightId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightId sets the InsightId field's value.
func (s *ListRecommendationsInput) SetInsightId(v string) *ListRecommendationsInput {
	s.InsightId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsInput) SetNextToken(v string) *ListRecommendationsInput {
	s.NextToken = &v
	return s
}

type ListRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `min:"36" type:"string"`

	Recommendations []*Recommendation `type:"list"`
}

// String returns the string representation
func (s ListRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecommendationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecommendationsOutput) SetNextToken(v string) *ListRecommendationsOutput {
	s.NextToken = &v
	return s
}

// SetRecommendations sets the Recommendations field's value.
func (s *ListRecommendationsOutput) SetRecommendations(v []*Recommendation) *ListRecommendationsOutput {
	s.Recommendations = v
	return s
}

type NotificationChannel struct {
	_ struct{} `type:"structure"`

	Config *NotificationChannelConfig `type:"structure"`

	Id *string `min:"36" type:"string"`
}

// String returns the string representation
func (s NotificationChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationChannel) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *NotificationChannel) SetConfig(v *NotificationChannelConfig) *NotificationChannel {
	s.Config = v
	return s
}

// SetId sets the Id field's value.
func (s *NotificationChannel) SetId(v string) *NotificationChannel {
	s.Id = &v
	return s
}

type NotificationChannelConfig struct {
	_ struct{} `type:"structure"`

	// Sns is a required field
	Sns *SnsChannelConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s NotificationChannelConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationChannelConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationChannelConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationChannelConfig"}
	if s.Sns == nil {
		invalidParams.Add(request.NewErrParamRequired("Sns"))
	}
	if s.Sns != nil {
		if err := s.Sns.Validate(); err != nil {
			invalidParams.AddNested("Sns", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSns sets the Sns field's value.
func (s *NotificationChannelConfig) SetSns(v *SnsChannelConfig) *NotificationChannelConfig {
	s.Sns = v
	return s
}

type OpsCenterIntegration struct {
	_ struct{} `type:"structure"`

	OptInStatus *string `type:"string" enum:"OptInStatus"`
}

// String returns the string representation
func (s OpsCenterIntegration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpsCenterIntegration) GoString() string {
	return s.String()
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *OpsCenterIntegration) SetOptInStatus(v string) *OpsCenterIntegration {
	s.OptInStatus = &v
	return s
}

type OpsCenterIntegrationConfig struct {
	_ struct{} `type:"structure"`

	OptInStatus *string `type:"string" enum:"OptInStatus"`
}

// String returns the string representation
func (s OpsCenterIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpsCenterIntegrationConfig) GoString() string {
	return s.String()
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *OpsCenterIntegrationConfig) SetOptInStatus(v string) *OpsCenterIntegrationConfig {
	s.OptInStatus = &v
	return s
}

type PredictionTimeRange struct {
	_ struct{} `type:"structure"`

	EndTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp" required:"true"`
}

// String returns the string representation
func (s PredictionTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictionTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *PredictionTimeRange) SetEndTime(v time.Time) *PredictionTimeRange {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *PredictionTimeRange) SetStartTime(v time.Time) *PredictionTimeRange {
	s.StartTime = &v
	return s
}

type ProactiveAnomaly struct {
	_ struct{} `type:"structure"`

	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	AssociatedInsightId *string `min:"1" type:"string"`

	Id *string `min:"1" type:"string"`

	Limit *float64 `type:"double"`

	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severity *string `type:"string" enum:"AnomalySeverity"`

	SourceDetails *AnomalySourceDetails `type:"structure"`

	Status *string `type:"string" enum:"AnomalyStatus"`

	UpdateTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`
}

// String returns the string representation
func (s ProactiveAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProactiveAnomaly) GoString() string {
	return s.String()
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ProactiveAnomaly) SetAnomalyTimeRange(v *AnomalyTimeRange) *ProactiveAnomaly {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ProactiveAnomaly) SetAssociatedInsightId(v string) *ProactiveAnomaly {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveAnomaly) SetId(v string) *ProactiveAnomaly {
	s.Id = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ProactiveAnomaly) SetLimit(v float64) *ProactiveAnomaly {
	s.Limit = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveAnomaly) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveAnomaly {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveAnomaly) SetResourceCollection(v *ResourceCollection) *ProactiveAnomaly {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveAnomaly) SetSeverity(v string) *ProactiveAnomaly {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ProactiveAnomaly) SetSourceDetails(v *AnomalySourceDetails) *ProactiveAnomaly {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveAnomaly) SetStatus(v string) *ProactiveAnomaly {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ProactiveAnomaly) SetUpdateTime(v time.Time) *ProactiveAnomaly {
	s.UpdateTime = &v
	return s
}

type ProactiveAnomalySummary struct {
	_ struct{} `type:"structure"`

	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	AssociatedInsightId *string `min:"1" type:"string"`

	Id *string `min:"1" type:"string"`

	Limit *float64 `type:"double"`

	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severity *string `type:"string" enum:"AnomalySeverity"`

	SourceDetails *AnomalySourceDetails `type:"structure"`

	Status *string `type:"string" enum:"AnomalyStatus"`

	UpdateTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`
}

// String returns the string representation
func (s ProactiveAnomalySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProactiveAnomalySummary) GoString() string {
	return s.String()
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ProactiveAnomalySummary) SetAnomalyTimeRange(v *AnomalyTimeRange) *ProactiveAnomalySummary {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ProactiveAnomalySummary) SetAssociatedInsightId(v string) *ProactiveAnomalySummary {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProactiveAnomalySummary) SetId(v string) *ProactiveAnomalySummary {
	s.Id = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ProactiveAnomalySummary) SetLimit(v float64) *ProactiveAnomalySummary {
	s.Limit = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveAnomalySummary) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveAnomalySummary {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveAnomalySummary) SetResourceCollection(v *ResourceCollection) *ProactiveAnomalySummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveAnomalySummary) SetSeverity(v string) *ProactiveAnomalySummary {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ProactiveAnomalySummary) SetSourceDetails(v *AnomalySourceDetails) *ProactiveAnomalySummary {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveAnomalySummary) SetStatus(v string) *ProactiveAnomalySummary {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ProactiveAnomalySummary) SetUpdateTime(v time.Time) *ProactiveAnomalySummary {
	s.UpdateTime = &v
	return s
}

type ProactiveInsight struct {
	_ struct{} `type:"structure"`

	Id *string `min:"1" type:"string"`

	InsightTimeRange *InsightTimeRange `type:"structure"`

	Name *string `min:"1" type:"string"`

	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severity *string `type:"string" enum:"InsightSeverity"`

	SsmOpsItemId *string `min:"1" type:"string"`

	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation
func (s ProactiveInsight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProactiveInsight) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ProactiveInsight) SetId(v string) *ProactiveInsight {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ProactiveInsight) SetInsightTimeRange(v *InsightTimeRange) *ProactiveInsight {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ProactiveInsight) SetName(v string) *ProactiveInsight {
	s.Name = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveInsight) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveInsight {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveInsight) SetResourceCollection(v *ResourceCollection) *ProactiveInsight {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveInsight) SetSeverity(v string) *ProactiveInsight {
	s.Severity = &v
	return s
}

// SetSsmOpsItemId sets the SsmOpsItemId field's value.
func (s *ProactiveInsight) SetSsmOpsItemId(v string) *ProactiveInsight {
	s.SsmOpsItemId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveInsight) SetStatus(v string) *ProactiveInsight {
	s.Status = &v
	return s
}

type ProactiveInsightSummary struct {
	_ struct{} `type:"structure"`

	Id *string `min:"1" type:"string"`

	InsightTimeRange *InsightTimeRange `type:"structure"`

	Name *string `min:"1" type:"string"`

	PredictionTimeRange *PredictionTimeRange `type:"structure"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severity *string `type:"string" enum:"InsightSeverity"`

	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation
func (s ProactiveInsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProactiveInsightSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ProactiveInsightSummary) SetId(v string) *ProactiveInsightSummary {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ProactiveInsightSummary) SetInsightTimeRange(v *InsightTimeRange) *ProactiveInsightSummary {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ProactiveInsightSummary) SetName(v string) *ProactiveInsightSummary {
	s.Name = &v
	return s
}

// SetPredictionTimeRange sets the PredictionTimeRange field's value.
func (s *ProactiveInsightSummary) SetPredictionTimeRange(v *PredictionTimeRange) *ProactiveInsightSummary {
	s.PredictionTimeRange = v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ProactiveInsightSummary) SetResourceCollection(v *ResourceCollection) *ProactiveInsightSummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ProactiveInsightSummary) SetSeverity(v string) *ProactiveInsightSummary {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProactiveInsightSummary) SetStatus(v string) *ProactiveInsightSummary {
	s.Status = &v
	return s
}

type PutFeedbackInput struct {
	_ struct{} `type:"structure"`

	InsightFeedback *InsightFeedback `type:"structure"`
}

// String returns the string representation
func (s PutFeedbackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFeedbackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFeedbackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFeedbackInput"}
	if s.InsightFeedback != nil {
		if err := s.InsightFeedback.Validate(); err != nil {
			invalidParams.AddNested("InsightFeedback", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInsightFeedback sets the InsightFeedback field's value.
func (s *PutFeedbackInput) SetInsightFeedback(v *InsightFeedback) *PutFeedbackInput {
	s.InsightFeedback = v
	return s
}

type PutFeedbackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutFeedbackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFeedbackOutput) GoString() string {
	return s.String()
}

type ReactiveAnomaly struct {
	_ struct{} `type:"structure"`

	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	AssociatedInsightId *string `min:"1" type:"string"`

	Id *string `min:"1" type:"string"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severity *string `type:"string" enum:"AnomalySeverity"`

	SourceDetails *AnomalySourceDetails `type:"structure"`

	Status *string `type:"string" enum:"AnomalyStatus"`
}

// String returns the string representation
func (s ReactiveAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReactiveAnomaly) GoString() string {
	return s.String()
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ReactiveAnomaly) SetAnomalyTimeRange(v *AnomalyTimeRange) *ReactiveAnomaly {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ReactiveAnomaly) SetAssociatedInsightId(v string) *ReactiveAnomaly {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveAnomaly) SetId(v string) *ReactiveAnomaly {
	s.Id = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveAnomaly) SetResourceCollection(v *ResourceCollection) *ReactiveAnomaly {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveAnomaly) SetSeverity(v string) *ReactiveAnomaly {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ReactiveAnomaly) SetSourceDetails(v *AnomalySourceDetails) *ReactiveAnomaly {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveAnomaly) SetStatus(v string) *ReactiveAnomaly {
	s.Status = &v
	return s
}

type ReactiveAnomalySummary struct {
	_ struct{} `type:"structure"`

	AnomalyTimeRange *AnomalyTimeRange `type:"structure"`

	AssociatedInsightId *string `min:"1" type:"string"`

	Id *string `min:"1" type:"string"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severity *string `type:"string" enum:"AnomalySeverity"`

	SourceDetails *AnomalySourceDetails `type:"structure"`

	Status *string `type:"string" enum:"AnomalyStatus"`
}

// String returns the string representation
func (s ReactiveAnomalySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReactiveAnomalySummary) GoString() string {
	return s.String()
}

// SetAnomalyTimeRange sets the AnomalyTimeRange field's value.
func (s *ReactiveAnomalySummary) SetAnomalyTimeRange(v *AnomalyTimeRange) *ReactiveAnomalySummary {
	s.AnomalyTimeRange = v
	return s
}

// SetAssociatedInsightId sets the AssociatedInsightId field's value.
func (s *ReactiveAnomalySummary) SetAssociatedInsightId(v string) *ReactiveAnomalySummary {
	s.AssociatedInsightId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ReactiveAnomalySummary) SetId(v string) *ReactiveAnomalySummary {
	s.Id = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveAnomalySummary) SetResourceCollection(v *ResourceCollection) *ReactiveAnomalySummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveAnomalySummary) SetSeverity(v string) *ReactiveAnomalySummary {
	s.Severity = &v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *ReactiveAnomalySummary) SetSourceDetails(v *AnomalySourceDetails) *ReactiveAnomalySummary {
	s.SourceDetails = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveAnomalySummary) SetStatus(v string) *ReactiveAnomalySummary {
	s.Status = &v
	return s
}

type ReactiveInsight struct {
	_ struct{} `type:"structure"`

	Id *string `min:"1" type:"string"`

	InsightTimeRange *InsightTimeRange `type:"structure"`

	Name *string `min:"1" type:"string"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severity *string `type:"string" enum:"InsightSeverity"`

	SsmOpsItemId *string `min:"1" type:"string"`

	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation
func (s ReactiveInsight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReactiveInsight) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ReactiveInsight) SetId(v string) *ReactiveInsight {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ReactiveInsight) SetInsightTimeRange(v *InsightTimeRange) *ReactiveInsight {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveInsight) SetName(v string) *ReactiveInsight {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveInsight) SetResourceCollection(v *ResourceCollection) *ReactiveInsight {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveInsight) SetSeverity(v string) *ReactiveInsight {
	s.Severity = &v
	return s
}

// SetSsmOpsItemId sets the SsmOpsItemId field's value.
func (s *ReactiveInsight) SetSsmOpsItemId(v string) *ReactiveInsight {
	s.SsmOpsItemId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveInsight) SetStatus(v string) *ReactiveInsight {
	s.Status = &v
	return s
}

type ReactiveInsightSummary struct {
	_ struct{} `type:"structure"`

	Id *string `min:"1" type:"string"`

	InsightTimeRange *InsightTimeRange `type:"structure"`

	Name *string `min:"1" type:"string"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severity *string `type:"string" enum:"InsightSeverity"`

	Status *string `type:"string" enum:"InsightStatus"`
}

// String returns the string representation
func (s ReactiveInsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReactiveInsightSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ReactiveInsightSummary) SetId(v string) *ReactiveInsightSummary {
	s.Id = &v
	return s
}

// SetInsightTimeRange sets the InsightTimeRange field's value.
func (s *ReactiveInsightSummary) SetInsightTimeRange(v *InsightTimeRange) *ReactiveInsightSummary {
	s.InsightTimeRange = v
	return s
}

// SetName sets the Name field's value.
func (s *ReactiveInsightSummary) SetName(v string) *ReactiveInsightSummary {
	s.Name = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *ReactiveInsightSummary) SetResourceCollection(v *ResourceCollection) *ReactiveInsightSummary {
	s.ResourceCollection = v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *ReactiveInsightSummary) SetSeverity(v string) *ReactiveInsightSummary {
	s.Severity = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReactiveInsightSummary) SetStatus(v string) *ReactiveInsightSummary {
	s.Status = &v
	return s
}

type Recommendation struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	Link *string `type:"string"`

	Name *string `type:"string"`

	Reason *string `type:"string"`

	RelatedAnomalies []*RecommendationRelatedAnomaly `type:"list"`

	RelatedEvents []*RecommendationRelatedEvent `type:"list"`
}

// String returns the string representation
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Recommendation) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *Recommendation) SetDescription(v string) *Recommendation {
	s.Description = &v
	return s
}

// SetLink sets the Link field's value.
func (s *Recommendation) SetLink(v string) *Recommendation {
	s.Link = &v
	return s
}

// SetName sets the Name field's value.
func (s *Recommendation) SetName(v string) *Recommendation {
	s.Name = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *Recommendation) SetReason(v string) *Recommendation {
	s.Reason = &v
	return s
}

// SetRelatedAnomalies sets the RelatedAnomalies field's value.
func (s *Recommendation) SetRelatedAnomalies(v []*RecommendationRelatedAnomaly) *Recommendation {
	s.RelatedAnomalies = v
	return s
}

// SetRelatedEvents sets the RelatedEvents field's value.
func (s *Recommendation) SetRelatedEvents(v []*RecommendationRelatedEvent) *Recommendation {
	s.RelatedEvents = v
	return s
}

type RecommendationRelatedAnomaly struct {
	_ struct{} `type:"structure"`

	Resources []*RecommendationRelatedAnomalyResource `type:"list"`

	SourceDetails []*RecommendationRelatedAnomalySourceDetail `type:"list"`
}

// String returns the string representation
func (s RecommendationRelatedAnomaly) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedAnomaly) GoString() string {
	return s.String()
}

// SetResources sets the Resources field's value.
func (s *RecommendationRelatedAnomaly) SetResources(v []*RecommendationRelatedAnomalyResource) *RecommendationRelatedAnomaly {
	s.Resources = v
	return s
}

// SetSourceDetails sets the SourceDetails field's value.
func (s *RecommendationRelatedAnomaly) SetSourceDetails(v []*RecommendationRelatedAnomalySourceDetail) *RecommendationRelatedAnomaly {
	s.SourceDetails = v
	return s
}

type RecommendationRelatedAnomalyResource struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s RecommendationRelatedAnomalyResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedAnomalyResource) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedAnomalyResource) SetName(v string) *RecommendationRelatedAnomalyResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecommendationRelatedAnomalyResource) SetType(v string) *RecommendationRelatedAnomalyResource {
	s.Type = &v
	return s
}

type RecommendationRelatedAnomalySourceDetail struct {
	_ struct{} `type:"structure"`

	CloudWatchMetrics []*RecommendationRelatedCloudWatchMetricsSourceDetail `type:"list"`
}

// String returns the string representation
func (s RecommendationRelatedAnomalySourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedAnomalySourceDetail) GoString() string {
	return s.String()
}

// SetCloudWatchMetrics sets the CloudWatchMetrics field's value.
func (s *RecommendationRelatedAnomalySourceDetail) SetCloudWatchMetrics(v []*RecommendationRelatedCloudWatchMetricsSourceDetail) *RecommendationRelatedAnomalySourceDetail {
	s.CloudWatchMetrics = v
	return s
}

type RecommendationRelatedCloudWatchMetricsSourceDetail struct {
	_ struct{} `type:"structure"`

	MetricName *string `type:"string"`

	Namespace *string `type:"string"`
}

// String returns the string representation
func (s RecommendationRelatedCloudWatchMetricsSourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedCloudWatchMetricsSourceDetail) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *RecommendationRelatedCloudWatchMetricsSourceDetail) SetMetricName(v string) *RecommendationRelatedCloudWatchMetricsSourceDetail {
	s.MetricName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *RecommendationRelatedCloudWatchMetricsSourceDetail) SetNamespace(v string) *RecommendationRelatedCloudWatchMetricsSourceDetail {
	s.Namespace = &v
	return s
}

type RecommendationRelatedEvent struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Resources []*RecommendationRelatedEventResource `type:"list"`
}

// String returns the string representation
func (s RecommendationRelatedEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedEvent) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedEvent) SetName(v string) *RecommendationRelatedEvent {
	s.Name = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *RecommendationRelatedEvent) SetResources(v []*RecommendationRelatedEventResource) *RecommendationRelatedEvent {
	s.Resources = v
	return s
}

type RecommendationRelatedEventResource struct {
	_ struct{} `type:"structure"`

	Name *string `type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation
func (s RecommendationRelatedEventResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecommendationRelatedEventResource) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RecommendationRelatedEventResource) SetName(v string) *RecommendationRelatedEventResource {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *RecommendationRelatedEventResource) SetType(v string) *RecommendationRelatedEventResource {
	s.Type = &v
	return s
}

type RemoveNotificationChannelInput struct {
	_ struct{} `type:"structure"`

	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveNotificationChannelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveNotificationChannelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveNotificationChannelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveNotificationChannelInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RemoveNotificationChannelInput) SetId(v string) *RemoveNotificationChannelInput {
	s.Id = &v
	return s
}

type RemoveNotificationChannelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveNotificationChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveNotificationChannelOutput) GoString() string {
	return s.String()
}

type ResourceCollection struct {
	_ struct{} `type:"structure"`

	CloudFormation *CloudFormationCollection `type:"structure"`
}

// String returns the string representation
func (s ResourceCollection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCollection) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *ResourceCollection) SetCloudFormation(v *CloudFormationCollection) *ResourceCollection {
	s.CloudFormation = v
	return s
}

type ResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	CloudFormation *CloudFormationCollectionFilter `type:"structure"`
}

// String returns the string representation
func (s ResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCollectionFilter) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *ResourceCollectionFilter) SetCloudFormation(v *CloudFormationCollectionFilter) *ResourceCollectionFilter {
	s.CloudFormation = v
	return s
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SearchInsightsFilters struct {
	_ struct{} `type:"structure"`

	ResourceCollection *ResourceCollection `type:"structure"`

	Severities []*string `type:"list"`

	Statuses []*string `type:"list"`
}

// String returns the string representation
func (s SearchInsightsFilters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchInsightsFilters) GoString() string {
	return s.String()
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *SearchInsightsFilters) SetResourceCollection(v *ResourceCollection) *SearchInsightsFilters {
	s.ResourceCollection = v
	return s
}

// SetSeverities sets the Severities field's value.
func (s *SearchInsightsFilters) SetSeverities(v []*string) *SearchInsightsFilters {
	s.Severities = v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *SearchInsightsFilters) SetStatuses(v []*string) *SearchInsightsFilters {
	s.Statuses = v
	return s
}

type SearchInsightsInput struct {
	_ struct{} `type:"structure"`

	Filters *SearchInsightsFilters `type:"structure"`

	MaxResults *int64 `min:"1" type:"integer"`

	NextToken *string `min:"36" type:"string"`

	// StartTimeRange is a required field
	StartTimeRange *StartTimeRange `type:"structure" required:"true"`

	// Type is a required field
	Type *string `type:"string" required:"true" enum:"InsightType"`
}

// String returns the string representation
func (s SearchInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchInsightsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 36))
	}
	if s.StartTimeRange == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTimeRange"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *SearchInsightsInput) SetFilters(v *SearchInsightsFilters) *SearchInsightsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchInsightsInput) SetMaxResults(v int64) *SearchInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchInsightsInput) SetNextToken(v string) *SearchInsightsInput {
	s.NextToken = &v
	return s
}

// SetStartTimeRange sets the StartTimeRange field's value.
func (s *SearchInsightsInput) SetStartTimeRange(v *StartTimeRange) *SearchInsightsInput {
	s.StartTimeRange = v
	return s
}

// SetType sets the Type field's value.
func (s *SearchInsightsInput) SetType(v string) *SearchInsightsInput {
	s.Type = &v
	return s
}

type SearchInsightsOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `min:"36" type:"string"`

	ProactiveInsights []*ProactiveInsightSummary `type:"list"`

	ReactiveInsights []*ReactiveInsightSummary `type:"list"`
}

// String returns the string representation
func (s SearchInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchInsightsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *SearchInsightsOutput) SetNextToken(v string) *SearchInsightsOutput {
	s.NextToken = &v
	return s
}

// SetProactiveInsights sets the ProactiveInsights field's value.
func (s *SearchInsightsOutput) SetProactiveInsights(v []*ProactiveInsightSummary) *SearchInsightsOutput {
	s.ProactiveInsights = v
	return s
}

// SetReactiveInsights sets the ReactiveInsights field's value.
func (s *SearchInsightsOutput) SetReactiveInsights(v []*ReactiveInsightSummary) *SearchInsightsOutput {
	s.ReactiveInsights = v
	return s
}

type ServiceIntegrationConfig struct {
	_ struct{} `type:"structure"`

	OpsCenter *OpsCenterIntegration `type:"structure"`
}

// String returns the string representation
func (s ServiceIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceIntegrationConfig) GoString() string {
	return s.String()
}

// SetOpsCenter sets the OpsCenter field's value.
func (s *ServiceIntegrationConfig) SetOpsCenter(v *OpsCenterIntegration) *ServiceIntegrationConfig {
	s.OpsCenter = v
	return s
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SnsChannelConfig struct {
	_ struct{} `type:"structure"`

	TopicArn *string `min:"36" type:"string"`
}

// String returns the string representation
func (s SnsChannelConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnsChannelConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SnsChannelConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SnsChannelConfig"}
	if s.TopicArn != nil && len(*s.TopicArn) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TopicArn", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopicArn sets the TopicArn field's value.
func (s *SnsChannelConfig) SetTopicArn(v string) *SnsChannelConfig {
	s.TopicArn = &v
	return s
}

type StartTimeRange struct {
	_ struct{} `type:"structure"`

	FromTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`

	ToTime *time.Time `type:"timestamp" timestampFormat:"unixTimestamp"`
}

// String returns the string representation
func (s StartTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimeRange) GoString() string {
	return s.String()
}

// SetFromTime sets the FromTime field's value.
func (s *StartTimeRange) SetFromTime(v time.Time) *StartTimeRange {
	s.FromTime = &v
	return s
}

// SetToTime sets the ToTime field's value.
func (s *StartTimeRange) SetToTime(v time.Time) *StartTimeRange {
	s.ToTime = &v
	return s
}

type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	QuotaCode *string `type:"string"`

	ServiceCode *string `type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateCloudFormationCollectionFilter struct {
	_ struct{} `type:"structure"`

	StackNames []*string `type:"list"`
}

// String returns the string representation
func (s UpdateCloudFormationCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCloudFormationCollectionFilter) GoString() string {
	return s.String()
}

// SetStackNames sets the StackNames field's value.
func (s *UpdateCloudFormationCollectionFilter) SetStackNames(v []*string) *UpdateCloudFormationCollectionFilter {
	s.StackNames = v
	return s
}

type UpdateResourceCollectionFilter struct {
	_ struct{} `type:"structure"`

	CloudFormation *UpdateCloudFormationCollectionFilter `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceCollectionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceCollectionFilter) GoString() string {
	return s.String()
}

// SetCloudFormation sets the CloudFormation field's value.
func (s *UpdateResourceCollectionFilter) SetCloudFormation(v *UpdateCloudFormationCollectionFilter) *UpdateResourceCollectionFilter {
	s.CloudFormation = v
	return s
}

type UpdateResourceCollectionInput struct {
	_ struct{} `type:"structure"`

	// Action is a required field
	Action *string `type:"string" required:"true" enum:"UpdateResourceCollectionAction"`

	// ResourceCollection is a required field
	ResourceCollection *UpdateResourceCollectionFilter `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateResourceCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceCollectionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ResourceCollection == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceCollection"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateResourceCollectionInput) SetAction(v string) *UpdateResourceCollectionInput {
	s.Action = &v
	return s
}

// SetResourceCollection sets the ResourceCollection field's value.
func (s *UpdateResourceCollectionInput) SetResourceCollection(v *UpdateResourceCollectionFilter) *UpdateResourceCollectionInput {
	s.ResourceCollection = v
	return s
}

type UpdateResourceCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateResourceCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceCollectionOutput) GoString() string {
	return s.String()
}

type UpdateServiceIntegrationConfig struct {
	_ struct{} `type:"structure"`

	OpsCenter *OpsCenterIntegrationConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceIntegrationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceIntegrationConfig) GoString() string {
	return s.String()
}

// SetOpsCenter sets the OpsCenter field's value.
func (s *UpdateServiceIntegrationConfig) SetOpsCenter(v *OpsCenterIntegrationConfig) *UpdateServiceIntegrationConfig {
	s.OpsCenter = v
	return s
}

type UpdateServiceIntegrationInput struct {
	_ struct{} `type:"structure"`

	// ServiceIntegration is a required field
	ServiceIntegration *UpdateServiceIntegrationConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateServiceIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceIntegrationInput"}
	if s.ServiceIntegration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceIntegration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceIntegration sets the ServiceIntegration field's value.
func (s *UpdateServiceIntegrationInput) SetServiceIntegration(v *UpdateServiceIntegrationConfig) *UpdateServiceIntegrationInput {
	s.ServiceIntegration = v
	return s
}

type UpdateServiceIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceIntegrationOutput) GoString() string {
	return s.String()
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Fields []*ValidationExceptionField `type:"list"`

	Message_ *string `locationName:"Message" type:"string"`

	Reason *string `type:"string" enum:"ValidationExceptionReason"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Message is a required field
	Message *string `type:"string" required:"true"`

	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AnomalySeverityLow is a AnomalySeverity enum value
	AnomalySeverityLow = "LOW"

	// AnomalySeverityMedium is a AnomalySeverity enum value
	AnomalySeverityMedium = "MEDIUM"

	// AnomalySeverityHigh is a AnomalySeverity enum value
	AnomalySeverityHigh = "HIGH"
)

// AnomalySeverity_Values returns all elements of the AnomalySeverity enum
func AnomalySeverity_Values() []string {
	return []string{
		AnomalySeverityLow,
		AnomalySeverityMedium,
		AnomalySeverityHigh,
	}
}

const (
	// AnomalyStatusOngoing is a AnomalyStatus enum value
	AnomalyStatusOngoing = "ONGOING"

	// AnomalyStatusClosed is a AnomalyStatus enum value
	AnomalyStatusClosed = "CLOSED"
)

// AnomalyStatus_Values returns all elements of the AnomalyStatus enum
func AnomalyStatus_Values() []string {
	return []string{
		AnomalyStatusOngoing,
		AnomalyStatusClosed,
	}
}

const (
	// CloudWatchMetricsStatSum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatSum = "Sum"

	// CloudWatchMetricsStatAverage is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatAverage = "Average"

	// CloudWatchMetricsStatSampleCount is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatSampleCount = "SampleCount"

	// CloudWatchMetricsStatMinimum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatMinimum = "Minimum"

	// CloudWatchMetricsStatMaximum is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatMaximum = "Maximum"

	// CloudWatchMetricsStatP99 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP99 = "p99"

	// CloudWatchMetricsStatP90 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP90 = "p90"

	// CloudWatchMetricsStatP50 is a CloudWatchMetricsStat enum value
	CloudWatchMetricsStatP50 = "p50"
)

// CloudWatchMetricsStat_Values returns all elements of the CloudWatchMetricsStat enum
func CloudWatchMetricsStat_Values() []string {
	return []string{
		CloudWatchMetricsStatSum,
		CloudWatchMetricsStatAverage,
		CloudWatchMetricsStatSampleCount,
		CloudWatchMetricsStatMinimum,
		CloudWatchMetricsStatMaximum,
		CloudWatchMetricsStatP99,
		CloudWatchMetricsStatP90,
		CloudWatchMetricsStatP50,
	}
}

const (
	// EventClassInfrastructure is a EventClass enum value
	EventClassInfrastructure = "INFRASTRUCTURE"

	// EventClassDeployment is a EventClass enum value
	EventClassDeployment = "DEPLOYMENT"

	// EventClassSecurityChange is a EventClass enum value
	EventClassSecurityChange = "SECURITY_CHANGE"

	// EventClassConfigChange is a EventClass enum value
	EventClassConfigChange = "CONFIG_CHANGE"

	// EventClassSchemaChange is a EventClass enum value
	EventClassSchemaChange = "SCHEMA_CHANGE"
)

// EventClass_Values returns all elements of the EventClass enum
func EventClass_Values() []string {
	return []string{
		EventClassInfrastructure,
		EventClassDeployment,
		EventClassSecurityChange,
		EventClassConfigChange,
		EventClassSchemaChange,
	}
}

const (
	// EventDataSourceAwsCloudTrail is a EventDataSource enum value
	EventDataSourceAwsCloudTrail = "AWS_CLOUD_TRAIL"

	// EventDataSourceAwsCodeDeploy is a EventDataSource enum value
	EventDataSourceAwsCodeDeploy = "AWS_CODE_DEPLOY"
)

// EventDataSource_Values returns all elements of the EventDataSource enum
func EventDataSource_Values() []string {
	return []string{
		EventDataSourceAwsCloudTrail,
		EventDataSourceAwsCodeDeploy,
	}
}

const (
	// InsightFeedbackOptionValidCollection is a InsightFeedbackOption enum value
	InsightFeedbackOptionValidCollection = "VALID_COLLECTION"

	// InsightFeedbackOptionRecommendationUseful is a InsightFeedbackOption enum value
	InsightFeedbackOptionRecommendationUseful = "RECOMMENDATION_USEFUL"

	// InsightFeedbackOptionAlertTooSensitive is a InsightFeedbackOption enum value
	InsightFeedbackOptionAlertTooSensitive = "ALERT_TOO_SENSITIVE"

	// InsightFeedbackOptionDataNoisyAnomaly is a InsightFeedbackOption enum value
	InsightFeedbackOptionDataNoisyAnomaly = "DATA_NOISY_ANOMALY"

	// InsightFeedbackOptionDataIncorrect is a InsightFeedbackOption enum value
	InsightFeedbackOptionDataIncorrect = "DATA_INCORRECT"
)

// InsightFeedbackOption_Values returns all elements of the InsightFeedbackOption enum
func InsightFeedbackOption_Values() []string {
	return []string{
		InsightFeedbackOptionValidCollection,
		InsightFeedbackOptionRecommendationUseful,
		InsightFeedbackOptionAlertTooSensitive,
		InsightFeedbackOptionDataNoisyAnomaly,
		InsightFeedbackOptionDataIncorrect,
	}
}

const (
	// InsightSeverityLow is a InsightSeverity enum value
	InsightSeverityLow = "LOW"

	// InsightSeverityMedium is a InsightSeverity enum value
	InsightSeverityMedium = "MEDIUM"

	// InsightSeverityHigh is a InsightSeverity enum value
	InsightSeverityHigh = "HIGH"
)

// InsightSeverity_Values returns all elements of the InsightSeverity enum
func InsightSeverity_Values() []string {
	return []string{
		InsightSeverityLow,
		InsightSeverityMedium,
		InsightSeverityHigh,
	}
}

const (
	// InsightStatusOngoing is a InsightStatus enum value
	InsightStatusOngoing = "ONGOING"

	// InsightStatusClosed is a InsightStatus enum value
	InsightStatusClosed = "CLOSED"
)

// InsightStatus_Values returns all elements of the InsightStatus enum
func InsightStatus_Values() []string {
	return []string{
		InsightStatusOngoing,
		InsightStatusClosed,
	}
}

const (
	// InsightTypeReactive is a InsightType enum value
	InsightTypeReactive = "REACTIVE"

	// InsightTypeProactive is a InsightType enum value
	InsightTypeProactive = "PROACTIVE"
)

// InsightType_Values returns all elements of the InsightType enum
func InsightType_Values() []string {
	return []string{
		InsightTypeReactive,
		InsightTypeProactive,
	}
}

const (
	// OptInStatusEnabled is a OptInStatus enum value
	OptInStatusEnabled = "ENABLED"

	// OptInStatusDisabled is a OptInStatus enum value
	OptInStatusDisabled = "DISABLED"
)

// OptInStatus_Values returns all elements of the OptInStatus enum
func OptInStatus_Values() []string {
	return []string{
		OptInStatusEnabled,
		OptInStatusDisabled,
	}
}

const (
	// UpdateResourceCollectionActionAdd is a UpdateResourceCollectionAction enum value
	UpdateResourceCollectionActionAdd = "ADD"

	// UpdateResourceCollectionActionRemove is a UpdateResourceCollectionAction enum value
	UpdateResourceCollectionActionRemove = "REMOVE"
)

// UpdateResourceCollectionAction_Values returns all elements of the UpdateResourceCollectionAction enum
func UpdateResourceCollectionAction_Values() []string {
	return []string{
		UpdateResourceCollectionActionAdd,
		UpdateResourceCollectionActionRemove,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
