// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptSharedDirectory = "AcceptSharedDirectory"

// AcceptSharedDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the AcceptSharedDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptSharedDirectory for more information on using the AcceptSharedDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AcceptSharedDirectoryRequest method.
//    req, resp := client.AcceptSharedDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AcceptSharedDirectory
func (c *DirectoryService) AcceptSharedDirectoryRequest(input *AcceptSharedDirectoryInput) (req *request.Request, output *AcceptSharedDirectoryOutput) {
	op := &request.Operation{
		Name:       opAcceptSharedDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptSharedDirectoryInput{}
	}

	output = &AcceptSharedDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptSharedDirectory API operation for AWS Directory Service.
//
// Accepts a directory sharing request that was sent from the directory owner
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation AcceptSharedDirectory for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryAlreadySharedException
//   The specified directory has already been shared with this AWS account.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AcceptSharedDirectory
func (c *DirectoryService) AcceptSharedDirectory(input *AcceptSharedDirectoryInput) (*AcceptSharedDirectoryOutput, error) {
	req, out := c.AcceptSharedDirectoryRequest(input)
	return out, req.Send()
}

// AcceptSharedDirectoryWithContext is the same as AcceptSharedDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptSharedDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) AcceptSharedDirectoryWithContext(ctx aws.Context, input *AcceptSharedDirectoryInput, opts ...request.Option) (*AcceptSharedDirectoryOutput, error) {
	req, out := c.AcceptSharedDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddIpRoutes = "AddIpRoutes"

// AddIpRoutesRequest generates a "aws/request.Request" representing the
// client's request for the AddIpRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddIpRoutes for more information on using the AddIpRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddIpRoutesRequest method.
//    req, resp := client.AddIpRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddIpRoutes
func (c *DirectoryService) AddIpRoutesRequest(input *AddIpRoutesInput) (req *request.Request, output *AddIpRoutesOutput) {
	op := &request.Operation{
		Name:       opAddIpRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddIpRoutesInput{}
	}

	output = &AddIpRoutesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddIpRoutes API operation for AWS Directory Service.
//
// If the DNS server for your on-premises domain uses a publicly addressable
// IP address, you must add a CIDR address block to correctly route traffic
// to and from your Microsoft AD on Amazon Web Services. AddIpRoutes adds this
// address block. You can also use AddIpRoutes to facilitate routing traffic
// that uses public IP ranges from your Microsoft AD on AWS to a peer VPC.
//
// Before you call AddIpRoutes, ensure that all of the required permissions
// have been explicitly granted through a policy. For details about what permissions
// are required to run the AddIpRoutes operation, see AWS Directory Service
// API Permissions: Actions, Resources, and Conditions Reference (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation AddIpRoutes for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * IpRouteLimitExceededException
//   The maximum allowed number of IP addresses was exceeded. The default limit
//   is 100 IP address blocks.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddIpRoutes
func (c *DirectoryService) AddIpRoutes(input *AddIpRoutesInput) (*AddIpRoutesOutput, error) {
	req, out := c.AddIpRoutesRequest(input)
	return out, req.Send()
}

// AddIpRoutesWithContext is the same as AddIpRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See AddIpRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) AddIpRoutesWithContext(ctx aws.Context, input *AddIpRoutesInput, opts ...request.Option) (*AddIpRoutesOutput, error) {
	req, out := c.AddIpRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddRegion = "AddRegion"

// AddRegionRequest generates a "aws/request.Request" representing the
// client's request for the AddRegion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddRegion for more information on using the AddRegion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddRegionRequest method.
//    req, resp := client.AddRegionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddRegion
func (c *DirectoryService) AddRegionRequest(input *AddRegionInput) (req *request.Request, output *AddRegionOutput) {
	op := &request.Operation{
		Name:       opAddRegion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddRegionInput{}
	}

	output = &AddRegionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddRegion API operation for AWS Directory Service.
//
// Adds two domain controllers in the specified Region for the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation AddRegion for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryAlreadyInRegionException
//   The Region you specified is the same Region where the AWS Managed Microsoft
//   AD directory was created. Specify a different Region and try again.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * RegionLimitExceededException
//   You have reached the limit for maximum number of simultaneous Region replications
//   per directory.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddRegion
func (c *DirectoryService) AddRegion(input *AddRegionInput) (*AddRegionOutput, error) {
	req, out := c.AddRegionRequest(input)
	return out, req.Send()
}

// AddRegionWithContext is the same as AddRegion with the addition of
// the ability to pass a context and additional request options.
//
// See AddRegion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) AddRegionWithContext(ctx aws.Context, input *AddRegionInput, opts ...request.Option) (*AddRegionOutput, error) {
	req, out := c.AddRegionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddTagsToResource
func (c *DirectoryService) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for AWS Directory Service.
//
// Adds or overwrites one or more tags for the specified directory. Each directory
// can have a maximum of 50 tags. Each tag consists of a key and optional value.
// Tag keys must be unique to each resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * TagLimitExceededException
//   The maximum allowed number of tags was exceeded.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddTagsToResource
func (c *DirectoryService) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSchemaExtension = "CancelSchemaExtension"

// CancelSchemaExtensionRequest generates a "aws/request.Request" representing the
// client's request for the CancelSchemaExtension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSchemaExtension for more information on using the CancelSchemaExtension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelSchemaExtensionRequest method.
//    req, resp := client.CancelSchemaExtensionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CancelSchemaExtension
func (c *DirectoryService) CancelSchemaExtensionRequest(input *CancelSchemaExtensionInput) (req *request.Request, output *CancelSchemaExtensionOutput) {
	op := &request.Operation{
		Name:       opCancelSchemaExtension,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelSchemaExtensionInput{}
	}

	output = &CancelSchemaExtensionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelSchemaExtension API operation for AWS Directory Service.
//
// Cancels an in-progress schema extension to a Microsoft AD directory. Once
// a schema extension has started replicating to all domain controllers, the
// task can no longer be canceled. A schema extension can be canceled during
// any of the following states; Initializing, CreatingSnapshot, and UpdatingSchema.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CancelSchemaExtension for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CancelSchemaExtension
func (c *DirectoryService) CancelSchemaExtension(input *CancelSchemaExtensionInput) (*CancelSchemaExtensionOutput, error) {
	req, out := c.CancelSchemaExtensionRequest(input)
	return out, req.Send()
}

// CancelSchemaExtensionWithContext is the same as CancelSchemaExtension with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSchemaExtension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CancelSchemaExtensionWithContext(ctx aws.Context, input *CancelSchemaExtensionInput, opts ...request.Option) (*CancelSchemaExtensionOutput, error) {
	req, out := c.CancelSchemaExtensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opConnectDirectory = "ConnectDirectory"

// ConnectDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the ConnectDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConnectDirectory for more information on using the ConnectDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ConnectDirectoryRequest method.
//    req, resp := client.ConnectDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ConnectDirectory
func (c *DirectoryService) ConnectDirectoryRequest(input *ConnectDirectoryInput) (req *request.Request, output *ConnectDirectoryOutput) {
	op := &request.Operation{
		Name:       opConnectDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConnectDirectoryInput{}
	}

	output = &ConnectDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConnectDirectory API operation for AWS Directory Service.
//
// Creates an AD Connector to connect to an on-premises directory.
//
// Before you call ConnectDirectory, ensure that all of the required permissions
// have been explicitly granted through a policy. For details about what permissions
// are required to run the ConnectDirectory operation, see AWS Directory Service
// API Permissions: Actions, Resources, and Conditions Reference (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ConnectDirectory for usage and error information.
//
// Returned Error Types:
//   * DirectoryLimitExceededException
//   The maximum number of directories in the region has been reached. You can
//   use the GetDirectoryLimits operation to determine your directory limits in
//   the region.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ConnectDirectory
func (c *DirectoryService) ConnectDirectory(input *ConnectDirectoryInput) (*ConnectDirectoryOutput, error) {
	req, out := c.ConnectDirectoryRequest(input)
	return out, req.Send()
}

// ConnectDirectoryWithContext is the same as ConnectDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See ConnectDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) ConnectDirectoryWithContext(ctx aws.Context, input *ConnectDirectoryInput, opts ...request.Option) (*ConnectDirectoryOutput, error) {
	req, out := c.ConnectDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAlias for more information on using the CreateAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateAlias
func (c *DirectoryService) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &CreateAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for AWS Directory Service.
//
// Creates an alias for a directory and assigns the alias to the directory.
// The alias is used to construct the access URL for the directory, such as
// http://<alias>.awsapps.com.
//
// After an alias has been created, it cannot be deleted or reused, so this
// operation should only be used when absolutely necessary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateAlias for usage and error information.
//
// Returned Error Types:
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateAlias
func (c *DirectoryService) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	return out, req.Send()
}

// CreateAliasWithContext is the same as CreateAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CreateAliasWithContext(ctx aws.Context, input *CreateAliasInput, opts ...request.Option) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComputer = "CreateComputer"

// CreateComputerRequest generates a "aws/request.Request" representing the
// client's request for the CreateComputer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComputer for more information on using the CreateComputer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateComputerRequest method.
//    req, resp := client.CreateComputerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateComputer
func (c *DirectoryService) CreateComputerRequest(input *CreateComputerInput) (req *request.Request, output *CreateComputerOutput) {
	op := &request.Operation{
		Name:       opCreateComputer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateComputerInput{}
	}

	output = &CreateComputerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateComputer API operation for AWS Directory Service.
//
// Creates an Active Directory computer object in the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateComputer for usage and error information.
//
// Returned Error Types:
//   * AuthenticationFailedException
//   An authentication error occurred.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateComputer
func (c *DirectoryService) CreateComputer(input *CreateComputerInput) (*CreateComputerOutput, error) {
	req, out := c.CreateComputerRequest(input)
	return out, req.Send()
}

// CreateComputerWithContext is the same as CreateComputer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComputer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CreateComputerWithContext(ctx aws.Context, input *CreateComputerInput, opts ...request.Option) (*CreateComputerOutput, error) {
	req, out := c.CreateComputerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConditionalForwarder = "CreateConditionalForwarder"

// CreateConditionalForwarderRequest generates a "aws/request.Request" representing the
// client's request for the CreateConditionalForwarder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConditionalForwarder for more information on using the CreateConditionalForwarder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConditionalForwarderRequest method.
//    req, resp := client.CreateConditionalForwarderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateConditionalForwarder
func (c *DirectoryService) CreateConditionalForwarderRequest(input *CreateConditionalForwarderInput) (req *request.Request, output *CreateConditionalForwarderOutput) {
	op := &request.Operation{
		Name:       opCreateConditionalForwarder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConditionalForwarderInput{}
	}

	output = &CreateConditionalForwarderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateConditionalForwarder API operation for AWS Directory Service.
//
// Creates a conditional forwarder associated with your AWS directory. Conditional
// forwarders are required in order to set up a trust relationship with another
// domain. The conditional forwarder points to the trusted domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateConditionalForwarder for usage and error information.
//
// Returned Error Types:
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateConditionalForwarder
func (c *DirectoryService) CreateConditionalForwarder(input *CreateConditionalForwarderInput) (*CreateConditionalForwarderOutput, error) {
	req, out := c.CreateConditionalForwarderRequest(input)
	return out, req.Send()
}

// CreateConditionalForwarderWithContext is the same as CreateConditionalForwarder with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConditionalForwarder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CreateConditionalForwarderWithContext(ctx aws.Context, input *CreateConditionalForwarderInput, opts ...request.Option) (*CreateConditionalForwarderOutput, error) {
	req, out := c.CreateConditionalForwarderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDirectory = "CreateDirectory"

// CreateDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDirectory for more information on using the CreateDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDirectoryRequest method.
//    req, resp := client.CreateDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateDirectory
func (c *DirectoryService) CreateDirectoryRequest(input *CreateDirectoryInput) (req *request.Request, output *CreateDirectoryOutput) {
	op := &request.Operation{
		Name:       opCreateDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectoryInput{}
	}

	output = &CreateDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDirectory API operation for AWS Directory Service.
//
// Creates a Simple AD directory. For more information, see Simple Active Directory
// (https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html)
// in the AWS Directory Service Admin Guide.
//
// Before you call CreateDirectory, ensure that all of the required permissions
// have been explicitly granted through a policy. For details about what permissions
// are required to run the CreateDirectory operation, see AWS Directory Service
// API Permissions: Actions, Resources, and Conditions Reference (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateDirectory for usage and error information.
//
// Returned Error Types:
//   * DirectoryLimitExceededException
//   The maximum number of directories in the region has been reached. You can
//   use the GetDirectoryLimits operation to determine your directory limits in
//   the region.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateDirectory
func (c *DirectoryService) CreateDirectory(input *CreateDirectoryInput) (*CreateDirectoryOutput, error) {
	req, out := c.CreateDirectoryRequest(input)
	return out, req.Send()
}

// CreateDirectoryWithContext is the same as CreateDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CreateDirectoryWithContext(ctx aws.Context, input *CreateDirectoryInput, opts ...request.Option) (*CreateDirectoryOutput, error) {
	req, out := c.CreateDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLogSubscription = "CreateLogSubscription"

// CreateLogSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateLogSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLogSubscription for more information on using the CreateLogSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLogSubscriptionRequest method.
//    req, resp := client.CreateLogSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscription
func (c *DirectoryService) CreateLogSubscriptionRequest(input *CreateLogSubscriptionInput) (req *request.Request, output *CreateLogSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateLogSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLogSubscriptionInput{}
	}

	output = &CreateLogSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateLogSubscription API operation for AWS Directory Service.
//
// Creates a subscription to forward real-time Directory Service domain controller
// security logs to the specified Amazon CloudWatch log group in your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateLogSubscription for usage and error information.
//
// Returned Error Types:
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InsufficientPermissionsException
//   The account does not have sufficient permission to perform the operation.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscription
func (c *DirectoryService) CreateLogSubscription(input *CreateLogSubscriptionInput) (*CreateLogSubscriptionOutput, error) {
	req, out := c.CreateLogSubscriptionRequest(input)
	return out, req.Send()
}

// CreateLogSubscriptionWithContext is the same as CreateLogSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLogSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CreateLogSubscriptionWithContext(ctx aws.Context, input *CreateLogSubscriptionInput, opts ...request.Option) (*CreateLogSubscriptionOutput, error) {
	req, out := c.CreateLogSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMicrosoftAD = "CreateMicrosoftAD"

// CreateMicrosoftADRequest generates a "aws/request.Request" representing the
// client's request for the CreateMicrosoftAD operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMicrosoftAD for more information on using the CreateMicrosoftAD
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMicrosoftADRequest method.
//    req, resp := client.CreateMicrosoftADRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateMicrosoftAD
func (c *DirectoryService) CreateMicrosoftADRequest(input *CreateMicrosoftADInput) (req *request.Request, output *CreateMicrosoftADOutput) {
	op := &request.Operation{
		Name:       opCreateMicrosoftAD,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMicrosoftADInput{}
	}

	output = &CreateMicrosoftADOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMicrosoftAD API operation for AWS Directory Service.
//
// Creates a Microsoft AD directory in the AWS Cloud. For more information,
// see AWS Managed Microsoft AD (https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html)
// in the AWS Directory Service Admin Guide.
//
// Before you call CreateMicrosoftAD, ensure that all of the required permissions
// have been explicitly granted through a policy. For details about what permissions
// are required to run the CreateMicrosoftAD operation, see AWS Directory Service
// API Permissions: Actions, Resources, and Conditions Reference (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateMicrosoftAD for usage and error information.
//
// Returned Error Types:
//   * DirectoryLimitExceededException
//   The maximum number of directories in the region has been reached. You can
//   use the GetDirectoryLimits operation to determine your directory limits in
//   the region.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateMicrosoftAD
func (c *DirectoryService) CreateMicrosoftAD(input *CreateMicrosoftADInput) (*CreateMicrosoftADOutput, error) {
	req, out := c.CreateMicrosoftADRequest(input)
	return out, req.Send()
}

// CreateMicrosoftADWithContext is the same as CreateMicrosoftAD with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMicrosoftAD for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CreateMicrosoftADWithContext(ctx aws.Context, input *CreateMicrosoftADInput, opts ...request.Option) (*CreateMicrosoftADOutput, error) {
	req, out := c.CreateMicrosoftADRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSnapshotRequest method.
//    req, resp := client.CreateSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateSnapshot
func (c *DirectoryService) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &CreateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for AWS Directory Service.
//
// Creates a snapshot of a Simple AD or Microsoft AD directory in the AWS cloud.
//
// You cannot take snapshots of AD Connector directories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * SnapshotLimitExceededException
//   The maximum number of manual snapshots for the directory has been reached.
//   You can use the GetSnapshotLimits operation to determine the snapshot limits
//   for a directory.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateSnapshot
func (c *DirectoryService) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrust = "CreateTrust"

// CreateTrustRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrust operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrust for more information on using the CreateTrust
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrustRequest method.
//    req, resp := client.CreateTrustRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateTrust
func (c *DirectoryService) CreateTrustRequest(input *CreateTrustInput) (req *request.Request, output *CreateTrustOutput) {
	op := &request.Operation{
		Name:       opCreateTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrustInput{}
	}

	output = &CreateTrustOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrust API operation for AWS Directory Service.
//
// AWS Directory Service for Microsoft Active Directory allows you to configure
// trust relationships. For example, you can establish a trust between your
// AWS Managed Microsoft AD directory, and your existing on-premises Microsoft
// Active Directory. This would allow you to provide users and groups access
// to resources in either domain, with a single set of credentials.
//
// This action initiates the creation of the AWS side of a trust relationship
// between an AWS Managed Microsoft AD directory and an external domain. You
// can create either a forest trust or an external trust.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation CreateTrust for usage and error information.
//
// Returned Error Types:
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateTrust
func (c *DirectoryService) CreateTrust(input *CreateTrustInput) (*CreateTrustOutput, error) {
	req, out := c.CreateTrustRequest(input)
	return out, req.Send()
}

// CreateTrustWithContext is the same as CreateTrust with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrust for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) CreateTrustWithContext(ctx aws.Context, input *CreateTrustInput, opts ...request.Option) (*CreateTrustOutput, error) {
	req, out := c.CreateTrustRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConditionalForwarder = "DeleteConditionalForwarder"

// DeleteConditionalForwarderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConditionalForwarder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConditionalForwarder for more information on using the DeleteConditionalForwarder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConditionalForwarderRequest method.
//    req, resp := client.DeleteConditionalForwarderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarder
func (c *DirectoryService) DeleteConditionalForwarderRequest(input *DeleteConditionalForwarderInput) (req *request.Request, output *DeleteConditionalForwarderOutput) {
	op := &request.Operation{
		Name:       opDeleteConditionalForwarder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConditionalForwarderInput{}
	}

	output = &DeleteConditionalForwarderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConditionalForwarder API operation for AWS Directory Service.
//
// Deletes a conditional forwarder that has been set up for your AWS directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteConditionalForwarder for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarder
func (c *DirectoryService) DeleteConditionalForwarder(input *DeleteConditionalForwarderInput) (*DeleteConditionalForwarderOutput, error) {
	req, out := c.DeleteConditionalForwarderRequest(input)
	return out, req.Send()
}

// DeleteConditionalForwarderWithContext is the same as DeleteConditionalForwarder with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConditionalForwarder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DeleteConditionalForwarderWithContext(ctx aws.Context, input *DeleteConditionalForwarderInput, opts ...request.Option) (*DeleteConditionalForwarderOutput, error) {
	req, out := c.DeleteConditionalForwarderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDirectory = "DeleteDirectory"

// DeleteDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDirectory for more information on using the DeleteDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDirectoryRequest method.
//    req, resp := client.DeleteDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteDirectory
func (c *DirectoryService) DeleteDirectoryRequest(input *DeleteDirectoryInput) (req *request.Request, output *DeleteDirectoryOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectoryInput{}
	}

	output = &DeleteDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDirectory API operation for AWS Directory Service.
//
// Deletes an AWS Directory Service directory.
//
// Before you call DeleteDirectory, ensure that all of the required permissions
// have been explicitly granted through a policy. For details about what permissions
// are required to run the DeleteDirectory operation, see AWS Directory Service
// API Permissions: Actions, Resources, and Conditions Reference (http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteDirectory for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteDirectory
func (c *DirectoryService) DeleteDirectory(input *DeleteDirectoryInput) (*DeleteDirectoryOutput, error) {
	req, out := c.DeleteDirectoryRequest(input)
	return out, req.Send()
}

// DeleteDirectoryWithContext is the same as DeleteDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DeleteDirectoryWithContext(ctx aws.Context, input *DeleteDirectoryInput, opts ...request.Option) (*DeleteDirectoryOutput, error) {
	req, out := c.DeleteDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLogSubscription = "DeleteLogSubscription"

// DeleteLogSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLogSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLogSubscription for more information on using the DeleteLogSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLogSubscriptionRequest method.
//    req, resp := client.DeleteLogSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteLogSubscription
func (c *DirectoryService) DeleteLogSubscriptionRequest(input *DeleteLogSubscriptionInput) (req *request.Request, output *DeleteLogSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteLogSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLogSubscriptionInput{}
	}

	output = &DeleteLogSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLogSubscription API operation for AWS Directory Service.
//
// Deletes the specified log subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteLogSubscription for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteLogSubscription
func (c *DirectoryService) DeleteLogSubscription(input *DeleteLogSubscriptionInput) (*DeleteLogSubscriptionOutput, error) {
	req, out := c.DeleteLogSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteLogSubscriptionWithContext is the same as DeleteLogSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLogSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DeleteLogSubscriptionWithContext(ctx aws.Context, input *DeleteLogSubscriptionInput, opts ...request.Option) (*DeleteLogSubscriptionOutput, error) {
	req, out := c.DeleteLogSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshot for more information on using the DeleteSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSnapshotRequest method.
//    req, resp := client.DeleteSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteSnapshot
func (c *DirectoryService) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	output = &DeleteSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSnapshot API operation for AWS Directory Service.
//
// Deletes a directory snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteSnapshot for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteSnapshot
func (c *DirectoryService) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	return out, req.Send()
}

// DeleteSnapshotWithContext is the same as DeleteSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DeleteSnapshotWithContext(ctx aws.Context, input *DeleteSnapshotInput, opts ...request.Option) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrust = "DeleteTrust"

// DeleteTrustRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrust operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrust for more information on using the DeleteTrust
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrustRequest method.
//    req, resp := client.DeleteTrustRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrust
func (c *DirectoryService) DeleteTrustRequest(input *DeleteTrustInput) (req *request.Request, output *DeleteTrustOutput) {
	op := &request.Operation{
		Name:       opDeleteTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrustInput{}
	}

	output = &DeleteTrustOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrust API operation for AWS Directory Service.
//
// Deletes an existing trust relationship between your AWS Managed Microsoft
// AD directory and an external domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeleteTrust for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrust
func (c *DirectoryService) DeleteTrust(input *DeleteTrustInput) (*DeleteTrustOutput, error) {
	req, out := c.DeleteTrustRequest(input)
	return out, req.Send()
}

// DeleteTrustWithContext is the same as DeleteTrust with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrust for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DeleteTrustWithContext(ctx aws.Context, input *DeleteTrustInput, opts ...request.Option) (*DeleteTrustOutput, error) {
	req, out := c.DeleteTrustRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterCertificate = "DeregisterCertificate"

// DeregisterCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterCertificate for more information on using the DeregisterCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterCertificateRequest method.
//    req, resp := client.DeregisterCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterCertificate
func (c *DirectoryService) DeregisterCertificateRequest(input *DeregisterCertificateInput) (req *request.Request, output *DeregisterCertificateOutput) {
	op := &request.Operation{
		Name:       opDeregisterCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterCertificateInput{}
	}

	output = &DeregisterCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterCertificate API operation for AWS Directory Service.
//
// Deletes from the system the certificate that was registered for a secured
// LDAP connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeregisterCertificate for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * CertificateDoesNotExistException
//   The certificate is not present in the system for describe or deregister activities.
//
//   * CertificateInUseException
//   The certificate is being used for the LDAP security connection and cannot
//   be removed without disabling LDAP security.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterCertificate
func (c *DirectoryService) DeregisterCertificate(input *DeregisterCertificateInput) (*DeregisterCertificateOutput, error) {
	req, out := c.DeregisterCertificateRequest(input)
	return out, req.Send()
}

// DeregisterCertificateWithContext is the same as DeregisterCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DeregisterCertificateWithContext(ctx aws.Context, input *DeregisterCertificateInput, opts ...request.Option) (*DeregisterCertificateOutput, error) {
	req, out := c.DeregisterCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterEventTopic = "DeregisterEventTopic"

// DeregisterEventTopicRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterEventTopic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterEventTopic for more information on using the DeregisterEventTopic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterEventTopicRequest method.
//    req, resp := client.DeregisterEventTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterEventTopic
func (c *DirectoryService) DeregisterEventTopicRequest(input *DeregisterEventTopicInput) (req *request.Request, output *DeregisterEventTopicOutput) {
	op := &request.Operation{
		Name:       opDeregisterEventTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterEventTopicInput{}
	}

	output = &DeregisterEventTopicOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterEventTopic API operation for AWS Directory Service.
//
// Removes the specified directory as a publisher to the specified SNS topic.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DeregisterEventTopic for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterEventTopic
func (c *DirectoryService) DeregisterEventTopic(input *DeregisterEventTopicInput) (*DeregisterEventTopicOutput, error) {
	req, out := c.DeregisterEventTopicRequest(input)
	return out, req.Send()
}

// DeregisterEventTopicWithContext is the same as DeregisterEventTopic with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterEventTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DeregisterEventTopicWithContext(ctx aws.Context, input *DeregisterEventTopicInput, opts ...request.Option) (*DeregisterEventTopicOutput, error) {
	req, out := c.DeregisterEventTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCertificate = "DescribeCertificate"

// DescribeCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificate for more information on using the DescribeCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificateRequest method.
//    req, resp := client.DescribeCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCertificate
func (c *DirectoryService) DescribeCertificateRequest(input *DescribeCertificateInput) (req *request.Request, output *DescribeCertificateOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCertificateInput{}
	}

	output = &DescribeCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificate API operation for AWS Directory Service.
//
// Displays information about the certificate registered for a secured LDAP
// connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeCertificate for usage and error information.
//
// Returned Error Types:
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * CertificateDoesNotExistException
//   The certificate is not present in the system for describe or deregister activities.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCertificate
func (c *DirectoryService) DescribeCertificate(input *DescribeCertificateInput) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	return out, req.Send()
}

// DescribeCertificateWithContext is the same as DescribeCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeCertificateWithContext(ctx aws.Context, input *DescribeCertificateInput, opts ...request.Option) (*DescribeCertificateOutput, error) {
	req, out := c.DescribeCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConditionalForwarders = "DescribeConditionalForwarders"

// DescribeConditionalForwardersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConditionalForwarders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConditionalForwarders for more information on using the DescribeConditionalForwarders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConditionalForwardersRequest method.
//    req, resp := client.DescribeConditionalForwardersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwarders
func (c *DirectoryService) DescribeConditionalForwardersRequest(input *DescribeConditionalForwardersInput) (req *request.Request, output *DescribeConditionalForwardersOutput) {
	op := &request.Operation{
		Name:       opDescribeConditionalForwarders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConditionalForwardersInput{}
	}

	output = &DescribeConditionalForwardersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConditionalForwarders API operation for AWS Directory Service.
//
// Obtains information about the conditional forwarders for this account.
//
// If no input parameters are provided for RemoteDomainNames, this request describes
// all conditional forwarders for the specified directory ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeConditionalForwarders for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwarders
func (c *DirectoryService) DescribeConditionalForwarders(input *DescribeConditionalForwardersInput) (*DescribeConditionalForwardersOutput, error) {
	req, out := c.DescribeConditionalForwardersRequest(input)
	return out, req.Send()
}

// DescribeConditionalForwardersWithContext is the same as DescribeConditionalForwarders with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConditionalForwarders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeConditionalForwardersWithContext(ctx aws.Context, input *DescribeConditionalForwardersInput, opts ...request.Option) (*DescribeConditionalForwardersOutput, error) {
	req, out := c.DescribeConditionalForwardersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDirectories = "DescribeDirectories"

// DescribeDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDirectories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDirectories for more information on using the DescribeDirectories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDirectoriesRequest method.
//    req, resp := client.DescribeDirectoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories
func (c *DirectoryService) DescribeDirectoriesRequest(input *DescribeDirectoriesInput) (req *request.Request, output *DescribeDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectoriesInput{}
	}

	output = &DescribeDirectoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDirectories API operation for AWS Directory Service.
//
// Obtains information about the directories that belong to this account.
//
// You can retrieve information about specific directories by passing the directory
// identifiers in the DirectoryIds parameter. Otherwise, all directories that
// belong to the current account are returned.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the DescribeDirectoriesResult.NextToken
// member contains a token that you pass in the next call to DescribeDirectories
// to retrieve the next set of items.
//
// You can also specify a maximum number of return results with the Limit parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeDirectories for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories
func (c *DirectoryService) DescribeDirectories(input *DescribeDirectoriesInput) (*DescribeDirectoriesOutput, error) {
	req, out := c.DescribeDirectoriesRequest(input)
	return out, req.Send()
}

// DescribeDirectoriesWithContext is the same as DescribeDirectories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDirectories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeDirectoriesWithContext(ctx aws.Context, input *DescribeDirectoriesInput, opts ...request.Option) (*DescribeDirectoriesOutput, error) {
	req, out := c.DescribeDirectoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDomainControllers = "DescribeDomainControllers"

// DescribeDomainControllersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDomainControllers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDomainControllers for more information on using the DescribeDomainControllers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDomainControllersRequest method.
//    req, resp := client.DescribeDomainControllersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers
func (c *DirectoryService) DescribeDomainControllersRequest(input *DescribeDomainControllersInput) (req *request.Request, output *DescribeDomainControllersOutput) {
	op := &request.Operation{
		Name:       opDescribeDomainControllers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDomainControllersInput{}
	}

	output = &DescribeDomainControllersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDomainControllers API operation for AWS Directory Service.
//
// Provides information about any domain controllers in your directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeDomainControllers for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers
func (c *DirectoryService) DescribeDomainControllers(input *DescribeDomainControllersInput) (*DescribeDomainControllersOutput, error) {
	req, out := c.DescribeDomainControllersRequest(input)
	return out, req.Send()
}

// DescribeDomainControllersWithContext is the same as DescribeDomainControllers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDomainControllers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeDomainControllersWithContext(ctx aws.Context, input *DescribeDomainControllersInput, opts ...request.Option) (*DescribeDomainControllersOutput, error) {
	req, out := c.DescribeDomainControllersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeDomainControllersPages iterates over the pages of a DescribeDomainControllers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeDomainControllers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeDomainControllers operation.
//    pageNum := 0
//    err := client.DescribeDomainControllersPages(params,
//        func(page *directoryservice.DescribeDomainControllersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DirectoryService) DescribeDomainControllersPages(input *DescribeDomainControllersInput, fn func(*DescribeDomainControllersOutput, bool) bool) error {
	return c.DescribeDomainControllersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeDomainControllersPagesWithContext same as DescribeDomainControllersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeDomainControllersPagesWithContext(ctx aws.Context, input *DescribeDomainControllersInput, fn func(*DescribeDomainControllersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeDomainControllersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeDomainControllersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeDomainControllersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEventTopics = "DescribeEventTopics"

// DescribeEventTopicsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventTopics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventTopics for more information on using the DescribeEventTopics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventTopicsRequest method.
//    req, resp := client.DescribeEventTopicsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeEventTopics
func (c *DirectoryService) DescribeEventTopicsRequest(input *DescribeEventTopicsInput) (req *request.Request, output *DescribeEventTopicsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventTopics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventTopicsInput{}
	}

	output = &DescribeEventTopicsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventTopics API operation for AWS Directory Service.
//
// Obtains information about which SNS topics receive status messages from the
// specified directory.
//
// If no input parameters are provided, such as DirectoryId or TopicName, this
// request describes all of the associations in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeEventTopics for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeEventTopics
func (c *DirectoryService) DescribeEventTopics(input *DescribeEventTopicsInput) (*DescribeEventTopicsOutput, error) {
	req, out := c.DescribeEventTopicsRequest(input)
	return out, req.Send()
}

// DescribeEventTopicsWithContext is the same as DescribeEventTopics with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventTopics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeEventTopicsWithContext(ctx aws.Context, input *DescribeEventTopicsInput, opts ...request.Option) (*DescribeEventTopicsOutput, error) {
	req, out := c.DescribeEventTopicsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLDAPSSettings = "DescribeLDAPSSettings"

// DescribeLDAPSSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLDAPSSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLDAPSSettings for more information on using the DescribeLDAPSSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLDAPSSettingsRequest method.
//    req, resp := client.DescribeLDAPSSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings
func (c *DirectoryService) DescribeLDAPSSettingsRequest(input *DescribeLDAPSSettingsInput) (req *request.Request, output *DescribeLDAPSSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeLDAPSSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLDAPSSettingsInput{}
	}

	output = &DescribeLDAPSSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLDAPSSettings API operation for AWS Directory Service.
//
// Describes the status of LDAP security for the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeLDAPSSettings for usage and error information.
//
// Returned Error Types:
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings
func (c *DirectoryService) DescribeLDAPSSettings(input *DescribeLDAPSSettingsInput) (*DescribeLDAPSSettingsOutput, error) {
	req, out := c.DescribeLDAPSSettingsRequest(input)
	return out, req.Send()
}

// DescribeLDAPSSettingsWithContext is the same as DescribeLDAPSSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLDAPSSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeLDAPSSettingsWithContext(ctx aws.Context, input *DescribeLDAPSSettingsInput, opts ...request.Option) (*DescribeLDAPSSettingsOutput, error) {
	req, out := c.DescribeLDAPSSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRegions = "DescribeRegions"

// DescribeRegionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRegions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRegions for more information on using the DescribeRegions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRegionsRequest method.
//    req, resp := client.DescribeRegionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions
func (c *DirectoryService) DescribeRegionsRequest(input *DescribeRegionsInput) (req *request.Request, output *DescribeRegionsOutput) {
	op := &request.Operation{
		Name:       opDescribeRegions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRegionsInput{}
	}

	output = &DescribeRegionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRegions API operation for AWS Directory Service.
//
// Provides information about the Regions that are configured for multi-Region
// replication.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeRegions for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions
func (c *DirectoryService) DescribeRegions(input *DescribeRegionsInput) (*DescribeRegionsOutput, error) {
	req, out := c.DescribeRegionsRequest(input)
	return out, req.Send()
}

// DescribeRegionsWithContext is the same as DescribeRegions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRegions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeRegionsWithContext(ctx aws.Context, input *DescribeRegionsInput, opts ...request.Option) (*DescribeRegionsOutput, error) {
	req, out := c.DescribeRegionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSharedDirectories = "DescribeSharedDirectories"

// DescribeSharedDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSharedDirectories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSharedDirectories for more information on using the DescribeSharedDirectories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSharedDirectoriesRequest method.
//    req, resp := client.DescribeSharedDirectoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories
func (c *DirectoryService) DescribeSharedDirectoriesRequest(input *DescribeSharedDirectoriesInput) (req *request.Request, output *DescribeSharedDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeSharedDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSharedDirectoriesInput{}
	}

	output = &DescribeSharedDirectoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSharedDirectories API operation for AWS Directory Service.
//
// Returns the shared directories in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeSharedDirectories for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories
func (c *DirectoryService) DescribeSharedDirectories(input *DescribeSharedDirectoriesInput) (*DescribeSharedDirectoriesOutput, error) {
	req, out := c.DescribeSharedDirectoriesRequest(input)
	return out, req.Send()
}

// DescribeSharedDirectoriesWithContext is the same as DescribeSharedDirectories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSharedDirectories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeSharedDirectoriesWithContext(ctx aws.Context, input *DescribeSharedDirectoriesInput, opts ...request.Option) (*DescribeSharedDirectoriesOutput, error) {
	req, out := c.DescribeSharedDirectoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSnapshots for more information on using the DescribeSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSnapshotsRequest method.
//    req, resp := client.DescribeSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots
func (c *DirectoryService) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *request.Request, output *DescribeSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	output = &DescribeSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSnapshots API operation for AWS Directory Service.
//
// Obtains information about the directory snapshots that belong to this account.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the DescribeSnapshots.NextToken
// member contains a token that you pass in the next call to DescribeSnapshots
// to retrieve the next set of items.
//
// You can also specify a maximum number of return results with the Limit parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeSnapshots for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots
func (c *DirectoryService) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeSnapshotsWithContext is the same as DescribeSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeSnapshotsWithContext(ctx aws.Context, input *DescribeSnapshotsInput, opts ...request.Option) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrusts = "DescribeTrusts"

// DescribeTrustsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrusts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrusts for more information on using the DescribeTrusts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrustsRequest method.
//    req, resp := client.DescribeTrustsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts
func (c *DirectoryService) DescribeTrustsRequest(input *DescribeTrustsInput) (req *request.Request, output *DescribeTrustsOutput) {
	op := &request.Operation{
		Name:       opDescribeTrusts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustsInput{}
	}

	output = &DescribeTrustsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrusts API operation for AWS Directory Service.
//
// Obtains information about the trust relationships for this account.
//
// If no input parameters are provided, such as DirectoryId or TrustIds, this
// request describes all the trust relationships belonging to the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DescribeTrusts for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts
func (c *DirectoryService) DescribeTrusts(input *DescribeTrustsInput) (*DescribeTrustsOutput, error) {
	req, out := c.DescribeTrustsRequest(input)
	return out, req.Send()
}

// DescribeTrustsWithContext is the same as DescribeTrusts with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrusts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DescribeTrustsWithContext(ctx aws.Context, input *DescribeTrustsInput, opts ...request.Option) (*DescribeTrustsOutput, error) {
	req, out := c.DescribeTrustsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableClientAuthentication = "DisableClientAuthentication"

// DisableClientAuthenticationRequest generates a "aws/request.Request" representing the
// client's request for the DisableClientAuthentication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableClientAuthentication for more information on using the DisableClientAuthentication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableClientAuthenticationRequest method.
//    req, resp := client.DisableClientAuthenticationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableClientAuthentication
func (c *DirectoryService) DisableClientAuthenticationRequest(input *DisableClientAuthenticationInput) (req *request.Request, output *DisableClientAuthenticationOutput) {
	op := &request.Operation{
		Name:       opDisableClientAuthentication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableClientAuthenticationInput{}
	}

	output = &DisableClientAuthenticationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableClientAuthentication API operation for AWS Directory Service.
//
// Disable client authentication for smart cards.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DisableClientAuthentication for usage and error information.
//
// Returned Error Types:
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidClientAuthStatusException
//   The client authorization was invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableClientAuthentication
func (c *DirectoryService) DisableClientAuthentication(input *DisableClientAuthenticationInput) (*DisableClientAuthenticationOutput, error) {
	req, out := c.DisableClientAuthenticationRequest(input)
	return out, req.Send()
}

// DisableClientAuthenticationWithContext is the same as DisableClientAuthentication with the addition of
// the ability to pass a context and additional request options.
//
// See DisableClientAuthentication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DisableClientAuthenticationWithContext(ctx aws.Context, input *DisableClientAuthenticationInput, opts ...request.Option) (*DisableClientAuthenticationOutput, error) {
	req, out := c.DisableClientAuthenticationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableLDAPS = "DisableLDAPS"

// DisableLDAPSRequest generates a "aws/request.Request" representing the
// client's request for the DisableLDAPS operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableLDAPS for more information on using the DisableLDAPS
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableLDAPSRequest method.
//    req, resp := client.DisableLDAPSRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableLDAPS
func (c *DirectoryService) DisableLDAPSRequest(input *DisableLDAPSInput) (req *request.Request, output *DisableLDAPSOutput) {
	op := &request.Operation{
		Name:       opDisableLDAPS,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableLDAPSInput{}
	}

	output = &DisableLDAPSOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableLDAPS API operation for AWS Directory Service.
//
// Deactivates LDAP secure calls for the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DisableLDAPS for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * InvalidLDAPSStatusException
//   The LDAP activities could not be performed because they are limited by the
//   LDAPS status.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableLDAPS
func (c *DirectoryService) DisableLDAPS(input *DisableLDAPSInput) (*DisableLDAPSOutput, error) {
	req, out := c.DisableLDAPSRequest(input)
	return out, req.Send()
}

// DisableLDAPSWithContext is the same as DisableLDAPS with the addition of
// the ability to pass a context and additional request options.
//
// See DisableLDAPS for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DisableLDAPSWithContext(ctx aws.Context, input *DisableLDAPSInput, opts ...request.Option) (*DisableLDAPSOutput, error) {
	req, out := c.DisableLDAPSRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableRadius = "DisableRadius"

// DisableRadiusRequest generates a "aws/request.Request" representing the
// client's request for the DisableRadius operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableRadius for more information on using the DisableRadius
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableRadiusRequest method.
//    req, resp := client.DisableRadiusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableRadius
func (c *DirectoryService) DisableRadiusRequest(input *DisableRadiusInput) (req *request.Request, output *DisableRadiusOutput) {
	op := &request.Operation{
		Name:       opDisableRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableRadiusInput{}
	}

	output = &DisableRadiusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableRadius API operation for AWS Directory Service.
//
// Disables multi-factor authentication (MFA) with the Remote Authentication
// Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD
// directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DisableRadius for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableRadius
func (c *DirectoryService) DisableRadius(input *DisableRadiusInput) (*DisableRadiusOutput, error) {
	req, out := c.DisableRadiusRequest(input)
	return out, req.Send()
}

// DisableRadiusWithContext is the same as DisableRadius with the addition of
// the ability to pass a context and additional request options.
//
// See DisableRadius for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DisableRadiusWithContext(ctx aws.Context, input *DisableRadiusInput, opts ...request.Option) (*DisableRadiusOutput, error) {
	req, out := c.DisableRadiusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisableSso = "DisableSso"

// DisableSsoRequest generates a "aws/request.Request" representing the
// client's request for the DisableSso operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisableSso for more information on using the DisableSso
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisableSsoRequest method.
//    req, resp := client.DisableSsoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableSso
func (c *DirectoryService) DisableSsoRequest(input *DisableSsoInput) (req *request.Request, output *DisableSsoOutput) {
	op := &request.Operation{
		Name:       opDisableSso,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableSsoInput{}
	}

	output = &DisableSsoOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisableSso API operation for AWS Directory Service.
//
// Disables single-sign on for a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation DisableSso for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InsufficientPermissionsException
//   The account does not have sufficient permission to perform the operation.
//
//   * AuthenticationFailedException
//   An authentication error occurred.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableSso
func (c *DirectoryService) DisableSso(input *DisableSsoInput) (*DisableSsoOutput, error) {
	req, out := c.DisableSsoRequest(input)
	return out, req.Send()
}

// DisableSsoWithContext is the same as DisableSso with the addition of
// the ability to pass a context and additional request options.
//
// See DisableSso for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) DisableSsoWithContext(ctx aws.Context, input *DisableSsoInput, opts ...request.Option) (*DisableSsoOutput, error) {
	req, out := c.DisableSsoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableClientAuthentication = "EnableClientAuthentication"

// EnableClientAuthenticationRequest generates a "aws/request.Request" representing the
// client's request for the EnableClientAuthentication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableClientAuthentication for more information on using the EnableClientAuthentication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableClientAuthenticationRequest method.
//    req, resp := client.EnableClientAuthenticationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableClientAuthentication
func (c *DirectoryService) EnableClientAuthenticationRequest(input *EnableClientAuthenticationInput) (req *request.Request, output *EnableClientAuthenticationOutput) {
	op := &request.Operation{
		Name:       opEnableClientAuthentication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableClientAuthenticationInput{}
	}

	output = &EnableClientAuthenticationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableClientAuthentication API operation for AWS Directory Service.
//
// Enable client authentication for smardtcards.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation EnableClientAuthentication for usage and error information.
//
// Returned Error Types:
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidClientAuthStatusException
//   The client authorization was invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * NoAvailableCertificateException
//   The LDAP activities could not be performed because at least one valid certificate
//   must be registered with the system.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableClientAuthentication
func (c *DirectoryService) EnableClientAuthentication(input *EnableClientAuthenticationInput) (*EnableClientAuthenticationOutput, error) {
	req, out := c.EnableClientAuthenticationRequest(input)
	return out, req.Send()
}

// EnableClientAuthenticationWithContext is the same as EnableClientAuthentication with the addition of
// the ability to pass a context and additional request options.
//
// See EnableClientAuthentication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) EnableClientAuthenticationWithContext(ctx aws.Context, input *EnableClientAuthenticationInput, opts ...request.Option) (*EnableClientAuthenticationOutput, error) {
	req, out := c.EnableClientAuthenticationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableLDAPS = "EnableLDAPS"

// EnableLDAPSRequest generates a "aws/request.Request" representing the
// client's request for the EnableLDAPS operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableLDAPS for more information on using the EnableLDAPS
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableLDAPSRequest method.
//    req, resp := client.EnableLDAPSRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableLDAPS
func (c *DirectoryService) EnableLDAPSRequest(input *EnableLDAPSInput) (req *request.Request, output *EnableLDAPSOutput) {
	op := &request.Operation{
		Name:       opEnableLDAPS,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableLDAPSInput{}
	}

	output = &EnableLDAPSOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableLDAPS API operation for AWS Directory Service.
//
// Activates the switch for the specific directory to always use LDAP secure
// calls.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation EnableLDAPS for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * NoAvailableCertificateException
//   The LDAP activities could not be performed because at least one valid certificate
//   must be registered with the system.
//
//   * InvalidLDAPSStatusException
//   The LDAP activities could not be performed because they are limited by the
//   LDAPS status.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableLDAPS
func (c *DirectoryService) EnableLDAPS(input *EnableLDAPSInput) (*EnableLDAPSOutput, error) {
	req, out := c.EnableLDAPSRequest(input)
	return out, req.Send()
}

// EnableLDAPSWithContext is the same as EnableLDAPS with the addition of
// the ability to pass a context and additional request options.
//
// See EnableLDAPS for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) EnableLDAPSWithContext(ctx aws.Context, input *EnableLDAPSInput, opts ...request.Option) (*EnableLDAPSOutput, error) {
	req, out := c.EnableLDAPSRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableRadius = "EnableRadius"

// EnableRadiusRequest generates a "aws/request.Request" representing the
// client's request for the EnableRadius operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableRadius for more information on using the EnableRadius
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableRadiusRequest method.
//    req, resp := client.EnableRadiusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableRadius
func (c *DirectoryService) EnableRadiusRequest(input *EnableRadiusInput) (req *request.Request, output *EnableRadiusOutput) {
	op := &request.Operation{
		Name:       opEnableRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableRadiusInput{}
	}

	output = &EnableRadiusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableRadius API operation for AWS Directory Service.
//
// Enables multi-factor authentication (MFA) with the Remote Authentication
// Dial In User Service (RADIUS) server for an AD Connector or Microsoft AD
// directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation EnableRadius for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * EntityAlreadyExistsException
//   The specified entity already exists.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableRadius
func (c *DirectoryService) EnableRadius(input *EnableRadiusInput) (*EnableRadiusOutput, error) {
	req, out := c.EnableRadiusRequest(input)
	return out, req.Send()
}

// EnableRadiusWithContext is the same as EnableRadius with the addition of
// the ability to pass a context and additional request options.
//
// See EnableRadius for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) EnableRadiusWithContext(ctx aws.Context, input *EnableRadiusInput, opts ...request.Option) (*EnableRadiusOutput, error) {
	req, out := c.EnableRadiusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opEnableSso = "EnableSso"

// EnableSsoRequest generates a "aws/request.Request" representing the
// client's request for the EnableSso operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See EnableSso for more information on using the EnableSso
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the EnableSsoRequest method.
//    req, resp := client.EnableSsoRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableSso
func (c *DirectoryService) EnableSsoRequest(input *EnableSsoInput) (req *request.Request, output *EnableSsoOutput) {
	op := &request.Operation{
		Name:       opEnableSso,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableSsoInput{}
	}

	output = &EnableSsoOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableSso API operation for AWS Directory Service.
//
// Enables single sign-on for a directory. Single sign-on allows users in your
// directory to access certain AWS services from a computer joined to the directory
// without having to enter their credentials separately.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation EnableSso for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InsufficientPermissionsException
//   The account does not have sufficient permission to perform the operation.
//
//   * AuthenticationFailedException
//   An authentication error occurred.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableSso
func (c *DirectoryService) EnableSso(input *EnableSsoInput) (*EnableSsoOutput, error) {
	req, out := c.EnableSsoRequest(input)
	return out, req.Send()
}

// EnableSsoWithContext is the same as EnableSso with the addition of
// the ability to pass a context and additional request options.
//
// See EnableSso for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) EnableSsoWithContext(ctx aws.Context, input *EnableSsoInput, opts ...request.Option) (*EnableSsoOutput, error) {
	req, out := c.EnableSsoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDirectoryLimits = "GetDirectoryLimits"

// GetDirectoryLimitsRequest generates a "aws/request.Request" representing the
// client's request for the GetDirectoryLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDirectoryLimits for more information on using the GetDirectoryLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDirectoryLimitsRequest method.
//    req, resp := client.GetDirectoryLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetDirectoryLimits
func (c *DirectoryService) GetDirectoryLimitsRequest(input *GetDirectoryLimitsInput) (req *request.Request, output *GetDirectoryLimitsOutput) {
	op := &request.Operation{
		Name:       opGetDirectoryLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDirectoryLimitsInput{}
	}

	output = &GetDirectoryLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDirectoryLimits API operation for AWS Directory Service.
//
// Obtains directory limit information for the current Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation GetDirectoryLimits for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetDirectoryLimits
func (c *DirectoryService) GetDirectoryLimits(input *GetDirectoryLimitsInput) (*GetDirectoryLimitsOutput, error) {
	req, out := c.GetDirectoryLimitsRequest(input)
	return out, req.Send()
}

// GetDirectoryLimitsWithContext is the same as GetDirectoryLimits with the addition of
// the ability to pass a context and additional request options.
//
// See GetDirectoryLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) GetDirectoryLimitsWithContext(ctx aws.Context, input *GetDirectoryLimitsInput, opts ...request.Option) (*GetDirectoryLimitsOutput, error) {
	req, out := c.GetDirectoryLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSnapshotLimits = "GetSnapshotLimits"

// GetSnapshotLimitsRequest generates a "aws/request.Request" representing the
// client's request for the GetSnapshotLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSnapshotLimits for more information on using the GetSnapshotLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSnapshotLimitsRequest method.
//    req, resp := client.GetSnapshotLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetSnapshotLimits
func (c *DirectoryService) GetSnapshotLimitsRequest(input *GetSnapshotLimitsInput) (req *request.Request, output *GetSnapshotLimitsOutput) {
	op := &request.Operation{
		Name:       opGetSnapshotLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSnapshotLimitsInput{}
	}

	output = &GetSnapshotLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSnapshotLimits API operation for AWS Directory Service.
//
// Obtains the manual snapshot limits for a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation GetSnapshotLimits for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetSnapshotLimits
func (c *DirectoryService) GetSnapshotLimits(input *GetSnapshotLimitsInput) (*GetSnapshotLimitsOutput, error) {
	req, out := c.GetSnapshotLimitsRequest(input)
	return out, req.Send()
}

// GetSnapshotLimitsWithContext is the same as GetSnapshotLimits with the addition of
// the ability to pass a context and additional request options.
//
// See GetSnapshotLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) GetSnapshotLimitsWithContext(ctx aws.Context, input *GetSnapshotLimitsInput, opts ...request.Option) (*GetSnapshotLimitsOutput, error) {
	req, out := c.GetSnapshotLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCertificates = "ListCertificates"

// ListCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCertificates for more information on using the ListCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCertificatesRequest method.
//    req, resp := client.ListCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates
func (c *DirectoryService) ListCertificatesRequest(input *ListCertificatesInput) (req *request.Request, output *ListCertificatesOutput) {
	op := &request.Operation{
		Name:       opListCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCertificatesInput{}
	}

	output = &ListCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCertificates API operation for AWS Directory Service.
//
// For the specified directory, lists all the certificates registered for a
// secured LDAP connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ListCertificates for usage and error information.
//
// Returned Error Types:
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates
func (c *DirectoryService) ListCertificates(input *ListCertificatesInput) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	return out, req.Send()
}

// ListCertificatesWithContext is the same as ListCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See ListCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) ListCertificatesWithContext(ctx aws.Context, input *ListCertificatesInput, opts ...request.Option) (*ListCertificatesOutput, error) {
	req, out := c.ListCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIpRoutes = "ListIpRoutes"

// ListIpRoutesRequest generates a "aws/request.Request" representing the
// client's request for the ListIpRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIpRoutes for more information on using the ListIpRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIpRoutesRequest method.
//    req, resp := client.ListIpRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes
func (c *DirectoryService) ListIpRoutesRequest(input *ListIpRoutesInput) (req *request.Request, output *ListIpRoutesOutput) {
	op := &request.Operation{
		Name:       opListIpRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIpRoutesInput{}
	}

	output = &ListIpRoutesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIpRoutes API operation for AWS Directory Service.
//
// Lists the address blocks that you have added to a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ListIpRoutes for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes
func (c *DirectoryService) ListIpRoutes(input *ListIpRoutesInput) (*ListIpRoutesOutput, error) {
	req, out := c.ListIpRoutesRequest(input)
	return out, req.Send()
}

// ListIpRoutesWithContext is the same as ListIpRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See ListIpRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) ListIpRoutesWithContext(ctx aws.Context, input *ListIpRoutesInput, opts ...request.Option) (*ListIpRoutesOutput, error) {
	req, out := c.ListIpRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLogSubscriptions = "ListLogSubscriptions"

// ListLogSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLogSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLogSubscriptions for more information on using the ListLogSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLogSubscriptionsRequest method.
//    req, resp := client.ListLogSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions
func (c *DirectoryService) ListLogSubscriptionsRequest(input *ListLogSubscriptionsInput) (req *request.Request, output *ListLogSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListLogSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLogSubscriptionsInput{}
	}

	output = &ListLogSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLogSubscriptions API operation for AWS Directory Service.
//
// Lists the active log subscriptions for the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ListLogSubscriptions for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions
func (c *DirectoryService) ListLogSubscriptions(input *ListLogSubscriptionsInput) (*ListLogSubscriptionsOutput, error) {
	req, out := c.ListLogSubscriptionsRequest(input)
	return out, req.Send()
}

// ListLogSubscriptionsWithContext is the same as ListLogSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLogSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) ListLogSubscriptionsWithContext(ctx aws.Context, input *ListLogSubscriptionsInput, opts ...request.Option) (*ListLogSubscriptionsOutput, error) {
	req, out := c.ListLogSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSchemaExtensions = "ListSchemaExtensions"

// ListSchemaExtensionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSchemaExtensions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSchemaExtensions for more information on using the ListSchemaExtensions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSchemaExtensionsRequest method.
//    req, resp := client.ListSchemaExtensionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions
func (c *DirectoryService) ListSchemaExtensionsRequest(input *ListSchemaExtensionsInput) (req *request.Request, output *ListSchemaExtensionsOutput) {
	op := &request.Operation{
		Name:       opListSchemaExtensions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSchemaExtensionsInput{}
	}

	output = &ListSchemaExtensionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSchemaExtensions API operation for AWS Directory Service.
//
// Lists all schema extensions applied to a Microsoft AD Directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ListSchemaExtensions for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions
func (c *DirectoryService) ListSchemaExtensions(input *ListSchemaExtensionsInput) (*ListSchemaExtensionsOutput, error) {
	req, out := c.ListSchemaExtensionsRequest(input)
	return out, req.Send()
}

// ListSchemaExtensionsWithContext is the same as ListSchemaExtensions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSchemaExtensions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) ListSchemaExtensionsWithContext(ctx aws.Context, input *ListSchemaExtensionsInput, opts ...request.Option) (*ListSchemaExtensionsOutput, error) {
	req, out := c.ListSchemaExtensionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListTagsForResource
func (c *DirectoryService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Directory Service.
//
// Lists all tags on a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidNextTokenException
//   The NextToken value is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListTagsForResource
func (c *DirectoryService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterCertificate = "RegisterCertificate"

// RegisterCertificateRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCertificate for more information on using the RegisterCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterCertificateRequest method.
//    req, resp := client.RegisterCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterCertificate
func (c *DirectoryService) RegisterCertificateRequest(input *RegisterCertificateInput) (req *request.Request, output *RegisterCertificateOutput) {
	op := &request.Operation{
		Name:       opRegisterCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterCertificateInput{}
	}

	output = &RegisterCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCertificate API operation for AWS Directory Service.
//
// Registers a certificate for secured LDAP connection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RegisterCertificate for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * InvalidCertificateException
//   The certificate PEM that was provided has incorrect encoding.
//
//   * CertificateLimitExceededException
//   The certificate could not be added because the certificate limit has been
//   reached.
//
//   * CertificateAlreadyExistsException
//   The certificate has already been registered into the system.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterCertificate
func (c *DirectoryService) RegisterCertificate(input *RegisterCertificateInput) (*RegisterCertificateOutput, error) {
	req, out := c.RegisterCertificateRequest(input)
	return out, req.Send()
}

// RegisterCertificateWithContext is the same as RegisterCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) RegisterCertificateWithContext(ctx aws.Context, input *RegisterCertificateInput, opts ...request.Option) (*RegisterCertificateOutput, error) {
	req, out := c.RegisterCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterEventTopic = "RegisterEventTopic"

// RegisterEventTopicRequest generates a "aws/request.Request" representing the
// client's request for the RegisterEventTopic operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterEventTopic for more information on using the RegisterEventTopic
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterEventTopicRequest method.
//    req, resp := client.RegisterEventTopicRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterEventTopic
func (c *DirectoryService) RegisterEventTopicRequest(input *RegisterEventTopicInput) (req *request.Request, output *RegisterEventTopicOutput) {
	op := &request.Operation{
		Name:       opRegisterEventTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterEventTopicInput{}
	}

	output = &RegisterEventTopicOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterEventTopic API operation for AWS Directory Service.
//
// Associates a directory with an SNS topic. This establishes the directory
// as a publisher to the specified SNS topic. You can then receive email or
// text (SMS) messages when the status of your directory changes. You get notified
// if your directory goes from an Active status to an Impaired or Inoperable
// status. You also receive a notification when the directory returns to an
// Active status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RegisterEventTopic for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterEventTopic
func (c *DirectoryService) RegisterEventTopic(input *RegisterEventTopicInput) (*RegisterEventTopicOutput, error) {
	req, out := c.RegisterEventTopicRequest(input)
	return out, req.Send()
}

// RegisterEventTopicWithContext is the same as RegisterEventTopic with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterEventTopic for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) RegisterEventTopicWithContext(ctx aws.Context, input *RegisterEventTopicInput, opts ...request.Option) (*RegisterEventTopicOutput, error) {
	req, out := c.RegisterEventTopicRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectSharedDirectory = "RejectSharedDirectory"

// RejectSharedDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the RejectSharedDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectSharedDirectory for more information on using the RejectSharedDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RejectSharedDirectoryRequest method.
//    req, resp := client.RejectSharedDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RejectSharedDirectory
func (c *DirectoryService) RejectSharedDirectoryRequest(input *RejectSharedDirectoryInput) (req *request.Request, output *RejectSharedDirectoryOutput) {
	op := &request.Operation{
		Name:       opRejectSharedDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectSharedDirectoryInput{}
	}

	output = &RejectSharedDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectSharedDirectory API operation for AWS Directory Service.
//
// Rejects a directory sharing request that was sent from the directory owner
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RejectSharedDirectory for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryAlreadySharedException
//   The specified directory has already been shared with this AWS account.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RejectSharedDirectory
func (c *DirectoryService) RejectSharedDirectory(input *RejectSharedDirectoryInput) (*RejectSharedDirectoryOutput, error) {
	req, out := c.RejectSharedDirectoryRequest(input)
	return out, req.Send()
}

// RejectSharedDirectoryWithContext is the same as RejectSharedDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See RejectSharedDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) RejectSharedDirectoryWithContext(ctx aws.Context, input *RejectSharedDirectoryInput, opts ...request.Option) (*RejectSharedDirectoryOutput, error) {
	req, out := c.RejectSharedDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveIpRoutes = "RemoveIpRoutes"

// RemoveIpRoutesRequest generates a "aws/request.Request" representing the
// client's request for the RemoveIpRoutes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveIpRoutes for more information on using the RemoveIpRoutes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveIpRoutesRequest method.
//    req, resp := client.RemoveIpRoutesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveIpRoutes
func (c *DirectoryService) RemoveIpRoutesRequest(input *RemoveIpRoutesInput) (req *request.Request, output *RemoveIpRoutesOutput) {
	op := &request.Operation{
		Name:       opRemoveIpRoutes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveIpRoutesInput{}
	}

	output = &RemoveIpRoutesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveIpRoutes API operation for AWS Directory Service.
//
// Removes IP address blocks from a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RemoveIpRoutes for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveIpRoutes
func (c *DirectoryService) RemoveIpRoutes(input *RemoveIpRoutesInput) (*RemoveIpRoutesOutput, error) {
	req, out := c.RemoveIpRoutesRequest(input)
	return out, req.Send()
}

// RemoveIpRoutesWithContext is the same as RemoveIpRoutes with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveIpRoutes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) RemoveIpRoutesWithContext(ctx aws.Context, input *RemoveIpRoutesInput, opts ...request.Option) (*RemoveIpRoutesOutput, error) {
	req, out := c.RemoveIpRoutesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveRegion = "RemoveRegion"

// RemoveRegionRequest generates a "aws/request.Request" representing the
// client's request for the RemoveRegion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveRegion for more information on using the RemoveRegion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveRegionRequest method.
//    req, resp := client.RemoveRegionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveRegion
func (c *DirectoryService) RemoveRegionRequest(input *RemoveRegionInput) (req *request.Request, output *RemoveRegionOutput) {
	op := &request.Operation{
		Name:       opRemoveRegion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRegionInput{}
	}

	output = &RemoveRegionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveRegion API operation for AWS Directory Service.
//
// Stops all replication and removes the domain controllers from the specified
// Region. You cannot remove the primary Region with this operation. Instead,
// use the DeleteDirectory API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RemoveRegion for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * DirectoryDoesNotExistException
//   The specified directory does not exist in the system.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveRegion
func (c *DirectoryService) RemoveRegion(input *RemoveRegionInput) (*RemoveRegionOutput, error) {
	req, out := c.RemoveRegionRequest(input)
	return out, req.Send()
}

// RemoveRegionWithContext is the same as RemoveRegion with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveRegion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) RemoveRegionWithContext(ctx aws.Context, input *RemoveRegionInput, opts ...request.Option) (*RemoveRegionOutput, error) {
	req, out := c.RemoveRegionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveTagsFromResource
func (c *DirectoryService) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for AWS Directory Service.
//
// Removes tags from a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveTagsFromResource
func (c *DirectoryService) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetUserPassword = "ResetUserPassword"

// ResetUserPasswordRequest generates a "aws/request.Request" representing the
// client's request for the ResetUserPassword operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetUserPassword for more information on using the ResetUserPassword
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetUserPasswordRequest method.
//    req, resp := client.ResetUserPasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ResetUserPassword
func (c *DirectoryService) ResetUserPasswordRequest(input *ResetUserPasswordInput) (req *request.Request, output *ResetUserPasswordOutput) {
	op := &request.Operation{
		Name:       opResetUserPassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetUserPasswordInput{}
	}

	output = &ResetUserPasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResetUserPassword API operation for AWS Directory Service.
//
// Resets the password for any user in your AWS Managed Microsoft AD or Simple
// AD directory.
//
// You can reset the password for any user in your directory with the following
// exceptions:
//
//    * For Simple AD, you cannot reset the password for any user that is a
//    member of either the Domain Admins or Enterprise Admins group except for
//    the administrator user.
//
//    * For AWS Managed Microsoft AD, you can only reset the password for a
//    user that is in an OU based off of the NetBIOS name that you typed when
//    you created your directory. For example, you cannot reset the password
//    for a user in the AWS Reserved OU. For more information about the OU structure
//    for an AWS Managed Microsoft AD directory, see What Gets Created (https://docs.aws.amazon.com/directoryservice/latest/admin-guide/ms_ad_getting_started_what_gets_created.html)
//    in the AWS Directory Service Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ResetUserPassword for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * UserDoesNotExistException
//   The user provided a username that does not exist in your directory.
//
//   * InvalidPasswordException
//   The new password provided by the user does not meet the password complexity
//   requirements defined in your directory.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ResetUserPassword
func (c *DirectoryService) ResetUserPassword(input *ResetUserPasswordInput) (*ResetUserPasswordOutput, error) {
	req, out := c.ResetUserPasswordRequest(input)
	return out, req.Send()
}

// ResetUserPasswordWithContext is the same as ResetUserPassword with the addition of
// the ability to pass a context and additional request options.
//
// See ResetUserPassword for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) ResetUserPasswordWithContext(ctx aws.Context, input *ResetUserPasswordInput, opts ...request.Option) (*ResetUserPasswordOutput, error) {
	req, out := c.ResetUserPasswordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreFromSnapshot = "RestoreFromSnapshot"

// RestoreFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreFromSnapshot for more information on using the RestoreFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreFromSnapshotRequest method.
//    req, resp := client.RestoreFromSnapshotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RestoreFromSnapshot
func (c *DirectoryService) RestoreFromSnapshotRequest(input *RestoreFromSnapshotInput) (req *request.Request, output *RestoreFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromSnapshotInput{}
	}

	output = &RestoreFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestoreFromSnapshot API operation for AWS Directory Service.
//
// Restores a directory using an existing directory snapshot.
//
// When you restore a directory from a snapshot, any changes made to the directory
// after the snapshot date are overwritten.
//
// This action returns as soon as the restore operation is initiated. You can
// monitor the progress of the restore operation by calling the DescribeDirectories
// operation with the directory identifier. When the DirectoryDescription.Stage
// value changes to Active, the restore operation is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation RestoreFromSnapshot for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RestoreFromSnapshot
func (c *DirectoryService) RestoreFromSnapshot(input *RestoreFromSnapshotInput) (*RestoreFromSnapshotOutput, error) {
	req, out := c.RestoreFromSnapshotRequest(input)
	return out, req.Send()
}

// RestoreFromSnapshotWithContext is the same as RestoreFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) RestoreFromSnapshotWithContext(ctx aws.Context, input *RestoreFromSnapshotInput, opts ...request.Option) (*RestoreFromSnapshotOutput, error) {
	req, out := c.RestoreFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opShareDirectory = "ShareDirectory"

// ShareDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the ShareDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ShareDirectory for more information on using the ShareDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ShareDirectoryRequest method.
//    req, resp := client.ShareDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ShareDirectory
func (c *DirectoryService) ShareDirectoryRequest(input *ShareDirectoryInput) (req *request.Request, output *ShareDirectoryOutput) {
	op := &request.Operation{
		Name:       opShareDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ShareDirectoryInput{}
	}

	output = &ShareDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ShareDirectory API operation for AWS Directory Service.
//
// Shares a specified directory (DirectoryId) in your AWS account (directory
// owner) with another AWS account (directory consumer). With this operation
// you can use your directory from any AWS account and from any Amazon VPC within
// an AWS Region.
//
// When you share your AWS Managed Microsoft AD directory, AWS Directory Service
// creates a shared directory in the directory consumer account. This shared
// directory contains the metadata to provide access to the directory within
// the directory owner account. The shared directory is visible in all VPCs
// in the directory consumer account.
//
// The ShareMethod parameter determines whether the specified directory can
// be shared between AWS accounts inside the same AWS organization (ORGANIZATIONS).
// It also determines whether you can share the directory with any other AWS
// account either inside or outside of the organization (HANDSHAKE).
//
// The ShareNotes parameter is only used when HANDSHAKE is called, which sends
// a directory sharing request to the directory consumer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation ShareDirectory for usage and error information.
//
// Returned Error Types:
//   * DirectoryAlreadySharedException
//   The specified directory has already been shared with this AWS account.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidTargetException
//   The specified shared target is not valid.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ShareLimitExceededException
//   The maximum number of AWS accounts that you can share with this directory
//   has been reached.
//
//   * OrganizationsException
//   Exception encountered while trying to access your AWS organization.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ShareDirectory
func (c *DirectoryService) ShareDirectory(input *ShareDirectoryInput) (*ShareDirectoryOutput, error) {
	req, out := c.ShareDirectoryRequest(input)
	return out, req.Send()
}

// ShareDirectoryWithContext is the same as ShareDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See ShareDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) ShareDirectoryWithContext(ctx aws.Context, input *ShareDirectoryInput, opts ...request.Option) (*ShareDirectoryOutput, error) {
	req, out := c.ShareDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSchemaExtension = "StartSchemaExtension"

// StartSchemaExtensionRequest generates a "aws/request.Request" representing the
// client's request for the StartSchemaExtension operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSchemaExtension for more information on using the StartSchemaExtension
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSchemaExtensionRequest method.
//    req, resp := client.StartSchemaExtensionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/StartSchemaExtension
func (c *DirectoryService) StartSchemaExtensionRequest(input *StartSchemaExtensionInput) (req *request.Request, output *StartSchemaExtensionOutput) {
	op := &request.Operation{
		Name:       opStartSchemaExtension,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSchemaExtensionInput{}
	}

	output = &StartSchemaExtensionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSchemaExtension API operation for AWS Directory Service.
//
// Applies a schema extension to a Microsoft AD directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation StartSchemaExtension for usage and error information.
//
// Returned Error Types:
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * SnapshotLimitExceededException
//   The maximum number of manual snapshots for the directory has been reached.
//   You can use the GetSnapshotLimits operation to determine the snapshot limits
//   for a directory.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/StartSchemaExtension
func (c *DirectoryService) StartSchemaExtension(input *StartSchemaExtensionInput) (*StartSchemaExtensionOutput, error) {
	req, out := c.StartSchemaExtensionRequest(input)
	return out, req.Send()
}

// StartSchemaExtensionWithContext is the same as StartSchemaExtension with the addition of
// the ability to pass a context and additional request options.
//
// See StartSchemaExtension for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) StartSchemaExtensionWithContext(ctx aws.Context, input *StartSchemaExtensionInput, opts ...request.Option) (*StartSchemaExtensionOutput, error) {
	req, out := c.StartSchemaExtensionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnshareDirectory = "UnshareDirectory"

// UnshareDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the UnshareDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnshareDirectory for more information on using the UnshareDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnshareDirectoryRequest method.
//    req, resp := client.UnshareDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UnshareDirectory
func (c *DirectoryService) UnshareDirectoryRequest(input *UnshareDirectoryInput) (req *request.Request, output *UnshareDirectoryOutput) {
	op := &request.Operation{
		Name:       opUnshareDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnshareDirectoryInput{}
	}

	output = &UnshareDirectoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UnshareDirectory API operation for AWS Directory Service.
//
// Stops the directory sharing between the directory owner and consumer accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation UnshareDirectory for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidTargetException
//   The specified shared target is not valid.
//
//   * DirectoryNotSharedException
//   The specified directory has not been shared with this AWS account.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UnshareDirectory
func (c *DirectoryService) UnshareDirectory(input *UnshareDirectoryInput) (*UnshareDirectoryOutput, error) {
	req, out := c.UnshareDirectoryRequest(input)
	return out, req.Send()
}

// UnshareDirectoryWithContext is the same as UnshareDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See UnshareDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) UnshareDirectoryWithContext(ctx aws.Context, input *UnshareDirectoryInput, opts ...request.Option) (*UnshareDirectoryOutput, error) {
	req, out := c.UnshareDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConditionalForwarder = "UpdateConditionalForwarder"

// UpdateConditionalForwarderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConditionalForwarder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConditionalForwarder for more information on using the UpdateConditionalForwarder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConditionalForwarderRequest method.
//    req, resp := client.UpdateConditionalForwarderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateConditionalForwarder
func (c *DirectoryService) UpdateConditionalForwarderRequest(input *UpdateConditionalForwarderInput) (req *request.Request, output *UpdateConditionalForwarderOutput) {
	op := &request.Operation{
		Name:       opUpdateConditionalForwarder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConditionalForwarderInput{}
	}

	output = &UpdateConditionalForwarderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConditionalForwarder API operation for AWS Directory Service.
//
// Updates a conditional forwarder that has been set up for your AWS directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation UpdateConditionalForwarder for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateConditionalForwarder
func (c *DirectoryService) UpdateConditionalForwarder(input *UpdateConditionalForwarderInput) (*UpdateConditionalForwarderOutput, error) {
	req, out := c.UpdateConditionalForwarderRequest(input)
	return out, req.Send()
}

// UpdateConditionalForwarderWithContext is the same as UpdateConditionalForwarder with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConditionalForwarder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) UpdateConditionalForwarderWithContext(ctx aws.Context, input *UpdateConditionalForwarderInput, opts ...request.Option) (*UpdateConditionalForwarderOutput, error) {
	req, out := c.UpdateConditionalForwarderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNumberOfDomainControllers = "UpdateNumberOfDomainControllers"

// UpdateNumberOfDomainControllersRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNumberOfDomainControllers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNumberOfDomainControllers for more information on using the UpdateNumberOfDomainControllers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNumberOfDomainControllersRequest method.
//    req, resp := client.UpdateNumberOfDomainControllersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateNumberOfDomainControllers
func (c *DirectoryService) UpdateNumberOfDomainControllersRequest(input *UpdateNumberOfDomainControllersInput) (req *request.Request, output *UpdateNumberOfDomainControllersOutput) {
	op := &request.Operation{
		Name:       opUpdateNumberOfDomainControllers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNumberOfDomainControllersInput{}
	}

	output = &UpdateNumberOfDomainControllersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateNumberOfDomainControllers API operation for AWS Directory Service.
//
// Adds or removes domain controllers to or from the directory. Based on the
// difference between current value and new value (provided through this API
// call), domain controllers will be added or removed. It may take up to 45
// minutes for any new domain controllers to become fully active once the requested
// number of domain controllers is updated. During this time, you cannot make
// another update request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation UpdateNumberOfDomainControllers for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * DirectoryUnavailableException
//   The specified directory is unavailable or could not be found.
//
//   * DomainControllerLimitExceededException
//   The maximum allowed number of domain controllers per directory was exceeded.
//   The default limit per directory is 20 domain controllers.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateNumberOfDomainControllers
func (c *DirectoryService) UpdateNumberOfDomainControllers(input *UpdateNumberOfDomainControllersInput) (*UpdateNumberOfDomainControllersOutput, error) {
	req, out := c.UpdateNumberOfDomainControllersRequest(input)
	return out, req.Send()
}

// UpdateNumberOfDomainControllersWithContext is the same as UpdateNumberOfDomainControllers with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNumberOfDomainControllers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) UpdateNumberOfDomainControllersWithContext(ctx aws.Context, input *UpdateNumberOfDomainControllersInput, opts ...request.Option) (*UpdateNumberOfDomainControllersOutput, error) {
	req, out := c.UpdateNumberOfDomainControllersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRadius = "UpdateRadius"

// UpdateRadiusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRadius operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRadius for more information on using the UpdateRadius
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRadiusRequest method.
//    req, resp := client.UpdateRadiusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateRadius
func (c *DirectoryService) UpdateRadiusRequest(input *UpdateRadiusInput) (req *request.Request, output *UpdateRadiusOutput) {
	op := &request.Operation{
		Name:       opUpdateRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRadiusInput{}
	}

	output = &UpdateRadiusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRadius API operation for AWS Directory Service.
//
// Updates the Remote Authentication Dial In User Service (RADIUS) server information
// for an AD Connector or Microsoft AD directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation UpdateRadius for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateRadius
func (c *DirectoryService) UpdateRadius(input *UpdateRadiusInput) (*UpdateRadiusOutput, error) {
	req, out := c.UpdateRadiusRequest(input)
	return out, req.Send()
}

// UpdateRadiusWithContext is the same as UpdateRadius with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRadius for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) UpdateRadiusWithContext(ctx aws.Context, input *UpdateRadiusInput, opts ...request.Option) (*UpdateRadiusOutput, error) {
	req, out := c.UpdateRadiusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrust = "UpdateTrust"

// UpdateTrustRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrust operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrust for more information on using the UpdateTrust
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrustRequest method.
//    req, resp := client.UpdateTrustRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateTrust
func (c *DirectoryService) UpdateTrustRequest(input *UpdateTrustInput) (req *request.Request, output *UpdateTrustOutput) {
	op := &request.Operation{
		Name:       opUpdateTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrustInput{}
	}

	output = &UpdateTrustOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrust API operation for AWS Directory Service.
//
// Updates the trust that has been set up between your AWS Managed Microsoft
// AD directory and an on-premises Active Directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation UpdateTrust for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateTrust
func (c *DirectoryService) UpdateTrust(input *UpdateTrustInput) (*UpdateTrustOutput, error) {
	req, out := c.UpdateTrustRequest(input)
	return out, req.Send()
}

// UpdateTrustWithContext is the same as UpdateTrust with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrust for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) UpdateTrustWithContext(ctx aws.Context, input *UpdateTrustInput, opts ...request.Option) (*UpdateTrustOutput, error) {
	req, out := c.UpdateTrustRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opVerifyTrust = "VerifyTrust"

// VerifyTrustRequest generates a "aws/request.Request" representing the
// client's request for the VerifyTrust operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See VerifyTrust for more information on using the VerifyTrust
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the VerifyTrustRequest method.
//    req, resp := client.VerifyTrustRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/VerifyTrust
func (c *DirectoryService) VerifyTrustRequest(input *VerifyTrustInput) (req *request.Request, output *VerifyTrustOutput) {
	op := &request.Operation{
		Name:       opVerifyTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyTrustInput{}
	}

	output = &VerifyTrustOutput{}
	req = c.newRequest(op, input, output)
	return
}

// VerifyTrust API operation for AWS Directory Service.
//
// AWS Directory Service for Microsoft Active Directory allows you to configure
// and verify trust relationships.
//
// This action verifies a trust relationship between your AWS Managed Microsoft
// AD directory and an external domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Directory Service's
// API operation VerifyTrust for usage and error information.
//
// Returned Error Types:
//   * EntityDoesNotExistException
//   The specified entity could not be found.
//
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * ClientException
//   A client exception has occurred.
//
//   * ServiceException
//   An exception has occurred in AWS Directory Service.
//
//   * UnsupportedOperationException
//   The operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/VerifyTrust
func (c *DirectoryService) VerifyTrust(input *VerifyTrustInput) (*VerifyTrustOutput, error) {
	req, out := c.VerifyTrustRequest(input)
	return out, req.Send()
}

// VerifyTrustWithContext is the same as VerifyTrust with the addition of
// the ability to pass a context and additional request options.
//
// See VerifyTrust for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DirectoryService) VerifyTrustWithContext(ctx aws.Context, input *VerifyTrustInput, opts ...request.Option) (*VerifyTrustOutput, error) {
	req, out := c.VerifyTrustRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptSharedDirectoryInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the shared directory in the directory consumer account. This
	// identifier is different for each directory owner account.
	//
	// SharedDirectoryId is a required field
	SharedDirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AcceptSharedDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptSharedDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptSharedDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptSharedDirectoryInput"}
	if s.SharedDirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedDirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSharedDirectoryId sets the SharedDirectoryId field's value.
func (s *AcceptSharedDirectoryInput) SetSharedDirectoryId(v string) *AcceptSharedDirectoryInput {
	s.SharedDirectoryId = &v
	return s
}

type AcceptSharedDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The shared directory in the directory consumer account.
	SharedDirectory *SharedDirectory `type:"structure"`
}

// String returns the string representation
func (s AcceptSharedDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcceptSharedDirectoryOutput) GoString() string {
	return s.String()
}

// SetSharedDirectory sets the SharedDirectory field's value.
func (s *AcceptSharedDirectoryOutput) SetSharedDirectory(v *SharedDirectory) *AcceptSharedDirectoryOutput {
	s.SharedDirectory = v
	return s
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddIpRoutesInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory to which to add the address block.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// IP address blocks, using CIDR format, of the traffic to route. This is often
	// the IP address block of the DNS server used for your on-premises domain.
	//
	// IpRoutes is a required field
	IpRoutes []*IpRoute `type:"list" required:"true"`

	// If set to true, updates the inbound and outbound rules of the security group
	// that has the description: "AWS created security group for directory ID directory
	// controllers." Following are the new rules:
	//
	// Inbound:
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
	//
	//    * Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0
	//
	//    * Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0
	//
	//    * Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
	//
	//    * Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
	//
	//    * Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
	//
	//    * Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
	//
	// Outbound:
	//
	//    * Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
	//
	// These security rules impact an internal network interface that is not exposed
	// publicly.
	UpdateSecurityGroupForDirectoryControllers *bool `type:"boolean"`
}

// String returns the string representation
func (s AddIpRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddIpRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddIpRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddIpRoutesInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.IpRoutes == nil {
		invalidParams.Add(request.NewErrParamRequired("IpRoutes"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *AddIpRoutesInput) SetDirectoryId(v string) *AddIpRoutesInput {
	s.DirectoryId = &v
	return s
}

// SetIpRoutes sets the IpRoutes field's value.
func (s *AddIpRoutesInput) SetIpRoutes(v []*IpRoute) *AddIpRoutesInput {
	s.IpRoutes = v
	return s
}

// SetUpdateSecurityGroupForDirectoryControllers sets the UpdateSecurityGroupForDirectoryControllers field's value.
func (s *AddIpRoutesInput) SetUpdateSecurityGroupForDirectoryControllers(v bool) *AddIpRoutesInput {
	s.UpdateSecurityGroupForDirectoryControllers = &v
	return s
}

type AddIpRoutesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddIpRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddIpRoutesOutput) GoString() string {
	return s.String()
}

type AddRegionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory to which you want to add Region replication.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The name of the Region where you want to add domain controllers for replication.
	// For example, us-east-1.
	//
	// RegionName is a required field
	RegionName *string `min:"8" type:"string" required:"true"`

	// Contains VPC information for the CreateDirectory or CreateMicrosoftAD operation.
	//
	// VPCSettings is a required field
	VPCSettings *DirectoryVpcSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s AddRegionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRegionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddRegionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddRegionInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RegionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RegionName"))
	}
	if s.RegionName != nil && len(*s.RegionName) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("RegionName", 8))
	}
	if s.VPCSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCSettings"))
	}
	if s.VPCSettings != nil {
		if err := s.VPCSettings.Validate(); err != nil {
			invalidParams.AddNested("VPCSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *AddRegionInput) SetDirectoryId(v string) *AddRegionInput {
	s.DirectoryId = &v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *AddRegionInput) SetRegionName(v string) *AddRegionInput {
	s.RegionName = &v
	return s
}

// SetVPCSettings sets the VPCSettings field's value.
func (s *AddRegionInput) SetVPCSettings(v *DirectoryVpcSettings) *AddRegionInput {
	s.VPCSettings = v
	return s
}

type AddRegionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddRegionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRegionOutput) GoString() string {
	return s.String()
}

type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) for the directory to which to add the tag.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The tags to be assigned to the directory.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AddTagsToResourceInput) SetResourceId(v string) *AddTagsToResourceInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

// Represents a named directory attribute.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	Name *string `min:"1" type:"string"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attribute"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Attribute) SetName(v string) *Attribute {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Attribute) SetValue(v string) *Attribute {
	s.Value = &v
	return s
}

// An authentication error occurred.
type AuthenticationFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The textual message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The identifier of the request that caused the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s AuthenticationFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthenticationFailedException) GoString() string {
	return s.String()
}

func newErrorAuthenticationFailedException(v protocol.ResponseMetadata) error {
	return &AuthenticationFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AuthenticationFailedException) Code() string {
	return "AuthenticationFailedException"
}

// Message returns the exception's message.
func (s *AuthenticationFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AuthenticationFailedException) OrigErr() error {
	return nil
}

func (s *AuthenticationFailedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AuthenticationFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AuthenticationFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CancelSchemaExtensionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory whose schema extension will be canceled.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The identifier of the schema extension that will be canceled.
	//
	// SchemaExtensionId is a required field
	SchemaExtensionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSchemaExtensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSchemaExtensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSchemaExtensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSchemaExtensionInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.SchemaExtensionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaExtensionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CancelSchemaExtensionInput) SetDirectoryId(v string) *CancelSchemaExtensionInput {
	s.DirectoryId = &v
	return s
}

// SetSchemaExtensionId sets the SchemaExtensionId field's value.
func (s *CancelSchemaExtensionInput) SetSchemaExtensionId(v string) *CancelSchemaExtensionInput {
	s.SchemaExtensionId = &v
	return s
}

type CancelSchemaExtensionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelSchemaExtensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSchemaExtensionOutput) GoString() string {
	return s.String()
}

// Information about the certificate.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The identifier of the certificate.
	CertificateId *string `type:"string"`

	// Provides information about the client certificate authentication settings.
	// The default value is ClientLDAPS.
	ClientCertAuthSettings *ClientCertAuthSettings `type:"structure"`

	// The common name for the certificate.
	CommonName *string `type:"string"`

	// The date and time when the certificate will expire.
	ExpiryDateTime *time.Time `type:"timestamp"`

	// The date and time that the certificate was registered.
	RegisteredDateTime *time.Time `type:"timestamp"`

	// The state of the certificate.
	State *string `type:"string" enum:"CertificateState"`

	// Describes a state change for the certificate.
	StateReason *string `type:"string"`

	// Select ClientCertAuth for smart card integration.
	Type *string `type:"string" enum:"CertificateType"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateId sets the CertificateId field's value.
func (s *Certificate) SetCertificateId(v string) *Certificate {
	s.CertificateId = &v
	return s
}

// SetClientCertAuthSettings sets the ClientCertAuthSettings field's value.
func (s *Certificate) SetClientCertAuthSettings(v *ClientCertAuthSettings) *Certificate {
	s.ClientCertAuthSettings = v
	return s
}

// SetCommonName sets the CommonName field's value.
func (s *Certificate) SetCommonName(v string) *Certificate {
	s.CommonName = &v
	return s
}

// SetExpiryDateTime sets the ExpiryDateTime field's value.
func (s *Certificate) SetExpiryDateTime(v time.Time) *Certificate {
	s.ExpiryDateTime = &v
	return s
}

// SetRegisteredDateTime sets the RegisteredDateTime field's value.
func (s *Certificate) SetRegisteredDateTime(v time.Time) *Certificate {
	s.RegisteredDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *Certificate) SetState(v string) *Certificate {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *Certificate) SetStateReason(v string) *Certificate {
	s.StateReason = &v
	return s
}

// SetType sets the Type field's value.
func (s *Certificate) SetType(v string) *Certificate {
	s.Type = &v
	return s
}

// The certificate has already been registered into the system.
type CertificateAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CertificateAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorCertificateAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &CertificateAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CertificateAlreadyExistsException) Code() string {
	return "CertificateAlreadyExistsException"
}

// Message returns the exception's message.
func (s *CertificateAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CertificateAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *CertificateAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CertificateAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CertificateAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The certificate is not present in the system for describe or deregister activities.
type CertificateDoesNotExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CertificateDoesNotExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateDoesNotExistException) GoString() string {
	return s.String()
}

func newErrorCertificateDoesNotExistException(v protocol.ResponseMetadata) error {
	return &CertificateDoesNotExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CertificateDoesNotExistException) Code() string {
	return "CertificateDoesNotExistException"
}

// Message returns the exception's message.
func (s *CertificateDoesNotExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CertificateDoesNotExistException) OrigErr() error {
	return nil
}

func (s *CertificateDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CertificateDoesNotExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CertificateDoesNotExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The certificate is being used for the LDAP security connection and cannot
// be removed without disabling LDAP security.
type CertificateInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CertificateInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateInUseException) GoString() string {
	return s.String()
}

func newErrorCertificateInUseException(v protocol.ResponseMetadata) error {
	return &CertificateInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CertificateInUseException) Code() string {
	return "CertificateInUseException"
}

// Message returns the exception's message.
func (s *CertificateInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CertificateInUseException) OrigErr() error {
	return nil
}

func (s *CertificateInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CertificateInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CertificateInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains general information about a certificate.
type CertificateInfo struct {
	_ struct{} `type:"structure"`

	// The identifier of the certificate.
	CertificateId *string `type:"string"`

	// The common name for the certificate.
	CommonName *string `type:"string"`

	// The date and time when the certificate will expire.
	ExpiryDateTime *time.Time `type:"timestamp"`

	// The state of the certificate.
	State *string `type:"string" enum:"CertificateState"`

	// Displays the type of certificate.
	Type *string `type:"string" enum:"CertificateType"`
}

// String returns the string representation
func (s CertificateInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateInfo) GoString() string {
	return s.String()
}

// SetCertificateId sets the CertificateId field's value.
func (s *CertificateInfo) SetCertificateId(v string) *CertificateInfo {
	s.CertificateId = &v
	return s
}

// SetCommonName sets the CommonName field's value.
func (s *CertificateInfo) SetCommonName(v string) *CertificateInfo {
	s.CommonName = &v
	return s
}

// SetExpiryDateTime sets the ExpiryDateTime field's value.
func (s *CertificateInfo) SetExpiryDateTime(v time.Time) *CertificateInfo {
	s.ExpiryDateTime = &v
	return s
}

// SetState sets the State field's value.
func (s *CertificateInfo) SetState(v string) *CertificateInfo {
	s.State = &v
	return s
}

// SetType sets the Type field's value.
func (s *CertificateInfo) SetType(v string) *CertificateInfo {
	s.Type = &v
	return s
}

// The certificate could not be added because the certificate limit has been
// reached.
type CertificateLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CertificateLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateLimitExceededException) GoString() string {
	return s.String()
}

func newErrorCertificateLimitExceededException(v protocol.ResponseMetadata) error {
	return &CertificateLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CertificateLimitExceededException) Code() string {
	return "CertificateLimitExceededException"
}

// Message returns the exception's message.
func (s *CertificateLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CertificateLimitExceededException) OrigErr() error {
	return nil
}

func (s *CertificateLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CertificateLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CertificateLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the client certificate authentication settings,
// such as ClientLDAPS or ClientCertAuth.
type ClientCertAuthSettings struct {
	_ struct{} `type:"structure"`

	// Specifies the URL of the default OCSP server used to check for revocation
	// status.
	OCSPUrl *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ClientCertAuthSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientCertAuthSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClientCertAuthSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClientCertAuthSettings"}
	if s.OCSPUrl != nil && len(*s.OCSPUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OCSPUrl", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOCSPUrl sets the OCSPUrl field's value.
func (s *ClientCertAuthSettings) SetOCSPUrl(v string) *ClientCertAuthSettings {
	s.OCSPUrl = &v
	return s
}

// A client exception has occurred.
type ClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientException) GoString() string {
	return s.String()
}

func newErrorClientException(v protocol.ResponseMetadata) error {
	return &ClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientException) Code() string {
	return "ClientException"
}

// Message returns the exception's message.
func (s *ClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientException) OrigErr() error {
	return nil
}

func (s *ClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about a computer account in a directory.
type Computer struct {
	_ struct{} `type:"structure"`

	// An array of Attribute objects containing the LDAP attributes that belong
	// to the computer account.
	ComputerAttributes []*Attribute `type:"list"`

	// The identifier of the computer.
	ComputerId *string `min:"1" type:"string"`

	// The computer name.
	ComputerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Computer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Computer) GoString() string {
	return s.String()
}

// SetComputerAttributes sets the ComputerAttributes field's value.
func (s *Computer) SetComputerAttributes(v []*Attribute) *Computer {
	s.ComputerAttributes = v
	return s
}

// SetComputerId sets the ComputerId field's value.
func (s *Computer) SetComputerId(v string) *Computer {
	s.ComputerId = &v
	return s
}

// SetComputerName sets the ComputerName field's value.
func (s *Computer) SetComputerName(v string) *Computer {
	s.ComputerName = &v
	return s
}

// Points to a remote domain with which you are setting up a trust relationship.
// Conditional forwarders are required in order to set up a trust relationship
// with another domain.
type ConditionalForwarder struct {
	_ struct{} `type:"structure"`

	// The IP addresses of the remote DNS server associated with RemoteDomainName.
	// This is the IP address of the DNS server that your conditional forwarder
	// points to.
	DnsIpAddrs []*string `type:"list"`

	// The fully qualified domain name (FQDN) of the remote domains pointed to by
	// the conditional forwarder.
	RemoteDomainName *string `type:"string"`

	// The replication scope of the conditional forwarder. The only allowed value
	// is Domain, which will replicate the conditional forwarder to all of the domain
	// controllers for your AWS directory.
	ReplicationScope *string `type:"string" enum:"ReplicationScope"`
}

// String returns the string representation
func (s ConditionalForwarder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalForwarder) GoString() string {
	return s.String()
}

// SetDnsIpAddrs sets the DnsIpAddrs field's value.
func (s *ConditionalForwarder) SetDnsIpAddrs(v []*string) *ConditionalForwarder {
	s.DnsIpAddrs = v
	return s
}

// SetRemoteDomainName sets the RemoteDomainName field's value.
func (s *ConditionalForwarder) SetRemoteDomainName(v string) *ConditionalForwarder {
	s.RemoteDomainName = &v
	return s
}

// SetReplicationScope sets the ReplicationScope field's value.
func (s *ConditionalForwarder) SetReplicationScope(v string) *ConditionalForwarder {
	s.ReplicationScope = &v
	return s
}

// Contains the inputs for the ConnectDirectory operation.
type ConnectDirectoryInput struct {
	_ struct{} `type:"structure"`

	// A DirectoryConnectSettings object that contains additional information for
	// the operation.
	//
	// ConnectSettings is a required field
	ConnectSettings *DirectoryConnectSettings `type:"structure" required:"true"`

	// A description for the directory.
	Description *string `type:"string"`

	// The fully qualified name of the on-premises directory, such as corp.example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The password for the on-premises user account.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The NetBIOS name of the on-premises directory, such as CORP.
	ShortName *string `type:"string"`

	// The size of the directory.
	//
	// Size is a required field
	Size *string `type:"string" required:"true" enum:"DirectorySize"`

	// The tags to be assigned to AD Connector.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ConnectDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectDirectoryInput"}
	if s.ConnectSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectSettings"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.ConnectSettings != nil {
		if err := s.ConnectSettings.Validate(); err != nil {
			invalidParams.AddNested("ConnectSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectSettings sets the ConnectSettings field's value.
func (s *ConnectDirectoryInput) SetConnectSettings(v *DirectoryConnectSettings) *ConnectDirectoryInput {
	s.ConnectSettings = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConnectDirectoryInput) SetDescription(v string) *ConnectDirectoryInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConnectDirectoryInput) SetName(v string) *ConnectDirectoryInput {
	s.Name = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *ConnectDirectoryInput) SetPassword(v string) *ConnectDirectoryInput {
	s.Password = &v
	return s
}

// SetShortName sets the ShortName field's value.
func (s *ConnectDirectoryInput) SetShortName(v string) *ConnectDirectoryInput {
	s.ShortName = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ConnectDirectoryInput) SetSize(v string) *ConnectDirectoryInput {
	s.Size = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ConnectDirectoryInput) SetTags(v []*Tag) *ConnectDirectoryInput {
	s.Tags = v
	return s
}

// Contains the results of the ConnectDirectory operation.
type ConnectDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the new directory.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s ConnectDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectDirectoryOutput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ConnectDirectoryOutput) SetDirectoryId(v string) *ConnectDirectoryOutput {
	s.DirectoryId = &v
	return s
}

// Contains the inputs for the CreateAlias operation.
type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// The requested alias.
	//
	// The alias must be unique amongst all aliases in AWS. This operation throws
	// an EntityAlreadyExistsException error if the alias already exists.
	//
	// Alias is a required field
	Alias *string `min:"1" type:"string" required:"true"`

	// The identifier of the directory for which to create the alias.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.Alias == nil {
		invalidParams.Add(request.NewErrParamRequired("Alias"))
	}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *CreateAliasInput) SetAlias(v string) *CreateAliasInput {
	s.Alias = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateAliasInput) SetDirectoryId(v string) *CreateAliasInput {
	s.DirectoryId = &v
	return s
}

// Contains the results of the CreateAlias operation.
type CreateAliasOutput struct {
	_ struct{} `type:"structure"`

	// The alias for the directory.
	Alias *string `min:"1" type:"string"`

	// The identifier of the directory.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *CreateAliasOutput) SetAlias(v string) *CreateAliasOutput {
	s.Alias = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateAliasOutput) SetDirectoryId(v string) *CreateAliasOutput {
	s.DirectoryId = &v
	return s
}

// Contains the inputs for the CreateComputer operation.
type CreateComputerInput struct {
	_ struct{} `type:"structure"`

	// An array of Attribute objects that contain any LDAP attributes to apply to
	// the computer account.
	ComputerAttributes []*Attribute `type:"list"`

	// The name of the computer account.
	//
	// ComputerName is a required field
	ComputerName *string `min:"1" type:"string" required:"true"`

	// The identifier of the directory in which to create the computer account.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The fully-qualified distinguished name of the organizational unit to place
	// the computer account in.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// A one-time password that is used to join the computer to the directory. You
	// should generate a random, strong password to use for this parameter.
	//
	// Password is a required field
	Password *string `min:"8" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s CreateComputerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComputerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComputerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComputerInput"}
	if s.ComputerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputerName"))
	}
	if s.ComputerName != nil && len(*s.ComputerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComputerName", 1))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.OrganizationalUnitDistinguishedName != nil && len(*s.OrganizationalUnitDistinguishedName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OrganizationalUnitDistinguishedName", 1))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 8))
	}
	if s.ComputerAttributes != nil {
		for i, v := range s.ComputerAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ComputerAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputerAttributes sets the ComputerAttributes field's value.
func (s *CreateComputerInput) SetComputerAttributes(v []*Attribute) *CreateComputerInput {
	s.ComputerAttributes = v
	return s
}

// SetComputerName sets the ComputerName field's value.
func (s *CreateComputerInput) SetComputerName(v string) *CreateComputerInput {
	s.ComputerName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateComputerInput) SetDirectoryId(v string) *CreateComputerInput {
	s.DirectoryId = &v
	return s
}

// SetOrganizationalUnitDistinguishedName sets the OrganizationalUnitDistinguishedName field's value.
func (s *CreateComputerInput) SetOrganizationalUnitDistinguishedName(v string) *CreateComputerInput {
	s.OrganizationalUnitDistinguishedName = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateComputerInput) SetPassword(v string) *CreateComputerInput {
	s.Password = &v
	return s
}

// Contains the results for the CreateComputer operation.
type CreateComputerOutput struct {
	_ struct{} `type:"structure"`

	// A Computer object that represents the computer account.
	Computer *Computer `type:"structure"`
}

// String returns the string representation
func (s CreateComputerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComputerOutput) GoString() string {
	return s.String()
}

// SetComputer sets the Computer field's value.
func (s *CreateComputerOutput) SetComputer(v *Computer) *CreateComputerOutput {
	s.Computer = v
	return s
}

// Initiates the creation of a conditional forwarder for your AWS Directory
// Service for Microsoft Active Directory. Conditional forwarders are required
// in order to set up a trust relationship with another domain.
type CreateConditionalForwarderInput struct {
	_ struct{} `type:"structure"`

	// The directory ID of the AWS directory for which you are creating the conditional
	// forwarder.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The IP addresses of the remote DNS server associated with RemoteDomainName.
	//
	// DnsIpAddrs is a required field
	DnsIpAddrs []*string `type:"list" required:"true"`

	// The fully qualified domain name (FQDN) of the remote domain with which you
	// will set up a trust relationship.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConditionalForwarderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConditionalForwarderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConditionalForwarderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConditionalForwarderInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DnsIpAddrs == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsIpAddrs"))
	}
	if s.RemoteDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateConditionalForwarderInput) SetDirectoryId(v string) *CreateConditionalForwarderInput {
	s.DirectoryId = &v
	return s
}

// SetDnsIpAddrs sets the DnsIpAddrs field's value.
func (s *CreateConditionalForwarderInput) SetDnsIpAddrs(v []*string) *CreateConditionalForwarderInput {
	s.DnsIpAddrs = v
	return s
}

// SetRemoteDomainName sets the RemoteDomainName field's value.
func (s *CreateConditionalForwarderInput) SetRemoteDomainName(v string) *CreateConditionalForwarderInput {
	s.RemoteDomainName = &v
	return s
}

// The result of a CreateConditinalForwarder request.
type CreateConditionalForwarderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateConditionalForwarderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConditionalForwarderOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateDirectory operation.
type CreateDirectoryInput struct {
	_ struct{} `type:"structure"`

	// A description for the directory.
	Description *string `type:"string"`

	// The fully qualified name for the directory, such as corp.example.com.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The password for the directory administrator. The directory creation process
	// creates a directory administrator account with the user name Administrator
	// and this password.
	//
	// If you need to change the password for the administrator account, you can
	// use the ResetUserPassword API call.
	//
	// The regex pattern for this string is made up of the following conditions:
	//
	//    * Length (?=^.{8,64}$) – Must be between 8 and 64 characters
	//
	// AND any 3 of the following password complexity rules required by Active Directory:
	//
	//    * Numbers and upper case and lowercase (?=.*\d)(?=.*[A-Z])(?=.*[a-z])
	//
	//    * Numbers and special characters and lower case (?=.*\d)(?=.*[^A-Za-z0-9\s])(?=.*[a-z])
	//
	//    * Special characters and upper case and lower case (?=.*[^A-Za-z0-9\s])(?=.*[A-Z])(?=.*[a-z])
	//
	//    * Numbers and upper case and special characters (?=.*\d)(?=.*[A-Z])(?=.*[^A-Za-z0-9\s])
	//
	// For additional information about how Active Directory passwords are enforced,
	// see Password must meet complexity requirements (https://docs.microsoft.com/en-us/windows/security/threat-protection/security-policy-settings/password-must-meet-complexity-requirements)
	// on the Microsoft website.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// The NetBIOS name of the directory, such as CORP.
	ShortName *string `type:"string"`

	// The size of the directory.
	//
	// Size is a required field
	Size *string `type:"string" required:"true" enum:"DirectorySize"`

	// The tags to be assigned to the Simple AD directory.
	Tags []*Tag `type:"list"`

	// A DirectoryVpcSettings object that contains additional information for the
	// operation.
	VpcSettings *DirectoryVpcSettings `type:"structure"`
}

// String returns the string representation
func (s CreateDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDirectoryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcSettings != nil {
		if err := s.VpcSettings.Validate(); err != nil {
			invalidParams.AddNested("VpcSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDirectoryInput) SetDescription(v string) *CreateDirectoryInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDirectoryInput) SetName(v string) *CreateDirectoryInput {
	s.Name = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateDirectoryInput) SetPassword(v string) *CreateDirectoryInput {
	s.Password = &v
	return s
}

// SetShortName sets the ShortName field's value.
func (s *CreateDirectoryInput) SetShortName(v string) *CreateDirectoryInput {
	s.ShortName = &v
	return s
}

// SetSize sets the Size field's value.
func (s *CreateDirectoryInput) SetSize(v string) *CreateDirectoryInput {
	s.Size = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDirectoryInput) SetTags(v []*Tag) *CreateDirectoryInput {
	s.Tags = v
	return s
}

// SetVpcSettings sets the VpcSettings field's value.
func (s *CreateDirectoryInput) SetVpcSettings(v *DirectoryVpcSettings) *CreateDirectoryInput {
	s.VpcSettings = v
	return s
}

// Contains the results of the CreateDirectory operation.
type CreateDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory that was created.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s CreateDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryOutput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateDirectoryOutput) SetDirectoryId(v string) *CreateDirectoryOutput {
	s.DirectoryId = &v
	return s
}

type CreateLogSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory to which you want to subscribe and receive real-time
	// logs to your specified CloudWatch log group.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The name of the CloudWatch log group where the real-time domain controller
	// logs are forwarded.
	//
	// LogGroupName is a required field
	LogGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLogSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLogSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLogSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLogSubscriptionInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.LogGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupName"))
	}
	if s.LogGroupName != nil && len(*s.LogGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateLogSubscriptionInput) SetDirectoryId(v string) *CreateLogSubscriptionInput {
	s.DirectoryId = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CreateLogSubscriptionInput) SetLogGroupName(v string) *CreateLogSubscriptionInput {
	s.LogGroupName = &v
	return s
}

type CreateLogSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLogSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLogSubscriptionOutput) GoString() string {
	return s.String()
}

// Creates an AWS Managed Microsoft AD directory.
type CreateMicrosoftADInput struct {
	_ struct{} `type:"structure"`

	// A description for the directory. This label will appear on the AWS console
	// Directory Details page after the directory is created.
	Description *string `type:"string"`

	// AWS Managed Microsoft AD is available in two editions: Standard and Enterprise.
	// Enterprise is the default.
	Edition *string `type:"string" enum:"DirectoryEdition"`

	// The fully qualified domain name for the AWS Managed Microsoft AD directory,
	// such as corp.example.com. This name will resolve inside your VPC only. It
	// does not need to be publicly resolvable.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The password for the default administrative user named Admin.
	//
	// If you need to change the password for the administrator account, you can
	// use the ResetUserPassword API call.
	//
	// Password is a required field
	Password *string `type:"string" required:"true" sensitive:"true"`

	// The NetBIOS name for your domain, such as CORP. If you don't specify a NetBIOS
	// name, it will default to the first part of your directory DNS. For example,
	// CORP for the directory DNS corp.example.com.
	ShortName *string `type:"string"`

	// The tags to be assigned to the AWS Managed Microsoft AD directory.
	Tags []*Tag `type:"list"`

	// Contains VPC information for the CreateDirectory or CreateMicrosoftAD operation.
	//
	// VpcSettings is a required field
	VpcSettings *DirectoryVpcSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateMicrosoftADInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMicrosoftADInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMicrosoftADInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMicrosoftADInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.VpcSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcSettings"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcSettings != nil {
		if err := s.VpcSettings.Validate(); err != nil {
			invalidParams.AddNested("VpcSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateMicrosoftADInput) SetDescription(v string) *CreateMicrosoftADInput {
	s.Description = &v
	return s
}

// SetEdition sets the Edition field's value.
func (s *CreateMicrosoftADInput) SetEdition(v string) *CreateMicrosoftADInput {
	s.Edition = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMicrosoftADInput) SetName(v string) *CreateMicrosoftADInput {
	s.Name = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateMicrosoftADInput) SetPassword(v string) *CreateMicrosoftADInput {
	s.Password = &v
	return s
}

// SetShortName sets the ShortName field's value.
func (s *CreateMicrosoftADInput) SetShortName(v string) *CreateMicrosoftADInput {
	s.ShortName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMicrosoftADInput) SetTags(v []*Tag) *CreateMicrosoftADInput {
	s.Tags = v
	return s
}

// SetVpcSettings sets the VpcSettings field's value.
func (s *CreateMicrosoftADInput) SetVpcSettings(v *DirectoryVpcSettings) *CreateMicrosoftADInput {
	s.VpcSettings = v
	return s
}

// Result of a CreateMicrosoftAD request.
type CreateMicrosoftADOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory that was created.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s CreateMicrosoftADOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMicrosoftADOutput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateMicrosoftADOutput) SetDirectoryId(v string) *CreateMicrosoftADOutput {
	s.DirectoryId = &v
	return s
}

// Contains the inputs for the CreateSnapshot operation.
type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory of which to take a snapshot.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The descriptive name to apply to the snapshot.
	Name *string `type:"string"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateSnapshotInput) SetDirectoryId(v string) *CreateSnapshotInput {
	s.DirectoryId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSnapshotInput) SetName(v string) *CreateSnapshotInput {
	s.Name = &v
	return s
}

// Contains the results of the CreateSnapshot operation.
type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the snapshot that was created.
	SnapshotId *string `type:"string"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *CreateSnapshotOutput) SetSnapshotId(v string) *CreateSnapshotOutput {
	s.SnapshotId = &v
	return s
}

// AWS Directory Service for Microsoft Active Directory allows you to configure
// trust relationships. For example, you can establish a trust between your
// AWS Managed Microsoft AD directory, and your existing on-premises Microsoft
// Active Directory. This would allow you to provide users and groups access
// to resources in either domain, with a single set of credentials.
//
// This action initiates the creation of the AWS side of a trust relationship
// between an AWS Managed Microsoft AD directory and an external domain.
type CreateTrustInput struct {
	_ struct{} `type:"structure"`

	// The IP addresses of the remote DNS server associated with RemoteDomainName.
	ConditionalForwarderIpAddrs []*string `type:"list"`

	// The Directory ID of the AWS Managed Microsoft AD directory for which to establish
	// the trust relationship.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The Fully Qualified Domain Name (FQDN) of the external domain for which to
	// create the trust relationship.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`

	// Optional parameter to enable selective authentication for the trust.
	SelectiveAuth *string `type:"string" enum:"SelectiveAuth"`

	// The direction of the trust relationship.
	//
	// TrustDirection is a required field
	TrustDirection *string `type:"string" required:"true" enum:"TrustDirection"`

	// The trust password. The must be the same password that was used when creating
	// the trust relationship on the external domain.
	//
	// TrustPassword is a required field
	TrustPassword *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The trust relationship type. Forest is the default.
	TrustType *string `type:"string" enum:"TrustType"`
}

// String returns the string representation
func (s CreateTrustInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrustInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrustInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrustInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RemoteDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainName"))
	}
	if s.TrustDirection == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustDirection"))
	}
	if s.TrustPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustPassword"))
	}
	if s.TrustPassword != nil && len(*s.TrustPassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrustPassword", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionalForwarderIpAddrs sets the ConditionalForwarderIpAddrs field's value.
func (s *CreateTrustInput) SetConditionalForwarderIpAddrs(v []*string) *CreateTrustInput {
	s.ConditionalForwarderIpAddrs = v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateTrustInput) SetDirectoryId(v string) *CreateTrustInput {
	s.DirectoryId = &v
	return s
}

// SetRemoteDomainName sets the RemoteDomainName field's value.
func (s *CreateTrustInput) SetRemoteDomainName(v string) *CreateTrustInput {
	s.RemoteDomainName = &v
	return s
}

// SetSelectiveAuth sets the SelectiveAuth field's value.
func (s *CreateTrustInput) SetSelectiveAuth(v string) *CreateTrustInput {
	s.SelectiveAuth = &v
	return s
}

// SetTrustDirection sets the TrustDirection field's value.
func (s *CreateTrustInput) SetTrustDirection(v string) *CreateTrustInput {
	s.TrustDirection = &v
	return s
}

// SetTrustPassword sets the TrustPassword field's value.
func (s *CreateTrustInput) SetTrustPassword(v string) *CreateTrustInput {
	s.TrustPassword = &v
	return s
}

// SetTrustType sets the TrustType field's value.
func (s *CreateTrustInput) SetTrustType(v string) *CreateTrustInput {
	s.TrustType = &v
	return s
}

// The result of a CreateTrust request.
type CreateTrustOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the trust relationship that was created.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s CreateTrustOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrustOutput) GoString() string {
	return s.String()
}

// SetTrustId sets the TrustId field's value.
func (s *CreateTrustOutput) SetTrustId(v string) *CreateTrustOutput {
	s.TrustId = &v
	return s
}

// Deletes a conditional forwarder.
type DeleteConditionalForwarderInput struct {
	_ struct{} `type:"structure"`

	// The directory ID for which you are deleting the conditional forwarder.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The fully qualified domain name (FQDN) of the remote domain with which you
	// are deleting the conditional forwarder.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConditionalForwarderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConditionalForwarderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConditionalForwarderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConditionalForwarderInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RemoteDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DeleteConditionalForwarderInput) SetDirectoryId(v string) *DeleteConditionalForwarderInput {
	s.DirectoryId = &v
	return s
}

// SetRemoteDomainName sets the RemoteDomainName field's value.
func (s *DeleteConditionalForwarderInput) SetRemoteDomainName(v string) *DeleteConditionalForwarderInput {
	s.RemoteDomainName = &v
	return s
}

// The result of a DeleteConditionalForwarder request.
type DeleteConditionalForwarderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConditionalForwarderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConditionalForwarderOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteDirectory operation.
type DeleteDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory to delete.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDirectoryInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DeleteDirectoryInput) SetDirectoryId(v string) *DeleteDirectoryInput {
	s.DirectoryId = &v
	return s
}

// Contains the results of the DeleteDirectory operation.
type DeleteDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// The directory identifier.
	DirectoryId *string `type:"string"`
}

// String returns the string representation
func (s DeleteDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryOutput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DeleteDirectoryOutput) SetDirectoryId(v string) *DeleteDirectoryOutput {
	s.DirectoryId = &v
	return s
}

type DeleteLogSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory whose log subscription you want to delete.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLogSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLogSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLogSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLogSubscriptionInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DeleteLogSubscriptionInput) SetDirectoryId(v string) *DeleteLogSubscriptionInput {
	s.DirectoryId = &v
	return s
}

type DeleteLogSubscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLogSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLogSubscriptionOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteSnapshot operation.
type DeleteSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory snapshot to be deleted.
	//
	// SnapshotId is a required field
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotInput"}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *DeleteSnapshotInput) SetSnapshotId(v string) *DeleteSnapshotInput {
	s.SnapshotId = &v
	return s
}

// Contains the results of the DeleteSnapshot operation.
type DeleteSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory snapshot that was deleted.
	SnapshotId *string `type:"string"`
}

// String returns the string representation
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *DeleteSnapshotOutput) SetSnapshotId(v string) *DeleteSnapshotOutput {
	s.SnapshotId = &v
	return s
}

// Deletes the local side of an existing trust relationship between the AWS
// Managed Microsoft AD directory and the external domain.
type DeleteTrustInput struct {
	_ struct{} `type:"structure"`

	// Delete a conditional forwarder as part of a DeleteTrustRequest.
	DeleteAssociatedConditionalForwarder *bool `type:"boolean"`

	// The Trust ID of the trust relationship to be deleted.
	//
	// TrustId is a required field
	TrustId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrustInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrustInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrustInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrustInput"}
	if s.TrustId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteAssociatedConditionalForwarder sets the DeleteAssociatedConditionalForwarder field's value.
func (s *DeleteTrustInput) SetDeleteAssociatedConditionalForwarder(v bool) *DeleteTrustInput {
	s.DeleteAssociatedConditionalForwarder = &v
	return s
}

// SetTrustId sets the TrustId field's value.
func (s *DeleteTrustInput) SetTrustId(v string) *DeleteTrustInput {
	s.TrustId = &v
	return s
}

// The result of a DeleteTrust request.
type DeleteTrustOutput struct {
	_ struct{} `type:"structure"`

	// The Trust ID of the trust relationship that was deleted.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s DeleteTrustOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrustOutput) GoString() string {
	return s.String()
}

// SetTrustId sets the TrustId field's value.
func (s *DeleteTrustOutput) SetTrustId(v string) *DeleteTrustOutput {
	s.TrustId = &v
	return s
}

type DeregisterCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `type:"string" required:"true"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DeregisterCertificateInput) SetCertificateId(v string) *DeregisterCertificateInput {
	s.CertificateId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DeregisterCertificateInput) SetDirectoryId(v string) *DeregisterCertificateInput {
	s.DirectoryId = &v
	return s
}

type DeregisterCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterCertificateOutput) GoString() string {
	return s.String()
}

// Removes the specified directory as a publisher to the specified SNS topic.
type DeregisterEventTopicInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID to remove as a publisher. This directory will no longer
	// send messages to the specified SNS topic.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The name of the SNS topic from which to remove the directory as a publisher.
	//
	// TopicName is a required field
	TopicName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterEventTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterEventTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterEventTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterEventTopicInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DeregisterEventTopicInput) SetDirectoryId(v string) *DeregisterEventTopicInput {
	s.DirectoryId = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *DeregisterEventTopicInput) SetTopicName(v string) *DeregisterEventTopicInput {
	s.TopicName = &v
	return s
}

// The result of a DeregisterEventTopic request.
type DeregisterEventTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterEventTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterEventTopicOutput) GoString() string {
	return s.String()
}

type DescribeCertificateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the certificate.
	//
	// CertificateId is a required field
	CertificateId *string `type:"string" required:"true"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DescribeCertificateInput) SetCertificateId(v string) *DescribeCertificateInput {
	s.CertificateId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeCertificateInput) SetDirectoryId(v string) *DescribeCertificateInput {
	s.DirectoryId = &v
	return s
}

type DescribeCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the certificate, including registered date time, certificate
	// state, the reason for the state, expiration date time, and certificate common
	// name.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s DescribeCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *DescribeCertificateOutput) SetCertificate(v *Certificate) *DescribeCertificateOutput {
	s.Certificate = v
	return s
}

// Describes a conditional forwarder.
type DescribeConditionalForwardersInput struct {
	_ struct{} `type:"structure"`

	// The directory ID for which to get the list of associated conditional forwarders.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The fully qualified domain names (FQDN) of the remote domains for which to
	// get the list of associated conditional forwarders. If this member is null,
	// all conditional forwarders are returned.
	RemoteDomainNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeConditionalForwardersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConditionalForwardersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConditionalForwardersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConditionalForwardersInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeConditionalForwardersInput) SetDirectoryId(v string) *DescribeConditionalForwardersInput {
	s.DirectoryId = &v
	return s
}

// SetRemoteDomainNames sets the RemoteDomainNames field's value.
func (s *DescribeConditionalForwardersInput) SetRemoteDomainNames(v []*string) *DescribeConditionalForwardersInput {
	s.RemoteDomainNames = v
	return s
}

// The result of a DescribeConditionalForwarder request.
type DescribeConditionalForwardersOutput struct {
	_ struct{} `type:"structure"`

	// The list of conditional forwarders that have been created.
	ConditionalForwarders []*ConditionalForwarder `type:"list"`
}

// String returns the string representation
func (s DescribeConditionalForwardersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConditionalForwardersOutput) GoString() string {
	return s.String()
}

// SetConditionalForwarders sets the ConditionalForwarders field's value.
func (s *DescribeConditionalForwardersOutput) SetConditionalForwarders(v []*ConditionalForwarder) *DescribeConditionalForwardersOutput {
	s.ConditionalForwarders = v
	return s
}

// Contains the inputs for the DescribeDirectories operation.
type DescribeDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// A list of identifiers of the directories for which to obtain the information.
	// If this member is null, all directories that belong to the current account
	// are returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	DirectoryIds []*string `type:"list"`

	// The maximum number of items to return. If this value is zero, the maximum
	// number of items is specified by the limitations of the operation.
	Limit *int64 `type:"integer"`

	// The DescribeDirectoriesResult.NextToken value from a previous call to DescribeDirectories.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoriesInput) GoString() string {
	return s.String()
}

// SetDirectoryIds sets the DirectoryIds field's value.
func (s *DescribeDirectoriesInput) SetDirectoryIds(v []*string) *DescribeDirectoriesInput {
	s.DirectoryIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeDirectoriesInput) SetLimit(v int64) *DescribeDirectoriesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectoriesInput) SetNextToken(v string) *DescribeDirectoriesInput {
	s.NextToken = &v
	return s
}

// Contains the results of the DescribeDirectories operation.
type DescribeDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of DirectoryDescription objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	DirectoryDescriptions []*DirectoryDescription `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeDirectories to retrieve the next
	// set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoriesOutput) GoString() string {
	return s.String()
}

// SetDirectoryDescriptions sets the DirectoryDescriptions field's value.
func (s *DescribeDirectoriesOutput) SetDirectoryDescriptions(v []*DirectoryDescription) *DescribeDirectoriesOutput {
	s.DirectoryDescriptions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDirectoriesOutput) SetNextToken(v string) *DescribeDirectoriesOutput {
	s.NextToken = &v
	return s
}

type DescribeDomainControllersInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory for which to retrieve the domain controller information.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// A list of identifiers for the domain controllers whose information will be
	// provided.
	DomainControllerIds []*string `type:"list"`

	// The maximum number of items to return.
	Limit *int64 `type:"integer"`

	// The DescribeDomainControllers.NextToken value from a previous call to DescribeDomainControllers.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDomainControllersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainControllersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDomainControllersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDomainControllersInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeDomainControllersInput) SetDirectoryId(v string) *DescribeDomainControllersInput {
	s.DirectoryId = &v
	return s
}

// SetDomainControllerIds sets the DomainControllerIds field's value.
func (s *DescribeDomainControllersInput) SetDomainControllerIds(v []*string) *DescribeDomainControllersInput {
	s.DomainControllerIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeDomainControllersInput) SetLimit(v int64) *DescribeDomainControllersInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDomainControllersInput) SetNextToken(v string) *DescribeDomainControllersInput {
	s.NextToken = &v
	return s
}

type DescribeDomainControllersOutput struct {
	_ struct{} `type:"structure"`

	// List of the DomainController objects that were retrieved.
	DomainControllers []*DomainController `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeDomainControllers retrieve the
	// next set of items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDomainControllersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDomainControllersOutput) GoString() string {
	return s.String()
}

// SetDomainControllers sets the DomainControllers field's value.
func (s *DescribeDomainControllersOutput) SetDomainControllers(v []*DomainController) *DescribeDomainControllersOutput {
	s.DomainControllers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDomainControllersOutput) SetNextToken(v string) *DescribeDomainControllersOutput {
	s.NextToken = &v
	return s
}

// Describes event topics.
type DescribeEventTopicsInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID for which to get the list of associated SNS topics. If this
	// member is null, associations for all Directory IDs are returned.
	DirectoryId *string `type:"string"`

	// A list of SNS topic names for which to obtain the information. If this member
	// is null, all associations for the specified Directory ID are returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	TopicNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeEventTopicsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventTopicsInput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeEventTopicsInput) SetDirectoryId(v string) *DescribeEventTopicsInput {
	s.DirectoryId = &v
	return s
}

// SetTopicNames sets the TopicNames field's value.
func (s *DescribeEventTopicsInput) SetTopicNames(v []*string) *DescribeEventTopicsInput {
	s.TopicNames = v
	return s
}

// The result of a DescribeEventTopic request.
type DescribeEventTopicsOutput struct {
	_ struct{} `type:"structure"`

	// A list of SNS topic names that receive status messages from the specified
	// Directory ID.
	EventTopics []*EventTopic `type:"list"`
}

// String returns the string representation
func (s DescribeEventTopicsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventTopicsOutput) GoString() string {
	return s.String()
}

// SetEventTopics sets the EventTopics field's value.
func (s *DescribeEventTopicsOutput) SetEventTopics(v []*EventTopic) *DescribeEventTopicsOutput {
	s.EventTopics = v
	return s
}

type DescribeLDAPSSettingsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Specifies the number of items that should be displayed on one page.
	Limit *int64 `min:"1" type:"integer"`

	// The type of next token used for pagination.
	NextToken *string `type:"string"`

	// The type of LDAP security to enable. Currently only the value Client is supported.
	Type *string `type:"string" enum:"LDAPSType"`
}

// String returns the string representation
func (s DescribeLDAPSSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLDAPSSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLDAPSSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLDAPSSettingsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeLDAPSSettingsInput) SetDirectoryId(v string) *DescribeLDAPSSettingsInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeLDAPSSettingsInput) SetLimit(v int64) *DescribeLDAPSSettingsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLDAPSSettingsInput) SetNextToken(v string) *DescribeLDAPSSettingsInput {
	s.NextToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *DescribeLDAPSSettingsInput) SetType(v string) *DescribeLDAPSSettingsInput {
	s.Type = &v
	return s
}

type DescribeLDAPSSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Information about LDAP security for the specified directory, including status
	// of enablement, state last updated date time, and the reason for the state.
	LDAPSSettingsInfo []*LDAPSSettingInfo `type:"list"`

	// The next token used to retrieve the LDAPS settings if the number of setting
	// types exceeds page limit and there is another page.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLDAPSSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLDAPSSettingsOutput) GoString() string {
	return s.String()
}

// SetLDAPSSettingsInfo sets the LDAPSSettingsInfo field's value.
func (s *DescribeLDAPSSettingsOutput) SetLDAPSSettingsInfo(v []*LDAPSSettingInfo) *DescribeLDAPSSettingsOutput {
	s.LDAPSSettingsInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeLDAPSSettingsOutput) SetNextToken(v string) *DescribeLDAPSSettingsOutput {
	s.NextToken = &v
	return s
}

type DescribeRegionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The DescribeRegionsResult.NextToken value from a previous call to DescribeRegions.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`

	// The name of the Region. For example, us-east-1.
	RegionName *string `min:"8" type:"string"`
}

// String returns the string representation
func (s DescribeRegionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRegionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRegionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRegionsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RegionName != nil && len(*s.RegionName) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("RegionName", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeRegionsInput) SetDirectoryId(v string) *DescribeRegionsInput {
	s.DirectoryId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRegionsInput) SetNextToken(v string) *DescribeRegionsInput {
	s.NextToken = &v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *DescribeRegionsInput) SetRegionName(v string) *DescribeRegionsInput {
	s.RegionName = &v
	return s
}

type DescribeRegionsOutput struct {
	_ struct{} `type:"structure"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeRegions to retrieve the next set
	// of items.
	NextToken *string `type:"string"`

	// List of Region information related to the directory for each replicated Region.
	RegionsDescription []*RegionDescription `type:"list"`
}

// String returns the string representation
func (s DescribeRegionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRegionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRegionsOutput) SetNextToken(v string) *DescribeRegionsOutput {
	s.NextToken = &v
	return s
}

// SetRegionsDescription sets the RegionsDescription field's value.
func (s *DescribeRegionsOutput) SetRegionsDescription(v []*RegionDescription) *DescribeRegionsOutput {
	s.RegionsDescription = v
	return s
}

type DescribeSharedDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// The number of shared directories to return in the response object.
	Limit *int64 `type:"integer"`

	// The DescribeSharedDirectoriesResult.NextToken value from a previous call
	// to DescribeSharedDirectories. Pass null if this is the first call.
	NextToken *string `type:"string"`

	// Returns the identifier of the directory in the directory owner account.
	//
	// OwnerDirectoryId is a required field
	OwnerDirectoryId *string `type:"string" required:"true"`

	// A list of identifiers of all shared directories in your account.
	SharedDirectoryIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeSharedDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSharedDirectoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSharedDirectoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSharedDirectoriesInput"}
	if s.OwnerDirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerDirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *DescribeSharedDirectoriesInput) SetLimit(v int64) *DescribeSharedDirectoriesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSharedDirectoriesInput) SetNextToken(v string) *DescribeSharedDirectoriesInput {
	s.NextToken = &v
	return s
}

// SetOwnerDirectoryId sets the OwnerDirectoryId field's value.
func (s *DescribeSharedDirectoriesInput) SetOwnerDirectoryId(v string) *DescribeSharedDirectoriesInput {
	s.OwnerDirectoryId = &v
	return s
}

// SetSharedDirectoryIds sets the SharedDirectoryIds field's value.
func (s *DescribeSharedDirectoriesInput) SetSharedDirectoryIds(v []*string) *DescribeSharedDirectoriesInput {
	s.SharedDirectoryIds = v
	return s
}

type DescribeSharedDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// If not null, token that indicates that more results are available. Pass this
	// value for the NextToken parameter in a subsequent call to DescribeSharedDirectories
	// to retrieve the next set of items.
	NextToken *string `type:"string"`

	// A list of all shared directories in your account.
	SharedDirectories []*SharedDirectory `type:"list"`
}

// String returns the string representation
func (s DescribeSharedDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSharedDirectoriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSharedDirectoriesOutput) SetNextToken(v string) *DescribeSharedDirectoriesOutput {
	s.NextToken = &v
	return s
}

// SetSharedDirectories sets the SharedDirectories field's value.
func (s *DescribeSharedDirectoriesOutput) SetSharedDirectories(v []*SharedDirectory) *DescribeSharedDirectoriesOutput {
	s.SharedDirectories = v
	return s
}

// Contains the inputs for the DescribeSnapshots operation.
type DescribeSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to retrieve snapshot information.
	DirectoryId *string `type:"string"`

	// The maximum number of objects to return.
	Limit *int64 `type:"integer"`

	// The DescribeSnapshotsResult.NextToken value from a previous call to DescribeSnapshots.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`

	// A list of identifiers of the snapshots to obtain the information for. If
	// this member is null or empty, all snapshots are returned using the Limit
	// and NextToken members.
	SnapshotIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsInput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeSnapshotsInput) SetDirectoryId(v string) *DescribeSnapshotsInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeSnapshotsInput) SetLimit(v int64) *DescribeSnapshotsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSnapshotsInput) SetNextToken(v string) *DescribeSnapshotsInput {
	s.NextToken = &v
	return s
}

// SetSnapshotIds sets the SnapshotIds field's value.
func (s *DescribeSnapshotsInput) SetSnapshotIds(v []*string) *DescribeSnapshotsInput {
	s.SnapshotIds = v
	return s
}

// Contains the results of the DescribeSnapshots operation.
type DescribeSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// If not null, more results are available. Pass this value in the NextToken
	// member of a subsequent call to DescribeSnapshots.
	NextToken *string `type:"string"`

	// The list of Snapshot objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	Snapshots []*Snapshot `type:"list"`
}

// String returns the string representation
func (s DescribeSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSnapshotsOutput) SetNextToken(v string) *DescribeSnapshotsOutput {
	s.NextToken = &v
	return s
}

// SetSnapshots sets the Snapshots field's value.
func (s *DescribeSnapshotsOutput) SetSnapshots(v []*Snapshot) *DescribeSnapshotsOutput {
	s.Snapshots = v
	return s
}

// Describes the trust relationships for a particular AWS Managed Microsoft
// AD directory. If no input parameters are are provided, such as directory
// ID or trust ID, this request describes all the trust relationships.
type DescribeTrustsInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID of the AWS directory that is a part of the requested trust
	// relationship.
	DirectoryId *string `type:"string"`

	// The maximum number of objects to return.
	Limit *int64 `type:"integer"`

	// The DescribeTrustsResult.NextToken value from a previous call to DescribeTrusts.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`

	// A list of identifiers of the trust relationships for which to obtain the
	// information. If this member is null, all trust relationships that belong
	// to the current account are returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	TrustIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTrustsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustsInput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeTrustsInput) SetDirectoryId(v string) *DescribeTrustsInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeTrustsInput) SetLimit(v int64) *DescribeTrustsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTrustsInput) SetNextToken(v string) *DescribeTrustsInput {
	s.NextToken = &v
	return s
}

// SetTrustIds sets the TrustIds field's value.
func (s *DescribeTrustsInput) SetTrustIds(v []*string) *DescribeTrustsInput {
	s.TrustIds = v
	return s
}

// The result of a DescribeTrust request.
type DescribeTrustsOutput struct {
	_ struct{} `type:"structure"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeTrusts to retrieve the next set
	// of items.
	NextToken *string `type:"string"`

	// The list of Trust objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	Trusts []*Trust `type:"list"`
}

// String returns the string representation
func (s DescribeTrustsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeTrustsOutput) SetNextToken(v string) *DescribeTrustsOutput {
	s.NextToken = &v
	return s
}

// SetTrusts sets the Trusts field's value.
func (s *DescribeTrustsOutput) SetTrusts(v []*Trust) *DescribeTrustsOutput {
	s.Trusts = v
	return s
}

// The Region you specified is the same Region where the AWS Managed Microsoft
// AD directory was created. Specify a different Region and try again.
type DirectoryAlreadyInRegionException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryAlreadyInRegionException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryAlreadyInRegionException) GoString() string {
	return s.String()
}

func newErrorDirectoryAlreadyInRegionException(v protocol.ResponseMetadata) error {
	return &DirectoryAlreadyInRegionException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryAlreadyInRegionException) Code() string {
	return "DirectoryAlreadyInRegionException"
}

// Message returns the exception's message.
func (s *DirectoryAlreadyInRegionException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryAlreadyInRegionException) OrigErr() error {
	return nil
}

func (s *DirectoryAlreadyInRegionException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryAlreadyInRegionException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryAlreadyInRegionException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified directory has already been shared with this AWS account.
type DirectoryAlreadySharedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryAlreadySharedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryAlreadySharedException) GoString() string {
	return s.String()
}

func newErrorDirectoryAlreadySharedException(v protocol.ResponseMetadata) error {
	return &DirectoryAlreadySharedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryAlreadySharedException) Code() string {
	return "DirectoryAlreadySharedException"
}

// Message returns the exception's message.
func (s *DirectoryAlreadySharedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryAlreadySharedException) OrigErr() error {
	return nil
}

func (s *DirectoryAlreadySharedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryAlreadySharedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryAlreadySharedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information for the ConnectDirectory operation when an AD Connector
// directory is being created.
type DirectoryConnectSettings struct {
	_ struct{} `type:"structure"`

	// A list of one or more IP addresses of DNS servers or domain controllers in
	// the on-premises directory.
	//
	// CustomerDnsIps is a required field
	CustomerDnsIps []*string `type:"list" required:"true"`

	// The user name of an account in the on-premises directory that is used to
	// connect to the directory. This account must have the following permissions:
	//
	//    * Read users and groups
	//
	//    * Create computer objects
	//
	//    * Join computers to the domain
	//
	// CustomerUserName is a required field
	CustomerUserName *string `min:"1" type:"string" required:"true"`

	// A list of subnet identifiers in the VPC in which the AD Connector is created.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The identifier of the VPC in which the AD Connector is created.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DirectoryConnectSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryConnectSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DirectoryConnectSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DirectoryConnectSettings"}
	if s.CustomerDnsIps == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerDnsIps"))
	}
	if s.CustomerUserName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerUserName"))
	}
	if s.CustomerUserName != nil && len(*s.CustomerUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerUserName", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerDnsIps sets the CustomerDnsIps field's value.
func (s *DirectoryConnectSettings) SetCustomerDnsIps(v []*string) *DirectoryConnectSettings {
	s.CustomerDnsIps = v
	return s
}

// SetCustomerUserName sets the CustomerUserName field's value.
func (s *DirectoryConnectSettings) SetCustomerUserName(v string) *DirectoryConnectSettings {
	s.CustomerUserName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DirectoryConnectSettings) SetSubnetIds(v []*string) *DirectoryConnectSettings {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DirectoryConnectSettings) SetVpcId(v string) *DirectoryConnectSettings {
	s.VpcId = &v
	return s
}

// Contains information about an AD Connector directory.
type DirectoryConnectSettingsDescription struct {
	_ struct{} `type:"structure"`

	// A list of the Availability Zones that the directory is in.
	AvailabilityZones []*string `type:"list"`

	// The IP addresses of the AD Connector servers.
	ConnectIps []*string `type:"list"`

	// The user name of the service account in the on-premises directory.
	CustomerUserName *string `min:"1" type:"string"`

	// The security group identifier for the AD Connector directory.
	SecurityGroupId *string `type:"string"`

	// A list of subnet identifiers in the VPC that the AD Connector is in.
	SubnetIds []*string `type:"list"`

	// The identifier of the VPC that the AD Connector is in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryConnectSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryConnectSettingsDescription) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DirectoryConnectSettingsDescription) SetAvailabilityZones(v []*string) *DirectoryConnectSettingsDescription {
	s.AvailabilityZones = v
	return s
}

// SetConnectIps sets the ConnectIps field's value.
func (s *DirectoryConnectSettingsDescription) SetConnectIps(v []*string) *DirectoryConnectSettingsDescription {
	s.ConnectIps = v
	return s
}

// SetCustomerUserName sets the CustomerUserName field's value.
func (s *DirectoryConnectSettingsDescription) SetCustomerUserName(v string) *DirectoryConnectSettingsDescription {
	s.CustomerUserName = &v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *DirectoryConnectSettingsDescription) SetSecurityGroupId(v string) *DirectoryConnectSettingsDescription {
	s.SecurityGroupId = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DirectoryConnectSettingsDescription) SetSubnetIds(v []*string) *DirectoryConnectSettingsDescription {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DirectoryConnectSettingsDescription) SetVpcId(v string) *DirectoryConnectSettingsDescription {
	s.VpcId = &v
	return s
}

// Contains information about an AWS Directory Service directory.
type DirectoryDescription struct {
	_ struct{} `type:"structure"`

	// The access URL for the directory, such as http://<alias>.awsapps.com. If
	// no alias has been created for the directory, <alias> is the directory identifier,
	// such as d-XXXXXXXXXX.
	AccessUrl *string `min:"1" type:"string"`

	// The alias for the directory. If no alias has been created for the directory,
	// the alias is the directory identifier, such as d-XXXXXXXXXX.
	Alias *string `min:"1" type:"string"`

	// A DirectoryConnectSettingsDescription object that contains additional information
	// about an AD Connector directory. This member is only present if the directory
	// is an AD Connector directory.
	ConnectSettings *DirectoryConnectSettingsDescription `type:"structure"`

	// The description for the directory.
	Description *string `type:"string"`

	// The desired number of domain controllers in the directory if the directory
	// is Microsoft AD.
	DesiredNumberOfDomainControllers *int64 `min:"2" type:"integer"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The IP addresses of the DNS servers for the directory. For a Simple AD or
	// Microsoft AD directory, these are the IP addresses of the Simple AD or Microsoft
	// AD directory servers. For an AD Connector directory, these are the IP addresses
	// of the DNS servers or domain controllers in the on-premises directory to
	// which the AD Connector is connected.
	DnsIpAddrs []*string `type:"list"`

	// The edition associated with this directory.
	Edition *string `type:"string" enum:"DirectoryEdition"`

	// Specifies when the directory was created.
	LaunchTime *time.Time `type:"timestamp"`

	// The fully qualified name of the directory.
	Name *string `type:"string"`

	// Describes the AWS Managed Microsoft AD directory in the directory owner account.
	OwnerDirectoryDescription *OwnerDirectoryDescription `type:"structure"`

	// A RadiusSettings object that contains information about the RADIUS server
	// configured for this directory.
	RadiusSettings *RadiusSettings `type:"structure"`

	// The status of the RADIUS MFA server connection.
	RadiusStatus *string `type:"string" enum:"RadiusStatus"`

	// Lists the Regions where the directory has replicated.
	RegionsInfo *RegionsInfo `type:"structure"`

	// The method used when sharing a directory to determine whether the directory
	// should be shared within your AWS organization (ORGANIZATIONS) or with any
	// AWS account by sending a shared directory request (HANDSHAKE).
	ShareMethod *string `type:"string" enum:"ShareMethod"`

	// A directory share request that is sent by the directory owner to the directory
	// consumer. The request includes a typed message to help the directory consumer
	// administrator determine whether to approve or reject the share invitation.
	ShareNotes *string `type:"string" sensitive:"true"`

	// Current directory status of the shared AWS Managed Microsoft AD directory.
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// The short name of the directory.
	ShortName *string `type:"string"`

	// The directory size.
	Size *string `type:"string" enum:"DirectorySize"`

	// Indicates if single sign-on is enabled for the directory. For more information,
	// see EnableSso and DisableSso.
	SsoEnabled *bool `type:"boolean"`

	// The current stage of the directory.
	Stage *string `type:"string" enum:"DirectoryStage"`

	// The date and time that the stage was last updated.
	StageLastUpdatedDateTime *time.Time `type:"timestamp"`

	// Additional information about the directory stage.
	StageReason *string `type:"string"`

	// The directory size.
	Type *string `type:"string" enum:"DirectoryType"`

	// A DirectoryVpcSettingsDescription object that contains additional information
	// about a directory. This member is only present if the directory is a Simple
	// AD or Managed AD directory.
	VpcSettings *DirectoryVpcSettingsDescription `type:"structure"`
}

// String returns the string representation
func (s DirectoryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryDescription) GoString() string {
	return s.String()
}

// SetAccessUrl sets the AccessUrl field's value.
func (s *DirectoryDescription) SetAccessUrl(v string) *DirectoryDescription {
	s.AccessUrl = &v
	return s
}

// SetAlias sets the Alias field's value.
func (s *DirectoryDescription) SetAlias(v string) *DirectoryDescription {
	s.Alias = &v
	return s
}

// SetConnectSettings sets the ConnectSettings field's value.
func (s *DirectoryDescription) SetConnectSettings(v *DirectoryConnectSettingsDescription) *DirectoryDescription {
	s.ConnectSettings = v
	return s
}

// SetDescription sets the Description field's value.
func (s *DirectoryDescription) SetDescription(v string) *DirectoryDescription {
	s.Description = &v
	return s
}

// SetDesiredNumberOfDomainControllers sets the DesiredNumberOfDomainControllers field's value.
func (s *DirectoryDescription) SetDesiredNumberOfDomainControllers(v int64) *DirectoryDescription {
	s.DesiredNumberOfDomainControllers = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DirectoryDescription) SetDirectoryId(v string) *DirectoryDescription {
	s.DirectoryId = &v
	return s
}

// SetDnsIpAddrs sets the DnsIpAddrs field's value.
func (s *DirectoryDescription) SetDnsIpAddrs(v []*string) *DirectoryDescription {
	s.DnsIpAddrs = v
	return s
}

// SetEdition sets the Edition field's value.
func (s *DirectoryDescription) SetEdition(v string) *DirectoryDescription {
	s.Edition = &v
	return s
}

// SetLaunchTime sets the LaunchTime field's value.
func (s *DirectoryDescription) SetLaunchTime(v time.Time) *DirectoryDescription {
	s.LaunchTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DirectoryDescription) SetName(v string) *DirectoryDescription {
	s.Name = &v
	return s
}

// SetOwnerDirectoryDescription sets the OwnerDirectoryDescription field's value.
func (s *DirectoryDescription) SetOwnerDirectoryDescription(v *OwnerDirectoryDescription) *DirectoryDescription {
	s.OwnerDirectoryDescription = v
	return s
}

// SetRadiusSettings sets the RadiusSettings field's value.
func (s *DirectoryDescription) SetRadiusSettings(v *RadiusSettings) *DirectoryDescription {
	s.RadiusSettings = v
	return s
}

// SetRadiusStatus sets the RadiusStatus field's value.
func (s *DirectoryDescription) SetRadiusStatus(v string) *DirectoryDescription {
	s.RadiusStatus = &v
	return s
}

// SetRegionsInfo sets the RegionsInfo field's value.
func (s *DirectoryDescription) SetRegionsInfo(v *RegionsInfo) *DirectoryDescription {
	s.RegionsInfo = v
	return s
}

// SetShareMethod sets the ShareMethod field's value.
func (s *DirectoryDescription) SetShareMethod(v string) *DirectoryDescription {
	s.ShareMethod = &v
	return s
}

// SetShareNotes sets the ShareNotes field's value.
func (s *DirectoryDescription) SetShareNotes(v string) *DirectoryDescription {
	s.ShareNotes = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *DirectoryDescription) SetShareStatus(v string) *DirectoryDescription {
	s.ShareStatus = &v
	return s
}

// SetShortName sets the ShortName field's value.
func (s *DirectoryDescription) SetShortName(v string) *DirectoryDescription {
	s.ShortName = &v
	return s
}

// SetSize sets the Size field's value.
func (s *DirectoryDescription) SetSize(v string) *DirectoryDescription {
	s.Size = &v
	return s
}

// SetSsoEnabled sets the SsoEnabled field's value.
func (s *DirectoryDescription) SetSsoEnabled(v bool) *DirectoryDescription {
	s.SsoEnabled = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *DirectoryDescription) SetStage(v string) *DirectoryDescription {
	s.Stage = &v
	return s
}

// SetStageLastUpdatedDateTime sets the StageLastUpdatedDateTime field's value.
func (s *DirectoryDescription) SetStageLastUpdatedDateTime(v time.Time) *DirectoryDescription {
	s.StageLastUpdatedDateTime = &v
	return s
}

// SetStageReason sets the StageReason field's value.
func (s *DirectoryDescription) SetStageReason(v string) *DirectoryDescription {
	s.StageReason = &v
	return s
}

// SetType sets the Type field's value.
func (s *DirectoryDescription) SetType(v string) *DirectoryDescription {
	s.Type = &v
	return s
}

// SetVpcSettings sets the VpcSettings field's value.
func (s *DirectoryDescription) SetVpcSettings(v *DirectoryVpcSettingsDescription) *DirectoryDescription {
	s.VpcSettings = v
	return s
}

// The specified directory does not exist in the system.
type DirectoryDoesNotExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryDoesNotExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryDoesNotExistException) GoString() string {
	return s.String()
}

func newErrorDirectoryDoesNotExistException(v protocol.ResponseMetadata) error {
	return &DirectoryDoesNotExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryDoesNotExistException) Code() string {
	return "DirectoryDoesNotExistException"
}

// Message returns the exception's message.
func (s *DirectoryDoesNotExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryDoesNotExistException) OrigErr() error {
	return nil
}

func (s *DirectoryDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryDoesNotExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryDoesNotExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum number of directories in the region has been reached. You can
// use the GetDirectoryLimits operation to determine your directory limits in
// the region.
type DirectoryLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryLimitExceededException) GoString() string {
	return s.String()
}

func newErrorDirectoryLimitExceededException(v protocol.ResponseMetadata) error {
	return &DirectoryLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryLimitExceededException) Code() string {
	return "DirectoryLimitExceededException"
}

// Message returns the exception's message.
func (s *DirectoryLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryLimitExceededException) OrigErr() error {
	return nil
}

func (s *DirectoryLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains directory limit information for a Region.
type DirectoryLimits struct {
	_ struct{} `type:"structure"`

	// The current number of cloud directories in the Region.
	CloudOnlyDirectoriesCurrentCount *int64 `type:"integer"`

	// The maximum number of cloud directories allowed in the Region.
	CloudOnlyDirectoriesLimit *int64 `type:"integer"`

	// Indicates if the cloud directory limit has been reached.
	CloudOnlyDirectoriesLimitReached *bool `type:"boolean"`

	// The current number of AWS Managed Microsoft AD directories in the region.
	CloudOnlyMicrosoftADCurrentCount *int64 `type:"integer"`

	// The maximum number of AWS Managed Microsoft AD directories allowed in the
	// region.
	CloudOnlyMicrosoftADLimit *int64 `type:"integer"`

	// Indicates if the AWS Managed Microsoft AD directory limit has been reached.
	CloudOnlyMicrosoftADLimitReached *bool `type:"boolean"`

	// The current number of connected directories in the Region.
	ConnectedDirectoriesCurrentCount *int64 `type:"integer"`

	// The maximum number of connected directories allowed in the Region.
	ConnectedDirectoriesLimit *int64 `type:"integer"`

	// Indicates if the connected directory limit has been reached.
	ConnectedDirectoriesLimitReached *bool `type:"boolean"`
}

// String returns the string representation
func (s DirectoryLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryLimits) GoString() string {
	return s.String()
}

// SetCloudOnlyDirectoriesCurrentCount sets the CloudOnlyDirectoriesCurrentCount field's value.
func (s *DirectoryLimits) SetCloudOnlyDirectoriesCurrentCount(v int64) *DirectoryLimits {
	s.CloudOnlyDirectoriesCurrentCount = &v
	return s
}

// SetCloudOnlyDirectoriesLimit sets the CloudOnlyDirectoriesLimit field's value.
func (s *DirectoryLimits) SetCloudOnlyDirectoriesLimit(v int64) *DirectoryLimits {
	s.CloudOnlyDirectoriesLimit = &v
	return s
}

// SetCloudOnlyDirectoriesLimitReached sets the CloudOnlyDirectoriesLimitReached field's value.
func (s *DirectoryLimits) SetCloudOnlyDirectoriesLimitReached(v bool) *DirectoryLimits {
	s.CloudOnlyDirectoriesLimitReached = &v
	return s
}

// SetCloudOnlyMicrosoftADCurrentCount sets the CloudOnlyMicrosoftADCurrentCount field's value.
func (s *DirectoryLimits) SetCloudOnlyMicrosoftADCurrentCount(v int64) *DirectoryLimits {
	s.CloudOnlyMicrosoftADCurrentCount = &v
	return s
}

// SetCloudOnlyMicrosoftADLimit sets the CloudOnlyMicrosoftADLimit field's value.
func (s *DirectoryLimits) SetCloudOnlyMicrosoftADLimit(v int64) *DirectoryLimits {
	s.CloudOnlyMicrosoftADLimit = &v
	return s
}

// SetCloudOnlyMicrosoftADLimitReached sets the CloudOnlyMicrosoftADLimitReached field's value.
func (s *DirectoryLimits) SetCloudOnlyMicrosoftADLimitReached(v bool) *DirectoryLimits {
	s.CloudOnlyMicrosoftADLimitReached = &v
	return s
}

// SetConnectedDirectoriesCurrentCount sets the ConnectedDirectoriesCurrentCount field's value.
func (s *DirectoryLimits) SetConnectedDirectoriesCurrentCount(v int64) *DirectoryLimits {
	s.ConnectedDirectoriesCurrentCount = &v
	return s
}

// SetConnectedDirectoriesLimit sets the ConnectedDirectoriesLimit field's value.
func (s *DirectoryLimits) SetConnectedDirectoriesLimit(v int64) *DirectoryLimits {
	s.ConnectedDirectoriesLimit = &v
	return s
}

// SetConnectedDirectoriesLimitReached sets the ConnectedDirectoriesLimitReached field's value.
func (s *DirectoryLimits) SetConnectedDirectoriesLimitReached(v bool) *DirectoryLimits {
	s.ConnectedDirectoriesLimitReached = &v
	return s
}

// The specified directory has not been shared with this AWS account.
type DirectoryNotSharedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryNotSharedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryNotSharedException) GoString() string {
	return s.String()
}

func newErrorDirectoryNotSharedException(v protocol.ResponseMetadata) error {
	return &DirectoryNotSharedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryNotSharedException) Code() string {
	return "DirectoryNotSharedException"
}

// Message returns the exception's message.
func (s *DirectoryNotSharedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryNotSharedException) OrigErr() error {
	return nil
}

func (s *DirectoryNotSharedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryNotSharedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryNotSharedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified directory is unavailable or could not be found.
type DirectoryUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryUnavailableException) GoString() string {
	return s.String()
}

func newErrorDirectoryUnavailableException(v protocol.ResponseMetadata) error {
	return &DirectoryUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DirectoryUnavailableException) Code() string {
	return "DirectoryUnavailableException"
}

// Message returns the exception's message.
func (s *DirectoryUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DirectoryUnavailableException) OrigErr() error {
	return nil
}

func (s *DirectoryUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DirectoryUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DirectoryUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains VPC information for the CreateDirectory or CreateMicrosoftAD operation.
type DirectoryVpcSettings struct {
	_ struct{} `type:"structure"`

	// The identifiers of the subnets for the directory servers. The two subnets
	// must be in different Availability Zones. AWS Directory Service creates a
	// directory server and a DNS server in each of these subnets.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// The identifier of the VPC in which to create the directory.
	//
	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DirectoryVpcSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryVpcSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DirectoryVpcSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DirectoryVpcSettings"}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DirectoryVpcSettings) SetSubnetIds(v []*string) *DirectoryVpcSettings {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DirectoryVpcSettings) SetVpcId(v string) *DirectoryVpcSettings {
	s.VpcId = &v
	return s
}

// Contains information about the directory.
type DirectoryVpcSettingsDescription struct {
	_ struct{} `type:"structure"`

	// The list of Availability Zones that the directory is in.
	AvailabilityZones []*string `type:"list"`

	// The domain controller security group identifier for the directory.
	SecurityGroupId *string `type:"string"`

	// The identifiers of the subnets for the directory servers.
	SubnetIds []*string `type:"list"`

	// The identifier of the VPC that the directory is in.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DirectoryVpcSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryVpcSettingsDescription) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DirectoryVpcSettingsDescription) SetAvailabilityZones(v []*string) *DirectoryVpcSettingsDescription {
	s.AvailabilityZones = v
	return s
}

// SetSecurityGroupId sets the SecurityGroupId field's value.
func (s *DirectoryVpcSettingsDescription) SetSecurityGroupId(v string) *DirectoryVpcSettingsDescription {
	s.SecurityGroupId = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *DirectoryVpcSettingsDescription) SetSubnetIds(v []*string) *DirectoryVpcSettingsDescription {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DirectoryVpcSettingsDescription) SetVpcId(v string) *DirectoryVpcSettingsDescription {
	s.VpcId = &v
	return s
}

type DisableClientAuthenticationInput struct {
	_ struct{} `type:"structure"`

	// Disable client authentication in a specified directory for smart cards.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Disable the type of client authentication request.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ClientAuthenticationType"`
}

// String returns the string representation
func (s DisableClientAuthenticationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableClientAuthenticationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableClientAuthenticationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableClientAuthenticationInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DisableClientAuthenticationInput) SetDirectoryId(v string) *DisableClientAuthenticationInput {
	s.DirectoryId = &v
	return s
}

// SetType sets the Type field's value.
func (s *DisableClientAuthenticationInput) SetType(v string) *DisableClientAuthenticationInput {
	s.Type = &v
	return s
}

type DisableClientAuthenticationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableClientAuthenticationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableClientAuthenticationOutput) GoString() string {
	return s.String()
}

type DisableLDAPSInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The type of LDAP security to enable. Currently only the value Client is supported.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"LDAPSType"`
}

// String returns the string representation
func (s DisableLDAPSInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableLDAPSInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableLDAPSInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableLDAPSInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DisableLDAPSInput) SetDirectoryId(v string) *DisableLDAPSInput {
	s.DirectoryId = &v
	return s
}

// SetType sets the Type field's value.
func (s *DisableLDAPSInput) SetType(v string) *DisableLDAPSInput {
	s.Type = &v
	return s
}

type DisableLDAPSOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableLDAPSOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableLDAPSOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DisableRadius operation.
type DisableRadiusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to disable MFA.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRadiusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableRadiusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableRadiusInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DisableRadiusInput) SetDirectoryId(v string) *DisableRadiusInput {
	s.DirectoryId = &v
	return s
}

// Contains the results of the DisableRadius operation.
type DisableRadiusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRadiusOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DisableSso operation.
type DisableSsoInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to disable single-sign on.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The password of an alternate account to use to disable single-sign on. This
	// is only used for AD Connector directories. For more information, see the
	// UserName parameter.
	Password *string `min:"1" type:"string" sensitive:"true"`

	// The username of an alternate account to use to disable single-sign on. This
	// is only used for AD Connector directories. This account must have privileges
	// to remove a service principal name.
	//
	// If the AD Connector service account does not have privileges to remove a
	// service principal name, you can specify an alternate account with the UserName
	// and Password parameters. These credentials are only used to disable single
	// sign-on and are not stored by the service. The AD Connector service account
	// is not changed.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DisableSsoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSsoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableSsoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableSsoInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DisableSsoInput) SetDirectoryId(v string) *DisableSsoInput {
	s.DirectoryId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *DisableSsoInput) SetPassword(v string) *DisableSsoInput {
	s.Password = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DisableSsoInput) SetUserName(v string) *DisableSsoInput {
	s.UserName = &v
	return s
}

// Contains the results of the DisableSso operation.
type DisableSsoOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableSsoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSsoOutput) GoString() string {
	return s.String()
}

// Contains information about the domain controllers for a specified directory.
type DomainController struct {
	_ struct{} `type:"structure"`

	// The Availability Zone where the domain controller is located.
	AvailabilityZone *string `type:"string"`

	// Identifier of the directory where the domain controller resides.
	DirectoryId *string `type:"string"`

	// The IP address of the domain controller.
	DnsIpAddr *string `type:"string"`

	// Identifies a specific domain controller in the directory.
	DomainControllerId *string `type:"string"`

	// Specifies when the domain controller was created.
	LaunchTime *time.Time `type:"timestamp"`

	// The status of the domain controller.
	Status *string `type:"string" enum:"DomainControllerStatus"`

	// The date and time that the status was last updated.
	StatusLastUpdatedDateTime *time.Time `type:"timestamp"`

	// A description of the domain controller state.
	StatusReason *string `type:"string"`

	// Identifier of the subnet in the VPC that contains the domain controller.
	SubnetId *string `type:"string"`

	// The identifier of the VPC that contains the domain controller.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DomainController) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainController) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *DomainController) SetAvailabilityZone(v string) *DomainController {
	s.AvailabilityZone = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DomainController) SetDirectoryId(v string) *DomainController {
	s.DirectoryId = &v
	return s
}

// SetDnsIpAddr sets the DnsIpAddr field's value.
func (s *DomainController) SetDnsIpAddr(v string) *DomainController {
	s.DnsIpAddr = &v
	return s
}

// SetDomainControllerId sets the DomainControllerId field's value.
func (s *DomainController) SetDomainControllerId(v string) *DomainController {
	s.DomainControllerId = &v
	return s
}

// SetLaunchTime sets the LaunchTime field's value.
func (s *DomainController) SetLaunchTime(v time.Time) *DomainController {
	s.LaunchTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainController) SetStatus(v string) *DomainController {
	s.Status = &v
	return s
}

// SetStatusLastUpdatedDateTime sets the StatusLastUpdatedDateTime field's value.
func (s *DomainController) SetStatusLastUpdatedDateTime(v time.Time) *DomainController {
	s.StatusLastUpdatedDateTime = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DomainController) SetStatusReason(v string) *DomainController {
	s.StatusReason = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *DomainController) SetSubnetId(v string) *DomainController {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *DomainController) SetVpcId(v string) *DomainController {
	s.VpcId = &v
	return s
}

// The maximum allowed number of domain controllers per directory was exceeded.
// The default limit per directory is 20 domain controllers.
type DomainControllerLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s DomainControllerLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainControllerLimitExceededException) GoString() string {
	return s.String()
}

func newErrorDomainControllerLimitExceededException(v protocol.ResponseMetadata) error {
	return &DomainControllerLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DomainControllerLimitExceededException) Code() string {
	return "DomainControllerLimitExceededException"
}

// Message returns the exception's message.
func (s *DomainControllerLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DomainControllerLimitExceededException) OrigErr() error {
	return nil
}

func (s *DomainControllerLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DomainControllerLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DomainControllerLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type EnableClientAuthenticationInput struct {
	_ struct{} `type:"structure"`

	// Enable client authentication in a specified directory for smart cards.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Enable the type of client authentication request.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ClientAuthenticationType"`
}

// String returns the string representation
func (s EnableClientAuthenticationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableClientAuthenticationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableClientAuthenticationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableClientAuthenticationInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *EnableClientAuthenticationInput) SetDirectoryId(v string) *EnableClientAuthenticationInput {
	s.DirectoryId = &v
	return s
}

// SetType sets the Type field's value.
func (s *EnableClientAuthenticationInput) SetType(v string) *EnableClientAuthenticationInput {
	s.Type = &v
	return s
}

type EnableClientAuthenticationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableClientAuthenticationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableClientAuthenticationOutput) GoString() string {
	return s.String()
}

type EnableLDAPSInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The type of LDAP security to enable. Currently only the value Client is supported.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"LDAPSType"`
}

// String returns the string representation
func (s EnableLDAPSInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableLDAPSInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableLDAPSInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableLDAPSInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *EnableLDAPSInput) SetDirectoryId(v string) *EnableLDAPSInput {
	s.DirectoryId = &v
	return s
}

// SetType sets the Type field's value.
func (s *EnableLDAPSInput) SetType(v string) *EnableLDAPSInput {
	s.Type = &v
	return s
}

type EnableLDAPSOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableLDAPSOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableLDAPSOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the EnableRadius operation.
type EnableRadiusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to enable MFA.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// A RadiusSettings object that contains information about the RADIUS server.
	//
	// RadiusSettings is a required field
	RadiusSettings *RadiusSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s EnableRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRadiusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableRadiusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableRadiusInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RadiusSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("RadiusSettings"))
	}
	if s.RadiusSettings != nil {
		if err := s.RadiusSettings.Validate(); err != nil {
			invalidParams.AddNested("RadiusSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *EnableRadiusInput) SetDirectoryId(v string) *EnableRadiusInput {
	s.DirectoryId = &v
	return s
}

// SetRadiusSettings sets the RadiusSettings field's value.
func (s *EnableRadiusInput) SetRadiusSettings(v *RadiusSettings) *EnableRadiusInput {
	s.RadiusSettings = v
	return s
}

// Contains the results of the EnableRadius operation.
type EnableRadiusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRadiusOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the EnableSso operation.
type EnableSsoInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to enable single-sign on.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The password of an alternate account to use to enable single-sign on. This
	// is only used for AD Connector directories. For more information, see the
	// UserName parameter.
	Password *string `min:"1" type:"string" sensitive:"true"`

	// The username of an alternate account to use to enable single-sign on. This
	// is only used for AD Connector directories. This account must have privileges
	// to add a service principal name.
	//
	// If the AD Connector service account does not have privileges to add a service
	// principal name, you can specify an alternate account with the UserName and
	// Password parameters. These credentials are only used to enable single sign-on
	// and are not stored by the service. The AD Connector service account is not
	// changed.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnableSsoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSsoInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableSsoInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableSsoInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *EnableSsoInput) SetDirectoryId(v string) *EnableSsoInput {
	s.DirectoryId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *EnableSsoInput) SetPassword(v string) *EnableSsoInput {
	s.Password = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *EnableSsoInput) SetUserName(v string) *EnableSsoInput {
	s.UserName = &v
	return s
}

// Contains the results of the EnableSso operation.
type EnableSsoOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableSsoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSsoOutput) GoString() string {
	return s.String()
}

// The specified entity already exists.
type EntityAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s EntityAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorEntityAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &EntityAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EntityAlreadyExistsException) Code() string {
	return "EntityAlreadyExistsException"
}

// Message returns the exception's message.
func (s *EntityAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EntityAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *EntityAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EntityAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EntityAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified entity could not be found.
type EntityDoesNotExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s EntityDoesNotExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityDoesNotExistException) GoString() string {
	return s.String()
}

func newErrorEntityDoesNotExistException(v protocol.ResponseMetadata) error {
	return &EntityDoesNotExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *EntityDoesNotExistException) Code() string {
	return "EntityDoesNotExistException"
}

// Message returns the exception's message.
func (s *EntityDoesNotExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *EntityDoesNotExistException) OrigErr() error {
	return nil
}

func (s *EntityDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *EntityDoesNotExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *EntityDoesNotExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about SNS topic and AWS Directory Service directory associations.
type EventTopic struct {
	_ struct{} `type:"structure"`

	// The date and time of when you associated your directory with the SNS topic.
	CreatedDateTime *time.Time `type:"timestamp"`

	// The Directory ID of an AWS Directory Service directory that will publish
	// status messages to an SNS topic.
	DirectoryId *string `type:"string"`

	// The topic registration status.
	Status *string `type:"string" enum:"TopicStatus"`

	// The SNS topic ARN (Amazon Resource Name).
	TopicArn *string `type:"string"`

	// The name of an AWS SNS topic the receives status messages from the directory.
	TopicName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EventTopic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventTopic) GoString() string {
	return s.String()
}

// SetCreatedDateTime sets the CreatedDateTime field's value.
func (s *EventTopic) SetCreatedDateTime(v time.Time) *EventTopic {
	s.CreatedDateTime = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *EventTopic) SetDirectoryId(v string) *EventTopic {
	s.DirectoryId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventTopic) SetStatus(v string) *EventTopic {
	s.Status = &v
	return s
}

// SetTopicArn sets the TopicArn field's value.
func (s *EventTopic) SetTopicArn(v string) *EventTopic {
	s.TopicArn = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *EventTopic) SetTopicName(v string) *EventTopic {
	s.TopicName = &v
	return s
}

// Contains the inputs for the GetDirectoryLimits operation.
type GetDirectoryLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetDirectoryLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDirectoryLimitsInput) GoString() string {
	return s.String()
}

// Contains the results of the GetDirectoryLimits operation.
type GetDirectoryLimitsOutput struct {
	_ struct{} `type:"structure"`

	// A DirectoryLimits object that contains the directory limits for the current
	// rRegion.
	DirectoryLimits *DirectoryLimits `type:"structure"`
}

// String returns the string representation
func (s GetDirectoryLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDirectoryLimitsOutput) GoString() string {
	return s.String()
}

// SetDirectoryLimits sets the DirectoryLimits field's value.
func (s *GetDirectoryLimitsOutput) SetDirectoryLimits(v *DirectoryLimits) *GetDirectoryLimitsOutput {
	s.DirectoryLimits = v
	return s
}

// Contains the inputs for the GetSnapshotLimits operation.
type GetSnapshotLimitsInput struct {
	_ struct{} `type:"structure"`

	// Contains the identifier of the directory to obtain the limits for.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetSnapshotLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnapshotLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSnapshotLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSnapshotLimitsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *GetSnapshotLimitsInput) SetDirectoryId(v string) *GetSnapshotLimitsInput {
	s.DirectoryId = &v
	return s
}

// Contains the results of the GetSnapshotLimits operation.
type GetSnapshotLimitsOutput struct {
	_ struct{} `type:"structure"`

	// A SnapshotLimits object that contains the manual snapshot limits for the
	// specified directory.
	SnapshotLimits *SnapshotLimits `type:"structure"`
}

// String returns the string representation
func (s GetSnapshotLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnapshotLimitsOutput) GoString() string {
	return s.String()
}

// SetSnapshotLimits sets the SnapshotLimits field's value.
func (s *GetSnapshotLimitsOutput) SetSnapshotLimits(v *SnapshotLimits) *GetSnapshotLimitsOutput {
	s.SnapshotLimits = v
	return s
}

// The account does not have sufficient permission to perform the operation.
type InsufficientPermissionsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s InsufficientPermissionsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsufficientPermissionsException) GoString() string {
	return s.String()
}

func newErrorInsufficientPermissionsException(v protocol.ResponseMetadata) error {
	return &InsufficientPermissionsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientPermissionsException) Code() string {
	return "InsufficientPermissionsException"
}

// Message returns the exception's message.
func (s *InsufficientPermissionsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientPermissionsException) OrigErr() error {
	return nil
}

func (s *InsufficientPermissionsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientPermissionsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientPermissionsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The certificate PEM that was provided has incorrect encoding.
type InvalidCertificateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s InvalidCertificateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidCertificateException) GoString() string {
	return s.String()
}

func newErrorInvalidCertificateException(v protocol.ResponseMetadata) error {
	return &InvalidCertificateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCertificateException) Code() string {
	return "InvalidCertificateException"
}

// Message returns the exception's message.
func (s *InvalidCertificateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCertificateException) OrigErr() error {
	return nil
}

func (s *InvalidCertificateException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCertificateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCertificateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The client authorization was invalid.
type InvalidClientAuthStatusException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s InvalidClientAuthStatusException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidClientAuthStatusException) GoString() string {
	return s.String()
}

func newErrorInvalidClientAuthStatusException(v protocol.ResponseMetadata) error {
	return &InvalidClientAuthStatusException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidClientAuthStatusException) Code() string {
	return "InvalidClientAuthStatusException"
}

// Message returns the exception's message.
func (s *InvalidClientAuthStatusException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidClientAuthStatusException) OrigErr() error {
	return nil
}

func (s *InvalidClientAuthStatusException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidClientAuthStatusException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidClientAuthStatusException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The LDAP activities could not be performed because they are limited by the
// LDAPS status.
type InvalidLDAPSStatusException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s InvalidLDAPSStatusException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidLDAPSStatusException) GoString() string {
	return s.String()
}

func newErrorInvalidLDAPSStatusException(v protocol.ResponseMetadata) error {
	return &InvalidLDAPSStatusException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidLDAPSStatusException) Code() string {
	return "InvalidLDAPSStatusException"
}

// Message returns the exception's message.
func (s *InvalidLDAPSStatusException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidLDAPSStatusException) OrigErr() error {
	return nil
}

func (s *InvalidLDAPSStatusException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidLDAPSStatusException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidLDAPSStatusException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The NextToken value is not valid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more parameters are not valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The new password provided by the user does not meet the password complexity
// requirements defined in your directory.
type InvalidPasswordException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s InvalidPasswordException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPasswordException) GoString() string {
	return s.String()
}

func newErrorInvalidPasswordException(v protocol.ResponseMetadata) error {
	return &InvalidPasswordException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPasswordException) Code() string {
	return "InvalidPasswordException"
}

// Message returns the exception's message.
func (s *InvalidPasswordException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPasswordException) OrigErr() error {
	return nil
}

func (s *InvalidPasswordException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPasswordException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPasswordException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified shared target is not valid.
type InvalidTargetException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s InvalidTargetException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidTargetException) GoString() string {
	return s.String()
}

func newErrorInvalidTargetException(v protocol.ResponseMetadata) error {
	return &InvalidTargetException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTargetException) Code() string {
	return "InvalidTargetException"
}

// Message returns the exception's message.
func (s *InvalidTargetException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTargetException) OrigErr() error {
	return nil
}

func (s *InvalidTargetException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTargetException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTargetException) RequestID() string {
	return s.RespMetadata.RequestID
}

// IP address block. This is often the address block of the DNS server used
// for your on-premises domain.
type IpRoute struct {
	_ struct{} `type:"structure"`

	// IP address block using CIDR format, for example 10.0.0.0/24. This is often
	// the address block of the DNS server used for your on-premises domain. For
	// a single IP address use a CIDR address block with /32. For example 10.0.0.0/32.
	CidrIp *string `type:"string"`

	// Description of the address block.
	Description *string `type:"string"`
}

// String returns the string representation
func (s IpRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpRoute) GoString() string {
	return s.String()
}

// SetCidrIp sets the CidrIp field's value.
func (s *IpRoute) SetCidrIp(v string) *IpRoute {
	s.CidrIp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IpRoute) SetDescription(v string) *IpRoute {
	s.Description = &v
	return s
}

// Information about one or more IP address blocks.
type IpRouteInfo struct {
	_ struct{} `type:"structure"`

	// The date and time the address block was added to the directory.
	AddedDateTime *time.Time `type:"timestamp"`

	// IP address block in the IpRoute.
	CidrIp *string `type:"string"`

	// Description of the IpRouteInfo.
	Description *string `type:"string"`

	// Identifier (ID) of the directory associated with the IP addresses.
	DirectoryId *string `type:"string"`

	// The status of the IP address block.
	IpRouteStatusMsg *string `type:"string" enum:"IpRouteStatusMsg"`

	// The reason for the IpRouteStatusMsg.
	IpRouteStatusReason *string `type:"string"`
}

// String returns the string representation
func (s IpRouteInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpRouteInfo) GoString() string {
	return s.String()
}

// SetAddedDateTime sets the AddedDateTime field's value.
func (s *IpRouteInfo) SetAddedDateTime(v time.Time) *IpRouteInfo {
	s.AddedDateTime = &v
	return s
}

// SetCidrIp sets the CidrIp field's value.
func (s *IpRouteInfo) SetCidrIp(v string) *IpRouteInfo {
	s.CidrIp = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IpRouteInfo) SetDescription(v string) *IpRouteInfo {
	s.Description = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *IpRouteInfo) SetDirectoryId(v string) *IpRouteInfo {
	s.DirectoryId = &v
	return s
}

// SetIpRouteStatusMsg sets the IpRouteStatusMsg field's value.
func (s *IpRouteInfo) SetIpRouteStatusMsg(v string) *IpRouteInfo {
	s.IpRouteStatusMsg = &v
	return s
}

// SetIpRouteStatusReason sets the IpRouteStatusReason field's value.
func (s *IpRouteInfo) SetIpRouteStatusReason(v string) *IpRouteInfo {
	s.IpRouteStatusReason = &v
	return s
}

// The maximum allowed number of IP addresses was exceeded. The default limit
// is 100 IP address blocks.
type IpRouteLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s IpRouteLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IpRouteLimitExceededException) GoString() string {
	return s.String()
}

func newErrorIpRouteLimitExceededException(v protocol.ResponseMetadata) error {
	return &IpRouteLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IpRouteLimitExceededException) Code() string {
	return "IpRouteLimitExceededException"
}

// Message returns the exception's message.
func (s *IpRouteLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IpRouteLimitExceededException) OrigErr() error {
	return nil
}

func (s *IpRouteLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IpRouteLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IpRouteLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains general information about the LDAPS settings.
type LDAPSSettingInfo struct {
	_ struct{} `type:"structure"`

	// The state of the LDAPS settings.
	LDAPSStatus *string `type:"string" enum:"LDAPSStatus"`

	// Describes a state change for LDAPS.
	LDAPSStatusReason *string `type:"string"`

	// The date and time when the LDAPS settings were last updated.
	LastUpdatedDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s LDAPSSettingInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LDAPSSettingInfo) GoString() string {
	return s.String()
}

// SetLDAPSStatus sets the LDAPSStatus field's value.
func (s *LDAPSSettingInfo) SetLDAPSStatus(v string) *LDAPSSettingInfo {
	s.LDAPSStatus = &v
	return s
}

// SetLDAPSStatusReason sets the LDAPSStatusReason field's value.
func (s *LDAPSSettingInfo) SetLDAPSStatusReason(v string) *LDAPSSettingInfo {
	s.LDAPSStatusReason = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *LDAPSSettingInfo) SetLastUpdatedDateTime(v time.Time) *LDAPSSettingInfo {
	s.LastUpdatedDateTime = &v
	return s
}

type ListCertificatesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The number of items that should show up on one page
	Limit *int64 `min:"1" type:"integer"`

	// A token for requesting another page of certificates if the NextToken response
	// element indicates that more certificates are available. Use the value of
	// the returned NextToken element in your request until the token comes back
	// as null. Pass null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCertificatesInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ListCertificatesInput) SetDirectoryId(v string) *ListCertificatesInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListCertificatesInput) SetLimit(v int64) *ListCertificatesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCertificatesInput) SetNextToken(v string) *ListCertificatesInput {
	s.NextToken = &v
	return s
}

type ListCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of certificates with basic details including certificate ID, certificate
	// common name, certificate state.
	CertificatesInfo []*CertificateInfo `type:"list"`

	// Indicates whether another page of certificates is available when the number
	// of available certificates exceeds the page limit.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificatesInfo sets the CertificatesInfo field's value.
func (s *ListCertificatesOutput) SetCertificatesInfo(v []*CertificateInfo) *ListCertificatesOutput {
	s.CertificatesInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCertificatesOutput) SetNextToken(v string) *ListCertificatesOutput {
	s.NextToken = &v
	return s
}

type ListIpRoutesInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory for which you want to retrieve the IP addresses.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Maximum number of items to return. If this value is zero, the maximum number
	// of items is specified by the limitations of the operation.
	Limit *int64 `type:"integer"`

	// The ListIpRoutes.NextToken value from a previous call to ListIpRoutes. Pass
	// null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIpRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIpRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIpRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIpRoutesInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ListIpRoutesInput) SetDirectoryId(v string) *ListIpRoutesInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListIpRoutesInput) SetLimit(v int64) *ListIpRoutesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIpRoutesInput) SetNextToken(v string) *ListIpRoutesInput {
	s.NextToken = &v
	return s
}

type ListIpRoutesOutput struct {
	_ struct{} `type:"structure"`

	// A list of IpRoutes.
	IpRoutesInfo []*IpRouteInfo `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to ListIpRoutes to retrieve the next set of
	// items.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIpRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIpRoutesOutput) GoString() string {
	return s.String()
}

// SetIpRoutesInfo sets the IpRoutesInfo field's value.
func (s *ListIpRoutesOutput) SetIpRoutesInfo(v []*IpRouteInfo) *ListIpRoutesOutput {
	s.IpRoutesInfo = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIpRoutesOutput) SetNextToken(v string) *ListIpRoutesOutput {
	s.NextToken = &v
	return s
}

type ListLogSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// If a DirectoryID is provided, lists only the log subscription associated
	// with that directory. If no DirectoryId is provided, lists all log subscriptions
	// associated with your AWS account. If there are no log subscriptions for the
	// AWS account or the directory, an empty list will be returned.
	DirectoryId *string `type:"string"`

	// The maximum number of items returned.
	Limit *int64 `type:"integer"`

	// The token for the next set of items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLogSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLogSubscriptionsInput) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ListLogSubscriptionsInput) SetDirectoryId(v string) *ListLogSubscriptionsInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListLogSubscriptionsInput) SetLimit(v int64) *ListLogSubscriptionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogSubscriptionsInput) SetNextToken(v string) *ListLogSubscriptionsInput {
	s.NextToken = &v
	return s
}

type ListLogSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of active LogSubscription objects for calling the AWS account.
	LogSubscriptions []*LogSubscription `type:"list"`

	// The token for the next set of items to return.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListLogSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLogSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetLogSubscriptions sets the LogSubscriptions field's value.
func (s *ListLogSubscriptionsOutput) SetLogSubscriptions(v []*LogSubscription) *ListLogSubscriptionsOutput {
	s.LogSubscriptions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLogSubscriptionsOutput) SetNextToken(v string) *ListLogSubscriptionsOutput {
	s.NextToken = &v
	return s
}

type ListSchemaExtensionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory from which to retrieve the schema extension
	// information.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The maximum number of items to return.
	Limit *int64 `type:"integer"`

	// The ListSchemaExtensions.NextToken value from a previous call to ListSchemaExtensions.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListSchemaExtensionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSchemaExtensionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSchemaExtensionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSchemaExtensionsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ListSchemaExtensionsInput) SetDirectoryId(v string) *ListSchemaExtensionsInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListSchemaExtensionsInput) SetLimit(v int64) *ListSchemaExtensionsInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemaExtensionsInput) SetNextToken(v string) *ListSchemaExtensionsInput {
	s.NextToken = &v
	return s
}

type ListSchemaExtensionsOutput struct {
	_ struct{} `type:"structure"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to ListSchemaExtensions to retrieve the next
	// set of items.
	NextToken *string `type:"string"`

	// Information about the schema extensions applied to the directory.
	SchemaExtensionsInfo []*SchemaExtensionInfo `type:"list"`
}

// String returns the string representation
func (s ListSchemaExtensionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSchemaExtensionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSchemaExtensionsOutput) SetNextToken(v string) *ListSchemaExtensionsOutput {
	s.NextToken = &v
	return s
}

// SetSchemaExtensionsInfo sets the SchemaExtensionsInfo field's value.
func (s *ListSchemaExtensionsOutput) SetSchemaExtensionsInfo(v []*SchemaExtensionInfo) *ListSchemaExtensionsOutput {
	s.SchemaExtensionsInfo = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	Limit *int64 `type:"integer"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Identifier (ID) of the directory for which you want to retrieve tags.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListTagsForResourceInput) SetResourceId(v string) *ListTagsForResourceInput {
	s.ResourceId = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// List of tags returned by the ListTagsForResource operation.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Represents a log subscription, which tracks real-time data from a chosen
// log group to a specified destination.
type LogSubscription struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory that you want to associate with the log
	// subscription.
	DirectoryId *string `type:"string"`

	// The name of the log group.
	LogGroupName *string `min:"1" type:"string"`

	// The date and time that the log subscription was created.
	SubscriptionCreatedDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s LogSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogSubscription) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *LogSubscription) SetDirectoryId(v string) *LogSubscription {
	s.DirectoryId = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *LogSubscription) SetLogGroupName(v string) *LogSubscription {
	s.LogGroupName = &v
	return s
}

// SetSubscriptionCreatedDateTime sets the SubscriptionCreatedDateTime field's value.
func (s *LogSubscription) SetSubscriptionCreatedDateTime(v time.Time) *LogSubscription {
	s.SubscriptionCreatedDateTime = &v
	return s
}

// The LDAP activities could not be performed because at least one valid certificate
// must be registered with the system.
type NoAvailableCertificateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s NoAvailableCertificateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NoAvailableCertificateException) GoString() string {
	return s.String()
}

func newErrorNoAvailableCertificateException(v protocol.ResponseMetadata) error {
	return &NoAvailableCertificateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoAvailableCertificateException) Code() string {
	return "NoAvailableCertificateException"
}

// Message returns the exception's message.
func (s *NoAvailableCertificateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoAvailableCertificateException) OrigErr() error {
	return nil
}

func (s *NoAvailableCertificateException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoAvailableCertificateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoAvailableCertificateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Exception encountered while trying to access your AWS organization.
type OrganizationsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s OrganizationsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationsException) GoString() string {
	return s.String()
}

func newErrorOrganizationsException(v protocol.ResponseMetadata) error {
	return &OrganizationsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OrganizationsException) Code() string {
	return "OrganizationsException"
}

// Message returns the exception's message.
func (s *OrganizationsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OrganizationsException) OrigErr() error {
	return nil
}

func (s *OrganizationsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OrganizationsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OrganizationsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the directory owner account details that have been shared to the
// directory consumer account.
type OwnerDirectoryDescription struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory owner account.
	AccountId *string `type:"string"`

	// Identifier of the AWS Managed Microsoft AD directory in the directory owner
	// account.
	DirectoryId *string `type:"string"`

	// IP address of the directory’s domain controllers.
	DnsIpAddrs []*string `type:"list"`

	// A RadiusSettings object that contains information about the RADIUS server.
	RadiusSettings *RadiusSettings `type:"structure"`

	// Information about the status of the RADIUS server.
	RadiusStatus *string `type:"string" enum:"RadiusStatus"`

	// Information about the VPC settings for the directory.
	VpcSettings *DirectoryVpcSettingsDescription `type:"structure"`
}

// String returns the string representation
func (s OwnerDirectoryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OwnerDirectoryDescription) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *OwnerDirectoryDescription) SetAccountId(v string) *OwnerDirectoryDescription {
	s.AccountId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *OwnerDirectoryDescription) SetDirectoryId(v string) *OwnerDirectoryDescription {
	s.DirectoryId = &v
	return s
}

// SetDnsIpAddrs sets the DnsIpAddrs field's value.
func (s *OwnerDirectoryDescription) SetDnsIpAddrs(v []*string) *OwnerDirectoryDescription {
	s.DnsIpAddrs = v
	return s
}

// SetRadiusSettings sets the RadiusSettings field's value.
func (s *OwnerDirectoryDescription) SetRadiusSettings(v *RadiusSettings) *OwnerDirectoryDescription {
	s.RadiusSettings = v
	return s
}

// SetRadiusStatus sets the RadiusStatus field's value.
func (s *OwnerDirectoryDescription) SetRadiusStatus(v string) *OwnerDirectoryDescription {
	s.RadiusStatus = &v
	return s
}

// SetVpcSettings sets the VpcSettings field's value.
func (s *OwnerDirectoryDescription) SetVpcSettings(v *DirectoryVpcSettingsDescription) *OwnerDirectoryDescription {
	s.VpcSettings = v
	return s
}

// Contains information about a Remote Authentication Dial In User Service (RADIUS)
// server.
type RadiusSettings struct {
	_ struct{} `type:"structure"`

	// The protocol specified for your RADIUS endpoints.
	AuthenticationProtocol *string `type:"string" enum:"RadiusAuthenticationProtocol"`

	// Not currently used.
	DisplayLabel *string `min:"1" type:"string"`

	// The port that your RADIUS server is using for communications. Your on-premises
	// network must allow inbound traffic over this port from the AWS Directory
	// Service servers.
	RadiusPort *int64 `min:"1025" type:"integer"`

	// The maximum number of times that communication with the RADIUS server is
	// attempted.
	RadiusRetries *int64 `type:"integer"`

	// An array of strings that contains the fully qualified domain name (FQDN)
	// or IP addresses of the RADIUS server endpoints, or the FQDN or IP addresses
	// of your RADIUS server load balancer.
	RadiusServers []*string `type:"list"`

	// The amount of time, in seconds, to wait for the RADIUS server to respond.
	RadiusTimeout *int64 `min:"1" type:"integer"`

	// Required for enabling RADIUS on the directory.
	SharedSecret *string `min:"8" type:"string" sensitive:"true"`

	// Not currently used.
	UseSameUsername *bool `type:"boolean"`
}

// String returns the string representation
func (s RadiusSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RadiusSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RadiusSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RadiusSettings"}
	if s.DisplayLabel != nil && len(*s.DisplayLabel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayLabel", 1))
	}
	if s.RadiusPort != nil && *s.RadiusPort < 1025 {
		invalidParams.Add(request.NewErrParamMinValue("RadiusPort", 1025))
	}
	if s.RadiusTimeout != nil && *s.RadiusTimeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RadiusTimeout", 1))
	}
	if s.SharedSecret != nil && len(*s.SharedSecret) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("SharedSecret", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationProtocol sets the AuthenticationProtocol field's value.
func (s *RadiusSettings) SetAuthenticationProtocol(v string) *RadiusSettings {
	s.AuthenticationProtocol = &v
	return s
}

// SetDisplayLabel sets the DisplayLabel field's value.
func (s *RadiusSettings) SetDisplayLabel(v string) *RadiusSettings {
	s.DisplayLabel = &v
	return s
}

// SetRadiusPort sets the RadiusPort field's value.
func (s *RadiusSettings) SetRadiusPort(v int64) *RadiusSettings {
	s.RadiusPort = &v
	return s
}

// SetRadiusRetries sets the RadiusRetries field's value.
func (s *RadiusSettings) SetRadiusRetries(v int64) *RadiusSettings {
	s.RadiusRetries = &v
	return s
}

// SetRadiusServers sets the RadiusServers field's value.
func (s *RadiusSettings) SetRadiusServers(v []*string) *RadiusSettings {
	s.RadiusServers = v
	return s
}

// SetRadiusTimeout sets the RadiusTimeout field's value.
func (s *RadiusSettings) SetRadiusTimeout(v int64) *RadiusSettings {
	s.RadiusTimeout = &v
	return s
}

// SetSharedSecret sets the SharedSecret field's value.
func (s *RadiusSettings) SetSharedSecret(v string) *RadiusSettings {
	s.SharedSecret = &v
	return s
}

// SetUseSameUsername sets the UseSameUsername field's value.
func (s *RadiusSettings) SetUseSameUsername(v bool) *RadiusSettings {
	s.UseSameUsername = &v
	return s
}

// The replicated Region information for a directory.
type RegionDescription struct {
	_ struct{} `type:"structure"`

	// The desired number of domain controllers in the specified Region for the
	// specified directory.
	DesiredNumberOfDomainControllers *int64 `min:"2" type:"integer"`

	// The identifier of the directory.
	DirectoryId *string `type:"string"`

	// The date and time that the Region description was last updated.
	LastUpdatedDateTime *time.Time `type:"timestamp"`

	// Specifies when the Region replication began.
	LaunchTime *time.Time `type:"timestamp"`

	// The name of the Region. For example, us-east-1.
	RegionName *string `min:"8" type:"string"`

	// Specifies whether the Region is the primary Region or an additional Region.
	RegionType *string `type:"string" enum:"RegionType"`

	// The status of the replication process for the specified Region.
	Status *string `type:"string" enum:"DirectoryStage"`

	// The date and time that the Region status was last updated.
	StatusLastUpdatedDateTime *time.Time `type:"timestamp"`

	// Contains VPC information for the CreateDirectory or CreateMicrosoftAD operation.
	VpcSettings *DirectoryVpcSettings `type:"structure"`
}

// String returns the string representation
func (s RegionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegionDescription) GoString() string {
	return s.String()
}

// SetDesiredNumberOfDomainControllers sets the DesiredNumberOfDomainControllers field's value.
func (s *RegionDescription) SetDesiredNumberOfDomainControllers(v int64) *RegionDescription {
	s.DesiredNumberOfDomainControllers = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *RegionDescription) SetDirectoryId(v string) *RegionDescription {
	s.DirectoryId = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *RegionDescription) SetLastUpdatedDateTime(v time.Time) *RegionDescription {
	s.LastUpdatedDateTime = &v
	return s
}

// SetLaunchTime sets the LaunchTime field's value.
func (s *RegionDescription) SetLaunchTime(v time.Time) *RegionDescription {
	s.LaunchTime = &v
	return s
}

// SetRegionName sets the RegionName field's value.
func (s *RegionDescription) SetRegionName(v string) *RegionDescription {
	s.RegionName = &v
	return s
}

// SetRegionType sets the RegionType field's value.
func (s *RegionDescription) SetRegionType(v string) *RegionDescription {
	s.RegionType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RegionDescription) SetStatus(v string) *RegionDescription {
	s.Status = &v
	return s
}

// SetStatusLastUpdatedDateTime sets the StatusLastUpdatedDateTime field's value.
func (s *RegionDescription) SetStatusLastUpdatedDateTime(v time.Time) *RegionDescription {
	s.StatusLastUpdatedDateTime = &v
	return s
}

// SetVpcSettings sets the VpcSettings field's value.
func (s *RegionDescription) SetVpcSettings(v *DirectoryVpcSettings) *RegionDescription {
	s.VpcSettings = v
	return s
}

// You have reached the limit for maximum number of simultaneous Region replications
// per directory.
type RegionLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s RegionLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegionLimitExceededException) GoString() string {
	return s.String()
}

func newErrorRegionLimitExceededException(v protocol.ResponseMetadata) error {
	return &RegionLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RegionLimitExceededException) Code() string {
	return "RegionLimitExceededException"
}

// Message returns the exception's message.
func (s *RegionLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RegionLimitExceededException) OrigErr() error {
	return nil
}

func (s *RegionLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RegionLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RegionLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about the Regions that are configured for multi-Region
// replication.
type RegionsInfo struct {
	_ struct{} `type:"structure"`

	// Lists the Regions where the directory has been replicated, excluding the
	// primary Region.
	AdditionalRegions []*string `type:"list"`

	// The Region where the AWS Managed Microsoft AD directory was originally created.
	PrimaryRegion *string `min:"8" type:"string"`
}

// String returns the string representation
func (s RegionsInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegionsInfo) GoString() string {
	return s.String()
}

// SetAdditionalRegions sets the AdditionalRegions field's value.
func (s *RegionsInfo) SetAdditionalRegions(v []*string) *RegionsInfo {
	s.AdditionalRegions = v
	return s
}

// SetPrimaryRegion sets the PrimaryRegion field's value.
func (s *RegionsInfo) SetPrimaryRegion(v string) *RegionsInfo {
	s.PrimaryRegion = &v
	return s
}

type RegisterCertificateInput struct {
	_ struct{} `type:"structure"`

	// The certificate PEM string that needs to be registered.
	//
	// CertificateData is a required field
	CertificateData *string `min:"1" type:"string" required:"true"`

	// Contains information about the client certificate authentication settings,
	// such as ClientLDAPS or ClientCertAuth.
	ClientCertAuthSettings *ClientCertAuthSettings `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The certificate type to register for the request.
	Type *string `type:"string" enum:"CertificateType"`
}

// String returns the string representation
func (s RegisterCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterCertificateInput"}
	if s.CertificateData == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateData"))
	}
	if s.CertificateData != nil && len(*s.CertificateData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateData", 1))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.ClientCertAuthSettings != nil {
		if err := s.ClientCertAuthSettings.Validate(); err != nil {
			invalidParams.AddNested("ClientCertAuthSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateData sets the CertificateData field's value.
func (s *RegisterCertificateInput) SetCertificateData(v string) *RegisterCertificateInput {
	s.CertificateData = &v
	return s
}

// SetClientCertAuthSettings sets the ClientCertAuthSettings field's value.
func (s *RegisterCertificateInput) SetClientCertAuthSettings(v *ClientCertAuthSettings) *RegisterCertificateInput {
	s.ClientCertAuthSettings = v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *RegisterCertificateInput) SetDirectoryId(v string) *RegisterCertificateInput {
	s.DirectoryId = &v
	return s
}

// SetType sets the Type field's value.
func (s *RegisterCertificateInput) SetType(v string) *RegisterCertificateInput {
	s.Type = &v
	return s
}

type RegisterCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the certificate.
	CertificateId *string `type:"string"`
}

// String returns the string representation
func (s RegisterCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificateId sets the CertificateId field's value.
func (s *RegisterCertificateOutput) SetCertificateId(v string) *RegisterCertificateOutput {
	s.CertificateId = &v
	return s
}

// Registers a new event topic.
type RegisterEventTopicInput struct {
	_ struct{} `type:"structure"`

	// The Directory ID that will publish status messages to the SNS topic.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The SNS topic name to which the directory will publish status messages. This
	// SNS topic must be in the same region as the specified Directory ID.
	//
	// TopicName is a required field
	TopicName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterEventTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterEventTopicInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterEventTopicInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterEventTopicInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *RegisterEventTopicInput) SetDirectoryId(v string) *RegisterEventTopicInput {
	s.DirectoryId = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *RegisterEventTopicInput) SetTopicName(v string) *RegisterEventTopicInput {
	s.TopicName = &v
	return s
}

// The result of a RegisterEventTopic request.
type RegisterEventTopicOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterEventTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterEventTopicOutput) GoString() string {
	return s.String()
}

type RejectSharedDirectoryInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the shared directory in the directory consumer account. This
	// identifier is different for each directory owner account.
	//
	// SharedDirectoryId is a required field
	SharedDirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RejectSharedDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectSharedDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectSharedDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectSharedDirectoryInput"}
	if s.SharedDirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedDirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSharedDirectoryId sets the SharedDirectoryId field's value.
func (s *RejectSharedDirectoryInput) SetSharedDirectoryId(v string) *RejectSharedDirectoryInput {
	s.SharedDirectoryId = &v
	return s
}

type RejectSharedDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// Identifier of the shared directory in the directory consumer account.
	SharedDirectoryId *string `type:"string"`
}

// String returns the string representation
func (s RejectSharedDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RejectSharedDirectoryOutput) GoString() string {
	return s.String()
}

// SetSharedDirectoryId sets the SharedDirectoryId field's value.
func (s *RejectSharedDirectoryOutput) SetSharedDirectoryId(v string) *RejectSharedDirectoryOutput {
	s.SharedDirectoryId = &v
	return s
}

type RemoveIpRoutesInput struct {
	_ struct{} `type:"structure"`

	// IP address blocks that you want to remove.
	//
	// CidrIps is a required field
	CidrIps []*string `type:"list" required:"true"`

	// Identifier (ID) of the directory from which you want to remove the IP addresses.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveIpRoutesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveIpRoutesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveIpRoutesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveIpRoutesInput"}
	if s.CidrIps == nil {
		invalidParams.Add(request.NewErrParamRequired("CidrIps"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCidrIps sets the CidrIps field's value.
func (s *RemoveIpRoutesInput) SetCidrIps(v []*string) *RemoveIpRoutesInput {
	s.CidrIps = v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *RemoveIpRoutesInput) SetDirectoryId(v string) *RemoveIpRoutesInput {
	s.DirectoryId = &v
	return s
}

type RemoveIpRoutesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveIpRoutesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveIpRoutesOutput) GoString() string {
	return s.String()
}

type RemoveRegionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which you want to remove Region replication.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveRegionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRegionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveRegionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveRegionInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *RemoveRegionInput) SetDirectoryId(v string) *RemoveRegionInput {
	s.DirectoryId = &v
	return s
}

type RemoveRegionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveRegionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRegionOutput) GoString() string {
	return s.String()
}

type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifier (ID) of the directory from which to remove the tag.
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *RemoveTagsFromResourceInput) SetResourceId(v string) *RemoveTagsFromResourceInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

type ResetUserPasswordInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the AWS Managed Microsoft AD or Simple AD directory in which
	// the user resides.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The new password that will be reset.
	//
	// NewPassword is a required field
	NewPassword *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The user name of the user whose password will be reset.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetUserPasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetUserPasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetUserPasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetUserPasswordInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.NewPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPassword"))
	}
	if s.NewPassword != nil && len(*s.NewPassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewPassword", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ResetUserPasswordInput) SetDirectoryId(v string) *ResetUserPasswordInput {
	s.DirectoryId = &v
	return s
}

// SetNewPassword sets the NewPassword field's value.
func (s *ResetUserPasswordInput) SetNewPassword(v string) *ResetUserPasswordInput {
	s.NewPassword = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ResetUserPasswordInput) SetUserName(v string) *ResetUserPasswordInput {
	s.UserName = &v
	return s
}

type ResetUserPasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetUserPasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetUserPasswordOutput) GoString() string {
	return s.String()
}

// An object representing the inputs for the RestoreFromSnapshot operation.
type RestoreFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the snapshot to restore from.
	//
	// SnapshotId is a required field
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreFromSnapshotInput"}
	if s.SnapshotId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *RestoreFromSnapshotInput) SetSnapshotId(v string) *RestoreFromSnapshotInput {
	s.SnapshotId = &v
	return s
}

// Contains the results of the RestoreFromSnapshot operation.
type RestoreFromSnapshotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromSnapshotOutput) GoString() string {
	return s.String()
}

// Information about a schema extension.
type SchemaExtensionInfo struct {
	_ struct{} `type:"structure"`

	// A description of the schema extension.
	Description *string `type:"string"`

	// The identifier of the directory to which the schema extension is applied.
	DirectoryId *string `type:"string"`

	// The date and time that the schema extension was completed.
	EndDateTime *time.Time `type:"timestamp"`

	// The identifier of the schema extension.
	SchemaExtensionId *string `type:"string"`

	// The current status of the schema extension.
	SchemaExtensionStatus *string `type:"string" enum:"SchemaExtensionStatus"`

	// The reason for the SchemaExtensionStatus.
	SchemaExtensionStatusReason *string `type:"string"`

	// The date and time that the schema extension started being applied to the
	// directory.
	StartDateTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s SchemaExtensionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SchemaExtensionInfo) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SchemaExtensionInfo) SetDescription(v string) *SchemaExtensionInfo {
	s.Description = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *SchemaExtensionInfo) SetDirectoryId(v string) *SchemaExtensionInfo {
	s.DirectoryId = &v
	return s
}

// SetEndDateTime sets the EndDateTime field's value.
func (s *SchemaExtensionInfo) SetEndDateTime(v time.Time) *SchemaExtensionInfo {
	s.EndDateTime = &v
	return s
}

// SetSchemaExtensionId sets the SchemaExtensionId field's value.
func (s *SchemaExtensionInfo) SetSchemaExtensionId(v string) *SchemaExtensionInfo {
	s.SchemaExtensionId = &v
	return s
}

// SetSchemaExtensionStatus sets the SchemaExtensionStatus field's value.
func (s *SchemaExtensionInfo) SetSchemaExtensionStatus(v string) *SchemaExtensionInfo {
	s.SchemaExtensionStatus = &v
	return s
}

// SetSchemaExtensionStatusReason sets the SchemaExtensionStatusReason field's value.
func (s *SchemaExtensionInfo) SetSchemaExtensionStatusReason(v string) *SchemaExtensionInfo {
	s.SchemaExtensionStatusReason = &v
	return s
}

// SetStartDateTime sets the StartDateTime field's value.
func (s *SchemaExtensionInfo) SetStartDateTime(v time.Time) *SchemaExtensionInfo {
	s.StartDateTime = &v
	return s
}

// An exception has occurred in AWS Directory Service.
type ServiceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ServiceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceException) GoString() string {
	return s.String()
}

func newErrorServiceException(v protocol.ResponseMetadata) error {
	return &ServiceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceException) Code() string {
	return "ServiceException"
}

// Message returns the exception's message.
func (s *ServiceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceException) OrigErr() error {
	return nil
}

func (s *ServiceException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ShareDirectoryInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the AWS Managed Microsoft AD directory that you want to share
	// with other AWS accounts.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The method used when sharing a directory to determine whether the directory
	// should be shared within your AWS organization (ORGANIZATIONS) or with any
	// AWS account by sending a directory sharing request (HANDSHAKE).
	//
	// ShareMethod is a required field
	ShareMethod *string `type:"string" required:"true" enum:"ShareMethod"`

	// A directory share request that is sent by the directory owner to the directory
	// consumer. The request includes a typed message to help the directory consumer
	// administrator determine whether to approve or reject the share invitation.
	ShareNotes *string `type:"string" sensitive:"true"`

	// Identifier for the directory consumer account with whom the directory is
	// to be shared.
	//
	// ShareTarget is a required field
	ShareTarget *ShareTarget `type:"structure" required:"true"`
}

// String returns the string representation
func (s ShareDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShareDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShareDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ShareDirectoryInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.ShareMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareMethod"))
	}
	if s.ShareTarget == nil {
		invalidParams.Add(request.NewErrParamRequired("ShareTarget"))
	}
	if s.ShareTarget != nil {
		if err := s.ShareTarget.Validate(); err != nil {
			invalidParams.AddNested("ShareTarget", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *ShareDirectoryInput) SetDirectoryId(v string) *ShareDirectoryInput {
	s.DirectoryId = &v
	return s
}

// SetShareMethod sets the ShareMethod field's value.
func (s *ShareDirectoryInput) SetShareMethod(v string) *ShareDirectoryInput {
	s.ShareMethod = &v
	return s
}

// SetShareNotes sets the ShareNotes field's value.
func (s *ShareDirectoryInput) SetShareNotes(v string) *ShareDirectoryInput {
	s.ShareNotes = &v
	return s
}

// SetShareTarget sets the ShareTarget field's value.
func (s *ShareDirectoryInput) SetShareTarget(v *ShareTarget) *ShareDirectoryInput {
	s.ShareTarget = v
	return s
}

type ShareDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory that is stored in the directory consumer account
	// that is shared from the specified directory (DirectoryId).
	SharedDirectoryId *string `type:"string"`
}

// String returns the string representation
func (s ShareDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShareDirectoryOutput) GoString() string {
	return s.String()
}

// SetSharedDirectoryId sets the SharedDirectoryId field's value.
func (s *ShareDirectoryOutput) SetSharedDirectoryId(v string) *ShareDirectoryOutput {
	s.SharedDirectoryId = &v
	return s
}

// The maximum number of AWS accounts that you can share with this directory
// has been reached.
type ShareLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ShareLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShareLimitExceededException) GoString() string {
	return s.String()
}

func newErrorShareLimitExceededException(v protocol.ResponseMetadata) error {
	return &ShareLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ShareLimitExceededException) Code() string {
	return "ShareLimitExceededException"
}

// Message returns the exception's message.
func (s *ShareLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ShareLimitExceededException) OrigErr() error {
	return nil
}

func (s *ShareLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ShareLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ShareLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Identifier that contains details about the directory consumer account.
type ShareTarget struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory consumer account.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Type of identifier to be used in the Id field.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"TargetType"`
}

// String returns the string representation
func (s ShareTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShareTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ShareTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ShareTarget"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *ShareTarget) SetId(v string) *ShareTarget {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *ShareTarget) SetType(v string) *ShareTarget {
	s.Type = &v
	return s
}

// Details about the shared directory in the directory owner account for which
// the share request in the directory consumer account has been accepted.
type SharedDirectory struct {
	_ struct{} `type:"structure"`

	// The date and time that the shared directory was created.
	CreatedDateTime *time.Time `type:"timestamp"`

	// The date and time that the shared directory was last updated.
	LastUpdatedDateTime *time.Time `type:"timestamp"`

	// Identifier of the directory owner account, which contains the directory that
	// has been shared to the consumer account.
	OwnerAccountId *string `type:"string"`

	// Identifier of the directory in the directory owner account.
	OwnerDirectoryId *string `type:"string"`

	// The method used when sharing a directory to determine whether the directory
	// should be shared within your AWS organization (ORGANIZATIONS) or with any
	// AWS account by sending a shared directory request (HANDSHAKE).
	ShareMethod *string `type:"string" enum:"ShareMethod"`

	// A directory share request that is sent by the directory owner to the directory
	// consumer. The request includes a typed message to help the directory consumer
	// administrator determine whether to approve or reject the share invitation.
	ShareNotes *string `type:"string" sensitive:"true"`

	// Current directory status of the shared AWS Managed Microsoft AD directory.
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// Identifier of the directory consumer account that has access to the shared
	// directory (OwnerDirectoryId) in the directory owner account.
	SharedAccountId *string `type:"string"`

	// Identifier of the shared directory in the directory consumer account. This
	// identifier is different for each directory owner account.
	SharedDirectoryId *string `type:"string"`
}

// String returns the string representation
func (s SharedDirectory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedDirectory) GoString() string {
	return s.String()
}

// SetCreatedDateTime sets the CreatedDateTime field's value.
func (s *SharedDirectory) SetCreatedDateTime(v time.Time) *SharedDirectory {
	s.CreatedDateTime = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *SharedDirectory) SetLastUpdatedDateTime(v time.Time) *SharedDirectory {
	s.LastUpdatedDateTime = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *SharedDirectory) SetOwnerAccountId(v string) *SharedDirectory {
	s.OwnerAccountId = &v
	return s
}

// SetOwnerDirectoryId sets the OwnerDirectoryId field's value.
func (s *SharedDirectory) SetOwnerDirectoryId(v string) *SharedDirectory {
	s.OwnerDirectoryId = &v
	return s
}

// SetShareMethod sets the ShareMethod field's value.
func (s *SharedDirectory) SetShareMethod(v string) *SharedDirectory {
	s.ShareMethod = &v
	return s
}

// SetShareNotes sets the ShareNotes field's value.
func (s *SharedDirectory) SetShareNotes(v string) *SharedDirectory {
	s.ShareNotes = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *SharedDirectory) SetShareStatus(v string) *SharedDirectory {
	s.ShareStatus = &v
	return s
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *SharedDirectory) SetSharedAccountId(v string) *SharedDirectory {
	s.SharedAccountId = &v
	return s
}

// SetSharedDirectoryId sets the SharedDirectoryId field's value.
func (s *SharedDirectory) SetSharedDirectoryId(v string) *SharedDirectory {
	s.SharedDirectoryId = &v
	return s
}

// Describes a directory snapshot.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The descriptive name of the snapshot.
	Name *string `type:"string"`

	// The snapshot identifier.
	SnapshotId *string `type:"string"`

	// The date and time that the snapshot was taken.
	StartTime *time.Time `type:"timestamp"`

	// The snapshot status.
	Status *string `type:"string" enum:"SnapshotStatus"`

	// The snapshot type.
	Type *string `type:"string" enum:"SnapshotType"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *Snapshot) SetDirectoryId(v string) *Snapshot {
	s.DirectoryId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Snapshot) SetName(v string) *Snapshot {
	s.Name = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *Snapshot) SetSnapshotId(v string) *Snapshot {
	s.SnapshotId = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *Snapshot) SetStartTime(v time.Time) *Snapshot {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Snapshot) SetStatus(v string) *Snapshot {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Snapshot) SetType(v string) *Snapshot {
	s.Type = &v
	return s
}

// The maximum number of manual snapshots for the directory has been reached.
// You can use the GetSnapshotLimits operation to determine the snapshot limits
// for a directory.
type SnapshotLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s SnapshotLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotLimitExceededException) GoString() string {
	return s.String()
}

func newErrorSnapshotLimitExceededException(v protocol.ResponseMetadata) error {
	return &SnapshotLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SnapshotLimitExceededException) Code() string {
	return "SnapshotLimitExceededException"
}

// Message returns the exception's message.
func (s *SnapshotLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SnapshotLimitExceededException) OrigErr() error {
	return nil
}

func (s *SnapshotLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SnapshotLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SnapshotLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains manual snapshot limit information for a directory.
type SnapshotLimits struct {
	_ struct{} `type:"structure"`

	// The current number of manual snapshots of the directory.
	ManualSnapshotsCurrentCount *int64 `type:"integer"`

	// The maximum number of manual snapshots allowed.
	ManualSnapshotsLimit *int64 `type:"integer"`

	// Indicates if the manual snapshot limit has been reached.
	ManualSnapshotsLimitReached *bool `type:"boolean"`
}

// String returns the string representation
func (s SnapshotLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotLimits) GoString() string {
	return s.String()
}

// SetManualSnapshotsCurrentCount sets the ManualSnapshotsCurrentCount field's value.
func (s *SnapshotLimits) SetManualSnapshotsCurrentCount(v int64) *SnapshotLimits {
	s.ManualSnapshotsCurrentCount = &v
	return s
}

// SetManualSnapshotsLimit sets the ManualSnapshotsLimit field's value.
func (s *SnapshotLimits) SetManualSnapshotsLimit(v int64) *SnapshotLimits {
	s.ManualSnapshotsLimit = &v
	return s
}

// SetManualSnapshotsLimitReached sets the ManualSnapshotsLimitReached field's value.
func (s *SnapshotLimits) SetManualSnapshotsLimitReached(v bool) *SnapshotLimits {
	s.ManualSnapshotsLimitReached = &v
	return s
}

type StartSchemaExtensionInput struct {
	_ struct{} `type:"structure"`

	// If true, creates a snapshot of the directory before applying the schema extension.
	//
	// CreateSnapshotBeforeSchemaExtension is a required field
	CreateSnapshotBeforeSchemaExtension *bool `type:"boolean" required:"true"`

	// A description of the schema extension.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The identifier of the directory for which the schema extension will be applied
	// to.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The LDIF file represented as a string. To construct the LdifContent string,
	// precede each line as it would be formatted in an ldif file with \n. See the
	// example request below for more details. The file size can be no larger than
	// 1MB.
	//
	// LdifContent is a required field
	LdifContent *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartSchemaExtensionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSchemaExtensionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSchemaExtensionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSchemaExtensionInput"}
	if s.CreateSnapshotBeforeSchemaExtension == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateSnapshotBeforeSchemaExtension"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.LdifContent == nil {
		invalidParams.Add(request.NewErrParamRequired("LdifContent"))
	}
	if s.LdifContent != nil && len(*s.LdifContent) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LdifContent", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateSnapshotBeforeSchemaExtension sets the CreateSnapshotBeforeSchemaExtension field's value.
func (s *StartSchemaExtensionInput) SetCreateSnapshotBeforeSchemaExtension(v bool) *StartSchemaExtensionInput {
	s.CreateSnapshotBeforeSchemaExtension = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartSchemaExtensionInput) SetDescription(v string) *StartSchemaExtensionInput {
	s.Description = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *StartSchemaExtensionInput) SetDirectoryId(v string) *StartSchemaExtensionInput {
	s.DirectoryId = &v
	return s
}

// SetLdifContent sets the LdifContent field's value.
func (s *StartSchemaExtensionInput) SetLdifContent(v string) *StartSchemaExtensionInput {
	s.LdifContent = &v
	return s
}

type StartSchemaExtensionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the schema extension that will be applied.
	SchemaExtensionId *string `type:"string"`
}

// String returns the string representation
func (s StartSchemaExtensionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSchemaExtensionOutput) GoString() string {
	return s.String()
}

// SetSchemaExtensionId sets the SchemaExtensionId field's value.
func (s *StartSchemaExtensionOutput) SetSchemaExtensionId(v string) *StartSchemaExtensionOutput {
	s.SchemaExtensionId = &v
	return s
}

// Metadata assigned to a directory consisting of a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// Required name of the tag. The string value can be Unicode characters and
	// cannot be prefixed with "aws:". The string can contain only the set of Unicode
	// letters, digits, white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The optional value of the tag. The string value can be Unicode characters.
	// The string can contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The maximum allowed number of tags was exceeded.
type TagLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s TagLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagLimitExceededException) GoString() string {
	return s.String()
}

func newErrorTagLimitExceededException(v protocol.ResponseMetadata) error {
	return &TagLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TagLimitExceededException) Code() string {
	return "TagLimitExceededException"
}

// Message returns the exception's message.
func (s *TagLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TagLimitExceededException) OrigErr() error {
	return nil
}

func (s *TagLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TagLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TagLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a trust relationship between an AWS Managed Microsoft AD directory
// and an external domain.
type Trust struct {
	_ struct{} `type:"structure"`

	// The date and time that the trust relationship was created.
	CreatedDateTime *time.Time `type:"timestamp"`

	// The Directory ID of the AWS directory involved in the trust relationship.
	DirectoryId *string `type:"string"`

	// The date and time that the trust relationship was last updated.
	LastUpdatedDateTime *time.Time `type:"timestamp"`

	// The Fully Qualified Domain Name (FQDN) of the external domain involved in
	// the trust relationship.
	RemoteDomainName *string `type:"string"`

	// Current state of selective authentication for the trust.
	SelectiveAuth *string `type:"string" enum:"SelectiveAuth"`

	// The date and time that the TrustState was last updated.
	StateLastUpdatedDateTime *time.Time `type:"timestamp"`

	// The trust relationship direction.
	TrustDirection *string `type:"string" enum:"TrustDirection"`

	// The unique ID of the trust relationship.
	TrustId *string `type:"string"`

	// The trust relationship state.
	TrustState *string `type:"string" enum:"TrustState"`

	// The reason for the TrustState.
	TrustStateReason *string `type:"string"`

	// The trust relationship type. Forest is the default.
	TrustType *string `type:"string" enum:"TrustType"`
}

// String returns the string representation
func (s Trust) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trust) GoString() string {
	return s.String()
}

// SetCreatedDateTime sets the CreatedDateTime field's value.
func (s *Trust) SetCreatedDateTime(v time.Time) *Trust {
	s.CreatedDateTime = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *Trust) SetDirectoryId(v string) *Trust {
	s.DirectoryId = &v
	return s
}

// SetLastUpdatedDateTime sets the LastUpdatedDateTime field's value.
func (s *Trust) SetLastUpdatedDateTime(v time.Time) *Trust {
	s.LastUpdatedDateTime = &v
	return s
}

// SetRemoteDomainName sets the RemoteDomainName field's value.
func (s *Trust) SetRemoteDomainName(v string) *Trust {
	s.RemoteDomainName = &v
	return s
}

// SetSelectiveAuth sets the SelectiveAuth field's value.
func (s *Trust) SetSelectiveAuth(v string) *Trust {
	s.SelectiveAuth = &v
	return s
}

// SetStateLastUpdatedDateTime sets the StateLastUpdatedDateTime field's value.
func (s *Trust) SetStateLastUpdatedDateTime(v time.Time) *Trust {
	s.StateLastUpdatedDateTime = &v
	return s
}

// SetTrustDirection sets the TrustDirection field's value.
func (s *Trust) SetTrustDirection(v string) *Trust {
	s.TrustDirection = &v
	return s
}

// SetTrustId sets the TrustId field's value.
func (s *Trust) SetTrustId(v string) *Trust {
	s.TrustId = &v
	return s
}

// SetTrustState sets the TrustState field's value.
func (s *Trust) SetTrustState(v string) *Trust {
	s.TrustState = &v
	return s
}

// SetTrustStateReason sets the TrustStateReason field's value.
func (s *Trust) SetTrustStateReason(v string) *Trust {
	s.TrustStateReason = &v
	return s
}

// SetTrustType sets the TrustType field's value.
func (s *Trust) SetTrustType(v string) *Trust {
	s.TrustType = &v
	return s
}

type UnshareDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS Managed Microsoft AD directory that you want to
	// stop sharing.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Identifier for the directory consumer account with whom the directory has
	// to be unshared.
	//
	// UnshareTarget is a required field
	UnshareTarget *UnshareTarget `type:"structure" required:"true"`
}

// String returns the string representation
func (s UnshareDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnshareDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnshareDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnshareDirectoryInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.UnshareTarget == nil {
		invalidParams.Add(request.NewErrParamRequired("UnshareTarget"))
	}
	if s.UnshareTarget != nil {
		if err := s.UnshareTarget.Validate(); err != nil {
			invalidParams.AddNested("UnshareTarget", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *UnshareDirectoryInput) SetDirectoryId(v string) *UnshareDirectoryInput {
	s.DirectoryId = &v
	return s
}

// SetUnshareTarget sets the UnshareTarget field's value.
func (s *UnshareDirectoryInput) SetUnshareTarget(v *UnshareTarget) *UnshareDirectoryInput {
	s.UnshareTarget = v
	return s
}

type UnshareDirectoryOutput struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory stored in the directory consumer account that
	// is to be unshared from the specified directory (DirectoryId).
	SharedDirectoryId *string `type:"string"`
}

// String returns the string representation
func (s UnshareDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnshareDirectoryOutput) GoString() string {
	return s.String()
}

// SetSharedDirectoryId sets the SharedDirectoryId field's value.
func (s *UnshareDirectoryOutput) SetSharedDirectoryId(v string) *UnshareDirectoryOutput {
	s.SharedDirectoryId = &v
	return s
}

// Identifier that contains details about the directory consumer account with
// whom the directory is being unshared.
type UnshareTarget struct {
	_ struct{} `type:"structure"`

	// Identifier of the directory consumer account.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// Type of identifier to be used in the Id field.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"TargetType"`
}

// String returns the string representation
func (s UnshareTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnshareTarget) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnshareTarget) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnshareTarget"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UnshareTarget) SetId(v string) *UnshareTarget {
	s.Id = &v
	return s
}

// SetType sets the Type field's value.
func (s *UnshareTarget) SetType(v string) *UnshareTarget {
	s.Type = &v
	return s
}

// The operation is not supported.
type UnsupportedOperationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s UnsupportedOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedOperationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedOperationException(v protocol.ResponseMetadata) error {
	return &UnsupportedOperationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedOperationException) Code() string {
	return "UnsupportedOperationException"
}

// Message returns the exception's message.
func (s *UnsupportedOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedOperationException) OrigErr() error {
	return nil
}

func (s *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedOperationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedOperationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Updates a conditional forwarder.
type UpdateConditionalForwarderInput struct {
	_ struct{} `type:"structure"`

	// The directory ID of the AWS directory for which to update the conditional
	// forwarder.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The updated IP addresses of the remote DNS server associated with the conditional
	// forwarder.
	//
	// DnsIpAddrs is a required field
	DnsIpAddrs []*string `type:"list" required:"true"`

	// The fully qualified domain name (FQDN) of the remote domain with which you
	// will set up a trust relationship.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConditionalForwarderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConditionalForwarderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConditionalForwarderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConditionalForwarderInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DnsIpAddrs == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsIpAddrs"))
	}
	if s.RemoteDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteDomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *UpdateConditionalForwarderInput) SetDirectoryId(v string) *UpdateConditionalForwarderInput {
	s.DirectoryId = &v
	return s
}

// SetDnsIpAddrs sets the DnsIpAddrs field's value.
func (s *UpdateConditionalForwarderInput) SetDnsIpAddrs(v []*string) *UpdateConditionalForwarderInput {
	s.DnsIpAddrs = v
	return s
}

// SetRemoteDomainName sets the RemoteDomainName field's value.
func (s *UpdateConditionalForwarderInput) SetRemoteDomainName(v string) *UpdateConditionalForwarderInput {
	s.RemoteDomainName = &v
	return s
}

// The result of an UpdateConditionalForwarder request.
type UpdateConditionalForwarderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateConditionalForwarderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConditionalForwarderOutput) GoString() string {
	return s.String()
}

type UpdateNumberOfDomainControllersInput struct {
	_ struct{} `type:"structure"`

	// The number of domain controllers desired in the directory.
	//
	// DesiredNumber is a required field
	DesiredNumber *int64 `min:"2" type:"integer" required:"true"`

	// Identifier of the directory to which the domain controllers will be added
	// or removed.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateNumberOfDomainControllersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNumberOfDomainControllersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNumberOfDomainControllersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNumberOfDomainControllersInput"}
	if s.DesiredNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredNumber"))
	}
	if s.DesiredNumber != nil && *s.DesiredNumber < 2 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredNumber", 2))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredNumber sets the DesiredNumber field's value.
func (s *UpdateNumberOfDomainControllersInput) SetDesiredNumber(v int64) *UpdateNumberOfDomainControllersInput {
	s.DesiredNumber = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *UpdateNumberOfDomainControllersInput) SetDirectoryId(v string) *UpdateNumberOfDomainControllersInput {
	s.DirectoryId = &v
	return s
}

type UpdateNumberOfDomainControllersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateNumberOfDomainControllersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNumberOfDomainControllersOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the UpdateRadius operation.
type UpdateRadiusInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory for which to update the RADIUS server information.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// A RadiusSettings object that contains information about the RADIUS server.
	//
	// RadiusSettings is a required field
	RadiusSettings *RadiusSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRadiusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRadiusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRadiusInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.RadiusSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("RadiusSettings"))
	}
	if s.RadiusSettings != nil {
		if err := s.RadiusSettings.Validate(); err != nil {
			invalidParams.AddNested("RadiusSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *UpdateRadiusInput) SetDirectoryId(v string) *UpdateRadiusInput {
	s.DirectoryId = &v
	return s
}

// SetRadiusSettings sets the RadiusSettings field's value.
func (s *UpdateRadiusInput) SetRadiusSettings(v *RadiusSettings) *UpdateRadiusInput {
	s.RadiusSettings = v
	return s
}

// Contains the results of the UpdateRadius operation.
type UpdateRadiusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRadiusOutput) GoString() string {
	return s.String()
}

type UpdateTrustInput struct {
	_ struct{} `type:"structure"`

	// Updates selective authentication for the trust.
	SelectiveAuth *string `type:"string" enum:"SelectiveAuth"`

	// Identifier of the trust relationship.
	//
	// TrustId is a required field
	TrustId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTrustInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrustInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrustInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrustInput"}
	if s.TrustId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSelectiveAuth sets the SelectiveAuth field's value.
func (s *UpdateTrustInput) SetSelectiveAuth(v string) *UpdateTrustInput {
	s.SelectiveAuth = &v
	return s
}

// SetTrustId sets the TrustId field's value.
func (s *UpdateTrustInput) SetTrustId(v string) *UpdateTrustInput {
	s.TrustId = &v
	return s
}

type UpdateTrustOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request identifier.
	RequestId *string `type:"string"`

	// Identifier of the trust relationship.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s UpdateTrustOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrustOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *UpdateTrustOutput) SetRequestId(v string) *UpdateTrustOutput {
	s.RequestId = &v
	return s
}

// SetTrustId sets the TrustId field's value.
func (s *UpdateTrustOutput) SetTrustId(v string) *UpdateTrustOutput {
	s.TrustId = &v
	return s
}

// The user provided a username that does not exist in your directory.
type UserDoesNotExistException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The descriptive message for the exception.
	Message_ *string `locationName:"Message" type:"string"`

	// The AWS request identifier.
	RequestId *string `type:"string"`
}

// String returns the string representation
func (s UserDoesNotExistException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserDoesNotExistException) GoString() string {
	return s.String()
}

func newErrorUserDoesNotExistException(v protocol.ResponseMetadata) error {
	return &UserDoesNotExistException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UserDoesNotExistException) Code() string {
	return "UserDoesNotExistException"
}

// Message returns the exception's message.
func (s *UserDoesNotExistException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UserDoesNotExistException) OrigErr() error {
	return nil
}

func (s *UserDoesNotExistException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UserDoesNotExistException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UserDoesNotExistException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Initiates the verification of an existing trust relationship between an AWS
// Managed Microsoft AD directory and an external domain.
type VerifyTrustInput struct {
	_ struct{} `type:"structure"`

	// The unique Trust ID of the trust relationship to verify.
	//
	// TrustId is a required field
	TrustId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyTrustInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyTrustInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyTrustInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VerifyTrustInput"}
	if s.TrustId == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustId sets the TrustId field's value.
func (s *VerifyTrustInput) SetTrustId(v string) *VerifyTrustInput {
	s.TrustId = &v
	return s
}

// Result of a VerifyTrust request.
type VerifyTrustOutput struct {
	_ struct{} `type:"structure"`

	// The unique Trust ID of the trust relationship that was verified.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s VerifyTrustOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyTrustOutput) GoString() string {
	return s.String()
}

// SetTrustId sets the TrustId field's value.
func (s *VerifyTrustOutput) SetTrustId(v string) *VerifyTrustOutput {
	s.TrustId = &v
	return s
}

const (
	// CertificateStateRegistering is a CertificateState enum value
	CertificateStateRegistering = "Registering"

	// CertificateStateRegistered is a CertificateState enum value
	CertificateStateRegistered = "Registered"

	// CertificateStateRegisterFailed is a CertificateState enum value
	CertificateStateRegisterFailed = "RegisterFailed"

	// CertificateStateDeregistering is a CertificateState enum value
	CertificateStateDeregistering = "Deregistering"

	// CertificateStateDeregistered is a CertificateState enum value
	CertificateStateDeregistered = "Deregistered"

	// CertificateStateDeregisterFailed is a CertificateState enum value
	CertificateStateDeregisterFailed = "DeregisterFailed"
)

// CertificateState_Values returns all elements of the CertificateState enum
func CertificateState_Values() []string {
	return []string{
		CertificateStateRegistering,
		CertificateStateRegistered,
		CertificateStateRegisterFailed,
		CertificateStateDeregistering,
		CertificateStateDeregistered,
		CertificateStateDeregisterFailed,
	}
}

const (
	// CertificateTypeClientCertAuth is a CertificateType enum value
	CertificateTypeClientCertAuth = "ClientCertAuth"

	// CertificateTypeClientLdaps is a CertificateType enum value
	CertificateTypeClientLdaps = "ClientLDAPS"
)

// CertificateType_Values returns all elements of the CertificateType enum
func CertificateType_Values() []string {
	return []string{
		CertificateTypeClientCertAuth,
		CertificateTypeClientLdaps,
	}
}

const (
	// ClientAuthenticationTypeSmartCard is a ClientAuthenticationType enum value
	ClientAuthenticationTypeSmartCard = "SmartCard"
)

// ClientAuthenticationType_Values returns all elements of the ClientAuthenticationType enum
func ClientAuthenticationType_Values() []string {
	return []string{
		ClientAuthenticationTypeSmartCard,
	}
}

const (
	// DirectoryEditionEnterprise is a DirectoryEdition enum value
	DirectoryEditionEnterprise = "Enterprise"

	// DirectoryEditionStandard is a DirectoryEdition enum value
	DirectoryEditionStandard = "Standard"
)

// DirectoryEdition_Values returns all elements of the DirectoryEdition enum
func DirectoryEdition_Values() []string {
	return []string{
		DirectoryEditionEnterprise,
		DirectoryEditionStandard,
	}
}

const (
	// DirectorySizeSmall is a DirectorySize enum value
	DirectorySizeSmall = "Small"

	// DirectorySizeLarge is a DirectorySize enum value
	DirectorySizeLarge = "Large"
)

// DirectorySize_Values returns all elements of the DirectorySize enum
func DirectorySize_Values() []string {
	return []string{
		DirectorySizeSmall,
		DirectorySizeLarge,
	}
}

const (
	// DirectoryStageRequested is a DirectoryStage enum value
	DirectoryStageRequested = "Requested"

	// DirectoryStageCreating is a DirectoryStage enum value
	DirectoryStageCreating = "Creating"

	// DirectoryStageCreated is a DirectoryStage enum value
	DirectoryStageCreated = "Created"

	// DirectoryStageActive is a DirectoryStage enum value
	DirectoryStageActive = "Active"

	// DirectoryStageInoperable is a DirectoryStage enum value
	DirectoryStageInoperable = "Inoperable"

	// DirectoryStageImpaired is a DirectoryStage enum value
	DirectoryStageImpaired = "Impaired"

	// DirectoryStageRestoring is a DirectoryStage enum value
	DirectoryStageRestoring = "Restoring"

	// DirectoryStageRestoreFailed is a DirectoryStage enum value
	DirectoryStageRestoreFailed = "RestoreFailed"

	// DirectoryStageDeleting is a DirectoryStage enum value
	DirectoryStageDeleting = "Deleting"

	// DirectoryStageDeleted is a DirectoryStage enum value
	DirectoryStageDeleted = "Deleted"

	// DirectoryStageFailed is a DirectoryStage enum value
	DirectoryStageFailed = "Failed"
)

// DirectoryStage_Values returns all elements of the DirectoryStage enum
func DirectoryStage_Values() []string {
	return []string{
		DirectoryStageRequested,
		DirectoryStageCreating,
		DirectoryStageCreated,
		DirectoryStageActive,
		DirectoryStageInoperable,
		DirectoryStageImpaired,
		DirectoryStageRestoring,
		DirectoryStageRestoreFailed,
		DirectoryStageDeleting,
		DirectoryStageDeleted,
		DirectoryStageFailed,
	}
}

const (
	// DirectoryTypeSimpleAd is a DirectoryType enum value
	DirectoryTypeSimpleAd = "SimpleAD"

	// DirectoryTypeAdconnector is a DirectoryType enum value
	DirectoryTypeAdconnector = "ADConnector"

	// DirectoryTypeMicrosoftAd is a DirectoryType enum value
	DirectoryTypeMicrosoftAd = "MicrosoftAD"

	// DirectoryTypeSharedMicrosoftAd is a DirectoryType enum value
	DirectoryTypeSharedMicrosoftAd = "SharedMicrosoftAD"
)

// DirectoryType_Values returns all elements of the DirectoryType enum
func DirectoryType_Values() []string {
	return []string{
		DirectoryTypeSimpleAd,
		DirectoryTypeAdconnector,
		DirectoryTypeMicrosoftAd,
		DirectoryTypeSharedMicrosoftAd,
	}
}

const (
	// DomainControllerStatusCreating is a DomainControllerStatus enum value
	DomainControllerStatusCreating = "Creating"

	// DomainControllerStatusActive is a DomainControllerStatus enum value
	DomainControllerStatusActive = "Active"

	// DomainControllerStatusImpaired is a DomainControllerStatus enum value
	DomainControllerStatusImpaired = "Impaired"

	// DomainControllerStatusRestoring is a DomainControllerStatus enum value
	DomainControllerStatusRestoring = "Restoring"

	// DomainControllerStatusDeleting is a DomainControllerStatus enum value
	DomainControllerStatusDeleting = "Deleting"

	// DomainControllerStatusDeleted is a DomainControllerStatus enum value
	DomainControllerStatusDeleted = "Deleted"

	// DomainControllerStatusFailed is a DomainControllerStatus enum value
	DomainControllerStatusFailed = "Failed"
)

// DomainControllerStatus_Values returns all elements of the DomainControllerStatus enum
func DomainControllerStatus_Values() []string {
	return []string{
		DomainControllerStatusCreating,
		DomainControllerStatusActive,
		DomainControllerStatusImpaired,
		DomainControllerStatusRestoring,
		DomainControllerStatusDeleting,
		DomainControllerStatusDeleted,
		DomainControllerStatusFailed,
	}
}

const (
	// IpRouteStatusMsgAdding is a IpRouteStatusMsg enum value
	IpRouteStatusMsgAdding = "Adding"

	// IpRouteStatusMsgAdded is a IpRouteStatusMsg enum value
	IpRouteStatusMsgAdded = "Added"

	// IpRouteStatusMsgRemoving is a IpRouteStatusMsg enum value
	IpRouteStatusMsgRemoving = "Removing"

	// IpRouteStatusMsgRemoved is a IpRouteStatusMsg enum value
	IpRouteStatusMsgRemoved = "Removed"

	// IpRouteStatusMsgAddFailed is a IpRouteStatusMsg enum value
	IpRouteStatusMsgAddFailed = "AddFailed"

	// IpRouteStatusMsgRemoveFailed is a IpRouteStatusMsg enum value
	IpRouteStatusMsgRemoveFailed = "RemoveFailed"
)

// IpRouteStatusMsg_Values returns all elements of the IpRouteStatusMsg enum
func IpRouteStatusMsg_Values() []string {
	return []string{
		IpRouteStatusMsgAdding,
		IpRouteStatusMsgAdded,
		IpRouteStatusMsgRemoving,
		IpRouteStatusMsgRemoved,
		IpRouteStatusMsgAddFailed,
		IpRouteStatusMsgRemoveFailed,
	}
}

const (
	// LDAPSStatusEnabling is a LDAPSStatus enum value
	LDAPSStatusEnabling = "Enabling"

	// LDAPSStatusEnabled is a LDAPSStatus enum value
	LDAPSStatusEnabled = "Enabled"

	// LDAPSStatusEnableFailed is a LDAPSStatus enum value
	LDAPSStatusEnableFailed = "EnableFailed"

	// LDAPSStatusDisabled is a LDAPSStatus enum value
	LDAPSStatusDisabled = "Disabled"
)

// LDAPSStatus_Values returns all elements of the LDAPSStatus enum
func LDAPSStatus_Values() []string {
	return []string{
		LDAPSStatusEnabling,
		LDAPSStatusEnabled,
		LDAPSStatusEnableFailed,
		LDAPSStatusDisabled,
	}
}

const (
	// LDAPSTypeClient is a LDAPSType enum value
	LDAPSTypeClient = "Client"
)

// LDAPSType_Values returns all elements of the LDAPSType enum
func LDAPSType_Values() []string {
	return []string{
		LDAPSTypeClient,
	}
}

const (
	// RadiusAuthenticationProtocolPap is a RadiusAuthenticationProtocol enum value
	RadiusAuthenticationProtocolPap = "PAP"

	// RadiusAuthenticationProtocolChap is a RadiusAuthenticationProtocol enum value
	RadiusAuthenticationProtocolChap = "CHAP"

	// RadiusAuthenticationProtocolMsChapv1 is a RadiusAuthenticationProtocol enum value
	RadiusAuthenticationProtocolMsChapv1 = "MS-CHAPv1"

	// RadiusAuthenticationProtocolMsChapv2 is a RadiusAuthenticationProtocol enum value
	RadiusAuthenticationProtocolMsChapv2 = "MS-CHAPv2"
)

// RadiusAuthenticationProtocol_Values returns all elements of the RadiusAuthenticationProtocol enum
func RadiusAuthenticationProtocol_Values() []string {
	return []string{
		RadiusAuthenticationProtocolPap,
		RadiusAuthenticationProtocolChap,
		RadiusAuthenticationProtocolMsChapv1,
		RadiusAuthenticationProtocolMsChapv2,
	}
}

const (
	// RadiusStatusCreating is a RadiusStatus enum value
	RadiusStatusCreating = "Creating"

	// RadiusStatusCompleted is a RadiusStatus enum value
	RadiusStatusCompleted = "Completed"

	// RadiusStatusFailed is a RadiusStatus enum value
	RadiusStatusFailed = "Failed"
)

// RadiusStatus_Values returns all elements of the RadiusStatus enum
func RadiusStatus_Values() []string {
	return []string{
		RadiusStatusCreating,
		RadiusStatusCompleted,
		RadiusStatusFailed,
	}
}

const (
	// RegionTypePrimary is a RegionType enum value
	RegionTypePrimary = "Primary"

	// RegionTypeAdditional is a RegionType enum value
	RegionTypeAdditional = "Additional"
)

// RegionType_Values returns all elements of the RegionType enum
func RegionType_Values() []string {
	return []string{
		RegionTypePrimary,
		RegionTypeAdditional,
	}
}

const (
	// ReplicationScopeDomain is a ReplicationScope enum value
	ReplicationScopeDomain = "Domain"
)

// ReplicationScope_Values returns all elements of the ReplicationScope enum
func ReplicationScope_Values() []string {
	return []string{
		ReplicationScopeDomain,
	}
}

const (
	// SchemaExtensionStatusInitializing is a SchemaExtensionStatus enum value
	SchemaExtensionStatusInitializing = "Initializing"

	// SchemaExtensionStatusCreatingSnapshot is a SchemaExtensionStatus enum value
	SchemaExtensionStatusCreatingSnapshot = "CreatingSnapshot"

	// SchemaExtensionStatusUpdatingSchema is a SchemaExtensionStatus enum value
	SchemaExtensionStatusUpdatingSchema = "UpdatingSchema"

	// SchemaExtensionStatusReplicating is a SchemaExtensionStatus enum value
	SchemaExtensionStatusReplicating = "Replicating"

	// SchemaExtensionStatusCancelInProgress is a SchemaExtensionStatus enum value
	SchemaExtensionStatusCancelInProgress = "CancelInProgress"

	// SchemaExtensionStatusRollbackInProgress is a SchemaExtensionStatus enum value
	SchemaExtensionStatusRollbackInProgress = "RollbackInProgress"

	// SchemaExtensionStatusCancelled is a SchemaExtensionStatus enum value
	SchemaExtensionStatusCancelled = "Cancelled"

	// SchemaExtensionStatusFailed is a SchemaExtensionStatus enum value
	SchemaExtensionStatusFailed = "Failed"

	// SchemaExtensionStatusCompleted is a SchemaExtensionStatus enum value
	SchemaExtensionStatusCompleted = "Completed"
)

// SchemaExtensionStatus_Values returns all elements of the SchemaExtensionStatus enum
func SchemaExtensionStatus_Values() []string {
	return []string{
		SchemaExtensionStatusInitializing,
		SchemaExtensionStatusCreatingSnapshot,
		SchemaExtensionStatusUpdatingSchema,
		SchemaExtensionStatusReplicating,
		SchemaExtensionStatusCancelInProgress,
		SchemaExtensionStatusRollbackInProgress,
		SchemaExtensionStatusCancelled,
		SchemaExtensionStatusFailed,
		SchemaExtensionStatusCompleted,
	}
}

const (
	// SelectiveAuthEnabled is a SelectiveAuth enum value
	SelectiveAuthEnabled = "Enabled"

	// SelectiveAuthDisabled is a SelectiveAuth enum value
	SelectiveAuthDisabled = "Disabled"
)

// SelectiveAuth_Values returns all elements of the SelectiveAuth enum
func SelectiveAuth_Values() []string {
	return []string{
		SelectiveAuthEnabled,
		SelectiveAuthDisabled,
	}
}

const (
	// ShareMethodOrganizations is a ShareMethod enum value
	ShareMethodOrganizations = "ORGANIZATIONS"

	// ShareMethodHandshake is a ShareMethod enum value
	ShareMethodHandshake = "HANDSHAKE"
)

// ShareMethod_Values returns all elements of the ShareMethod enum
func ShareMethod_Values() []string {
	return []string{
		ShareMethodOrganizations,
		ShareMethodHandshake,
	}
}

const (
	// ShareStatusShared is a ShareStatus enum value
	ShareStatusShared = "Shared"

	// ShareStatusPendingAcceptance is a ShareStatus enum value
	ShareStatusPendingAcceptance = "PendingAcceptance"

	// ShareStatusRejected is a ShareStatus enum value
	ShareStatusRejected = "Rejected"

	// ShareStatusRejecting is a ShareStatus enum value
	ShareStatusRejecting = "Rejecting"

	// ShareStatusRejectFailed is a ShareStatus enum value
	ShareStatusRejectFailed = "RejectFailed"

	// ShareStatusSharing is a ShareStatus enum value
	ShareStatusSharing = "Sharing"

	// ShareStatusShareFailed is a ShareStatus enum value
	ShareStatusShareFailed = "ShareFailed"

	// ShareStatusDeleted is a ShareStatus enum value
	ShareStatusDeleted = "Deleted"

	// ShareStatusDeleting is a ShareStatus enum value
	ShareStatusDeleting = "Deleting"
)

// ShareStatus_Values returns all elements of the ShareStatus enum
func ShareStatus_Values() []string {
	return []string{
		ShareStatusShared,
		ShareStatusPendingAcceptance,
		ShareStatusRejected,
		ShareStatusRejecting,
		ShareStatusRejectFailed,
		ShareStatusSharing,
		ShareStatusShareFailed,
		ShareStatusDeleted,
		ShareStatusDeleting,
	}
}

const (
	// SnapshotStatusCreating is a SnapshotStatus enum value
	SnapshotStatusCreating = "Creating"

	// SnapshotStatusCompleted is a SnapshotStatus enum value
	SnapshotStatusCompleted = "Completed"

	// SnapshotStatusFailed is a SnapshotStatus enum value
	SnapshotStatusFailed = "Failed"
)

// SnapshotStatus_Values returns all elements of the SnapshotStatus enum
func SnapshotStatus_Values() []string {
	return []string{
		SnapshotStatusCreating,
		SnapshotStatusCompleted,
		SnapshotStatusFailed,
	}
}

const (
	// SnapshotTypeAuto is a SnapshotType enum value
	SnapshotTypeAuto = "Auto"

	// SnapshotTypeManual is a SnapshotType enum value
	SnapshotTypeManual = "Manual"
)

// SnapshotType_Values returns all elements of the SnapshotType enum
func SnapshotType_Values() []string {
	return []string{
		SnapshotTypeAuto,
		SnapshotTypeManual,
	}
}

const (
	// TargetTypeAccount is a TargetType enum value
	TargetTypeAccount = "ACCOUNT"
)

// TargetType_Values returns all elements of the TargetType enum
func TargetType_Values() []string {
	return []string{
		TargetTypeAccount,
	}
}

const (
	// TopicStatusRegistered is a TopicStatus enum value
	TopicStatusRegistered = "Registered"

	// TopicStatusTopicnotfound is a TopicStatus enum value
	TopicStatusTopicnotfound = "Topic not found"

	// TopicStatusFailed is a TopicStatus enum value
	TopicStatusFailed = "Failed"

	// TopicStatusDeleted is a TopicStatus enum value
	TopicStatusDeleted = "Deleted"
)

// TopicStatus_Values returns all elements of the TopicStatus enum
func TopicStatus_Values() []string {
	return []string{
		TopicStatusRegistered,
		TopicStatusTopicnotfound,
		TopicStatusFailed,
		TopicStatusDeleted,
	}
}

const (
	// TrustDirectionOneWayOutgoing is a TrustDirection enum value
	TrustDirectionOneWayOutgoing = "One-Way: Outgoing"

	// TrustDirectionOneWayIncoming is a TrustDirection enum value
	TrustDirectionOneWayIncoming = "One-Way: Incoming"

	// TrustDirectionTwoWay is a TrustDirection enum value
	TrustDirectionTwoWay = "Two-Way"
)

// TrustDirection_Values returns all elements of the TrustDirection enum
func TrustDirection_Values() []string {
	return []string{
		TrustDirectionOneWayOutgoing,
		TrustDirectionOneWayIncoming,
		TrustDirectionTwoWay,
	}
}

const (
	// TrustStateCreating is a TrustState enum value
	TrustStateCreating = "Creating"

	// TrustStateCreated is a TrustState enum value
	TrustStateCreated = "Created"

	// TrustStateVerifying is a TrustState enum value
	TrustStateVerifying = "Verifying"

	// TrustStateVerifyFailed is a TrustState enum value
	TrustStateVerifyFailed = "VerifyFailed"

	// TrustStateVerified is a TrustState enum value
	TrustStateVerified = "Verified"

	// TrustStateUpdating is a TrustState enum value
	TrustStateUpdating = "Updating"

	// TrustStateUpdateFailed is a TrustState enum value
	TrustStateUpdateFailed = "UpdateFailed"

	// TrustStateUpdated is a TrustState enum value
	TrustStateUpdated = "Updated"

	// TrustStateDeleting is a TrustState enum value
	TrustStateDeleting = "Deleting"

	// TrustStateDeleted is a TrustState enum value
	TrustStateDeleted = "Deleted"

	// TrustStateFailed is a TrustState enum value
	TrustStateFailed = "Failed"
)

// TrustState_Values returns all elements of the TrustState enum
func TrustState_Values() []string {
	return []string{
		TrustStateCreating,
		TrustStateCreated,
		TrustStateVerifying,
		TrustStateVerifyFailed,
		TrustStateVerified,
		TrustStateUpdating,
		TrustStateUpdateFailed,
		TrustStateUpdated,
		TrustStateDeleting,
		TrustStateDeleted,
		TrustStateFailed,
	}
}

const (
	// TrustTypeForest is a TrustType enum value
	TrustTypeForest = "Forest"

	// TrustTypeExternal is a TrustType enum value
	TrustTypeExternal = "External"
)

// TrustType_Values returns all elements of the TrustType enum
func TrustType_Values() []string {
	return []string{
		TrustTypeForest,
		TrustTypeExternal,
	}
}
