package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnDeliverList invokes the cdn.DescribeCdnDeliverList API synchronously
func (client *Client) DescribeCdnDeliverList(request *DescribeCdnDeliverListRequest) (response *DescribeCdnDeliverListResponse, err error) {
	response = CreateDescribeCdnDeliverListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnDeliverListWithChan invokes the cdn.DescribeCdnDeliverList API asynchronously
func (client *Client) DescribeCdnDeliverListWithChan(request *DescribeCdnDeliverListRequest) (<-chan *DescribeCdnDeliverListResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnDeliverListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnDeliverList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnDeliverListWithCallback invokes the cdn.DescribeCdnDeliverList API asynchronously
func (client *Client) DescribeCdnDeliverListWithCallback(request *DescribeCdnDeliverListRequest, callback func(response *DescribeCdnDeliverListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnDeliverListResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnDeliverList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnDeliverListRequest is the request struct for api DescribeCdnDeliverList
type DescribeCdnDeliverListRequest struct {
	*requests.RpcRequest
	DeliverId requests.Integer `position:"Query" name:"DeliverId"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	Status    string           `position:"Query" name:"Status"`
}

// DescribeCdnDeliverListResponse is the response struct for api DescribeCdnDeliverList
type DescribeCdnDeliverListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Content   string `json:"Content" xml:"Content"`
}

// CreateDescribeCdnDeliverListRequest creates a request to invoke DescribeCdnDeliverList API
func CreateDescribeCdnDeliverListRequest() (request *DescribeCdnDeliverListRequest) {
	request = &DescribeCdnDeliverListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnDeliverList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnDeliverListResponse creates a response to parse from DescribeCdnDeliverList response
func CreateDescribeCdnDeliverListResponse() (response *DescribeCdnDeliverListResponse) {
	response = &DescribeCdnDeliverListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
