package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWhitelistSetting invokes the cloudauth.DeleteWhitelistSetting API synchronously
func (client *Client) DeleteWhitelistSetting(request *DeleteWhitelistSettingRequest) (response *DeleteWhitelistSettingResponse, err error) {
	response = CreateDeleteWhitelistSettingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWhitelistSettingWithChan invokes the cloudauth.DeleteWhitelistSetting API asynchronously
func (client *Client) DeleteWhitelistSettingWithChan(request *DeleteWhitelistSettingRequest) (<-chan *DeleteWhitelistSettingResponse, <-chan error) {
	responseChan := make(chan *DeleteWhitelistSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWhitelistSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWhitelistSettingWithCallback invokes the cloudauth.DeleteWhitelistSetting API asynchronously
func (client *Client) DeleteWhitelistSettingWithCallback(request *DeleteWhitelistSettingRequest, callback func(response *DeleteWhitelistSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWhitelistSettingResponse
		var err error
		defer close(result)
		response, err = client.DeleteWhitelistSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWhitelistSettingRequest is the request struct for api DeleteWhitelistSetting
type DeleteWhitelistSettingRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	Lang        string `position:"Query" name:"Lang"`
	ServiceCode string `position:"Query" name:"ServiceCode"`
	Ids         string `position:"Query" name:"Ids"`
}

// DeleteWhitelistSettingResponse is the response struct for api DeleteWhitelistSetting
type DeleteWhitelistSettingResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ResultObject bool   `json:"ResultObject" xml:"ResultObject"`
}

// CreateDeleteWhitelistSettingRequest creates a request to invoke DeleteWhitelistSetting API
func CreateDeleteWhitelistSettingRequest() (request *DeleteWhitelistSettingRequest) {
	request = &DeleteWhitelistSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DeleteWhitelistSetting", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteWhitelistSettingResponse creates a response to parse from DeleteWhitelistSetting response
func CreateDeleteWhitelistSettingResponse() (response *DeleteWhitelistSettingResponse) {
	response = &DeleteWhitelistSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
