package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUpdatePackageResult invokes the cloudauth.DescribeUpdatePackageResult API synchronously
func (client *Client) DescribeUpdatePackageResult(request *DescribeUpdatePackageResultRequest) (response *DescribeUpdatePackageResultResponse, err error) {
	response = CreateDescribeUpdatePackageResultResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUpdatePackageResultWithChan invokes the cloudauth.DescribeUpdatePackageResult API asynchronously
func (client *Client) DescribeUpdatePackageResultWithChan(request *DescribeUpdatePackageResultRequest) (<-chan *DescribeUpdatePackageResultResponse, <-chan error) {
	responseChan := make(chan *DescribeUpdatePackageResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUpdatePackageResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUpdatePackageResultWithCallback invokes the cloudauth.DescribeUpdatePackageResult API asynchronously
func (client *Client) DescribeUpdatePackageResultWithCallback(request *DescribeUpdatePackageResultRequest, callback func(response *DescribeUpdatePackageResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUpdatePackageResultResponse
		var err error
		defer close(result)
		response, err = client.DescribeUpdatePackageResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUpdatePackageResultRequest is the request struct for api DescribeUpdatePackageResult
type DescribeUpdatePackageResultRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	TaskId   string `position:"Query" name:"TaskId"`
}

// DescribeUpdatePackageResultResponse is the response struct for api DescribeUpdatePackageResult
type DescribeUpdatePackageResultResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	AppInfo   AppInfo `json:"AppInfo" xml:"AppInfo"`
}

// CreateDescribeUpdatePackageResultRequest creates a request to invoke DescribeUpdatePackageResult API
func CreateDescribeUpdatePackageResultRequest() (request *DescribeUpdatePackageResultRequest) {
	request = &DescribeUpdatePackageResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DescribeUpdatePackageResult", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeUpdatePackageResultResponse creates a response to parse from DescribeUpdatePackageResult response
func CreateDescribeUpdatePackageResultResponse() (response *DescribeUpdatePackageResultResponse) {
	response = &DescribeUpdatePackageResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
