package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVerifySetting invokes the cloudauth.DescribeVerifySetting API synchronously
func (client *Client) DescribeVerifySetting(request *DescribeVerifySettingRequest) (response *DescribeVerifySettingResponse, err error) {
	response = CreateDescribeVerifySettingResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVerifySettingWithChan invokes the cloudauth.DescribeVerifySetting API asynchronously
func (client *Client) DescribeVerifySettingWithChan(request *DescribeVerifySettingRequest) (<-chan *DescribeVerifySettingResponse, <-chan error) {
	responseChan := make(chan *DescribeVerifySettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVerifySetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVerifySettingWithCallback invokes the cloudauth.DescribeVerifySetting API asynchronously
func (client *Client) DescribeVerifySettingWithCallback(request *DescribeVerifySettingRequest, callback func(response *DescribeVerifySettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVerifySettingResponse
		var err error
		defer close(result)
		response, err = client.DescribeVerifySetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVerifySettingRequest is the request struct for api DescribeVerifySetting
type DescribeVerifySettingRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeVerifySettingResponse is the response struct for api DescribeVerifySetting
type DescribeVerifySettingResponse struct {
	*responses.BaseResponse
	RequestId         string          `json:"RequestId" xml:"RequestId"`
	VerifySettingList []VerifySetting `json:"VerifySettingList" xml:"VerifySettingList"`
}

// CreateDescribeVerifySettingRequest creates a request to invoke DescribeVerifySetting API
func CreateDescribeVerifySettingRequest() (request *DescribeVerifySettingRequest) {
	request = &DescribeVerifySettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "DescribeVerifySetting", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVerifySettingResponse creates a response to parse from DescribeVerifySetting response
func CreateDescribeVerifySettingResponse() (response *DescribeVerifySettingResponse) {
	response = &DescribeVerifySettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
